/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.databind.ser;

import java.lang.reflect.AnnotatedElement;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.hive.druid.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.hive.druid.com.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.hive.druid.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.hive.druid.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.apache.hive.druid.com.fasterxml.jackson.databind.util.Annotations;
import org.apache.hive.druid.com.fasterxml.jackson.databind.util.ArrayBuilders;
import org.apache.hive.druid.com.fasterxml.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final JsonInclude.Include _defaultInclusion;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        this._config = config;
        this._beanDesc = beanDesc;
        this._defaultInclusion = beanDesc.findSerializationInclusion(config.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider prov, BeanPropertyDefinition propDef, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, TypeSerializer contentTypeSer, AnnotatedMember am, boolean defaultUseStaticTyping) throws JsonMappingException {
        NameTransformer unwrapper;
        JavaType serializationType = this.findSerializationType(am, defaultUseStaticTyping, declaredType);
        if (contentTypeSer != null) {
            JavaType ct;
            if (serializationType == null) {
                serializationType = declaredType;
            }
            if ((ct = serializationType.getContentType()) == null) {
                throw new IllegalStateException("Problem trying to create BeanPropertyWriter for property '" + propDef.getName() + "' (of type " + this._beanDesc.getType() + "); serialization type " + serializationType + " has no content");
            }
            serializationType = serializationType.withContentTypeHandler(contentTypeSer);
            ct = serializationType.getContentType();
        }
        Object valueToSuppress = null;
        boolean suppressNulls = false;
        JsonInclude.Include inclusion = propDef.findInclusion();
        if ((inclusion == null || inclusion == JsonInclude.Include.USE_DEFAULTS) && (inclusion = this._defaultInclusion) == null) {
            inclusion = JsonInclude.Include.ALWAYS;
        }
        switch (inclusion) {
            case NON_DEFAULT: {
                valueToSuppress = this.getDefaultValue(propDef.getName(), am);
                if (valueToSuppress == null) {
                    suppressNulls = true;
                    break;
                }
                if (!valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                suppressNulls = true;
                if (!declaredType.isReferenceType()) break;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_EMPTY: {
                suppressNulls = true;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_NULL: {
                suppressNulls = true;
            }
            default: {
                if (!declaredType.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
            }
        }
        BeanPropertyWriter bpw = new BeanPropertyWriter(propDef, am, this._beanDesc.getClassAnnotations(), declaredType, ser, typeSer, serializationType, suppressNulls, valueToSuppress);
        Object serDef = this._annotationIntrospector.findNullSerializer(am);
        if (serDef != null) {
            bpw.assignNullSerializer(prov.serializerInstance(am, serDef));
        }
        if ((unwrapper = this._annotationIntrospector.findUnwrappingNameTransformer(am)) != null) {
            bpw = bpw.unwrappingWriter(unwrapper);
        }
        return bpw;
    }

    protected JavaType findSerializationType(Annotated a, boolean useStaticTyping, JavaType declaredType) {
        JsonSerialize.Typing typing;
        JavaType secondary;
        Class<?> serClass = this._annotationIntrospector.findSerializationType(a);
        if (serClass != null) {
            Class<?> rawDeclared = declaredType.getRawClass();
            if (serClass.isAssignableFrom(rawDeclared)) {
                declaredType = declaredType.widenBy(serClass);
            } else {
                if (!rawDeclared.isAssignableFrom(serClass)) {
                    throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + a.getName() + "': class " + serClass.getName() + " not a super-type of (declared) class " + rawDeclared.getName());
                }
                declaredType = this._config.constructSpecializedType(declaredType, serClass);
            }
            useStaticTyping = true;
        }
        if ((secondary = BasicSerializerFactory.modifySecondaryTypesByAnnotation(this._config, a, declaredType)) != declaredType) {
            useStaticTyping = true;
            declaredType = secondary;
        }
        if ((typing = this._annotationIntrospector.findSerializationTyping(a)) != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            useStaticTyping = typing == JsonSerialize.Typing.STATIC;
        }
        return useStaticTyping ? declaredType : null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (this._defaultBean == null) {
                AnnotatedElement cls = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)cls).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String name, AnnotatedMember member) {
        Object defaultBean = this.getDefaultBean();
        try {
            return member.getValue(defaultBean);
        }
        catch (Exception e) {
            return this._throwWrapped(e, name, defaultBean);
        }
    }

    protected Object _throwWrapped(Exception e, String propName, Object defaultBean) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IllegalArgumentException("Failed to get property '" + propName + "' of default " + defaultBean.getClass().getName() + " instance");
    }
}

