/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;

public class DruidTopNQueryRecordReader
extends DruidQueryRecordReader<TopNQuery, Result<TopNResultValue>> {
    private Result<TopNResultValue> current;
    private Iterator<DimensionAndMetricValueExtractor> values = Iterators.emptyIterator();

    @Override
    protected TopNQuery createQuery(String content) throws IOException {
        return DruidStorageHandlerUtils.JSON_MAPPER.readValue(content, TopNQuery.class);
    }

    @Override
    protected List<Result<TopNResultValue>> createResultsList(InputStream content) throws IOException {
        return (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(content, (TypeReference)new TypeReference<List<Result<TopNResultValue>>>(){});
    }

    @Override
    public boolean nextKeyValue() {
        if (this.values.hasNext()) {
            return true;
        }
        if (this.results.hasNext()) {
            this.current = (Result)this.results.next();
            this.values = this.current.getValue().getValue().iterator();
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("__time", this.current.getTimestamp().getMillis());
        if (this.values.hasNext()) {
            value.getValue().putAll(this.values.next().getBaseObject());
            return value;
        }
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("__time", this.current.getTimestamp().getMillis());
            if (this.values.hasNext()) {
                value.getValue().putAll(this.values.next().getBaseObject());
            }
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() {
        return this.results.hasNext() || this.values.hasNext() ? 0.0f : 1.0f;
    }
}

