/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidOutputFormat;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.DruidRecordWriter;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.FluentIterable;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.RetryUtils;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.indexer.SQLMetadataStorageUpdaterJobHandler;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.hive.druid.io.druid.metadata.storage.postgresql.PostgreSQLConnector;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidStorageHandler
extends DefaultHiveMetaHook
implements HiveStorageHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidStorageHandler.class);
    protected static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String SEGMENTS_DESCRIPTOR_DIR_NAME = "segmentsDescriptorDir";
    private final SQLMetadataConnector connector;
    private final SQLMetadataStorageUpdaterJobHandler druidSqlMetadataStorageUpdaterJobHandler;
    private final MetadataStorageTablesConfig druidMetadataStorageTablesConfig;
    private HttpClient httpClient;
    private String uniqueId = null;
    private String rootWorkingDir = null;
    private Configuration conf;

    public DruidStorageHandler() {
        String base = HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_BASE);
        String dbType = HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_TYPE);
        final String username = HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_USERNAME);
        final String password = HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_PASSWORD);
        final String uri = HiveConf.getVar((Configuration)SessionState.getSessionConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_METADATA_DB_URI);
        this.druidMetadataStorageTablesConfig = MetadataStorageTablesConfig.fromBase(base);
        Supplier<MetadataStorageConnectorConfig> storageConnectorConfigSupplier = Suppliers.ofInstance(new MetadataStorageConnectorConfig(){

            @Override
            public String getConnectURI() {
                return uri;
            }

            @Override
            public String getUser() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }
        });
        if (dbType.equals("mysql")) {
            this.connector = new MySQLConnector(storageConnectorConfigSupplier, Suppliers.ofInstance(this.druidMetadataStorageTablesConfig));
        } else if (dbType.equals("postgresql")) {
            this.connector = new PostgreSQLConnector(storageConnectorConfigSupplier, Suppliers.ofInstance(this.druidMetadataStorageTablesConfig));
        } else {
            throw new IllegalStateException(String.format("Unknown metadata storage type [%s]", dbType));
        }
        this.druidSqlMetadataStorageUpdaterJobHandler = new SQLMetadataStorageUpdaterJobHandler(this.connector);
    }

    @VisibleForTesting
    public DruidStorageHandler(SQLMetadataConnector connector, SQLMetadataStorageUpdaterJobHandler druidSqlMetadataStorageUpdaterJobHandler, MetadataStorageTablesConfig druidMetadataStorageTablesConfig, HttpClient httpClient) {
        this.connector = connector;
        this.druidSqlMetadataStorageUpdaterJobHandler = druidSqlMetadataStorageUpdaterJobHandler;
        this.druidMetadataStorageTablesConfig = druidMetadataStorageTablesConfig;
        this.httpClient = httpClient;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return DruidQueryBasedInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return DruidOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return DruidSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public void preCreateTable(Table table) throws MetaException {
        if (MetaStoreUtils.isExternalTable((Table)table) && !StringUtils.isEmpty(table.getSd().getLocation())) {
            throw new MetaException("LOCATION may not be specified for Druid");
        }
        if (table.getPartitionKeysSize() != 0) {
            throw new MetaException("PARTITIONED BY may not be specified for Druid");
        }
        if (table.getSd().getBucketColsSize() != 0) {
            throw new MetaException("CLUSTERED BY may not be specified for Druid");
        }
        String dataSourceName = (String)table.getParameters().get("druid.datasource");
        if (MetaStoreUtils.isExternalTable((Table)table)) {
            return;
        }
        try {
            this.connector.createSegmentTable();
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create druid segments table", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        Collection<String> existingDataSources = DruidStorageHandlerUtils.getAllDataSourceNames(this.connector, this.druidMetadataStorageTablesConfig);
        LOG.debug(String.format("pre-create data source with name [%s]", dataSourceName));
        if (existingDataSources.contains(dataSourceName)) {
            throw new MetaException(String.format("Data source [%s] already existing", dataSourceName));
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        if (MetaStoreUtils.isExternalTable((Table)table)) {
            return;
        }
        Path segmentDescriptorDir = this.getSegmentDescriptorDir();
        try {
            List<DataSegment> dataSegmentList = DruidStorageHandlerUtils.getPublishedSegments(segmentDescriptorDir, this.getConf());
            for (DataSegment dataSegment : dataSegmentList) {
                try {
                    this.deleteSegment(dataSegment);
                }
                catch (SegmentLoadingException e) {
                    LOG.error(String.format("Error while trying to clean the segment [%s]", dataSegment), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Exception while rollback", (Throwable)e);
            throw Throwables.propagate(e);
        }
        finally {
            this.cleanWorkingDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitCreateTable(Table table) throws MetaException {
        if (MetaStoreUtils.isExternalTable((Table)table)) {
            return;
        }
        Lifecycle lifecycle = new Lifecycle();
        LOG.info(String.format("Committing table [%s] to the druid metastore", table.getDbName()));
        Path tableDir = this.getSegmentDescriptorDir();
        try {
            List<DataSegment> segmentList = DruidStorageHandlerUtils.getPublishedSegments(tableDir, this.getConf());
            LOG.info(String.format("Found [%d] segments under path [%s]", segmentList.size(), tableDir));
            this.druidSqlMetadataStorageUpdaterJobHandler.publishSegments(this.druidMetadataStorageTablesConfig.getSegmentsTable(), segmentList, DruidStorageHandlerUtils.JSON_MAPPER);
            final String coordinatorAddress = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_COORDINATOR_DEFAULT_ADDRESS);
            int maxTries = HiveConf.getIntVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_TRIES);
            final String dataSourceName = (String)table.getParameters().get("druid.datasource");
            LOG.info(String.format("checking load status from coordinator [%s]", coordinatorAddress));
            this.httpClient = this.makeHttpClient(lifecycle);
            try {
                lifecycle.start();
            }
            catch (Exception e) {
                Throwables.propagate(e);
            }
            String coordinatorResponse = null;
            try {
                coordinatorResponse = RetryUtils.retry(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return DruidStorageHandlerUtils.getURL(DruidStorageHandler.this.httpClient, new URL(String.format("http://%s/status", coordinatorAddress)));
                    }
                }, new Predicate<Throwable>(){

                    @Override
                    public boolean apply(@Nullable Throwable input) {
                        return input instanceof IOException;
                    }
                }, maxTries);
            }
            catch (Exception e) {
                console.printInfo("Will skip waiting for data loading");
                this.cleanWorkingDir();
                lifecycle.stop();
                return;
            }
            if (Strings.isNullOrEmpty(coordinatorResponse)) {
                console.printInfo("Will skip waiting for data loading");
                return;
            }
            console.printInfo(String.format("Waiting for the loading of [%s] segments", segmentList.size()));
            long passiveWaitTimeMs = HiveConf.getLongVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_PASSIVE_WAIT_TIME);
            ImmutableSet<URL> setOfUrls = FluentIterable.from(segmentList).transform(new Function<DataSegment, URL>(){

                @Override
                public URL apply(DataSegment dataSegment) {
                    try {
                        return new URL(String.format("http://%s/druid/coordinator/v1/datasources/%s/segments/%s", coordinatorAddress, dataSourceName, DataSegment.makeDataSegmentIdentifier(dataSegment.getDataSource(), new DateTime(dataSegment.getInterval().getStartMillis(), DateTimeZone.UTC), new DateTime(dataSegment.getInterval().getEndMillis(), DateTimeZone.UTC), dataSegment.getVersion(), dataSegment.getShardSpec())));
                    }
                    catch (MalformedURLException e) {
                        Throwables.propagate(e);
                        return null;
                    }
                }
            }).toSet();
            int numRetries = 0;
            while (numRetries++ < maxTries && !setOfUrls.isEmpty()) {
                setOfUrls = ImmutableSet.copyOf(Sets.filter(setOfUrls, new Predicate<URL>(){

                    @Override
                    public boolean apply(URL input) {
                        try {
                            String result = DruidStorageHandlerUtils.getURL(DruidStorageHandler.this.httpClient, input);
                            LOG.debug(String.format("Checking segment [%s] response is [%s]", input, result));
                            return Strings.isNullOrEmpty(result);
                        }
                        catch (IOException e) {
                            LOG.error(String.format("Error while checking URL [%s]", input), (Throwable)e);
                            return true;
                        }
                    }
                }));
                try {
                    if (setOfUrls.isEmpty()) continue;
                    Thread.sleep(passiveWaitTimeMs);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    Throwables.propagate(e);
                }
            }
            if (!setOfUrls.isEmpty()) {
                console.printError(String.format("Wait time exhausted and we have [%s] out of [%s] segments not loaded yet", setOfUrls.size(), segmentList.size()));
            }
        }
        catch (IOException e) {
            LOG.error("Exception while commit", (Throwable)e);
            Throwables.propagate(e);
        }
        finally {
            this.cleanWorkingDir();
            lifecycle.stop();
        }
    }

    @VisibleForTesting
    protected void deleteSegment(DataSegment segment) throws SegmentLoadingException {
        block6: {
            Path path = DruidStorageHandler.getPath(segment);
            LOG.info(String.format("removing segment[%s], located at path[%s]", segment.getIdentifier(), path));
            try {
                if (path.getName().endsWith(".zip")) {
                    Path intervalDir;
                    FileSystem fs = path.getFileSystem(this.getConf());
                    if (!fs.exists(path)) {
                        LOG.warn(String.format("Segment Path [%s] does not exist. It appears to have been deleted already.", path));
                        return;
                    }
                    Path partitionNumDir = path.getParent();
                    if (!fs.delete(partitionNumDir, true)) {
                        throw new SegmentLoadingException("Unable to kill segment, failed to delete dir [%s]", partitionNumDir.toString());
                    }
                    Path versionDir = partitionNumDir.getParent();
                    if (DruidStorageHandler.safeNonRecursiveDelete(fs, versionDir) && DruidStorageHandler.safeNonRecursiveDelete(fs, intervalDir = versionDir.getParent())) {
                        Path dataSourceDir = intervalDir.getParent();
                        DruidStorageHandler.safeNonRecursiveDelete(fs, dataSourceDir);
                    }
                    break block6;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", path);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    private static Path getPath(DataSegment dataSegment) {
        return new Path(String.valueOf(dataSegment.getLoadSpec().get("path")));
    }

    private static boolean safeNonRecursiveDelete(FileSystem fs, Path path) {
        try {
            return fs.delete(path, false);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        if (MetaStoreUtils.isExternalTable((Table)table)) {
            return;
        }
        String dataSourceName = (String)Preconditions.checkNotNull(table.getParameters().get("druid.datasource"), "DataSource name is null !");
        if (deleteData) {
            LOG.info(String.format("Dropping with purge all the data for data source [%s]", dataSourceName));
            List<DataSegment> dataSegmentList = DruidStorageHandlerUtils.getDataSegmentList(this.connector, this.druidMetadataStorageTablesConfig, dataSourceName);
            if (dataSegmentList.isEmpty()) {
                LOG.info(String.format("Nothing to delete for data source [%s]", dataSourceName));
                return;
            }
            for (DataSegment dataSegment : dataSegmentList) {
                try {
                    this.deleteSegment(dataSegment);
                }
                catch (SegmentLoadingException e) {
                    LOG.error(String.format("Error while deleting segment [%s]", dataSegment.getIdentifier()), (Throwable)e);
                }
            }
        }
        if (DruidStorageHandlerUtils.disableDataSource(this.connector, this.druidMetadataStorageTablesConfig, dataSourceName)) {
            LOG.info(String.format("Successfully dropped druid data source [%s]", dataSourceName));
        }
    }

    public void commitInsertTable(Table table, boolean overwrite) throws MetaException {
        if (!overwrite) {
            throw new MetaException("Insert into is not supported yet");
        }
        LOG.debug(String.format("commit insert overwrite into table [%s]", table.getTableName()));
        this.commitCreateTable(table);
    }

    public void preInsertTable(Table table, boolean overwrite) throws MetaException {
        if (!overwrite) {
            throw new MetaException("INSERT INTO statement is not allowed by druid storage handler");
        }
    }

    public void rollbackInsertTable(Table table, boolean overwrite) throws MetaException {
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        jobProperties.put("druid.segment.version", new DateTime().toString());
        jobProperties.put("druid.job.workingDirectory", this.getStagingWorkingDir().toString());
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            DruidStorageHandlerUtils.addDependencyJars((Configuration)jobConf, DruidRecordWriter.class);
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String toString() {
        return "org.apache.hadoop.hive.druid.DruidStorageHandler";
    }

    public String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = Preconditions.checkNotNull(Strings.emptyToNull(HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID)), "Hive query id is null");
        }
        return this.uniqueId;
    }

    private Path getStagingWorkingDir() {
        return new Path(this.getRootWorkingDir(), this.makeStagingName());
    }

    @VisibleForTesting
    protected String makeStagingName() {
        return ".staging-".concat(this.getUniqueId().replace(":", ""));
    }

    private Path getSegmentDescriptorDir() {
        return new Path(this.getStagingWorkingDir(), SEGMENTS_DESCRIPTOR_DIR_NAME);
    }

    private void cleanWorkingDir() {
        try {
            FileSystem fileSystem = this.getStagingWorkingDir().getFileSystem(this.getConf());
            fileSystem.delete(this.getStagingWorkingDir(), true);
        }
        catch (IOException e) {
            LOG.error("Got Exception while cleaning working directory", (Throwable)e);
        }
    }

    private String getRootWorkingDir() {
        if (Strings.isNullOrEmpty(this.rootWorkingDir)) {
            this.rootWorkingDir = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_WORKING_DIR);
        }
        return this.rootWorkingDir;
    }

    private HttpClient makeHttpClient(Lifecycle lifecycle) {
        int numConnection = HiveConf.getIntVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        Period readTimeout = new Period((Object)HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        return HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(numConnection).withReadTimeout(new Period((Object)readTimeout).toStandardDuration()).build(), lifecycle);
    }
}

