/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.conftool;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.conftool.ConfTool;
import org.apache.hive.conftool.ConfToolUtil;
import org.apache.hive.conftool.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ConfCli {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfCli.class.getName());
    private static final Options CMD_LINE_OPTIONS = new Options();
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    private static final String HELP = "help";
    private static final String MAPR_SASL = "maprsasl";
    private static final String SECURITY = "security";
    private static final String PATH = "path";
    private static final String TOOL_NAME = "conftool";
    private static final String HS2_HA = "hs2ha";
    private static final String ZK_QUORUM = "zkquorum";
    private static final String INIT_META_STORE_URI = "initMetastoreUri";
    private static final String CONNECTION_URL = "connurl";
    private static final String WEB_UI_PAM_SSL = "webuipamssl";
    private static final String EXIST_PROPERTY = "existProperty";
    private static final String WEBHCAT_SSL = "webhcatssl";
    private static final String HS2_SSL = "hs2ssl";
    private static final String METASTORE_SSL = "hmetassl";
    private static final String ADMIN_USER = "adminUser";
    private static final String ADD_PROPERTY = "addProperty";
    private static final String APPEND_PROPERTY = "appendProperty";
    private static final String RESTRICTED_LIST = "restrictedList";
    private static final String DEL_PROPERTY = "delProperty";
    private static final String GET_PROPERTY = "getProperty";
    private static final String FALLBACK_AUTHORIZER = "fallBackAuthorizer";
    private static final String HIVE_SERVER2_METRICS_ENABLED = "hiveserver2_metrics_enabled";
    private static final String METASTORE_METRICS_ENABLED = "metastore_metrics_enabled";
    private static final String REPORTER_ENABLED = "reporter_enabled";
    private static final String METRICS_REPORTER_TYPE = "reporter_type";
    private static final String JSON_JMX_METASTORE_METRICS_FILE_LOCATION = "hmeta_report_file";
    private static final String JSON_JMX_HIVE_SERVER2_METRICS_FILE_LOCATION = "hs2_report_file";

    private ConfCli() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        GnuParser cmdParser = new GnuParser();
        CommandLine line = null;
        try {
            line = cmdParser.parse(CMD_LINE_OPTIONS, args);
        }
        catch (ParseException e) {
            ConfCli.printHelp();
            throw new IllegalArgumentException("conftool: Parsing failed.  Reason: " + e.getLocalizedMessage());
        }
        if (line == null) {
            throw new IllegalArgumentException("conftool: parsing failed.  Reason: unknown");
        }
        if (line.hasOption(HELP)) {
            ConfCli.printHelp();
            return;
        } else if (line.hasOption(PATH)) {
            String fileLocation;
            String value;
            String property;
            String[] optionValues;
            String property2;
            String pathToXmlFile = line.getOptionValue(PATH);
            if (ConfCli.isSecurityConfig(line)) {
                ConfCli.configureSecurity(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isHs2HaConfig(line)) {
                if (ConfCli.hasValidHs2HaOptions(line)) {
                    String zookeeperQuorum = line.getOptionValue(ZK_QUORUM);
                    ConfTool.enableHs2Ha(pathToXmlFile, zookeeperQuorum);
                } else {
                    ConfCli.printHelp();
                    throw new IllegalArgumentException("Incorrect HS2 HA configuration options");
                }
            }
            if (ConfCli.isMetaStoreUriConfig(line)) {
                ConfTool.initMetaStoreUri(pathToXmlFile);
            }
            if (ConfCli.isExistVerification(line)) {
                if (ConfCli.hasValidExistPropertyOptions(line)) {
                    property2 = line.getOptionValue(EXIST_PROPERTY);
                    ConfToolUtil.printBool(ConfTool.exists(pathToXmlFile, property2));
                } else {
                    ConfCli.printHelp();
                    throw new IllegalArgumentException("Incorrect property verification options");
                }
            }
            if (ConfCli.isConnectionUrlConfig(line)) {
                if (ConfCli.hasValidConnectionUrlOptions(line)) {
                    String connectionUrl = line.getOptionValue(CONNECTION_URL);
                    ConfTool.setConnectionUrl(pathToXmlFile, connectionUrl);
                } else {
                    ConfCli.printHelp();
                    throw new IllegalArgumentException("Incorrect connection URL configuration options");
                }
            }
            if (ConfCli.isDelProperty(line)) {
                property2 = line.getOptionValue(DEL_PROPERTY);
                ConfTool.delProperty(pathToXmlFile, property2);
            }
            if (ConfCli.isAddProperty(line) && (optionValues = line.getOptionValues(ADD_PROPERTY)).length == 2) {
                property = optionValues[0];
                value = optionValues[1];
                ConfTool.addProperty(pathToXmlFile, property, value);
            }
            if (ConfCli.isAppendProperty(line) && (optionValues = line.getOptionValues(APPEND_PROPERTY)).length == 2) {
                property = optionValues[0];
                value = optionValues[1];
                ConfTool.appendProperty(pathToXmlFile, property, value);
            }
            if (ConfCli.isRestrictedList(line)) {
                ConfTool.setRestrictedList(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isGetProperty(line)) {
                property2 = line.getOptionValue(GET_PROPERTY);
                String propertyValue = ConfTool.getProperty(pathToXmlFile, property2);
                if (propertyValue.isEmpty()) throw new IllegalArgumentException("Property does not exist!");
                System.out.print(propertyValue);
            }
            if (ConfCli.isWebUiHs2PamSslConfig(line)) {
                ConfTool.setHs2WebUiPamSsl(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isWeHCatSslConfig(line)) {
                ConfTool.setWebHCatSsl(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isHs2SslConfig(line)) {
                ConfTool.setHs2Ssl(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isHMetaSslConfig(line)) {
                ConfTool.setHMetaSsl(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isAdminUser(line)) {
                String adminUser = line.getOptionValue(ADMIN_USER);
                ConfTool.setAdminUser(pathToXmlFile, adminUser, ConfCli.getSecurity(line));
            }
            if (ConfCli.isFallbackAuthorizer(line)) {
                ConfTool.setFallbackAuthorizer(pathToXmlFile, ConfCli.getSecurity(line));
            }
            if (ConfCli.isHiveServer2Metrics(line)) {
                boolean isMetricsEnabled = Boolean.parseBoolean(line.getOptionValue(HIVE_SERVER2_METRICS_ENABLED));
                ConfTool.configureHs2Metrics(pathToXmlFile, isMetricsEnabled);
            }
            if (ConfCli.isMetasoreMetrics(line)) {
                boolean isMetricsEnabled = Boolean.parseBoolean(line.getOptionValue(METASTORE_METRICS_ENABLED));
                ConfTool.configureMetastoreMetrics(pathToXmlFile, isMetricsEnabled);
            }
            if (!ConfCli.isReporterConfig(line)) return;
            boolean isReporterEnabled = Boolean.parseBoolean(line.getOptionValue(REPORTER_ENABLED));
            if (ConfCli.isMetricsReporterType(line)) {
                String reporterType = line.getOptionValue(METRICS_REPORTER_TYPE);
                if (!ConfToolUtil.isNotNullNotEmpty(reporterType)) throw new IllegalArgumentException("Incorrect metrics reporter type: empty string");
                ConfTool.configureMetricsReporterType(pathToXmlFile, isReporterEnabled, reporterType);
            }
            if (ConfCli.isHiveServer2MetricsReporterFileLocation(line)) {
                fileLocation = line.getOptionValue(JSON_JMX_HIVE_SERVER2_METRICS_FILE_LOCATION);
                if (!ConfToolUtil.isNotNullNotEmpty(fileLocation)) throw new IllegalArgumentException("Incorrect metrics reporter file location: empty string");
                ConfTool.configureHiveServer2MetricsFileLocation(pathToXmlFile, isReporterEnabled, fileLocation);
            }
            if (!ConfCli.isMetastoreMetricsReporterFileLocation(line)) return;
            fileLocation = line.getOptionValue(JSON_JMX_METASTORE_METRICS_FILE_LOCATION);
            if (!ConfToolUtil.isNotNullNotEmpty(fileLocation)) throw new IllegalArgumentException("Incorrect metrics reporter file location: empty string");
            ConfTool.configureHiveMetastoreMetricsFileLocation(pathToXmlFile, isReporterEnabled, fileLocation);
            return;
        } else {
            ConfCli.printHelp();
        }
    }

    private static boolean isConnectionUrlConfig(CommandLine line) {
        return line.hasOption(CONNECTION_URL);
    }

    private static boolean hasValidConnectionUrlOptions(CommandLine line) {
        return line.getOptionValue(CONNECTION_URL) != null && !line.getOptionValue(CONNECTION_URL).isEmpty();
    }

    private static boolean isSecurityConfig(CommandLine line) {
        return line.hasOption(MAPR_SASL);
    }

    private static boolean hasValidSecurityOptions(CommandLine line) {
        return line.hasOption(SECURITY) && ConfToolUtil.isTrueOrFalseOrCustom(line.getOptionValue(SECURITY));
    }

    private static void configureSecurity(String pathToHiveSite, Security security) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ConfTool.setMaprSasl(pathToHiveSite, security);
        ConfTool.setEncryption(pathToHiveSite, security);
        ConfTool.setMetaStoreUgi(pathToHiveSite, security);
        ConfTool.setMetaStoreAuthManager(pathToHiveSite, security);
    }

    private static Security getSecurity(CommandLine line) {
        if (ConfCli.hasValidSecurityOptions(line)) {
            return Security.parse(line.getOptionValue(SECURITY));
        }
        ConfCli.printHelp();
        throw new IllegalArgumentException("Incorrect security configuration options");
    }

    private static boolean isHs2HaConfig(CommandLine line) {
        return line.hasOption(HS2_HA);
    }

    private static boolean isMetaStoreUriConfig(CommandLine line) {
        return line.hasOption(INIT_META_STORE_URI);
    }

    private static boolean hasValidHs2HaOptions(CommandLine line) {
        return line.hasOption(HS2_HA) && line.getOptionValue(ZK_QUORUM) != null && !line.getOptionValue(ZK_QUORUM).isEmpty();
    }

    private static boolean isDelProperty(CommandLine line) {
        return line.hasOption(DEL_PROPERTY);
    }

    private static boolean isAddProperty(CommandLine line) {
        return line.hasOption(ADD_PROPERTY);
    }

    private static boolean isAppendProperty(CommandLine line) {
        return line.hasOption(APPEND_PROPERTY);
    }

    private static boolean isRestrictedList(CommandLine line) {
        return line.hasOption(RESTRICTED_LIST);
    }

    private static boolean isGetProperty(CommandLine line) {
        return line.hasOption(GET_PROPERTY);
    }

    private static boolean isWebUiHs2PamSslConfig(CommandLine line) {
        return line.hasOption(WEB_UI_PAM_SSL);
    }

    private static boolean isExistVerification(CommandLine line) {
        return line.hasOption(EXIST_PROPERTY);
    }

    private static boolean hasValidExistPropertyOptions(CommandLine line) {
        return line.hasOption(EXIST_PROPERTY) && line.getOptionValue(EXIST_PROPERTY) != null && !line.getOptionValue(EXIST_PROPERTY).isEmpty();
    }

    private static boolean isWeHCatSslConfig(CommandLine line) {
        return line.hasOption(WEBHCAT_SSL);
    }

    private static boolean isHs2SslConfig(CommandLine line) {
        return line.hasOption(HS2_SSL);
    }

    private static boolean isHMetaSslConfig(CommandLine line) {
        return line.hasOption(METASTORE_SSL);
    }

    private static boolean isAdminUser(CommandLine line) {
        return line.hasOption(ADMIN_USER);
    }

    private static boolean isFallbackAuthorizer(CommandLine line) {
        return line.hasOption(FALLBACK_AUTHORIZER);
    }

    private static boolean isHiveServer2Metrics(CommandLine line) {
        return line.hasOption(HIVE_SERVER2_METRICS_ENABLED) && ConfToolUtil.isTrueOrFalse(line.getOptionValue(HIVE_SERVER2_METRICS_ENABLED));
    }

    private static boolean isMetasoreMetrics(CommandLine line) {
        return line.hasOption(METASTORE_METRICS_ENABLED) && ConfToolUtil.isTrueOrFalse(line.getOptionValue(METASTORE_METRICS_ENABLED));
    }

    private static boolean isReporterConfig(CommandLine line) {
        return line.hasOption(REPORTER_ENABLED) && ConfToolUtil.isTrueOrFalse(line.getOptionValue(REPORTER_ENABLED));
    }

    private static boolean isMetricsReporterType(CommandLine line) {
        return line.hasOption(METRICS_REPORTER_TYPE);
    }

    private static boolean isMetastoreMetricsReporterFileLocation(CommandLine line) {
        return line.hasOption(JSON_JMX_METASTORE_METRICS_FILE_LOCATION);
    }

    private static boolean isHiveServer2MetricsReporterFileLocation(CommandLine line) {
        return line.hasOption(JSON_JMX_HIVE_SERVER2_METRICS_FILE_LOCATION);
    }

    private static void printHelp() {
        HELP_FORMATTER.printHelp(TOOL_NAME, CMD_LINE_OPTIONS);
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Print help information");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HELP));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures hive-site.xml for MapR-SASL security");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)MAPR_SASL));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true or false for security");
        OptionBuilder.withDescription((String)"Shows current status of security");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)SECURITY));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path to xml file");
        OptionBuilder.withDescription((String)"Path to xml file to configure (hive-site.xml, webhcat-site.xml etc).");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)PATH));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures hive-site.xml for HiveServer2 High Availability");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HS2_HA));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Initializes Hive metastore Uri to run on local host");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)INIT_META_STORE_URI));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"quorum");
        OptionBuilder.withDescription((String)"Hive Zookeeper Quorum");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)ZK_QUORUM));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"connection-url");
        OptionBuilder.withDescription((String)"Metastore DB connection URL");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)CONNECTION_URL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures hive-site.xml for HiveServer2 web UI PAM authentication and SSL encryption");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)WEB_UI_PAM_SSL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures webhcat-site.xml for webHCat SSL encryption");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)WEBHCAT_SSL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures hive-site.xml for HS2 SSL encryption");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HS2_SSL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures hive-site.xml for Hive Metastore SSL encryption");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)METASTORE_SSL));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"user name");
        OptionBuilder.withDescription((String)"Admin user will be appended to existing property(hive.user.in.admin.role) using coma separator. In case it does not exist, it will be added as a new value.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)ADMIN_USER));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property to check");
        OptionBuilder.withDescription((String)"Checks if property is set in xml file.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)EXIST_PROPERTY));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Key, value of property that should be written to xml file. In case it already exists, it is replaced with new value. Property is added like: \n<property>\n  <name>property-name<\\name>\n  <value>property-value<\\value>\n<\\property>");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)ADD_PROPERTY));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=appendedValue");
        OptionBuilder.withDescription((String)"Value will be appended to existing property using coma separator. In case it does not exist, it will be added as a new value.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)APPEND_PROPERTY));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures restricted list of options that are immutable at runtime");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)RESTRICTED_LIST));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Configures FallbackHiveAuthorizerFactory by default on MapR SASL cluster");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)FALLBACK_AUTHORIZER));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property-name");
        OptionBuilder.withDescription((String)"Removes property from xml file");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)DEL_PROPERTY));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property-name");
        OptionBuilder.withDescription((String)"Retrieves the property value.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)GET_PROPERTY));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true/false value");
        OptionBuilder.withDescription((String)"Enables/disables Hiveserver2 for collecting metrics");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HIVE_SERVER2_METRICS_ENABLED));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true/false value");
        OptionBuilder.withDescription((String)"Enables/disables Hive Metastore for collecting metrics");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)METASTORE_METRICS_ENABLED));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true/false value");
        OptionBuilder.withDescription((String)"Enables/disables reporter for collecting metrics");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)REPORTER_ENABLED));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"metrics reporter type");
        OptionBuilder.withDescription((String)"Configures metrics reporter type");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)METRICS_REPORTER_TYPE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"metrics file location");
        OptionBuilder.withDescription((String)"Configures HiveServer2 metrics output file location");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)JSON_JMX_HIVE_SERVER2_METRICS_FILE_LOCATION));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"metrics file location");
        OptionBuilder.withDescription((String)"Configures Metastore metrics output file location");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)JSON_JMX_METASTORE_METRICS_FILE_LOCATION));
    }
}

