/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.om;

import com.ircclouds.irc.api.domain.ChannelMode;
import com.ircclouds.irc.api.domain.ChannelModeA;
import com.ircclouds.irc.api.domain.ChannelModeB;
import com.ircclouds.irc.api.domain.ChannelModeC;
import com.ircclouds.irc.api.domain.ChannelModeD;
import com.ircclouds.irc.api.domain.ChannelModes;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.IRCUserStatusMode;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.messages.ChannelModeMessage;
import com.ircclouds.irc.api.om.IBuilder;
import com.ircclouds.irc.api.utils.ParseUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractChanModeBuilder
implements IBuilder<ChannelModeMessage> {
    @Override
    public ChannelModeMessage build(String aMessage) {
        String[] _cmpnts = aMessage.split(" ");
        Stack<String> _params = this.createParamsInStack(_cmpnts);
        ArrayList<ChannelMode> _addedModes = new ArrayList<ChannelMode>();
        ArrayList<ChannelMode> _removedModes = new ArrayList<ChannelMode>();
        String _modesStr = _cmpnts[3];
        for (int _i = 0; _i < _modesStr.length(); ++_i) {
            int _plusIndex = _modesStr.indexOf("+", _i + 1);
            int _minusIndex = _modesStr.indexOf("-", _i + 1);
            int _end = 0;
            _end = _plusIndex < _minusIndex ? (_plusIndex != -1 ? _plusIndex : _minusIndex) : (_minusIndex < _plusIndex ? (_minusIndex != -1 ? _minusIndex : _plusIndex) : _modesStr.length());
            char _m = _modesStr.charAt(_i);
            String _mode = _modesStr.substring(_i + 1, _end);
            _i = _end - 1;
            if (_m == '+') {
                this.parseModes(_params, _addedModes, _mode, true);
                continue;
            }
            this.parseModes(_params, _removedModes, _mode, false);
        }
        return new ChannelModeMessage(ParseUtils.getSource(_cmpnts[0]), _cmpnts[2], this.getModeStr(_cmpnts), _addedModes, _removedModes);
    }

    protected abstract IRCServerOptions getIRCServerOptions();

    private String getModeStr(String[] aCmpnts) {
        StringBuilder _sb = new StringBuilder();
        int _i = aCmpnts.length;
        for (int _j = 3; _j < _i; ++_j) {
            _sb.append(aCmpnts[_j]).append(" ");
        }
        return _sb.substring(0, _sb.length() - 1).toString();
    }

    private Stack<String> createParamsInStack(String[] aCmpnts) {
        Stack<String> _params = new Stack<String>();
        int _i = aCmpnts.length;
        for (int _j = _i - 1; _j > 3; --_j) {
            _params.push(aCmpnts[_j]);
        }
        return _params;
    }

    private void parseModes(Stack<String> aParams, List<ChannelMode> aModes, String aModesStr, boolean aAddFlag) {
        for (int _i = 0; _i < aModesStr.length(); ++_i) {
            char _mode = aModesStr.charAt(_i);
            if (this.getChannelModes().isOfTypeA(Character.valueOf(_mode))) {
                aModes.add(new ChannelModeA(Character.valueOf(_mode), aParams.pop()));
                continue;
            }
            if (this.getChannelModes().isOfTypeB(Character.valueOf(_mode))) {
                aModes.add(new ChannelModeB(Character.valueOf(_mode), aParams.pop()));
                continue;
            }
            if (this.getChannelModes().isOfTypeC(Character.valueOf(_mode))) {
                if (aAddFlag) {
                    aModes.add(new ChannelModeC(Character.valueOf(_mode), aParams.pop()));
                    continue;
                }
                aModes.add(new ChannelModeC(Character.valueOf(_mode)));
                continue;
            }
            if (this.getChannelModes().isOfTypeD(Character.valueOf(_mode))) {
                aModes.add(new ChannelModeD(Character.valueOf(_mode)));
                continue;
            }
            if (!this.getUserStatuses().contains(Character.valueOf(_mode))) continue;
            aModes.add(new IRCUserStatusMode(this.getUserStatuses().getUserStatus(Character.valueOf(_mode)), aParams.pop()));
        }
    }

    private IRCUserStatuses getUserStatuses() {
        return this.getIRCServerOptions().getUserChanStatuses();
    }

    private ChannelModes getChannelModes() {
        return this.getIRCServerOptions().getChannelModes();
    }
}

