/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.IMessageDispatcher;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ChannelActionMsg;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ChannelModeMessage;
import com.ircclouds.irc.api.domain.messages.ChannelNotice;
import com.ircclouds.irc.api.domain.messages.ChannelPrivMsg;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNotice;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.ServerPing;
import com.ircclouds.irc.api.domain.messages.TopicMessage;
import com.ircclouds.irc.api.domain.messages.UserActionMsg;
import com.ircclouds.irc.api.domain.messages.UserNotice;
import com.ircclouds.irc.api.domain.messages.UserPing;
import com.ircclouds.irc.api.domain.messages.UserPrivMsg;
import com.ircclouds.irc.api.domain.messages.UserVersion;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.filters.HowMany;
import com.ircclouds.irc.api.filters.TargetListeners;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.IVariousMessageListener;
import com.ircclouds.irc.api.listeners.MESSAGE_VISIBILITY;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageDispatcherImpl
implements IMessageDispatcher {
    private static Logger LOG = LoggerFactory.getLogger(MessageDispatcherImpl.class);
    private Map<MESSAGE_VISIBILITY, List<IMessageListener>> listenersMap = new HashMap<MESSAGE_VISIBILITY, List<IMessageListener>>();

    public MessageDispatcherImpl() {
        this.listenersMap.put(MESSAGE_VISIBILITY.PRIVATE, new ArrayList());
        this.listenersMap.put(MESSAGE_VISIBILITY.PUBLIC, new ArrayList());
    }

    @Override
    public void dispatch(IMessage aMessage, TargetListeners aTargetListeners) {
        if (aTargetListeners.getHowMany().equals((Object)HowMany.ALL)) {
            this.dispatchTo(aMessage, new ArrayList<IMessageListener>((Collection)this.listenersMap.get((Object)MESSAGE_VISIBILITY.PUBLIC)));
        } else {
            this.dispatchTo(aMessage, aTargetListeners.getListeners());
        }
    }

    @Override
    public void dispatchToPrivateListeners(IMessage aMessage) {
        this.dispatchTo(aMessage, new ArrayList<IMessageListener>((Collection)this.listenersMap.get((Object)MESSAGE_VISIBILITY.PRIVATE)));
    }

    @Override
    public void register(IMessageListener aListener, MESSAGE_VISIBILITY aVisibility) {
        this.listenersMap.get((Object)aVisibility).add(aListener);
    }

    @Override
    public void unregister(IMessageListener aListener) {
        this.listenersMap.get((Object)MESSAGE_VISIBILITY.PUBLIC).remove(aListener);
        this.listenersMap.get((Object)MESSAGE_VISIBILITY.PUBLIC).remove(aListener);
    }

    private void dispatchTo(IMessage aMessage, List<IMessageListener> aListeners) {
        for (IMessageListener _listener : aListeners) {
            try {
                if (_listener instanceof IVariousMessageListener) {
                    this.dispatchVarious((IVariousMessageListener)_listener, aMessage);
                    continue;
                }
                _listener.onMessage(aMessage);
            }
            catch (Exception aExc) {
                LOG.error("", (Throwable)aExc);
            }
        }
    }

    private void dispatchVarious(IVariousMessageListener aListener, IMessage aMessage) {
        if (aMessage instanceof ChanJoinMessage) {
            aListener.onChannelJoin((ChanJoinMessage)aMessage);
        } else if (aMessage instanceof ChanPartMessage) {
            aListener.onChannelPart((ChanPartMessage)aMessage);
        } else if (aMessage instanceof ChannelNotice) {
            aListener.onChannelNotice((ChannelNotice)aMessage);
        } else if (aMessage instanceof ChannelActionMsg) {
            aListener.onChannelAction((ChannelActionMsg)aMessage);
        } else if (aMessage instanceof ChannelKick) {
            aListener.onChannelKick((ChannelKick)aMessage);
        } else if (aMessage instanceof ChannelPrivMsg) {
            aListener.onChannelMessage((ChannelPrivMsg)aMessage);
        } else if (aMessage instanceof TopicMessage) {
            aListener.onTopicChange((TopicMessage)aMessage);
        } else if (aMessage instanceof UserPrivMsg) {
            if (aMessage instanceof UserVersion) {
                aListener.onUserVersion((UserVersion)aMessage);
            } else if (aMessage instanceof UserPing) {
                aListener.onUserPing((UserPing)aMessage);
            } else if (aMessage instanceof UserActionMsg) {
                aListener.onUserAction((UserActionMsg)aMessage);
            } else {
                aListener.onUserPrivMessage((UserPrivMsg)aMessage);
            }
        } else if (aMessage instanceof UserNotice) {
            aListener.onUserNotice((UserNotice)aMessage);
        } else if (aMessage instanceof ServerNumericMessage) {
            aListener.onServerNumericMessage((ServerNumericMessage)aMessage);
        } else if (aMessage instanceof ServerNotice) {
            aListener.onServerNotice((ServerNotice)aMessage);
        } else if (aMessage instanceof NickMessage) {
            aListener.onNickChange((NickMessage)aMessage);
        } else if (aMessage instanceof QuitMessage) {
            aListener.onUserQuit((QuitMessage)aMessage);
        } else if (aMessage instanceof ErrorMessage) {
            aListener.onError((ErrorMessage)aMessage);
        } else if (aMessage instanceof ChannelModeMessage) {
            aListener.onChannelMode((ChannelModeMessage)aMessage);
        } else if (aMessage instanceof ServerPing) {
            aListener.onServerPing((ServerPing)aMessage);
        } else {
            aListener.onMessage(aMessage);
        }
    }
}

