/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.CompressionFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class LongsLongEncodingReader
implements CompressionFactory.LongEncodingReader {
    private LongBuffer buffer;

    public LongsLongEncodingReader(ByteBuffer fromBuffer, ByteOrder order) {
        this.buffer = fromBuffer.asReadOnlyBuffer().order(order).asLongBuffer();
    }

    private LongsLongEncodingReader(LongBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer.asLongBuffer();
    }

    @Override
    public long read(int index) {
        return this.buffer.get(this.buffer.position() + index);
    }

    @Override
    public int getNumBytes(int values) {
        return values * 8;
    }

    @Override
    public CompressionFactory.LongEncodingReader duplicate() {
        return new LongsLongEncodingReader(this.buffer.duplicate());
    }
}

