/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedLongs;
import io.druid.segment.data.LongsLongEncodingReader;
import io.druid.segment.data.VSizeCompressedObjectStrategy;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class BlockLayoutIndexedLongSupplier
implements Supplier<IndexedLongs> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseLongBuffers;
    private final int totalSize;
    private final int sizePer;
    private final CompressionFactory.LongEncodingReader baseReader;

    public BlockLayoutIndexedLongSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionFactory.LongEncodingReader reader, CompressedObjectStrategy.CompressionStrategy strategy) {
        this.baseLongBuffers = GenericIndexed.read(fromBuffer, VSizeCompressedObjectStrategy.getBufferForOrder(order, strategy, reader.getNumBytes(sizePer)));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseReader = reader;
    }

    public IndexedLongs get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            if (this.baseReader instanceof LongsLongEncodingReader) {
                return new BlockLayoutIndexedLongs(){

                    @Override
                    public long get(int index) {
                        int bufferNum = index >> div;
                        if (bufferNum != this.currIndex) {
                            this.loadBuffer(bufferNum);
                        }
                        int bufferIndex = index & rem;
                        return this.longBuffer.get(this.longBuffer.position() + bufferIndex);
                    }

                    @Override
                    protected void loadBuffer(int bufferNum) {
                        CloseQuietly.close((Closeable)this.holder);
                        this.holder = (ResourceHolder)this.singleThreadedLongBuffers.get(bufferNum);
                        this.buffer = (ByteBuffer)this.holder.get();
                        this.longBuffer = this.buffer.asLongBuffer();
                        this.currIndex = bufferNum;
                    }
                };
            }
            return new BlockLayoutIndexedLongs(){

                @Override
                public long get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.reader.read(bufferIndex);
                }
            };
        }
        return new BlockLayoutIndexedLongs();
    }

    private class BlockLayoutIndexedLongs
    implements IndexedLongs {
        final CompressionFactory.LongEncodingReader reader;
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedLongBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        LongBuffer longBuffer;

        private BlockLayoutIndexedLongs() {
            this.reader = BlockLayoutIndexedLongSupplier.this.baseReader.duplicate();
            this.singleThreadedLongBuffers = BlockLayoutIndexedLongSupplier.this.baseLongBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutIndexedLongSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            int bufferNum = index / BlockLayoutIndexedLongSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutIndexedLongSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.reader.read(bufferIndex);
        }

        @Override
        public void fill(int index, long[] toFill) {
            if (BlockLayoutIndexedLongSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutIndexedLongSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedLongBuffers.get(bufferNum);
            this.buffer = (ByteBuffer)this.holder.get();
            this.currIndex = bufferNum;
            this.reader.setBuffer(this.buffer);
        }

        public String toString() {
            return "BlockCompressedIndexedLongs_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutIndexedLongSupplier.this.sizePer + ", numChunks=" + this.singleThreadedLongBuffers.size() + ", totalSize=" + BlockLayoutIndexedLongSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }
    }
}

