/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import io.druid.segment.column.AbstractColumn;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.IndexedLongsGenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedLongsIndexedSupplier;

public class LongColumn
extends AbstractColumn {
    private static final ColumnCapabilitiesImpl CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.LONG);
    private final CompressedLongsIndexedSupplier column;

    public LongColumn(CompressedLongsIndexedSupplier column) {
        this.column = column;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getLength() {
        return this.column.size();
    }

    @Override
    public GenericColumn getGenericColumn() {
        return new IndexedLongsGenericColumn(this.column.get());
    }
}

