/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.ordering;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.metamx.common.IAE;
import io.druid.query.ordering.StringComparators;
import java.util.Comparator;

public abstract class StringComparator
implements Comparator<String> {
    @JsonCreator
    public static StringComparator fromString(String type) {
        switch (type.toLowerCase()) {
            case "lexicographic": {
                return StringComparators.LEXICOGRAPHIC;
            }
            case "alphanumeric": {
                return StringComparators.ALPHANUMERIC;
            }
            case "strlen": {
                return StringComparators.STRLEN;
            }
            case "numeric": {
                return StringComparators.NUMERIC;
            }
        }
        throw new IAE("Unknown string comparator[%s]", new Object[]{type});
    }

    public abstract byte[] getCacheKey();
}

