/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.strategy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.nary.BinaryFn;
import io.druid.collections.BlockingPool;
import io.druid.collections.StupidPool;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularities;
import io.druid.granularity.QueryGranularity;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Merging;
import io.druid.guice.annotations.Smile;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import io.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import io.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import io.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import io.druid.query.groupby.strategy.GroupByStrategy;
import io.druid.segment.StorageAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.DateTime;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final StupidPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Global StupidPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    public static DateTime getUniversalTimestamp(GroupByQuery query) {
        QueryGranularity gran = query.getGranularity();
        String timestampStringFromContext = query.getContextValue(CTX_KEY_FUDGE_TIMESTAMP, "");
        if (!timestampStringFromContext.isEmpty()) {
            return new DateTime(Long.parseLong(timestampStringFromContext));
        }
        if (QueryGranularities.ALL.equals(gran)) {
            long timeStart = query.getIntervals().get(0).getStartMillis();
            return new DateTime((Object)gran.iterable(timeStart, timeStart + 1L).iterator().next());
        }
        return null;
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, final GroupByQuery query, Map<String, Object> responseContext) {
        ResultMergeQueryRunner<Row> mergingQueryRunner = new ResultMergeQueryRunner<Row>(baseRunner){

            @Override
            protected Ordering<Row> makeOrdering(Query<Row> queryParam) {
                return ((GroupByQuery)queryParam).getRowOrdering(true);
            }

            @Override
            protected BinaryFn<Row, Row, Row> createMergeFn(Query<Row> queryParam) {
                return new GroupByBinaryFnV2((GroupByQuery)queryParam);
            }
        };
        DateTime fudgeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query);
        return query.applyLimit((Sequence<Row>)Sequences.map(mergingQueryRunner.run(new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), (List<PostAggregator>)ImmutableList.of(), null, null, query.getContext()).withOverriddenContext((Map)ImmutableMap.of((Object)"finalize", (Object)false, (Object)"groupByStrategy", (Object)"v2", (Object)CTX_KEY_FUDGE_TIMESTAMP, (Object)(fudgeTimestamp == null ? "" : String.valueOf(fudgeTimestamp.getMillis())))), responseContext), (Function)new Function<Row, Row>(){

            public Row apply(Row row) {
                Map newMap;
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    newMap = ((MapBasedRow)row).getEvent();
                } else {
                    newMap = Maps.newLinkedHashMap((Map)((MapBasedRow)row).getEvent());
                    for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
                        newMap.put(postAggregator.getName(), postAggregator.compute(newMap));
                    }
                }
                return new MapBasedRow(row.getTimestamp(), newMap);
            }
        }));
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, Sequence<Row> subqueryResult) {
        final Sequence<Row> results = GroupByRowProcessor.process(query, subqueryResult, (GroupByQueryConfig)this.configSupplier.get(), this.mergeBufferPool, this.spillMapper);
        return this.mergeResults(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                return results;
            }
        }, query, null);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergingQueryRunnerV2((GroupByQueryConfig)this.configSupplier.get(), (ExecutorService)exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.mergeBufferPool, this.spillMapper);
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, (GroupByQueryConfig)this.configSupplier.get());
    }
}

