/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Map;

public class Pair<A, B> {
    A first;
    B second;

    public Pair(A f, B s) {
        this.first = f;
        this.second = s;
    }

    private int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public int hashCode() {
        return this.hashCode(this.first) + this.hashCode(this.second);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair op = (Pair)o;
            return this.equals(this.first, op.first) && this.equals(this.second, op.second);
        }
        return false;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return this.toString("(", ",", ")");
    }

    public String toString(String prefix, String separator, String suffix) {
        return prefix + this.first + separator + this.second + suffix;
    }

    public Map.Entry<A, B> toMapEntry() {
        return new Map.Entry<A, B>(){

            @Override
            public A getKey() {
                return Pair.this.getFirst();
            }

            @Override
            public B getValue() {
                return Pair.this.getSecond();
            }

            @Override
            public B setValue(B value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Pair<B, A> swap() {
        return new Pair<B, A>(this.getSecond(), this.getFirst());
    }

    public static <K, V> Pair<K, V> fromEntry(Map.Entry<K, V> entry) {
        return new Pair<K, V>(entry.getKey(), entry.getValue());
    }
}

