/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.ServiceListenerAdapter;

public final class Services {
    public static ListenableFuture<List<ListenableFuture<Service.State>>> chainStart(Service firstService, Service ... moreServices) {
        return Services.doChain(true, firstService, moreServices);
    }

    public static ListenableFuture<List<ListenableFuture<Service.State>>> chainStop(Service firstService, Service ... moreServices) {
        return Services.doChain(false, firstService, moreServices);
    }

    public static ListenableFuture<Service.State> getCompletionFuture(Service service) {
        final SettableFuture resultFuture = SettableFuture.create();
        service.addListener((Service.Listener)new ServiceListenerAdapter(){

            @Override
            public void terminated(Service.State from) {
                resultFuture.set((Object)Service.State.TERMINATED);
            }

            @Override
            public void failed(Service.State from, Throwable failure) {
                resultFuture.setException(failure);
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        Service.State state = service.state();
        if (state == Service.State.TERMINATED) {
            return Futures.immediateFuture((Object)state);
        }
        if (state == Service.State.FAILED) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Service failed with unknown exception."));
        }
        return resultFuture;
    }

    private static ListenableFuture<List<ListenableFuture<Service.State>>> doChain(boolean doStart, Service firstService, Service ... moreServices) {
        SettableFuture resultFuture = SettableFuture.create();
        ArrayList result = Lists.newArrayListWithCapacity((int)(moreServices.length + 1));
        ListenableFuture future = doStart ? firstService.start() : firstService.stop();
        future.addListener(Services.createChainListener((ListenableFuture<Service.State>)future, moreServices, new AtomicInteger(0), result, (SettableFuture<List<ListenableFuture<Service.State>>>)resultFuture, doStart), Threads.SAME_THREAD_EXECUTOR);
        return resultFuture;
    }

    private static Runnable createChainListener(final ListenableFuture<Service.State> future, final Service[] services, final AtomicInteger idx, final List<ListenableFuture<Service.State>> result, final SettableFuture<List<ListenableFuture<Service.State>>> resultFuture, final boolean doStart) {
        return new Runnable(){

            @Override
            public void run() {
                result.add(future);
                int nextIdx = idx.getAndIncrement();
                if (nextIdx == services.length) {
                    resultFuture.set((Object)result);
                    return;
                }
                ListenableFuture actionFuture = doStart ? services[nextIdx].start() : services[nextIdx].stop();
                actionFuture.addListener(Services.createChainListener((ListenableFuture<Service.State>)actionFuture, services, idx, result, (SettableFuture<List<ListenableFuture<Service.State>>>)resultFuture, doStart), Threads.SAME_THREAD_EXECUTOR);
            }
        };
    }

    private Services() {
    }
}

