/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.google.common.base.Throwables;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedImmutableRoaringBitmap;
import com.metamx.collections.bitmap.WrappedRoaringBitmap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class RoaringBitmapFactory
implements BitmapFactory {
    static final boolean DEFAULT_COMPRESS_RUN_ON_SERIALIZATION = false;
    private static final ImmutableRoaringBitmap EMPTY_IMMUTABLE_BITMAP;
    private static final WrappedImmutableRoaringBitmap WRAPPED_IMMUTABLE_ROARING_BITMAP;
    private final boolean compressRunOnSerialization;

    public RoaringBitmapFactory() {
        this(false);
    }

    public RoaringBitmapFactory(boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization;
    }

    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedRoaringBitmap(this.compressRunOnSerialization);
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return WRAPPED_IMMUTABLE_ROARING_BITMAP;
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedRoaringBitmap)) {
            throw new IllegalStateException(String.format("Cannot convert [%s]", mutableBitmap.getClass()));
        }
        try {
            return ((WrappedRoaringBitmap)mutableBitmap).toImmutableBitmap();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedImmutableRoaringBitmap(b);
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) {
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)ImmutableRoaringBitmap.or(RoaringBitmapFactory.unwrap(b).iterator()));
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) {
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)BufferFastAggregation.and(RoaringBitmapFactory.unwrap(b).iterator()));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b) {
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)((WrappedImmutableRoaringBitmap)b).getBitmap(), (int)0, (int)b.size()));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)((WrappedImmutableRoaringBitmap)b).getBitmap(), (int)0, (int)length));
    }

    private static Iterable<ImmutableRoaringBitmap> unwrap(final Iterable<ImmutableBitmap> b) {
        return new Iterable<ImmutableRoaringBitmap>(){

            @Override
            public Iterator<ImmutableRoaringBitmap> iterator() {
                final Iterator i = b.iterator();
                return new Iterator<ImmutableRoaringBitmap>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public ImmutableRoaringBitmap next() {
                        WrappedImmutableRoaringBitmap wrappedBitmap = (WrappedImmutableRoaringBitmap)i.next();
                        if (wrappedBitmap == null) {
                            return EMPTY_IMMUTABLE_BITMAP;
                        }
                        return wrappedBitmap.getBitmap();
                    }
                };
            }
        };
    }

    static {
        try {
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            roaringBitmap.serialize((DataOutput)new DataOutputStream(out));
            byte[] bytes = out.toByteArray();
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            EMPTY_IMMUTABLE_BITMAP = new ImmutableRoaringBitmap(buf);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        WRAPPED_IMMUTABLE_ROARING_BITMAP = new WrappedImmutableRoaringBitmap(EMPTY_IMMUTABLE_BITMAP);
    }
}

