/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TxnHandler {
    public static final String INITIATED_RESPONSE = "initiated";
    public static final String WORKING_RESPONSE = "working";
    public static final String CLEANING_RESPONSE = "ready for cleaning";
    public static final String FAILED_RESPONSE = "failed";
    public static final String SUCCEEDED_RESPONSE = "succeeded";
    public static final String ATTEMPTED_RESPONSE = "attempted";
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    static final char FAILED_STATE = 'f';
    static final char SUCCEEDED_STATE = 's';
    static final char ATTEMPTED_STATE = 'a';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char TXN_ABORTED = 'a';
    protected static final char TXN_OPEN = 'o';
    protected static final char LOCK_ACQUIRED = 'a';
    protected static final char LOCK_WAITING = 'w';
    protected static final char LOCK_EXCLUSIVE = 'e';
    protected static final char LOCK_SHARED = 'r';
    protected static final char LOCK_SEMI_SHARED = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 10;
    public static final int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnHandler.class.getName());
    private static DataSource connPool;
    private static boolean doRetryOnConnPool;
    private static final Object lockLock;
    private int deadlockCnt;
    private final long deadlockRetryInterval;
    protected HiveConf conf;
    protected DatabaseProduct dbProduct;
    private long timeout;
    private String identifierQuoteString;
    private final long retryInterval;
    private final int retryLimit;
    private int retryNum;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    public TxnHandler(HiveConf conf) {
        this.conf = conf;
        this.checkQFileTestHack();
        try {
            TxnHandler.setupJdbcConnectionPool(conf);
        }
        catch (SQLException e) {
            String msg = "Unable to instantiate JDBC connection pooling, " + e.getMessage();
            LOG.error(msg);
            throw new RuntimeException(e);
        }
        this.timeout = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        TxnHandler.buildJumpTable();
        this.retryInterval = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERINTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        this.retryLimit = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERATTEMPTS);
        this.deadlockRetryInterval = this.retryInterval / 10L;
    }

    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            this.close(rs);
            ArrayList<TxnInfo> txnInfo = new ArrayList<TxnInfo>();
            s = "select txn_id, txn_state, txn_user, txn_host from TXNS where txn_id <= " + hwm;
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                TxnState state;
                char c = rs.getString(2).charAt(0);
                switch (c) {
                    case 'a': {
                        state = TxnState.ABORTED;
                        break;
                    }
                    case 'o': {
                        state = TxnState.OPEN;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected transaction state " + c + " found in txns table");
                    }
                }
                txnInfo.add(new TxnInfo(rs.getLong(1), state, rs.getString(3), rs.getString(4)));
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            GetOpenTxnsInfoResponse getOpenTxnsInfoResponse = new GetOpenTxnsInfoResponse(hwm, txnInfo);
            this.close(rs, stmt, dbConn);
            return getOpenTxnsInfoResponse;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxnsInfo");
                    throw new MetaException("Unable to select from transaction database: " + TxnHandler.getMessage(e) + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxnsInfo();
            }
        }
    }

    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            this.close(rs);
            HashSet<Long> openList = new HashSet<Long>();
            s = "select txn_id from TXNS where txn_id <= " + hwm;
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                openList.add(rs.getLong(1));
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            GetOpenTxnsResponse getOpenTxnsResponse = new GetOpenTxnsResponse(hwm, openList);
            this.close(rs, stmt, dbConn);
            return getOpenTxnsResponse;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxns");
                    throw new MetaException("Unable to select from transaction database, " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxns();
            }
        }
    }

    public static ValidTxnList createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        long highWater = txns.getTxn_high_water_mark();
        Set<Long> open = txns.getOpen_txns();
        long[] exceptions = new long[open.size() - (currentTxn > 0L ? 1 : 0)];
        int i = 0;
        for (long txn : open) {
            if (currentTxn > 0L && currentTxn == txn) continue;
            exceptions[i++] = txn;
        }
        return new ValidReadTxnList(exceptions, highWater);
    }

    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        int numTxns = rqst.getNum_txns();
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(this.getRequiredIsolationLevel());
            int maxTxns = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_MAX_OPEN_BATCH);
            if (numTxns > maxTxns) {
                numTxns = maxTxns;
            }
            stmt = dbConn.createStatement();
            String s = this.addForUpdateClause(dbConn, "select ntxn_next from NEXT_TXN_ID");
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
            }
            long first = rs.getLong(1);
            s = "update NEXT_TXN_ID set ntxn_next = " + (first + (long)numTxns);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            long now = this.getDbTime(dbConn);
            s = "insert into TXNS (txn_id, txn_state, txn_started, txn_last_heartbeat, txn_user, txn_host) values (?, 'o', " + now + ", " + now + ", '" + rqst.getUser() + "', '" + rqst.getHostname() + "')";
            LOG.debug("Going to prepare statement <" + s + ">");
            PreparedStatement ps = dbConn.prepareStatement(s);
            ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
            for (long i = first; i < first + (long)numTxns; ++i) {
                ps.setLong(1, i);
                ps.executeUpdate();
                txnIds.add(i);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            OpenTxnsResponse openTxnsResponse = new OpenTxnsResponse(txnIds);
            this.close(rs, stmt, dbConn);
            return openTxnsResponse;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "openTxns(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.openTxns(rqst);
            }
        }
    }

    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException {
        long txnid = rqst.getTxnid();
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(8);
                if (this.abortTxns(dbConn, Collections.singletonList(txnid)) != 1) {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString((long)txnid));
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                this.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "abortTxn(" + rqst + ")");
                throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.abortTxn(rqst);
        }
    }

    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        long txnid = rqst.getTxnid();
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(8);
                stmt = dbConn.createStatement();
                this.heartbeatTxn(dbConn, txnid);
                String s = "insert into COMPLETED_TXN_COMPONENTS select tc_txnid, tc_database, tc_table, tc_partition from TXN_COMPONENTS where tc_txnid = " + txnid;
                LOG.debug("Going to execute insert <" + s + ">");
                if (stmt.executeUpdate(s) < 1) {
                    LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! " + JavaUtils.txnIdToString((long)txnid));
                }
                s = "delete from TXN_COMPONENTS where tc_txnid = " + txnid;
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                s = "delete from HIVE_LOCKS where hl_txnid = " + txnid;
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                s = "delete from TXNS where txn_id = " + txnid;
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                LOG.debug("Going to commit");
                dbConn.commit();
                this.closeStmt(stmt);
                this.closeDbConn(dbConn);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "commitTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
        }
        catch (RetryException e) {
            this.commitTxn(rqst);
        }
    }

    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn(8);
            LockResponse lockResponse = this.lock(dbConn, rqst);
            this.closeDbConn(dbConn);
            return lockResponse;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "lock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.lock(rqst);
            }
        }
    }

    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        long extLockId = rqst.getLockid();
        try {
            dbConn = this.getDbConn(2);
            Long txnid = this.getTxnIdFromLockId(dbConn, extLockId);
            if (txnid == null) {
                throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString((long)extLockId));
            }
            if (txnid > 0L) {
                this.heartbeatTxn(dbConn, txnid);
            } else {
                this.heartbeatLock(dbConn, extLockId);
            }
            this.closeDbConn(dbConn);
            dbConn = this.getDbConn(8);
            LockResponse lockResponse = this.checkLock(dbConn, extLockId);
            this.closeDbConn(dbConn);
            return lockResponse;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLock(" + rqst + " )");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString((long)extLockId) + " " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLock(rqst);
            }
        }
    }

    public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            long extLockId = rqst.getLockid();
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "delete from HIVE_LOCKS where hl_lock_ext_id = " + extLockId + " AND hl_txnid = 0";
                LOG.debug("Going to execute update <" + s + ">");
                int rc = stmt.executeUpdate(s);
                if (rc < 1) {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    Long txnid = this.getTxnIdFromLockId(dbConn, extLockId);
                    if (txnid == null) {
                        LOG.error("No lock found for unlock(" + rqst + ")");
                        throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString((long)extLockId));
                    }
                    if (txnid != 0L) {
                        String msg = "Unlocking locks associated with transaction not permitted.  Lockid " + JavaUtils.lockIdToString((long)extLockId) + " is associated with " + "transaction " + JavaUtils.txnIdToString((long)txnid);
                        LOG.error(msg);
                        throw new TxnOpenException(msg);
                    }
                    if (txnid == 0L) {
                        String msg = "Found lock " + JavaUtils.lockIdToString((long)extLockId) + " with " + JavaUtils.txnIdToString((long)txnid);
                        LOG.error(msg);
                        throw new MetaException(msg);
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
                this.closeStmt(stmt);
                this.closeDbConn(dbConn);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "unlock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString((long)extLockId) + " " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
        }
        catch (RetryException e) {
            this.unlock(rqst);
        }
    }

    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            ShowLocksResponse rsp = new ShowLocksResponse();
            ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
            ArrayList<LockInfoExt> sortedList = new ArrayList<LockInfoExt>();
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select hl_lock_ext_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_acquired_at, hl_user, hl_host, hl_lock_int_id from HIVE_LOCKS";
                LOG.debug("Doing to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    ShowLocksResponseElement e = new ShowLocksResponseElement();
                    e.setLockid(rs.getLong(1));
                    long txnid = rs.getLong(2);
                    if (!rs.wasNull()) {
                        e.setTxnid(txnid);
                    }
                    e.setDbname(rs.getString(3));
                    e.setTablename(rs.getString(4));
                    String partition = rs.getString(5);
                    if (partition != null) {
                        e.setPartname(partition);
                    }
                    switch (rs.getString(6).charAt(0)) {
                        case 'a': {
                            e.setState(LockState.ACQUIRED);
                            break;
                        }
                        case 'w': {
                            e.setState(LockState.WAITING);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                        }
                    }
                    switch (rs.getString(7).charAt(0)) {
                        case 'w': {
                            e.setType(LockType.SHARED_WRITE);
                            break;
                        }
                        case 'e': {
                            e.setType(LockType.EXCLUSIVE);
                            break;
                        }
                        case 'r': {
                            e.setType(LockType.SHARED_READ);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock type " + rs.getString(6).charAt(0));
                        }
                    }
                    e.setLastheartbeat(rs.getLong(8));
                    long acquiredAt = rs.getLong(9);
                    if (!rs.wasNull()) {
                        e.setAcquiredat(acquiredAt);
                    }
                    e.setUser(rs.getString(10));
                    e.setHostname(rs.getString(11));
                    sortedList.add(new LockInfoExt(e, rs.getLong(12)));
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
                this.closeStmt(stmt);
                this.closeDbConn(dbConn);
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(dbConn, e, "showLocks(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            Collections.sort(sortedList, new LockInfoComparator());
            for (LockInfoExt lockInfoExt : sortedList) {
                elems.add(lockInfoExt.e);
            }
            rsp.setLocks(elems);
            return rsp;
        }
        catch (RetryException e) {
            return this.showLocks(rqst);
        }
    }

    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                this.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "heartbeat(" + ids + ")");
                throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.heartbeat(ids);
        }
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        Connection dbConn = null;
        HeartbeatTxnRangeResponse rsp = new HeartbeatTxnRangeResponse();
        HashSet<Long> nosuch = new HashSet<Long>();
        HashSet<Long> aborted = new HashSet<Long>();
        rsp.setNosuch(nosuch);
        rsp.setAborted(aborted);
        try {
            dbConn = this.getDbConn(2);
            for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                try {
                    this.heartbeatTxn(dbConn, txn);
                    continue;
                }
                catch (NoSuchTxnException e) {
                    nosuch.add(txn);
                    continue;
                }
                catch (TxnAbortedException e) {
                    aborted.add(txn);
                }
            }
            HeartbeatTxnRangeResponse txn = rsp;
            this.closeDbConn(dbConn);
            return txn;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatTxnRange(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.heartbeatTxnRange(rqst);
            }
        }
    }

    public long compact(CompactionRequest rqst) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            dbConn = this.getDbConn(this.getRequiredIsolationLevel());
            stmt = dbConn.createStatement();
            String s = this.addForUpdateClause(dbConn, "select ncq_next from NEXT_COMPACTION_QUEUE_ID");
            LOG.debug("going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new MetaException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
            }
            long id = rs.getLong(1);
            s = "update NEXT_COMPACTION_QUEUE_ID set ncq_next = " + (id + 1L);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            StringBuilder buf = new StringBuilder("insert into COMPACTION_QUEUE (cq_id, cq_database, cq_table, ");
            String partName = rqst.getPartitionname();
            if (partName != null) {
                buf.append("cq_partition, ");
            }
            buf.append("cq_state, cq_type");
            if (rqst.getRunas() != null) {
                buf.append(", cq_run_as");
            }
            buf.append(") values (");
            buf.append(id);
            buf.append(", '");
            buf.append(rqst.getDbname());
            buf.append("', '");
            buf.append(rqst.getTablename());
            buf.append("', '");
            if (partName != null) {
                buf.append(partName);
                buf.append("', '");
            }
            buf.append('i');
            buf.append("', '");
            switch (rqst.getType()) {
                case MAJOR: {
                    buf.append('a');
                    break;
                }
                case MINOR: {
                    buf.append('i');
                    break;
                }
                default: {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("Unexpected compaction type " + rqst.getType().toString());
                }
            }
            if (rqst.getRunas() != null) {
                buf.append("', '");
                buf.append(rqst.getRunas());
            }
            buf.append("')");
            s = buf.toString();
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            LOG.debug("Going to commit");
            dbConn.commit();
            long l = id;
            this.closeStmt(stmt);
            this.closeDbConn(dbConn);
            return l;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "compact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.compact(rqst);
            }
        }
    }

    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        ShowCompactResponse response = new ShowCompactResponse(new ArrayList<ShowCompactResponseElement>());
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select cq_database, cq_table, cq_partition, cq_state, cq_type, cq_worker_id, cq_start, -1 cc_end, cq_run_as, cq_hadoop_job_id, cq_id from COMPACTION_QUEUE union all select cc_database, cc_table, cc_partition, cc_state, cc_type, cc_worker_id, cc_start, cc_end, cc_run_as, cc_hadoop_job_id, cc_id from COMPLETED_COMPACTIONS";
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    ShowCompactResponseElement e = new ShowCompactResponseElement();
                    e.setDbname(rs.getString(1));
                    e.setTablename(rs.getString(2));
                    e.setPartitionname(rs.getString(3));
                    switch (rs.getString(4).charAt(0)) {
                        case 'i': {
                            e.setState(INITIATED_RESPONSE);
                            break;
                        }
                        case 'w': {
                            e.setState(WORKING_RESPONSE);
                            break;
                        }
                        case 'r': {
                            e.setState(CLEANING_RESPONSE);
                            break;
                        }
                        case 'f': {
                            e.setState(FAILED_RESPONSE);
                            break;
                        }
                        case 's': {
                            e.setState(SUCCEEDED_RESPONSE);
                            break;
                        }
                    }
                    switch (rs.getString(5).charAt(0)) {
                        case 'a': {
                            e.setType(CompactionType.MAJOR);
                            break;
                        }
                        case 'i': {
                            e.setType(CompactionType.MINOR);
                            break;
                        }
                    }
                    e.setWorkerid(rs.getString(6));
                    e.setStart(rs.getLong(7));
                    long endTime = rs.getLong(8);
                    if (endTime != -1L) {
                        e.setEndTime(endTime);
                    }
                    e.setRunAs(rs.getString(9));
                    e.setHadoopJobId(rs.getString(10));
                    long id = rs.getLong(11);
                    response.addToCompacts(e);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
                this.closeStmt(stmt);
                this.closeDbConn(dbConn);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "showCompact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            return response;
        }
        catch (RetryException e) {
            return this.showCompact(rqst);
        }
    }

    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                this.heartbeatTxn(dbConn, rqst.getTxnid());
                for (String partName : rqst.getPartitionnames()) {
                    StringBuilder buff = new StringBuilder();
                    buff.append("insert into TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition) values (");
                    buff.append(rqst.getTxnid());
                    buff.append(", '");
                    buff.append(rqst.getDbname());
                    buff.append("', '");
                    buff.append(rqst.getTablename());
                    buff.append("', '");
                    buff.append(partName);
                    buff.append("')");
                    String s = buff.toString();
                    LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                }
                LOG.debug("Going to commit");
                dbConn.commit();
                this.closeStmt(stmt);
                this.closeDbConn(dbConn);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    this.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "addDynamicPartitions(" + rqst + ")");
                    throw new MetaException("Unable to insert into from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeStmt(stmt);
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
        }
        catch (RetryException e) {
            this.addDynamicPartitions(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int numLocksInLockTable() throws SQLException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select count(*) from HIVE_LOCKS";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            int n = rc;
            this.close(rs, stmt, dbConn);
            return n;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt, dbConn);
            throw throwable;
        }
    }

    long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    protected Connection getDbConn(int isolationLevel) throws SQLException {
        int rc = doRetryOnConnPool ? 10 : 1;
        while (true) {
            try {
                Connection dbConn = connPool.getConnection();
                dbConn.setAutoCommit(false);
                dbConn.setTransactionIsolation(isolationLevel);
                return dbConn;
            }
            catch (SQLException e) {
                if (--rc <= 0) {
                    throw e;
                }
                LOG.error("There is a problem with a connection from the pool, retrying(rc=" + rc + "): " + TxnHandler.getMessage(e), (Throwable)e);
                continue;
            }
            break;
        }
    }

    void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection " + TxnHandler.getMessage(e));
        }
    }

    protected void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close db connection " + TxnHandler.getMessage(e));
        }
    }

    protected void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(e));
        }
    }

    void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(ex));
        }
    }

    void close(ResultSet rs, Statement stmt, Connection dbConn) {
        this.close(rs);
        this.closeStmt(stmt);
        this.closeDbConn(dbConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRetryable(Connection conn, SQLException e, String caller) throws RetryException, MetaException {
        boolean sendRetrySignal;
        block13: {
            sendRetrySignal = false;
            try {
                if (this.dbProduct == null && conn != null) {
                    this.determineDatabaseProduct(conn);
                }
                if (e instanceof SQLTransactionRollbackException || (this.dbProduct == DatabaseProduct.MYSQL || this.dbProduct == DatabaseProduct.POSTGRES || this.dbProduct == DatabaseProduct.SQLSERVER) && e.getSQLState().equals("40001") || this.dbProduct == DatabaseProduct.POSTGRES && e.getSQLState().equals("40P01") || this.dbProduct == DatabaseProduct.ORACLE && (e.getMessage().contains("deadlock detected") || e.getMessage().contains("can't serialize access for this transaction"))) {
                    if (this.deadlockCnt++ < 10) {
                        long waitInterval = this.deadlockRetryInterval * (long)this.deadlockCnt;
                        LOG.warn("Deadlock detected in " + caller + ". Will wait " + waitInterval + "ms try again up to " + (10 - this.deadlockCnt + 1) + " times.");
                        try {
                            Thread.sleep(waitInterval);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block13;
                    }
                    LOG.error("Too many repeated deadlocks in " + caller + ", giving up.");
                    break block13;
                }
                if (!TxnHandler.isRetryable(e)) break block13;
                if (this.retryNum++ < this.retryLimit) {
                    LOG.warn("Retryable error detected in " + caller + ".  Will wait " + this.retryInterval + "ms and retry up to " + (this.retryLimit - this.retryNum + 1) + " times.  Error: " + TxnHandler.getMessage(e));
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    sendRetrySignal = true;
                    break block13;
                }
                LOG.error("Fatal error. Retry limit (" + this.retryLimit + ") reached. Last error: " + TxnHandler.getMessage(e));
            }
            finally {
                if (!sendRetrySignal) {
                    this.deadlockCnt = 0;
                    this.retryNum = 0;
                }
            }
        }
        if (sendRetrySignal) {
            throw new RetryException();
        }
    }

    protected long getDbTime(Connection conn) throws MetaException {
        Statement stmt = null;
        try {
            String s;
            stmt = conn.createStatement();
            DatabaseProduct prod = this.determineDatabaseProduct(conn);
            switch (prod) {
                case DERBY: {
                    s = "values current_timestamp";
                    break;
                }
                case MYSQL: 
                case POSTGRES: 
                case SQLSERVER: {
                    s = "select current_timestamp";
                    break;
                }
                case ORACLE: {
                    s = "select current_timestamp from dual";
                    break;
                }
                default: {
                    String msg = "Unknown database product: " + prod.toString();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("No results from date query");
            }
            long l = rs.getTimestamp(1).getTime();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to determine current time: " + e.getMessage();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        finally {
            this.closeStmt(stmt);
        }
    }

    protected String getIdentifierQuoteString(Connection conn) throws SQLException {
        if (this.identifierQuoteString == null) {
            this.identifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
        }
        return this.identifierQuoteString;
    }

    protected DatabaseProduct determineDatabaseProduct(Connection conn) throws MetaException {
        block9: {
            if (this.dbProduct == null) {
                try {
                    String s = conn.getMetaData().getDatabaseProductName();
                    if (s == null) {
                        String msg = "getDatabaseProductName returns null, can't determine database product";
                        LOG.error(msg);
                        throw new MetaException(msg);
                    }
                    if (s.equals("Apache Derby")) {
                        this.dbProduct = DatabaseProduct.DERBY;
                        break block9;
                    }
                    if (s.equals("Microsoft SQL Server")) {
                        this.dbProduct = DatabaseProduct.SQLSERVER;
                        break block9;
                    }
                    if (s.equals("MySQL")) {
                        this.dbProduct = DatabaseProduct.MYSQL;
                        break block9;
                    }
                    if (s.equals("Oracle")) {
                        this.dbProduct = DatabaseProduct.ORACLE;
                        break block9;
                    }
                    if (s.equals("PostgreSQL")) {
                        this.dbProduct = DatabaseProduct.POSTGRES;
                        break block9;
                    }
                    String msg = "Unrecognized database product name <" + s + ">";
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
                catch (SQLException e) {
                    String msg = "Unable to get database product name: " + e.getMessage();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
        }
        return this.dbProduct;
    }

    private void checkQFileTestHack() {
        block2: {
            LOG.info("Hacking in canned values for transaction manager");
            TxnDbUtil.setConfValues(this.conf);
            try {
                TxnDbUtil.prepDb();
            }
            catch (Exception e) {
                if (e.getMessage().contains("already exists")) break block2;
                throw new RuntimeException("Unable to set up transaction database for testing: " + e.getMessage());
            }
        }
    }

    private int abortTxns(Connection dbConn, List<Long> txnids) throws SQLException {
        return this.abortTxns(dbConn, txnids, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTxns(Connection dbConn, List<Long> txnids, long max_heartbeat) throws SQLException {
        Statement stmt = null;
        int updateCnt = 0;
        if (txnids.isEmpty()) {
            return 0;
        }
        if (8 != dbConn.getTransactionIsolation()) {
            throw new IllegalStateException("Expected SERIALIZABLE isolation. Found " + dbConn.getTransactionIsolation());
        }
        try {
            stmt = dbConn.createStatement();
            StringBuilder buf = new StringBuilder("delete from HIVE_LOCKS where hl_txnid in (");
            boolean first = true;
            for (Long id : txnids) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(id);
            }
            buf.append(')');
            LOG.debug("Going to execute update <" + buf.toString() + ">");
            stmt.executeUpdate(buf.toString());
            buf = new StringBuilder("update TXNS set txn_state = 'a' where txn_state = 'o' and txn_id in (");
            first = true;
            for (Long id : txnids) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(id);
            }
            buf.append(')');
            if (max_heartbeat > 0L) {
                buf.append(" and txn_last_heartbeat < ").append(max_heartbeat);
            }
            LOG.debug("Going to execute update <" + buf.toString() + ">");
            updateCnt = stmt.executeUpdate(buf.toString());
        }
        finally {
            this.closeStmt(stmt);
        }
        return updateCnt;
    }

    private LockResponse lock(Connection dbConn, LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException, SQLException {
        Object object = lockLock;
        synchronized (object) {
            LockResponse lockResponse;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                long txnid = rqst.getTxnid();
                if (txnid > 0L) {
                    this.heartbeatTxn(dbConn, txnid);
                }
                stmt = dbConn.createStatement();
                String s = this.addForUpdateClause(dbConn, "select nl_next from NEXT_LOCK_ID");
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
                }
                long extLockId = rs.getLong(1);
                s = "update NEXT_LOCK_ID set nl_next = " + (extLockId + 1L);
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                if (txnid > 0L) {
                    for (LockComponent lc : rqst.getComponent()) {
                        String dbName = lc.getDbname();
                        String tblName = lc.getTablename();
                        String partName = lc.getPartitionname();
                        s = "insert into TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition) values (" + txnid + ", '" + dbName + "', " + (tblName == null ? "null" : "'" + tblName + "'") + ", " + (partName == null ? "null" : "'" + partName + "'") + ")";
                        LOG.debug("Going to execute update <" + s + ">");
                        stmt.executeUpdate(s);
                    }
                }
                long intLockId = 0L;
                for (LockComponent lc : rqst.getComponent()) {
                    ++intLockId;
                    String dbName = lc.getDbname();
                    String tblName = lc.getTablename();
                    String partName = lc.getPartitionname();
                    LockType lockType = lc.getType();
                    char lockChar = 'z';
                    switch (lockType) {
                        case EXCLUSIVE: {
                            lockChar = 'e';
                            break;
                        }
                        case SHARED_READ: {
                            lockChar = 'r';
                            break;
                        }
                        case SHARED_WRITE: {
                            lockChar = 'w';
                        }
                    }
                    long now = this.getDbTime(dbConn);
                    s = "insert into HIVE_LOCKS  (hl_lock_ext_id, hl_lock_int_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_user, hl_host) values (" + extLockId + ", " + intLockId + "," + txnid + ", '" + dbName + "', " + (tblName == null ? "null" : "'" + tblName + "'") + ", " + (partName == null ? "null" : "'" + partName + "'") + ", '" + 'w' + "', " + "'" + lockChar + "', " + (TxnHandler.isValidTxn(txnid) ? 0L : now) + ", '" + rqst.getUser() + "', '" + rqst.getHostname() + "')";
                    LOG.debug("Going to execute update <" + s + ">");
                    stmt.executeUpdate(s);
                }
                lockResponse = this.checkLock(dbConn, extLockId);
                this.close(rs);
                this.closeStmt(stmt);
            }
            catch (NoSuchLockException e) {
                try {
                    throw new MetaException("Couldn't find a lock we just created!");
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.closeStmt(stmt);
                    throw throwable;
                }
            }
            return lockResponse;
        }
    }

    private static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LockResponse checkLock(Connection dbConn, long extLockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, MetaException, SQLException {
        locksBeingChecked = this.getLockInfoFromLockId(dbConn, extLockId);
        response = new LockResponse();
        response.setLockid(extLockId);
        TxnHandler.LOG.debug("checkLock(): Setting savepoint. extLockId=" + JavaUtils.lockIdToString((long)extLockId));
        save = dbConn.setSavepoint();
        query = new StringBuilder("select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_db in (");
        strings = new HashSet<String>(locksBeingChecked.size());
        for (LockInfo info : locksBeingChecked) {
            strings.add(LockInfo.access$700(info));
        }
        first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                query.append(", ");
            }
            query.append('\'');
            query.append(s);
            query.append('\'');
        }
        query.append(")");
        sawNull = false;
        strings.clear();
        for (LockInfo info : locksBeingChecked) {
            if (LockInfo.access$800(info) == null) {
                sawNull = true;
                break;
            }
            strings.add(LockInfo.access$800(info));
        }
        if (!sawNull) {
            query.append(" and (hl_table is null or hl_table in(");
            first = true;
            for (String s : strings) {
                if (first) {
                    first = false;
                } else {
                    query.append(", ");
                }
                query.append('\'');
                query.append(s);
                query.append('\'');
            }
            query.append("))");
            sawNull = false;
            strings.clear();
            for (LockInfo info : locksBeingChecked) {
                if (LockInfo.access$900(info) == null) {
                    sawNull = true;
                    break;
                }
                strings.add(LockInfo.access$900(info));
            }
            if (!sawNull) {
                query.append(" and (hl_partition is null or hl_partition in(");
                first = true;
                for (String s : strings) {
                    if (first) {
                        first = false;
                    } else {
                        query.append(", ");
                    }
                    query.append('\'');
                    query.append(s);
                    query.append('\'');
                }
                query.append("))");
            }
        }
        query.append(" and hl_lock_ext_id <= ").append(extLockId);
        TxnHandler.LOG.debug("Going to execute query <" + query.toString() + ">");
        stmt = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(query.toString());
            lockSet = new TreeSet<LockInfo>(new LockInfoComparator());
            while (rs.next()) {
                lockSet.add(new LockInfo(rs));
            }
            locks = lockSet.toArray(new LockInfo[lockSet.size()]);
            if (TxnHandler.LOG.isDebugEnabled()) {
                TxnHandler.LOG.debug("Locks to check(full): ");
                for (LockInfo info : locks) {
                    TxnHandler.LOG.debug("  " + info);
                }
            }
            for (LockInfo info : locksBeingChecked) {
                index = -1;
                for (i = 0; i < locks.length; ++i) {
                    if (!locks[i].equals(info)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    TxnHandler.LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("How did we get here, we heartbeated our lock before we started!");
                }
                if (LockInfo.access$300(locks[index]) == LockState.ACQUIRED) continue;
                acquired = false;
                block19: for (i = index - 1; i >= 0; --i) {
                    if (!LockInfo.access$700(locks[index]).equals(LockInfo.access$700(locks[i])) || LockInfo.access$800(locks[index]) != null && LockInfo.access$800(locks[i]) != null && !LockInfo.access$800(locks[index]).equals(LockInfo.access$800(locks[i])) || LockInfo.access$900(locks[index]) != null && LockInfo.access$900(locks[i]) != null && !LockInfo.access$900(locks[index]).equals(LockInfo.access$900(locks[i]))) continue;
                    lockAction = TxnHandler.jumpTable.get((Object)LockInfo.access$400(locks[index])).get((Object)LockInfo.access$400(locks[i])).get((Object)LockInfo.access$300(locks[i]));
                    TxnHandler.LOG.debug("desired Lock: " + info + " checked Lock: " + locks[i] + " action: " + (Object)lockAction);
                    switch (1.$SwitchMap$org$apache$hadoop$hive$metastore$txn$TxnHandler$LockAction[lockAction.ordinal()]) {
                        case 1: {
                            if (!this.ignoreConflict(info, locks[i])) {
                                this.wait(dbConn, save);
                                TxnHandler.LOG.debug("Going to commit");
                                dbConn.commit();
                                response.setState(LockState.WAITING);
                                TxnHandler.LOG.debug("Lock(" + info + ") waiting for Lock(" + locks[i] + ")");
                                var21_24 = response;
                                return var21_24;
                            }
                        }
                        case 2: {
                            this.acquire(dbConn, stmt, extLockId, info);
                            acquired = true;
                            ** GOTO lbl134
                        }
                        case 3: {
                            continue block19;
                        }
lbl134:
                        // 2 sources

                        default: {
                            if (acquired) break block19;
                        }
                    }
                }
                if (acquired) continue;
                this.acquire(dbConn, stmt, extLockId, info);
            }
            TxnHandler.LOG.debug("Going to commit");
            dbConn.commit();
            response.setState(LockState.ACQUIRED);
        }
        finally {
            this.closeStmt(stmt);
        }
        return response;
    }

    private boolean ignoreConflict(LockInfo desiredLock, LockInfo existingLock) {
        return desiredLock.isDbLock() && desiredLock.type == LockType.SHARED_READ && existingLock.isTableLock() && existingLock.type == LockType.EXCLUSIVE || existingLock.isDbLock() && existingLock.type == LockType.SHARED_READ && desiredLock.isTableLock() && desiredLock.type == LockType.EXCLUSIVE || desiredLock.txnId != 0L && desiredLock.txnId == existingLock.txnId || desiredLock.txnId == 0L && desiredLock.extLockId == existingLock.extLockId;
    }

    private void wait(Connection dbConn, Savepoint save) throws SQLException {
        LOG.debug("Going to rollback to savepoint");
        dbConn.rollback(save);
    }

    private void acquire(Connection dbConn, Statement stmt, long extLockId, LockInfo lockInfo) throws SQLException, NoSuchLockException, MetaException {
        long now = this.getDbTime(dbConn);
        String s = "update HIVE_LOCKS set hl_lock_state = 'a', hl_last_heartbeat = " + (TxnHandler.isValidTxn(lockInfo.txnId) ? 0L : now) + ", hl_acquired_at = " + now + " where hl_lock_ext_id = " + extLockId + " and hl_lock_int_id = " + lockInfo.intLockId;
        LOG.debug("Going to execute update <" + s + ">");
        int rc = stmt.executeUpdate(s);
        if (rc < 1) {
            LOG.debug("Going to rollback");
            dbConn.rollback();
            throw new NoSuchLockException("No such lock: (" + JavaUtils.lockIdToString((long)extLockId) + "," + lockInfo.intLockId + ") " + JavaUtils.txnIdToString((long)lockInfo.txnId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException, MetaException {
        if (extLockId == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            long now = this.getDbTime(dbConn);
            String s = "update HIVE_LOCKS set hl_last_heartbeat = " + now + " where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString((long)extLockId));
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            this.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException, MetaException {
        if (txnid == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            long now = this.getDbTime(dbConn);
            String s = "update TXNS set txn_last_heartbeat = " + now + " where txn_id = " + txnid + " and txn_state = '" + 'o' + "'";
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                LOG.warn("Can neither heartbeat txn nor confirm it as invalid.");
                dbConn.rollback();
                throw new NoSuchTxnException("No such txn: " + txnid);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            this.closeStmt(stmt);
        }
    }

    private static void ensureValidTxn(Connection dbConn, long txnid, Statement stmt) throws SQLException, NoSuchTxnException, TxnAbortedException {
        String s = "select txn_state from TXNS where txn_id = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            s = "select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TXNID = " + txnid;
            ResultSet rs2 = stmt.executeQuery(s);
            boolean alreadyCommitted = rs2.next() && rs2.getInt(1) > 0;
            LOG.debug("Going to rollback");
            dbConn.rollback();
            if (alreadyCommitted) {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString((long)txnid) + " is already committed.");
            }
            throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString((long)txnid));
        }
        if (rs.getString(1).charAt(0) == 'a') {
            LOG.debug("Going to rollback");
            dbConn.rollback();
            throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString((long)txnid) + " already aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getTxnIdFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        ResultSet rs;
        Statement stmt;
        block3: {
            stmt = null;
            rs = null;
            try {
                stmt = dbConn.createStatement();
                String s = "select hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) break block3;
                Long l = null;
                this.close(rs);
                this.closeStmt(stmt);
                return l;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.closeStmt(stmt);
                throw throwable;
            }
        }
        long txnid = rs.getLong(1);
        LOG.debug("getTxnIdFromLockId(" + extLockId + ") Return " + JavaUtils.txnIdToString((long)txnid));
        Long l = txnid;
        this.close(rs);
        this.closeStmt(stmt);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LockInfo> getLockInfoFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            boolean sawAtLeastOne = false;
            ArrayList<LockInfo> ourLockInfo = new ArrayList<LockInfo>();
            while (rs.next()) {
                ourLockInfo.add(new LockInfo(rs));
                sawAtLeastOne = true;
            }
            if (!sawAtLeastOne) {
                throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString((long)extLockId) + ") existed but now we can't find it!");
            }
            ArrayList<LockInfo> arrayList = ourLockInfo;
            return arrayList;
        }
        finally {
            this.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeOutLocks(Connection dbConn, long now) {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "delete from HIVE_LOCKS where hl_last_heartbeat < " + (now - this.timeout) + " and hl_txnid = 0";
            LOG.debug("Going to execute update <" + s + ">");
            int deletedLocks = stmt.executeUpdate(s);
            if (deletedLocks > 0) {
                LOG.info("Deleted " + deletedLocks + " locks from HIVE_LOCKS due to timeout");
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        catch (SQLException ex) {
            LOG.error("Failed to purge timedout locks due to: " + TxnHandler.getMessage(ex), (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Failed to purge timedout locks due to: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.closeStmt(stmt);
        }
    }

    private String addLimitClause(Connection dbConn, int numRows, String noSelectsqlQuery) throws MetaException {
        DatabaseProduct prod = this.determineDatabaseProduct(dbConn);
        switch (prod) {
            case DERBY: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)prod) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performTimeOuts() {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            long now = this.getDbTime(dbConn);
            this.timeOutLocks(dbConn, now);
            while (true) {
                stmt = dbConn.createStatement();
                String s = " txn_id from TXNS where txn_state = 'o' and txn_last_heartbeat <  " + (now - this.timeout);
                s = this.addLimitClause(dbConn, 250000, s);
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    this.close(rs, stmt, dbConn);
                    return;
                }
                ArrayList timedOutTxns = new ArrayList();
                ArrayList<Long> currentBatch = new ArrayList<Long>(1000);
                timedOutTxns.add(currentBatch);
                do {
                    currentBatch.add(rs.getLong(1));
                    if (currentBatch.size() != 1000) continue;
                    currentBatch = new ArrayList(1000);
                    timedOutTxns.add(currentBatch);
                } while (rs.next());
                dbConn.commit();
                this.close(rs, stmt, dbConn);
                dbConn = this.getDbConn(8);
                int numTxnsAborted = 0;
                for (List list : timedOutTxns) {
                    if (this.abortTxns(dbConn, list, now - this.timeout) == list.size()) {
                        dbConn.commit();
                        numTxnsAborted += list.size();
                        LOG.info("Aborted the following transactions due to timeout: " + list.toString());
                        continue;
                    }
                    dbConn.rollback();
                }
                LOG.info("Aborted " + numTxnsAborted + " transactions due to timeout");
                continue;
                break;
            }
        }
        catch (SQLException ex) {
            LOG.warn("Aborting timedout transactions failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            this.close(rs, stmt, dbConn);
            return;
        }
        catch (MetaException e) {
            try {
                LOG.warn("Aborting timedout transactions failed due to " + e.getMessage(), (Throwable)((Object)e));
                this.close(rs, stmt, dbConn);
                return;
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, dbConn);
                throw throwable;
            }
        }
    }

    private static synchronized void setupJdbcConnectionPool(HiveConf conf) throws SQLException {
        String passwd;
        if (connPool != null) {
            return;
        }
        String driverUrl = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORECONNECTURLKEY);
        String user = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
        try {
            passwd = ShimLoader.getHadoopShims().getPassword((Configuration)conf, HiveConf.ConfVars.METASTOREPWD.varname);
        }
        catch (IOException err) {
            throw new SQLException("Error getting metastore password", err);
        }
        String connectionPooler = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_TYPE).toLowerCase();
        if ("bonecp".equals(connectionPooler)) {
            BoneCPConfig config = new BoneCPConfig();
            config.setJdbcUrl(driverUrl);
            config.setConnectionTimeoutInMs(60000L);
            config.setMaxConnectionsPerPartition(10);
            config.setPartitionCount(1);
            config.setUser(user);
            config.setPassword(passwd);
            connPool = new BoneCPDataSource(config);
            doRetryOnConnPool = true;
        } else if ("dbcp".equals(connectionPooler)) {
            GenericObjectPool objectPool = new GenericObjectPool();
            DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(driverUrl, user, passwd);
            PoolableConnectionFactory poolConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)objectPool, null, null, false, true);
            connPool = new PoolingDataSource((ObjectPool)objectPool);
        } else {
            throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
        }
    }

    private static synchronized void buildJumpTable() {
        if (jumpTable != null) {
            return;
        }
        jumpTable = new HashMap<LockType, Map<LockType, Map<LockState, LockAction>>>(3);
        HashMap m = new HashMap(3);
        jumpTable.put(LockType.SHARED_READ, m);
        HashMap<LockState, LockAction> m2 = new HashMap<LockState, LockAction>(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.SHARED_WRITE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.KEEP_LOOKING);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.EXCLUSIVE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
    }

    private static boolean isRetryable(Exception ex) {
        SQLException sqlException;
        return ex instanceof SQLException && "08S01".equalsIgnoreCase((sqlException = (SQLException)ex).getSQLState());
    }

    private static String getMessage(SQLException ex) {
        return ex.getMessage() + "(SQLState=" + ex.getSQLState() + ",ErrorCode=" + ex.getErrorCode() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRequiredIsolationLevel() throws MetaException, SQLException {
        if (this.dbProduct == null) {
            Connection tmp = null;
            try {
                tmp = this.getDbConn(2);
                this.determineDatabaseProduct(tmp);
            }
            finally {
                this.closeDbConn(tmp);
            }
        }
        switch (this.dbProduct) {
            case DERBY: {
                return 8;
            }
            case MYSQL: 
            case POSTGRES: 
            case SQLSERVER: 
            case ORACLE: {
                return 2;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    private String addForUpdateClause(Connection dbConn, String selectStatement) throws MetaException {
        DatabaseProduct prod = this.determineDatabaseProduct(dbConn);
        switch (prod) {
            case DERBY: {
                return selectStatement;
            }
            case MYSQL: 
            case POSTGRES: 
            case ORACLE: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                return selectStatement + " with(updlock)";
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)prod) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    static CompactionType dbCompactionType2ThriftType(char dbValue) {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
        }
        LOG.warn("Unexpected compaction type " + dbValue);
        return null;
    }

    static Character thriftCompactionType2DbType(CompactionType ct) {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
        }
        LOG.warn("Unexpected compaction type " + (Object)((Object)ct));
        return null;
    }

    static {
        doRetryOnConnPool = false;
        lockLock = new Object();
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static final class LockTypeComparator
    implements Comparator<LockType> {
        private LockTypeComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockType t1, LockType t2) {
            switch (t1) {
                case EXCLUSIVE: {
                    if (t2 == LockType.EXCLUSIVE) {
                        return 0;
                    }
                    return 1;
                }
                case SHARED_WRITE: {
                    switch (t2) {
                        case EXCLUSIVE: {
                            return -1;
                        }
                        case SHARED_WRITE: {
                            return 0;
                        }
                        case SHARED_READ: {
                            return 1;
                        }
                    }
                    throw new RuntimeException("Unexpected LockType: " + (Object)((Object)t2));
                }
                case SHARED_READ: {
                    if (t2 == LockType.SHARED_READ) {
                        return 0;
                    }
                    return -1;
                }
            }
            throw new RuntimeException("Unexpected LockType: " + (Object)((Object)t1));
        }
    }

    private static class LockInfoComparator
    implements Comparator<LockInfo> {
        private static final LockTypeComparator lockTypeComparator = new LockTypeComparator();

        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            int sortByType = lockTypeComparator.compare(info1.type, info2.type);
            if (sortByType != 0) {
                return sortByType;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        private final long extLockId;
        private final long intLockId;
        private final long txnId;
        private final String db;
        private final String table;
        private final String partition;
        private final LockState state;
        private final LockType type;

        LockInfo(ResultSet rs) throws SQLException, MetaException {
            this.extLockId = rs.getLong("hl_lock_ext_id");
            this.intLockId = rs.getLong("hl_lock_int_id");
            this.db = rs.getString("hl_db");
            String t = rs.getString("hl_table");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("hl_partition");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("hl_lock_state").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock state " + rs.getString("hl_lock_state").charAt(0));
                }
            }
            switch (rs.getString("hl_lock_type").charAt(0)) {
                case 'e': {
                    this.type = LockType.EXCLUSIVE;
                    break;
                }
                case 'r': {
                    this.type = LockType.SHARED_READ;
                    break;
                }
                case 'w': {
                    this.type = LockType.SHARED_WRITE;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock type " + rs.getString("hl_lock_type").charAt(0));
                }
            }
            this.txnId = rs.getLong("hl_txnid");
        }

        LockInfo(ShowLocksResponseElement e, long intLockId) {
            this.extLockId = e.getLockid();
            this.intLockId = intLockId;
            this.db = e.getDbname();
            this.table = e.getTablename();
            this.partition = e.getPartname();
            this.state = e.getState();
            this.type = e.getType();
            this.txnId = e.getTxnid();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return JavaUtils.lockIdToString((long)this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString((long)this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }

        private boolean isDbLock() {
            return this.db != null && this.table == null && this.partition == null;
        }

        private boolean isTableLock() {
            return this.db != null && this.table != null && this.partition == null;
        }

        static /* synthetic */ String access$700(LockInfo x0) {
            return x0.db;
        }

        static /* synthetic */ String access$800(LockInfo x0) {
            return x0.table;
        }

        static /* synthetic */ String access$900(LockInfo x0) {
            return x0.partition;
        }
    }

    protected static enum DatabaseProduct {
        DERBY,
        MYSQL,
        POSTGRES,
        ORACLE,
        SQLSERVER;

    }

    protected class RetryException
    extends Exception {
        protected RetryException() {
        }
    }

    private static class LockInfoExt
    extends LockInfo {
        private final ShowLocksResponseElement e;

        LockInfoExt(ShowLocksResponseElement e, long intLockId) {
            super(e, intLockId);
            this.e = e;
        }
    }
}

