/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.identity.IntIdentity;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.MetaStoreDirectSql;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.model.MColumnDescriptor;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MDelegationToken;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.apache.hadoop.hive.metastore.model.MFunction;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MIndex;
import org.apache.hadoop.hive.metastore.model.MMasterKey;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.apache.hadoop.hive.metastore.model.MOrder;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MPartitionEvent;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MResourceUri;
import org.apache.hadoop.hive.metastore.model.MRole;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MStringList;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.metastore.model.MType;
import org.apache.hadoop.hive.metastore.model.MVersionTable;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.thrift.TException;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore
implements RawStore,
Configurable {
    private static Properties prop = null;
    private static PersistenceManagerFactory pmf = null;
    private static Lock pmfPropLock = new ReentrantLock();
    private static final AtomicBoolean isSchemaVerified = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectStore.class.getName());
    private static final Map<String, Class> PINCLASSMAP;
    private static final String HOSTNAME;
    private static final String USER;
    private boolean isInitialized = false;
    private PersistenceManager pm = null;
    private MetaStoreDirectSql directSql = null;
    private PartitionExpressionProxy expressionProxy = null;
    private Configuration hiveConf;
    private volatile int openTrasactionCalls = 0;
    private Transaction currentTransaction = null;
    private TXN_STATUS transactionStatus = TXN_STATUS.NO_STATE;
    private Pattern partitionValidationPattern;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final int stackLimit = 5;

    public ObjectStore() {
        if (this.classLoader == null) {
            this.classLoader = ObjectStore.class.getClassLoader();
        }
    }

    public Configuration getConf() {
        return this.hiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        pmfPropLock.lock();
        try {
            boolean propsChanged;
            this.isInitialized = false;
            this.hiveConf = conf;
            Properties propsFromConf = ObjectStore.getDataSourceProps(conf);
            boolean bl = propsChanged = !propsFromConf.equals(prop);
            if (propsChanged) {
                pmf = null;
                prop = null;
            }
            assert (!this.isActiveTransaction());
            this.shutdown();
            this.pm = null;
            this.directSql = null;
            this.expressionProxy = null;
            this.openTrasactionCalls = 0;
            this.currentTransaction = null;
            this.transactionStatus = TXN_STATUS.NO_STATE;
            this.initialize(propsFromConf);
            String partitionValidationRegex = this.hiveConf.get(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.name());
            this.partitionValidationPattern = partitionValidationRegex != null && partitionValidationRegex.equals("") ? Pattern.compile(partitionValidationRegex) : null;
            if (!this.isInitialized) {
                throw new RuntimeException("Unable to create persistence manager. Check dss.log for details");
            }
            LOG.info("Initialized ObjectStore");
        }
        finally {
            pmfPropLock.unlock();
        }
    }

    private void initialize(Properties dsProps) {
        LOG.info("ObjectStore, initialize called");
        prop = dsProps;
        this.pm = this.getPersistenceManager();
        boolean bl = this.isInitialized = this.pm != null;
        if (this.isInitialized) {
            this.expressionProxy = ObjectStore.createExpressionProxy(this.hiveConf);
            if (HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL)) {
                this.directSql = new MetaStoreDirectSql(this.pm, this.hiveConf);
            }
        }
        LOG.debug("RawStore: " + this + ", with PersistenceManager: " + this.pm + " created in the thread with id: " + Thread.currentThread().getId());
    }

    private static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS);
        try {
            Class<?> clazz = MetaStoreUtils.getClass(className);
            return (PartitionExpressionProxy)MetaStoreUtils.newInstance(clazz, new Class[0], new Object[0]);
        }
        catch (MetaException e) {
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)((Object)e));
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }

    private static Properties getDataSourceProps(Configuration conf) {
        Properties prop = new Properties();
        for (Map.Entry e : conf) {
            if (!((String)e.getKey()).contains("datanucleus") && !((String)e.getKey()).contains("jdo")) continue;
            Object prevVal = prop.setProperty((String)e.getKey(), conf.get((String)e.getKey()));
            if (!LOG.isDebugEnabled() || ((String)e.getKey()).equals(HiveConf.ConfVars.METASTOREPWD.varname)) continue;
            LOG.debug("Overriding " + (String)e.getKey() + " value " + prevVal + " from  jpox.properties with " + (String)e.getValue());
        }
        try {
            String passwd = ShimLoader.getHadoopShims().getPassword(conf, HiveConf.ConfVars.METASTOREPWD.varname);
            if (passwd != null && !passwd.isEmpty()) {
                prop.setProperty(HiveConf.ConfVars.METASTOREPWD.varname, passwd);
            }
        }
        catch (IOException err) {
            throw new RuntimeException("Error getting metastore password: " + err.getMessage(), err);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, Object> e : prop.entrySet()) {
                if (e.getKey().equals(HiveConf.ConfVars.METASTOREPWD.varname)) continue;
                LOG.debug(e.getKey() + " = " + e.getValue());
            }
        }
        return prop;
    }

    private static synchronized PersistenceManagerFactory getPMF() {
        if (pmf == null) {
            pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
            DataStoreCache dsc = pmf.getDataStoreCache();
            if (dsc != null) {
                HiveConf conf = new HiveConf(ObjectStore.class);
                String objTypes = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CACHE_PINOBJTYPES);
                LOG.info("Setting MetaStore object pin classes with hive.metastore.cache.pinobjtypes=\"" + objTypes + "\"");
                if (objTypes != null && objTypes.length() > 0) {
                    String[] typeTokens;
                    objTypes = objTypes.toLowerCase();
                    for (String type : typeTokens = objTypes.split(",")) {
                        if (PINCLASSMAP.containsKey(type = type.trim())) {
                            dsc.pinAll(true, PINCLASSMAP.get(type));
                            continue;
                        }
                        LOG.warn(type + " is not one of the pinnable object types: " + StringUtils.join(PINCLASSMAP.keySet(), (String)" "));
                    }
                }
            } else {
                LOG.warn("PersistenceManagerFactory returned null DataStoreCache object. Unable to initialize object pin types defined by hive.metastore.cache.pinobjtypes");
            }
        }
        return pmf;
    }

    @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
    @InterfaceStability.Evolving
    public PersistenceManager getPersistenceManager() {
        return ObjectStore.getPMF().getPersistenceManager();
    }

    @Override
    public void shutdown() {
        if (this.pm != null) {
            LOG.debug("RawStore: " + this + ", with PersistenceManager: " + this.pm + " will be shutdown");
            this.pm.close();
        }
    }

    @Override
    public boolean openTransaction() {
        ++this.openTrasactionCalls;
        if (this.openTrasactionCalls == 1) {
            this.currentTransaction = this.pm.currentTransaction();
            this.currentTransaction.begin();
            this.transactionStatus = TXN_STATUS.OPEN;
        } else if (this.currentTransaction == null || !this.currentTransaction.isActive()) {
            throw new RuntimeException("openTransaction called in an interior transaction scope, but currentTransaction is not active.");
        }
        boolean result = this.currentTransaction.isActive();
        this.debugLog("Open transaction: count = " + this.openTrasactionCalls + ", isActive = " + result);
        return result;
    }

    @Override
    public boolean commitTransaction() {
        if (TXN_STATUS.ROLLBACK == this.transactionStatus) {
            this.debugLog("Commit transaction: rollback");
            return false;
        }
        if (this.openTrasactionCalls <= 0) {
            RuntimeException e = new RuntimeException("commitTransaction was called but openTransactionCalls = " + this.openTrasactionCalls + ". This probably indicates that there are unbalanced " + "calls to openTransaction/commitTransaction");
            LOG.error("Unbalanced calls to open/commit Transaction", (Throwable)e);
            throw e;
        }
        if (!this.currentTransaction.isActive()) {
            RuntimeException e = new RuntimeException("commitTransaction was called but openTransactionCalls = " + this.openTrasactionCalls + ". This probably indicates that there are unbalanced " + "calls to openTransaction/commitTransaction");
            LOG.error("Unbalanced calls to open/commit Transaction", (Throwable)e);
            throw e;
        }
        --this.openTrasactionCalls;
        this.debugLog("Commit transaction: count = " + this.openTrasactionCalls + ", isactive " + this.currentTransaction.isActive());
        if (this.openTrasactionCalls == 0 && this.currentTransaction.isActive()) {
            this.transactionStatus = TXN_STATUS.COMMITED;
            this.currentTransaction.commit();
        }
        return true;
    }

    public boolean isActiveTransaction() {
        if (this.currentTransaction == null) {
            return false;
        }
        return this.currentTransaction.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() {
        if (this.openTrasactionCalls < 1) {
            this.debugLog("rolling back transaction: no open transactions: " + this.openTrasactionCalls);
            return;
        }
        this.debugLog("Rollback transaction, isActive: " + this.currentTransaction.isActive());
        try {
            if (this.currentTransaction.isActive() && this.transactionStatus != TXN_STATUS.ROLLBACK) {
                this.currentTransaction.rollback();
            }
        }
        finally {
            this.openTrasactionCalls = 0;
            this.transactionStatus = TXN_STATUS.ROLLBACK;
            this.pm.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        boolean commited = false;
        MDatabase mdb = new MDatabase();
        mdb.setName(db.getName().toLowerCase());
        mdb.setLocationUri(db.getLocationUri());
        mdb.setDescription(db.getDescription());
        mdb.setParameters(db.getParameters());
        mdb.setOwnerName(db.getOwnerName());
        PrincipalType ownerType = db.getOwnerType();
        mdb.setOwnerType(null == ownerType ? PrincipalType.USER.name() : ownerType.name());
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mdb);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDatabase getMDatabase(String name) throws NoSuchObjectException {
        MDatabase mdb = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            name = HiveStringUtils.normalizeIdentifier((String)name);
            query = this.pm.newQuery(MDatabase.class, "name == dbname");
            query.declareParameters("java.lang.String dbname");
            query.setUnique(true);
            mdb = (MDatabase)query.execute((Object)name);
            this.pm.retrieve((Object)mdb);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        if (mdb == null) {
            throw new NoSuchObjectException("There is no database named " + name);
        }
        return mdb;
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException {
        MetaException ex = null;
        Database db = null;
        try {
            db = this.getDatabaseInternal(name);
        }
        catch (MetaException e) {
            ex = e;
        }
        if (db == null) {
            LOG.warn("Failed to get database " + name + ", returning NoSuchObjectException", (Throwable)((Object)ex));
            throw new NoSuchObjectException(name + (ex == null ? "" : ": " + ex.getMessage()));
        }
        return db;
    }

    public Database getDatabaseInternal(String name) throws MetaException, NoSuchObjectException {
        return (Database)new GetDbHelper(name, null, true, true){

            @Override
            protected Database getSqlResult(GetHelper<Database> ctx) throws MetaException {
                return ObjectStore.this.directSql.getDatabase(this.dbName);
            }

            @Override
            protected Database getJdoResult(GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getJDODatabase(this.dbName);
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getJDODatabase(String name) throws NoSuchObjectException {
        MDatabase mdb = null;
        boolean commited = false;
        try {
            this.openTransaction();
            mdb = this.getMDatabase(name);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        Database db = new Database();
        db.setName(mdb.getName());
        db.setDescription(mdb.getDescription());
        db.setLocationUri(mdb.getLocationUri());
        db.setParameters(this.convertMap(mdb.getParameters()));
        db.setOwnerName(mdb.getOwnerName());
        String type = mdb.getOwnerType();
        db.setOwnerType(null == type || type.trim().isEmpty() ? null : PrincipalType.valueOf(type));
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alterDatabase(String dbName, Database db) throws MetaException, NoSuchObjectException {
        MDatabase mdb = null;
        boolean committed = false;
        try {
            mdb = this.getMDatabase(dbName);
            mdb.setParameters(db.getParameters());
            mdb.setOwnerName(db.getOwnerName());
            if (db.getOwnerType() != null) {
                mdb.setOwnerType(db.getOwnerType().name());
            }
            this.openTransaction();
            this.pm.makePersistent((Object)mdb);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropDatabase(String dbname) throws NoSuchObjectException, MetaException {
        boolean success = false;
        LOG.info("Dropping database " + dbname + " along with all tables");
        dbname = HiveStringUtils.normalizeIdentifier((String)dbname);
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            MDatabase db = this.getMDatabase(dbname);
            this.pm.retrieve((Object)db);
            if (db != null) {
                List<MDBPrivilege> dbGrants = this.listDatabaseGrants(dbname, queryWrapper);
                if (dbGrants != null && dbGrants.size() > 0) {
                    this.pm.deletePersistentAll(dbGrants);
                }
                this.pm.deletePersistent((Object)db);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDatabases(String pattern) throws MetaException {
        if (pattern == null || pattern.equals("*")) {
            return this.getAllDatabases();
        }
        boolean commited = false;
        ArrayList<String> databases = null;
        Query query = null;
        try {
            this.openTransaction();
            String[] subpatterns = pattern.trim().split("\\|");
            String queryStr = "select name from org.apache.hadoop.hive.metastore.model.MDatabase where (";
            boolean first = true;
            for (String subpattern : subpatterns) {
                subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
                if (!first) {
                    queryStr = queryStr + " || ";
                }
                queryStr = queryStr + " name.matches(\"" + subpattern + "\")";
                first = false;
            }
            queryStr = queryStr + ")";
            query = this.pm.newQuery(queryStr);
            query.setResult("name");
            query.setOrdering("name ascending");
            Collection names = (Collection)query.execute();
            databases = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                databases.add((String)i.next());
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllDatabases() throws MetaException {
        boolean commited = false;
        ArrayList<String> databases = null;
        String queryStr = "select name from org.apache.hadoop.hive.metastore.model.MDatabase";
        Query query = null;
        this.openTransaction();
        try {
            query = this.pm.newQuery(queryStr);
            query.setResult("name");
            databases = new ArrayList<String>((Collection)query.execute());
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        Collections.sort(databases);
        return databases;
    }

    private MType getMType(Type type) {
        ArrayList<MFieldSchema> fields = new ArrayList<MFieldSchema>();
        if (type.getFields() != null) {
            for (FieldSchema field : type.getFields()) {
                fields.add(new MFieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        return new MType(type.getName(), type.getType1(), type.getType2(), fields);
    }

    private Type getType(MType mtype) {
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        if (mtype.getFields() != null) {
            for (MFieldSchema field : mtype.getFields()) {
                fields.add(new FieldSchema(field.getName(), field.getType(), field.getComment()));
            }
        }
        Type ret = new Type();
        ret.setName(mtype.getName());
        ret.setType1(mtype.getType1());
        ret.setType2(mtype.getType2());
        ret.setFields(fields);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createType(Type type) {
        boolean success = false;
        MType mtype = this.getMType(type);
        boolean commited = false;
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mtype);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getType(String typeName) {
        Type type = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType mtype = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve(type);
            if (mtype != null) {
                type = this.getType(mtype);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropType(String typeName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MType.class, "name == typeName");
            query.declareParameters("java.lang.String typeName");
            query.setUnique(true);
            MType type = (MType)query.execute((Object)typeName.trim());
            this.pm.retrieve((Object)type);
            if (type != null) {
                this.pm.deletePersistent((Object)type);
            }
            success = this.commitTransaction();
        }
        catch (JDOObjectNotFoundException e) {
            success = this.commitTransaction();
            LOG.debug("type not found " + typeName, (Throwable)e);
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MTable mtbl = this.convertToMTable(tbl);
            this.pm.makePersistent((Object)mtbl);
            PrincipalPrivilegeSet principalPrivs = tbl.getPrivileges();
            ArrayList<Object> toPersistPrivObjs = new ArrayList<Object>();
            if (principalPrivs != null) {
                int now = (int)(System.currentTimeMillis() / 1000L);
                Map<String, List<PrivilegeGrantInfo>> userPrivs = principalPrivs.getUserPrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, userPrivs, PrincipalType.USER);
                Map<String, List<PrivilegeGrantInfo>> groupPrivs = principalPrivs.getGroupPrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, groupPrivs, PrincipalType.GROUP);
                Map<String, List<PrivilegeGrantInfo>> rolePrivs = principalPrivs.getRolePrivileges();
                this.putPersistentPrivObjects(mtbl, toPersistPrivObjs, now, rolePrivs, PrincipalType.ROLE);
            }
            this.pm.makePersistentAll(toPersistPrivObjs);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    private void putPersistentPrivObjects(MTable mtbl, List<Object> toPersistPrivObjs, int now, Map<String, List<PrivilegeGrantInfo>> privMap, PrincipalType type) {
        if (privMap != null) {
            for (Map.Entry<String, List<PrivilegeGrantInfo>> entry : privMap.entrySet()) {
                String principalName = entry.getKey();
                List<PrivilegeGrantInfo> privs = entry.getValue();
                for (int i = 0; i < privs.size(); ++i) {
                    PrivilegeGrantInfo priv = privs.get(i);
                    if (priv == null) continue;
                    MTablePrivilege mTblSec = new MTablePrivilege(principalName, type.toString(), mtbl, priv.getPrivilege(), now, priv.getGrantor(), priv.getGrantorType().toString(), priv.isGrantOption());
                    toPersistPrivObjs.add(mTblSec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropTable(String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            MTable tbl = this.getMTable(dbName, tableName);
            this.pm.retrieve((Object)tbl);
            if (tbl != null) {
                List<MPartitionColumnPrivilege> partColGrants;
                List<MPartitionPrivilege> partGrants;
                List<MTableColumnPrivilege> tblColGrants;
                List<MTablePrivilege> tabGrants = this.listAllTableGrants(dbName, tableName);
                if (tabGrants != null && tabGrants.size() > 0) {
                    this.pm.deletePersistentAll(tabGrants);
                }
                if ((tblColGrants = this.listTableAllColumnGrants(dbName, tableName)) != null && tblColGrants.size() > 0) {
                    this.pm.deletePersistentAll(tblColGrants);
                }
                if ((partGrants = this.listTableAllPartitionGrants(dbName, tableName)) != null && partGrants.size() > 0) {
                    this.pm.deletePersistentAll(partGrants);
                }
                if ((partColGrants = this.listTableAllPartitionColumnGrants(dbName, tableName)) != null && partColGrants.size() > 0) {
                    this.pm.deletePersistentAll(partColGrants);
                }
                try {
                    this.deleteTableColumnStatistics(dbName, tableName, null);
                }
                catch (NoSuchObjectException e) {
                    LOG.info("Found no table level column statistics associated with db " + dbName + " table " + tableName + " record to delete");
                }
                this.preDropStorageDescriptor(tbl.getSd());
                this.pm.deletePersistentAll(new Object[]{tbl});
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String dbName, String tableName) throws MetaException {
        boolean commited = false;
        Table tbl = null;
        try {
            this.openTransaction();
            tbl = this.convertToTable(this.getMTable(dbName, tableName));
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTables(String dbName, String pattern) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<String> tbls = null;
        try {
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            String[] subpatterns = pattern.trim().split("\\|");
            String queryStr = "select tableName from org.apache.hadoop.hive.metastore.model.MTable where database.name == dbName && (";
            boolean first = true;
            for (String subpattern : subpatterns) {
                subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
                if (!first) {
                    queryStr = queryStr + " || ";
                }
                queryStr = queryStr + " tableName.matches(\"" + subpattern + "\")";
                first = false;
            }
            queryStr = queryStr + ")";
            query = this.pm.newQuery(queryStr);
            query.declareParameters("java.lang.String dbName");
            query.setResult("tableName");
            query.setOrdering("tableName ascending");
            Collection names = (Collection)query.execute((Object)dbName);
            tbls = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                tbls.add((String)i.next());
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return tbls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableMeta> getTableMeta(String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<TableMeta> metas = new ArrayList<TableMeta>();
        try {
            this.openTransaction();
            StringBuilder builder = new StringBuilder();
            if (dbNames != null && !dbNames.equals("*")) {
                this.appendPatternCondition(builder, "database.name", dbNames);
            }
            if (tableNames != null && !tableNames.equals("*")) {
                this.appendPatternCondition(builder, "tableName", tableNames);
            }
            if (tableTypes != null && !tableTypes.isEmpty()) {
                this.appendSimpleCondition(builder, "tableType", tableTypes.toArray(new String[0]));
            }
            query = this.pm.newQuery(MTable.class, builder.toString());
            Collection tables = (Collection)query.execute();
            for (MTable table : tables) {
                TableMeta metaData = new TableMeta(table.getDatabase().getName(), table.getTableName(), table.getTableType());
                metaData.setComments(table.getParameters().get("comment"));
                metas.add(metaData);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return metas;
    }

    private StringBuilder appendPatternCondition(StringBuilder builder, String fieldName, String elements) {
        elements = HiveStringUtils.normalizeIdentifier((String)elements);
        return this.appendCondition(builder, fieldName, elements.split("\\|"), true);
    }

    private StringBuilder appendSimpleCondition(StringBuilder builder, String fieldName, String[] elements) {
        return this.appendCondition(builder, fieldName, elements, false);
    }

    private StringBuilder appendCondition(StringBuilder builder, String fieldName, String[] elements, boolean pattern) {
        if (builder.length() > 0) {
            builder.append(" && ");
        }
        builder.append(" (");
        int length = builder.length();
        for (String element : elements) {
            if (pattern) {
                element = "(?i)" + element.replaceAll("\\*", ".*");
            }
            if (builder.length() > length) {
                builder.append(" || ");
            }
            builder.append(fieldName);
            if (pattern) {
                builder.append(".matches(\"").append(element).append("\")");
                continue;
            }
            builder.append(" == \"").append(element).append("\"");
        }
        builder.append(" )");
        return builder;
    }

    @Override
    public List<String> getAllTables(String dbName) throws MetaException {
        return this.getTables(dbName, ".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MTable getMTable(String db, String table) {
        MTable mtbl = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            db = HiveStringUtils.normalizeIdentifier((String)db);
            table = HiveStringUtils.normalizeIdentifier((String)table);
            query = this.pm.newQuery(MTable.class, "tableName == table && database.name == db");
            query.declareParameters("java.lang.String table, java.lang.String db");
            query.setUnique(true);
            mtbl = (MTable)query.execute((Object)table, (Object)db);
            this.pm.retrieve((Object)mtbl);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mtbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Table> getTableObjectsByName(String db, List<String> tbl_names) throws MetaException, UnknownDBException {
        ArrayList<Table> tables = new ArrayList<Table>();
        boolean committed = false;
        Query dbExistsQuery = null;
        Query query = null;
        try {
            this.openTransaction();
            db = HiveStringUtils.normalizeIdentifier((String)db);
            dbExistsQuery = this.pm.newQuery(MDatabase.class, "name == db");
            dbExistsQuery.declareParameters("java.lang.String db");
            dbExistsQuery.setUnique(true);
            dbExistsQuery.setResult("name");
            String dbNameIfExists = (String)dbExistsQuery.execute((Object)db);
            if (dbNameIfExists == null || dbNameIfExists.isEmpty()) {
                throw new UnknownDBException("Could not find database " + db);
            }
            ArrayList<String> lowered_tbl_names = new ArrayList<String>();
            for (String t : tbl_names) {
                lowered_tbl_names.add(HiveStringUtils.normalizeIdentifier((String)t));
            }
            query = this.pm.newQuery(MTable.class);
            query.setFilter("database.name == db && tbl_names.contains(tableName)");
            query.declareParameters("java.lang.String db, java.util.Collection tbl_names");
            Collection mtables = (Collection)query.execute((Object)db, lowered_tbl_names);
            Iterator iter = mtables.iterator();
            while (iter.hasNext()) {
                tables.add(this.convertToTable((MTable)iter.next()));
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (dbExistsQuery != null) {
                dbExistsQuery.closeAll();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return tables;
    }

    private <T> List<T> convertList(List<T> dnList) {
        return dnList == null ? null : Lists.newArrayList(dnList);
    }

    private Map<String, String> convertMap(Map<String, String> dnMap) {
        return MetaStoreUtils.trimMapNulls(dnMap, HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS));
    }

    private Table convertToTable(MTable mtbl) throws MetaException {
        if (mtbl == null) {
            return null;
        }
        String tableType = mtbl.getTableType();
        if (tableType == null) {
            tableType = mtbl.getViewOriginalText() != null ? TableType.VIRTUAL_VIEW.toString() : ("TRUE".equals(mtbl.getParameters().get("EXTERNAL")) ? TableType.EXTERNAL_TABLE.toString() : TableType.MANAGED_TABLE.toString());
        }
        return new Table(mtbl.getTableName(), mtbl.getDatabase().getName(), mtbl.getOwner(), mtbl.getCreateTime(), mtbl.getLastAccessTime(), mtbl.getRetention(), this.convertToStorageDescriptor(mtbl.getSd()), this.convertToFieldSchemas(mtbl.getPartitionKeys()), this.convertMap(mtbl.getParameters()), mtbl.getViewOriginalText(), mtbl.getViewExpandedText(), tableType);
    }

    private MTable convertToMTable(Table tbl) throws InvalidObjectException, MetaException {
        if (tbl == null) {
            return null;
        }
        MDatabase mdb = null;
        try {
            mdb = this.getMDatabase(tbl.getDbName());
        }
        catch (NoSuchObjectException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)((Object)e)));
            throw new InvalidObjectException("Database " + tbl.getDbName() + " doesn't exist.");
        }
        String tableType = tbl.getTableType();
        boolean isExternal = "TRUE".equals(tbl.getParameters().get("EXTERNAL"));
        if (TableType.MANAGED_TABLE.toString().equals(tableType) && isExternal) {
            tableType = TableType.EXTERNAL_TABLE.toString();
        }
        if (TableType.EXTERNAL_TABLE.toString().equals(tableType) && !isExternal) {
            tableType = TableType.MANAGED_TABLE.toString();
        }
        return new MTable(HiveStringUtils.normalizeIdentifier((String)tbl.getTableName()), mdb, this.convertToMStorageDescriptor(tbl.getSd()), tbl.getOwner(), tbl.getCreateTime(), tbl.getLastAccessTime(), tbl.getRetention(), this.convertToMFieldSchemas(tbl.getPartitionKeys()), tbl.getParameters(), tbl.getViewOriginalText(), tbl.getViewExpandedText(), tableType);
    }

    private List<MFieldSchema> convertToMFieldSchemas(List<FieldSchema> keys) {
        ArrayList<MFieldSchema> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MFieldSchema>(keys.size());
            for (FieldSchema part : keys) {
                mkeys.add(new MFieldSchema(HiveStringUtils.normalizeIdentifier((String)part.getName()), part.getType(), part.getComment()));
            }
        }
        return mkeys;
    }

    private List<FieldSchema> convertToFieldSchemas(List<MFieldSchema> mkeys) {
        ArrayList<FieldSchema> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<FieldSchema>(mkeys.size());
            for (MFieldSchema part : mkeys) {
                keys.add(new FieldSchema(part.getName(), part.getType(), part.getComment()));
            }
        }
        return keys;
    }

    private List<MOrder> convertToMOrders(List<Order> keys) {
        ArrayList<MOrder> mkeys = null;
        if (keys != null) {
            mkeys = new ArrayList<MOrder>(keys.size());
            for (Order part : keys) {
                mkeys.add(new MOrder(HiveStringUtils.normalizeIdentifier((String)part.getCol()), part.getOrder()));
            }
        }
        return mkeys;
    }

    private List<Order> convertToOrders(List<MOrder> mkeys) {
        ArrayList<Order> keys = null;
        if (mkeys != null) {
            keys = new ArrayList<Order>(mkeys.size());
            for (MOrder part : mkeys) {
                keys.add(new Order(part.getCol(), part.getOrder()));
            }
        }
        return keys;
    }

    private SerDeInfo convertToSerDeInfo(MSerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        return new SerDeInfo(ms.getName(), ms.getSerializationLib(), this.convertMap(ms.getParameters()));
    }

    private MSerDeInfo convertToMSerDeInfo(SerDeInfo ms) throws MetaException {
        if (ms == null) {
            throw new MetaException("Invalid SerDeInfo object");
        }
        return new MSerDeInfo(ms.getName(), ms.getSerializationLib(), ms.getParameters());
    }

    private MColumnDescriptor createNewMColumnDescriptor(List<MFieldSchema> cols) {
        if (cols == null) {
            return null;
        }
        return new MColumnDescriptor(cols);
    }

    private StorageDescriptor convertToStorageDescriptor(MStorageDescriptor msd, boolean noFS) throws MetaException {
        if (msd == null) {
            return null;
        }
        List<MFieldSchema> mFieldSchemas = msd.getCD() == null ? null : msd.getCD().getCols();
        StorageDescriptor sd = new StorageDescriptor(noFS ? null : this.convertToFieldSchemas(mFieldSchemas), msd.getLocation(), msd.getInputFormat(), msd.getOutputFormat(), msd.isCompressed(), msd.getNumBuckets(), this.convertToSerDeInfo(msd.getSerDeInfo()), this.convertList(msd.getBucketCols()), this.convertToOrders(msd.getSortCols()), this.convertMap(msd.getParameters()));
        SkewedInfo skewedInfo = new SkewedInfo(this.convertList(msd.getSkewedColNames()), this.convertToSkewedValues(msd.getSkewedColValues()), this.covertToSkewedMap(msd.getSkewedColValueLocationMaps()));
        sd.setSkewedInfo(skewedInfo);
        sd.setStoredAsSubDirectories(msd.isStoredAsSubDirectories());
        return sd;
    }

    private StorageDescriptor convertToStorageDescriptor(MStorageDescriptor msd) throws MetaException {
        return this.convertToStorageDescriptor(msd, false);
    }

    private List<List<String>> convertToSkewedValues(List<MStringList> mLists) {
        ArrayList<ArrayList<String>> lists = null;
        if (mLists != null) {
            lists = new ArrayList<ArrayList<String>>(mLists.size());
            for (MStringList element : mLists) {
                lists.add(new ArrayList<String>(element.getInternalList()));
            }
        }
        return lists;
    }

    private List<MStringList> convertToMStringLists(List<List<String>> mLists) {
        ArrayList<MStringList> lists = null;
        if (null != mLists) {
            lists = new ArrayList<MStringList>();
            for (List<String> mList : mLists) {
                lists.add(new MStringList(mList));
            }
        }
        return lists;
    }

    private Map<List<String>, String> covertToSkewedMap(Map<MStringList, String> mMap) {
        HashMap<ArrayList<String>, String> map = null;
        if (mMap != null) {
            map = new HashMap<ArrayList<String>, String>(mMap.size());
            Set<MStringList> keys = mMap.keySet();
            for (MStringList key : keys) {
                map.put(new ArrayList<String>(key.getInternalList()), mMap.get(key));
            }
        }
        return map;
    }

    private Map<MStringList, String> covertToMapMStringList(Map<List<String>, String> mMap) {
        HashMap<MStringList, String> map = null;
        if (mMap != null) {
            map = new HashMap<MStringList, String>(mMap.size());
            Set<List<String>> keys = mMap.keySet();
            for (List<String> key : keys) {
                map.put(new MStringList(key), mMap.get(key));
            }
        }
        return map;
    }

    private MStorageDescriptor convertToMStorageDescriptor(StorageDescriptor sd) throws MetaException {
        if (sd == null) {
            return null;
        }
        MColumnDescriptor mcd = this.createNewMColumnDescriptor(this.convertToMFieldSchemas(sd.getCols()));
        return this.convertToMStorageDescriptor(sd, mcd);
    }

    private MStorageDescriptor convertToMStorageDescriptor(StorageDescriptor sd, MColumnDescriptor mcd) throws MetaException {
        if (sd == null) {
            return null;
        }
        return new MStorageDescriptor(mcd, sd.getLocation(), sd.getInputFormat(), sd.getOutputFormat(), sd.isCompressed(), sd.getNumBuckets(), this.convertToMSerDeInfo(sd.getSerdeInfo()), sd.getBucketCols(), this.convertToMOrders(sd.getSortCols()), sd.getParameters(), null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColNames(), this.convertToMStringLists(null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColValues()), this.covertToMapMStringList(null == sd.getSkewedInfo() ? null : sd.getSkewedInfo().getSkewedColValueLocationMaps()), sd.isStoredAsSubDirectories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        boolean success = false;
        this.openTransaction();
        try {
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            MTable table = this.getMTable(dbName, tblName);
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(dbName, tblName);
                tabColumnGrants = this.listTableAllColumnGrants(dbName, tblName);
            }
            ArrayList<Object> toPersist = new ArrayList<Object>();
            for (Partition part : parts) {
                if (!part.getTableName().equals(tblName) || !part.getDbName().equals(dbName)) {
                    throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + part);
                }
                MPartition mpart = this.convertToMPart(part, true);
                toPersist.add(mpart);
                int now = (int)(System.currentTimeMillis() / 1000L);
                if (tabGrants != null) {
                    for (MTablePrivilege tab : tabGrants) {
                        toPersist.add(new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption()));
                    }
                }
                if (tabColumnGrants == null) continue;
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    toPersist.add(new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption()));
                }
            }
            if (toPersist.size() > 0) {
                this.pm.makePersistentAll(toPersist);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    private boolean isValidPartition(Partition part, boolean ifNotExists) throws MetaException {
        MetaStoreUtils.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
        boolean doesExist = this.doesPartitionExist(part.getDbName(), part.getTableName(), part.getValues());
        if (doesExist && !ifNotExists) {
            throw new MetaException("Partition already exists: " + part);
        }
        return !doesExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartitions(String dbName, String tblName, PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException, MetaException {
        boolean success = false;
        this.openTransaction();
        try {
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            MTable table = this.getMTable(dbName, tblName);
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(dbName, tblName);
                tabColumnGrants = this.listTableAllColumnGrants(dbName, tblName);
            }
            if (!partitionSpec.getTableName().equals(tblName) || !partitionSpec.getDbName().equals(dbName)) {
                throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + partitionSpec);
            }
            PartitionSpecProxy.PartitionIterator iterator = partitionSpec.getPartitionIterator();
            int now = (int)(System.currentTimeMillis() / 1000L);
            while (iterator.hasNext()) {
                Partition part = (Partition)iterator.next();
                if (!this.isValidPartition(part, ifNotExists)) continue;
                MPartition mpart = this.convertToMPart(part, true);
                this.pm.makePersistent((Object)mpart);
                if (tabGrants != null) {
                    for (MTablePrivilege tab : tabGrants) {
                        this.pm.makePersistent((Object)new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption()));
                    }
                }
                if (tabColumnGrants == null) continue;
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    this.pm.makePersistent((Object)new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption()));
                }
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        boolean success = false;
        boolean commited = false;
        try {
            MTable table = this.getMTable(part.getDbName(), part.getTableName());
            List<MTablePrivilege> tabGrants = null;
            List<MTableColumnPrivilege> tabColumnGrants = null;
            if ("TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                tabGrants = this.listAllTableGrants(part.getDbName(), part.getTableName());
                tabColumnGrants = this.listTableAllColumnGrants(part.getDbName(), part.getTableName());
            }
            this.openTransaction();
            MPartition mpart = this.convertToMPart(part, true);
            this.pm.makePersistent((Object)mpart);
            int now = (int)(System.currentTimeMillis() / 1000L);
            ArrayList<Object> toPersist = new ArrayList<Object>();
            if (tabGrants != null) {
                for (MTablePrivilege tab : tabGrants) {
                    MPartitionPrivilege partGrant = new MPartitionPrivilege(tab.getPrincipalName(), tab.getPrincipalType(), mpart, tab.getPrivilege(), now, tab.getGrantor(), tab.getGrantorType(), tab.getGrantOption());
                    toPersist.add(partGrant);
                }
            }
            if (tabColumnGrants != null) {
                for (MTableColumnPrivilege col : tabColumnGrants) {
                    MPartitionColumnPrivilege partColumn = new MPartitionColumnPrivilege(col.getPrincipalName(), col.getPrincipalType(), mpart, col.getColumnName(), col.getPrivilege(), now, col.getGrantor(), col.getGrantorType(), col.getGrantOption());
                    toPersist.add(partColumn);
                }
                if (toPersist.size() > 0) {
                    this.pm.makePersistentAll(toPersist);
                }
            }
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws NoSuchObjectException, MetaException {
        this.openTransaction();
        Partition part = this.convertToPart(this.getMPartition(dbName, tableName, part_vals));
        this.commitTransaction();
        if (part == null) {
            throw new NoSuchObjectException("partition values=" + part_vals.toString());
        }
        part.setValues(part_vals);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPartition getMPartition(String dbName, String tableName, List<String> part_vals) throws MetaException {
        MPartition mpart = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
            MTable mtbl = this.getMTable(dbName, tableName);
            if (mtbl == null) {
                commited = this.commitTransaction();
                MPartition mPartition = null;
                return mPartition;
            }
            String name = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part_vals);
            query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2 && partitionName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            mpart = (MPartition)query.execute((Object)tableName, (Object)dbName, (Object)name);
            this.pm.retrieve((Object)mpart);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mpart;
    }

    private MPartition convertToMPart(Partition part, boolean useTableCD) throws InvalidObjectException, MetaException {
        if (part == null) {
            return null;
        }
        MTable mt = this.getMTable(part.getDbName(), part.getTableName());
        if (mt == null) {
            throw new InvalidObjectException("Partition doesn't have a valid table or database name");
        }
        MStorageDescriptor msd = useTableCD && mt.getSd() != null && mt.getSd().getCD() != null && mt.getSd().getCD().getCols() != null && part.getSd() != null && this.convertToFieldSchemas(mt.getSd().getCD().getCols()).equals(part.getSd().getCols()) ? this.convertToMStorageDescriptor(part.getSd(), mt.getSd().getCD()) : this.convertToMStorageDescriptor(part.getSd());
        return new MPartition(Warehouse.makePartName(this.convertToFieldSchemas(mt.getPartitionKeys()), part.getValues()), mt, part.getValues(), part.getCreateTime(), part.getLastAccessTime(), msd, part.getParameters());
    }

    private Partition convertToPart(MPartition mpart) throws MetaException {
        if (mpart == null) {
            return null;
        }
        return new Partition(this.convertList(mpart.getValues()), mpart.getTable().getDatabase().getName(), mpart.getTable().getTableName(), mpart.getCreateTime(), mpart.getLastAccessTime(), this.convertToStorageDescriptor(mpart.getSd()), this.convertMap(mpart.getParameters()));
    }

    private Partition convertToPart(String dbName, String tblName, MPartition mpart) throws MetaException {
        if (mpart == null) {
            return null;
        }
        return new Partition(this.convertList(mpart.getValues()), dbName, tblName, mpart.getCreateTime(), mpart.getLastAccessTime(), this.convertToStorageDescriptor(mpart.getSd(), false), this.convertMap(mpart.getParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            MPartition part = this.getMPartition(dbName, tableName, part_vals);
            this.dropPartitionCommon(part);
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartitions(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        if (partNames.isEmpty()) {
            return;
        }
        boolean success = false;
        this.openTransaction();
        try {
            this.dropPartitionGrantsNoTxn(dbName, tblName, partNames);
            this.dropPartitionAllColumnGrantsNoTxn(dbName, tblName, partNames);
            this.dropPartitionColumnStatisticsNoTxn(dbName, tblName, partNames);
            for (MColumnDescriptor mcd : this.detachCdsFromSdsNoTxn(dbName, tblName, partNames)) {
                this.removeUnusedColumnDescriptor(mcd);
            }
            this.dropPartitionsNoTxn(dbName, tblName, partNames);
            success = this.commitTransaction();
            if (!success) {
                throw new MetaException("Failed to drop partitions");
            }
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropPartitionCommon(MPartition part) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            if (part != null) {
                List<MPartitionColumnPrivilege> partColumnGrants;
                List<MFieldSchema> schemas = part.getTable().getPartitionKeys();
                ArrayList<String> colNames = new ArrayList<String>();
                for (MFieldSchema col : schemas) {
                    colNames.add(col.getName());
                }
                String partName = FileUtils.makePartName(colNames, part.getValues());
                List<MPartitionPrivilege> partGrants = this.listPartitionGrants(part.getTable().getDatabase().getName(), part.getTable().getTableName(), Lists.newArrayList((Object[])new String[]{partName}));
                if (partGrants != null && partGrants.size() > 0) {
                    this.pm.deletePersistentAll(partGrants);
                }
                if ((partColumnGrants = this.listPartitionAllColumnGrants(part.getTable().getDatabase().getName(), part.getTable().getTableName(), Lists.newArrayList((Object[])new String[]{partName}))) != null && partColumnGrants.size() > 0) {
                    this.pm.deletePersistentAll(partColumnGrants);
                }
                String dbName = part.getTable().getDatabase().getName();
                String tableName = part.getTable().getTableName();
                try {
                    this.deletePartitionColumnStatistics(dbName, tableName, partName, part.getValues(), null);
                }
                catch (NoSuchObjectException e) {
                    LOG.info("No column statistics records found to delete");
                }
                this.preDropStorageDescriptor(part.getSd());
                this.pm.deletePersistent((Object)part);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    @Override
    public List<Partition> getPartitions(String dbName, String tableName, int maxParts) throws MetaException, NoSuchObjectException {
        return this.getPartitionsInternal(dbName, tableName, maxParts, true, true);
    }

    protected List<Partition> getPartitionsInternal(String dbName, String tblName, final int maxParts, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<Partition>(dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                Integer max = maxParts < 0 ? null : Integer.valueOf(maxParts);
                return ObjectStore.this.directSql.getPartitions(this.dbName, this.tblName, max);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List list = ObjectStore.this.convertToParts(ObjectStore.this.listMPartitions(this.dbName, this.tblName, maxParts, queryWrapper));
                    return list;
                }
            }
        }.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short max, String userName, List<String> groupNames) throws MetaException, InvalidObjectException {
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            List<MPartition> mparts = this.listMPartitions(dbName, tblName, max, queryWrapper);
            ArrayList<Partition> parts = new ArrayList<Partition>(mparts.size());
            if (mparts != null && mparts.size() > 0) {
                for (MPartition mpart : mparts) {
                    MTable mtbl = mpart.getTable();
                    Partition part = this.convertToPart(mpart);
                    parts.add(part);
                    if (!"TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) continue;
                    String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part.getValues());
                    PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(dbName, tblName, partName, userName, groupNames);
                    part.setPrivileges(partAuth);
                }
            }
            success = this.commitTransaction();
            ArrayList<Partition> arrayList = parts;
            return arrayList;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, InvalidObjectException {
        boolean success = false;
        try {
            this.openTransaction();
            MPartition mpart = this.getMPartition(dbName, tblName, partVals);
            if (mpart == null) {
                this.commitTransaction();
                throw new NoSuchObjectException("partition values=" + partVals.toString());
            }
            Partition part = null;
            MTable mtbl = mpart.getTable();
            part = this.convertToPart(mpart);
            if ("TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), partVals);
                PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(dbName, tblName, partName, user_name, group_names);
                part.setPrivileges(partAuth);
            }
            success = this.commitTransaction();
            Partition partition = part;
            return partition;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    private List<Partition> convertToParts(List<MPartition> mparts) throws MetaException {
        return this.convertToParts(mparts, null);
    }

    private List<Partition> convertToParts(List<MPartition> src, List<Partition> dest) throws MetaException {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (MPartition mp : src) {
            dest.add(this.convertToPart(mp));
            Deadline.checkTimeout();
        }
        return dest;
    }

    private List<Partition> convertToParts(String dbName, String tblName, List<MPartition> mparts) throws MetaException {
        ArrayList<Partition> parts = new ArrayList<Partition>(mparts.size());
        for (MPartition mp : mparts) {
            parts.add(this.convertToPart(dbName, tblName, mp));
            Deadline.checkTimeout();
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNames(String dbName, String tableName, short max) throws MetaException {
        List<String> pns = null;
        boolean success = false;
        try {
            this.openTransaction();
            LOG.debug("Executing getPartitionNames");
            pns = this.getPartitionNamesNoTxn(dbName, tableName, max);
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return pns;
    }

    private List<String> getPartitionNamesNoTxn(String dbName, String tableName, short max) {
        ArrayList<String> pns = new ArrayList<String>();
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        Query query = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where table.database.name == t1 && table.tableName == t2 order by partitionName asc");
        query.declareParameters("java.lang.String t1, java.lang.String t2");
        query.setResult("partitionName");
        if (max > 0) {
            query.setRange(0L, (long)max);
        }
        Collection names = (Collection)query.execute((Object)dbName, (Object)tableName);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            pns.add((String)i.next());
        }
        if (query != null) {
            query.closeAll();
        }
        return pns;
    }

    private Collection getPartitionPsQueryResults(String dbName, String tableName, List<String> part_vals, short max_parts, String resultsCol, QueryWrapper queryWrapper) throws MetaException, NoSuchObjectException {
        Table table = this.getTable(dbName = HiveStringUtils.normalizeIdentifier((String)dbName), tableName = HiveStringUtils.normalizeIdentifier((String)tableName));
        if (table == null) {
            throw new NoSuchObjectException(dbName + "." + tableName + " table not found");
        }
        List<FieldSchema> partCols = table.getPartitionKeys();
        int numPartKeys = partCols.size();
        if (part_vals.size() > numPartKeys) {
            throw new MetaException("Incorrect number of partition values");
        }
        partCols = partCols.subList(0, part_vals.size());
        String partNameMatcher = Warehouse.makePartName(partCols, part_vals, ".*");
        if (part_vals.size() < numPartKeys) {
            partNameMatcher = partNameMatcher + ".*";
        }
        Query query = queryWrapper.query = this.pm.newQuery(MPartition.class);
        StringBuilder queryFilter = new StringBuilder("table.database.name == dbName");
        queryFilter.append(" && table.tableName == tableName");
        queryFilter.append(" && partitionName.matches(partialRegex)");
        query.setFilter(queryFilter.toString());
        query.declareParameters("java.lang.String dbName, java.lang.String tableName, java.lang.String partialRegex");
        if (max_parts >= 0) {
            query.setRange(0L, (long)max_parts);
        }
        if (resultsCol != null && !resultsCol.isEmpty()) {
            query.setResult(resultsCol);
        }
        return (Collection)query.execute((Object)dbName, (Object)tableName, (Object)partNameMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> listPartitionsPsWithAuth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            LOG.debug("executing listPartitionNamesPsWithAuth");
            Collection parts = this.getPartitionPsQueryResults(db_name, tbl_name, part_vals, max_parts, null, queryWrapper);
            MTable mtbl = this.getMTable(db_name, tbl_name);
            for (Object o : parts) {
                Partition part = this.convertToPart((MPartition)o);
                if (null != userName && null != groupNames && "TRUE".equalsIgnoreCase(mtbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
                    String partName = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), part.getValues());
                    PrincipalPrivilegeSet partAuth = this.getPartitionPrivilegeSet(db_name, tbl_name, partName, userName, groupNames);
                    part.setPrivileges(partAuth);
                }
                partitions.add(part);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNamesPs(String dbName, String tableName, List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
        ArrayList<String> partitionNames = new ArrayList<String>();
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionNamesPs");
            Collection names = this.getPartitionPsQueryResults(dbName, tableName, part_vals, max_parts, "partitionName", queryWrapper);
            for (Object o : names) {
                partitionNames.add((String)o);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
        return partitionNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartition> listMPartitions(String dbName, String tableName, int max, QueryWrapper queryWrapper) {
        boolean success = false;
        List mparts = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listMPartitions");
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
            Query query = queryWrapper.query = this.pm.newQuery(MPartition.class, "table.tableName == t1 && table.database.name == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            query.setOrdering("partitionName ascending");
            if (max > 0) {
                query.setRange(0L, (long)max);
            }
            mparts = (List)query.execute((Object)tableName, (Object)dbName);
            LOG.debug("Done executing query for listMPartitions");
            this.pm.retrieveAll((Collection)mparts);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listMPartitions " + mparts);
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mparts;
    }

    @Override
    public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        return this.getPartitionsByNamesInternal(dbName, tblName, partNames, true, true);
    }

    protected List<Partition> getPartitionsByNamesInternal(String dbName, String tblName, final List<String> partNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<Partition>(dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPartitionsViaSqlFilter(this.dbName, this.tblName, partNames);
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getPartitionsViaOrmFilter(this.dbName, this.tblName, partNames);
            }
        }.run(false);
    }

    @Override
    public boolean getPartitionsByExpr(String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        return this.getPartitionsByExprInternal(dbName, tblName, expr, defaultPartitionName, maxParts, result, true, true);
    }

    protected boolean getPartitionsByExprInternal(String dbName, String tblName, final byte[] expr, final String defaultPartitionName, final short maxParts, List<Partition> result, boolean allowSql, boolean allowJdo) throws TException {
        assert (result != null);
        final ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree(this.expressionProxy, expr);
        final AtomicBoolean hasUnknownPartitions = new AtomicBoolean(false);
        result.addAll((Collection)new GetListHelper<Partition>(dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                List<Partition> result = null;
                if (exprTree != null) {
                    result = ObjectStore.this.directSql.getPartitionsViaSqlFilter(ctx.getTable(), exprTree, null);
                }
                if (result == null) {
                    LinkedList<String> partNames = new LinkedList<String>();
                    hasUnknownPartitions.set(ObjectStore.this.getPartitionNamesPrunedByExprNoTxn(ctx.getTable(), expr, defaultPartitionName, maxParts, partNames));
                    result = ObjectStore.this.directSql.getPartitionsViaSqlFilter(this.dbName, this.tblName, partNames);
                }
                return result;
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                List result = null;
                if (exprTree != null) {
                    result = ObjectStore.this.getPartitionsViaOrmFilter(ctx.getTable(), exprTree, maxParts, false);
                }
                if (result == null) {
                    ArrayList partNames = new ArrayList();
                    hasUnknownPartitions.set(ObjectStore.this.getPartitionNamesPrunedByExprNoTxn(ctx.getTable(), expr, defaultPartitionName, maxParts, partNames));
                    result = ObjectStore.this.getPartitionsViaOrmFilter(this.dbName, this.tblName, partNames);
                }
                return result;
            }
        }.run(true));
        return hasUnknownPartitions.get();
    }

    private boolean getPartitionNamesPrunedByExprNoTxn(Table table, byte[] expr, String defaultPartName, short maxParts, List<String> result) throws MetaException {
        result.addAll(this.getPartitionNamesNoTxn(table.getDbName(), table.getTableName(), maxParts));
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> typeInfos = new ArrayList<PrimitiveTypeInfo>();
        for (FieldSchema fs : table.getPartitionKeys()) {
            columnNames.add(fs.getName());
            typeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType()));
        }
        if (defaultPartName == null || defaultPartName.isEmpty()) {
            defaultPartName = HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        }
        return this.expressionProxy.filterPartitionsByExpr(columnNames, typeInfos, expr, defaultPartName, result);
    }

    private List<Partition> getPartitionsViaOrmFilter(Table table, ExpressionTree tree, short maxParts, boolean isValidatedFilter) throws MetaException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String jdoFilter = this.makeQueryFilterString(table.getDbName(), table, tree, params, isValidatedFilter);
        if (jdoFilter == null) {
            assert (!isValidatedFilter);
            return null;
        }
        Query query = this.pm.newQuery(MPartition.class, jdoFilter);
        if (maxParts >= 0) {
            query.setRange(0L, (long)maxParts);
        }
        String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
        query.declareParameters(parameterDeclaration);
        query.setOrdering("partitionName ascending");
        List mparts = (List)query.executeWithMap(params);
        LOG.debug("Done executing query for getPartitionsViaOrmFilter");
        this.pm.retrieveAll((Collection)mparts);
        LOG.debug("Done retrieving all objects for getPartitionsViaOrmFilter");
        List<Partition> results = this.convertToParts(mparts);
        query.closeAll();
        return results;
    }

    private List<Partition> getPartitionsViaOrmFilter(String dbName, String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return new ArrayList<Partition>();
        }
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(dbName, tblName, partNames);
        Query query = (Query)queryWithParams.getFirst();
        query.setResultClass(MPartition.class);
        query.setClass(MPartition.class);
        query.setOrdering("partitionName ascending");
        List mparts = (List)query.executeWithMap((Map)queryWithParams.getSecond());
        List<Partition> partitions = this.convertToParts(dbName, tblName, mparts);
        if (query != null) {
            query.closeAll();
        }
        return partitions;
    }

    private void dropPartitionsNoTxn(String dbName, String tblName, List<String> partNames) {
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(dbName, tblName, partNames);
        Query query = (Query)queryWithParams.getFirst();
        query.setClass(MPartition.class);
        long deleted = query.deletePersistentAll((Map)queryWithParams.getSecond());
        LOG.debug("Deleted " + deleted + " partition from store");
        query.closeAll();
    }

    private HashSet<MColumnDescriptor> detachCdsFromSdsNoTxn(String dbName, String tblName, List<String> partNames) {
        ObjectPair<Query, Map<String, String>> queryWithParams = this.getPartQueryWithParams(dbName, tblName, partNames);
        Query query = (Query)queryWithParams.getFirst();
        query.setClass(MPartition.class);
        query.setResult("sd");
        List sds = (List)query.executeWithMap((Map)queryWithParams.getSecond());
        HashSet<MColumnDescriptor> candidateCds = new HashSet<MColumnDescriptor>();
        for (MStorageDescriptor sd : sds) {
            if (sd == null || sd.getCD() == null) continue;
            candidateCds.add(sd.getCD());
            sd.setCD(null);
        }
        if (query != null) {
            query.closeAll();
        }
        return candidateCds;
    }

    private ObjectPair<Query, Map<String, String>> getPartQueryWithParams(String dbName, String tblName, List<String> partNames) {
        StringBuilder sb = new StringBuilder("table.tableName == t1 && table.database.name == t2 && (");
        int n = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<String> itr = partNames.iterator();
        while (itr.hasNext()) {
            String pn = "p" + n;
            ++n;
            String part = itr.next();
            params.put(pn, part);
            sb.append("partitionName == ").append(pn);
            sb.append(" || ");
        }
        sb.setLength(sb.length() - 4);
        sb.append(')');
        Query query = this.pm.newQuery();
        query.setFilter(sb.toString());
        LOG.debug(" JDOQL filter is " + sb.toString());
        params.put("t1", HiveStringUtils.normalizeIdentifier((String)tblName));
        params.put("t2", HiveStringUtils.normalizeIdentifier((String)dbName));
        query.declareParameters(this.makeParameterDeclarationString(params));
        return new ObjectPair((Object)query, params);
    }

    @Override
    public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        return this.getPartitionsByFilterInternal(dbName, tblName, filter, maxParts, true, true);
    }

    protected List<Partition> getPartitionsByFilterInternal(String dbName, String tblName, String filter, final short maxParts, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        final ExpressionTree tree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return (List)new GetListHelper<Partition>(dbName, tblName, allowSql, allowJdo){

            @Override
            protected List<Partition> getSqlResult(GetHelper<List<Partition>> ctx) throws MetaException {
                List<Partition> parts = ObjectStore.this.directSql.getPartitionsViaSqlFilter(ctx.getTable(), tree, maxParts < 0 ? null : Integer.valueOf(maxParts));
                if (parts == null) {
                    ctx.disableDirectSql();
                }
                return parts;
            }

            @Override
            protected List<Partition> getJdoResult(GetHelper<List<Partition>> ctx) throws MetaException, NoSuchObjectException {
                return ObjectStore.this.getPartitionsViaOrmFilter(ctx.getTable(), tree, maxParts, true);
            }
        }.run(true);
    }

    private MTable ensureGetMTable(String dbName, String tblName) throws NoSuchObjectException, MetaException {
        MTable mtable = this.getMTable(dbName, tblName);
        if (mtable == null) {
            throw new NoSuchObjectException("Specified database/table does not exist : " + dbName + "." + tblName);
        }
        return mtable;
    }

    private Table ensureGetTable(String dbName, String tblName) throws NoSuchObjectException, MetaException {
        return this.convertToTable(this.ensureGetMTable(dbName, tblName));
    }

    private String makeQueryFilterString(String dbName, MTable mtable, String filter, Map<String, Object> params) throws MetaException {
        ExpressionTree tree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return this.makeQueryFilterString(dbName, this.convertToTable(mtable), tree, params, true);
    }

    private String makeQueryFilterString(String dbName, Table table, ExpressionTree tree, Map<String, Object> params, boolean isValidatedFilter) throws MetaException {
        assert (tree != null);
        ExpressionTree.FilterBuilder queryBuilder = new ExpressionTree.FilterBuilder(isValidatedFilter);
        if (table != null) {
            queryBuilder.append("table.tableName == t1 && table.database.name == t2");
            params.put("t1", table.getTableName());
            params.put("t2", table.getDbName());
        } else {
            queryBuilder.append("database.name == dbName");
            params.put("dbName", dbName);
        }
        tree.generateJDOFilterFragment(this.getConf(), table, params, queryBuilder);
        if (queryBuilder.hasError()) {
            assert (!isValidatedFilter);
            LOG.info("JDO filter pushdown cannot be used: " + queryBuilder.getErrorMessage());
            return null;
        }
        String jdoFilter = queryBuilder.getFilter();
        LOG.debug("jdoFilter = " + jdoFilter);
        return jdoFilter;
    }

    private String makeParameterDeclarationString(Map<String, String> params) {
        StringBuilder paramDecl = new StringBuilder();
        for (String key : params.keySet()) {
            paramDecl.append(", java.lang.String " + key);
        }
        return paramDecl.toString();
    }

    private String makeParameterDeclarationStringObj(Map<String, Object> params) {
        StringBuilder paramDecl = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramDecl.append(", ");
            paramDecl.append(entry.getValue().getClass().getName());
            paramDecl.append(" ");
            paramDecl.append(entry.getKey());
        }
        return paramDecl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException {
        boolean success = false;
        Query query = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            this.openTransaction();
            LOG.debug("Executing listTableNamesByFilter");
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            String queryFilterString = this.makeQueryFilterString(dbName, null, filter, params);
            query = this.pm.newQuery(MTable.class);
            query.declareImports("import java.lang.String");
            query.setResult("tableName");
            query.setResultClass(String.class);
            if (maxTables >= 0) {
                query.setRange(0L, (long)maxTables);
            }
            LOG.debug("filter specified is " + filter + "," + " JDOQL filter is " + queryFilterString);
            for (Map.Entry entry : params.entrySet()) {
                LOG.debug("key: " + (String)entry.getKey() + " value: " + entry.getValue() + " class: " + entry.getValue().getClass().getName());
            }
            String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
            query.declareParameters(parameterDeclaration);
            query.setFilter(queryFilterString);
            Collection names = (Collection)query.executeWithMap(params);
            HashSet<String> tableNamesSet = new HashSet<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                tableNamesSet.add((String)i.next());
            }
            tableNames = new ArrayList(tableNamesSet);
            LOG.debug("Done executing query for listTableNamesByFilter");
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listTableNamesByFilter");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPartitionNamesByFilter(String dbName, String tableName, String filter, short maxParts) throws MetaException {
        boolean success = false;
        Query query = null;
        ArrayList<String> partNames = new ArrayList<String>();
        try {
            this.openTransaction();
            LOG.debug("Executing listMPartitionNamesByFilter");
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
            MTable mtable = this.getMTable(dbName, tableName);
            if (mtable == null) {
                ArrayList<String> arrayList = partNames;
                return arrayList;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String queryFilterString = this.makeQueryFilterString(dbName, mtable, filter, params);
            query = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where " + queryFilterString);
            if (maxParts >= 0) {
                query.setRange(0L, (long)maxParts);
            }
            LOG.debug("Filter specified is " + filter + "," + " JDOQL filter is " + queryFilterString);
            LOG.debug("Parms is " + params);
            String parameterDeclaration = this.makeParameterDeclarationStringObj(params);
            query.declareParameters(parameterDeclaration);
            query.setOrdering("partitionName ascending");
            query.setResult("partitionName");
            Collection names = (Collection)query.executeWithMap(params);
            partNames = new ArrayList();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                partNames.add((String)i.next());
            }
            LOG.debug("Done executing query for listMPartitionNamesByFilter");
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listMPartitionNamesByFilter");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return partNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTable(String dbname, String name, Table newTable) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            name = HiveStringUtils.normalizeIdentifier((String)name);
            dbname = HiveStringUtils.normalizeIdentifier((String)dbname);
            MTable newt = this.convertToMTable(newTable);
            if (newt == null) {
                throw new InvalidObjectException("new table is invalid");
            }
            MTable oldt = this.getMTable(dbname, name);
            if (oldt == null) {
                throw new MetaException("table " + dbname + "." + name + " doesn't exist");
            }
            oldt.setDatabase(newt.getDatabase());
            oldt.setTableName(HiveStringUtils.normalizeIdentifier((String)newt.getTableName()));
            oldt.setParameters(newt.getParameters());
            oldt.setOwner(newt.getOwner());
            this.copyMSD(newt.getSd(), oldt.getSd());
            oldt.setRetention(newt.getRetention());
            oldt.setPartitionKeys(newt.getPartitionKeys());
            oldt.setTableType(newt.getTableType());
            oldt.setLastAccessTime(newt.getLastAccessTime());
            oldt.setViewOriginalText(newt.getViewOriginalText());
            oldt.setViewExpandedText(newt.getViewExpandedText());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterIndex(String dbname, String baseTblName, String name, Index newIndex) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            name = HiveStringUtils.normalizeIdentifier((String)name);
            baseTblName = HiveStringUtils.normalizeIdentifier((String)baseTblName);
            dbname = HiveStringUtils.normalizeIdentifier((String)dbname);
            MIndex newi = this.convertToMIndex(newIndex);
            if (newi == null) {
                throw new InvalidObjectException("new index is invalid");
            }
            MIndex oldi = this.getMIndex(dbname, baseTblName, name);
            if (oldi == null) {
                throw new MetaException("index " + name + " doesn't exist");
            }
            oldi.setParameters(newi.getParameters());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    private void alterPartitionNoTxn(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidObjectException, MetaException {
        name = HiveStringUtils.normalizeIdentifier((String)name);
        dbname = HiveStringUtils.normalizeIdentifier((String)dbname);
        MPartition oldp = this.getMPartition(dbname, name, part_vals);
        MPartition newp = this.convertToMPart(newPart, false);
        if (oldp == null || newp == null) {
            throw new InvalidObjectException("partition does not exist.");
        }
        oldp.setValues(newp.getValues());
        oldp.setPartitionName(newp.getPartitionName());
        oldp.setParameters(newPart.getParameters());
        if (!TableType.VIRTUAL_VIEW.name().equals(oldp.getTable().getTableType())) {
            this.copyMSD(newp.getSd(), oldp.getSd());
        }
        if (newp.getCreateTime() != oldp.getCreateTime()) {
            oldp.setCreateTime(newp.getCreateTime());
        }
        if (newp.getLastAccessTime() != oldp.getLastAccessTime()) {
            oldp.setLastAccessTime(newp.getLastAccessTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidObjectException, MetaException {
        block6: {
            boolean success = false;
            Exception e = null;
            try {
                this.openTransaction();
                this.alterPartitionNoTxn(dbname, name, part_vals, newPart);
                success = this.commitTransaction();
            }
            catch (Exception exception) {
                e = exception;
            }
            finally {
                if (success) break block6;
                this.rollbackTransaction();
                MetaException metaException = new MetaException("The transaction for alter partition did not commit successfully.");
                if (e != null) {
                    metaException.initCause(e);
                }
                throw metaException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartitions(String dbname, String name, List<List<String>> part_vals, List<Partition> newParts) throws InvalidObjectException, MetaException {
        block7: {
            boolean success = false;
            Exception e = null;
            try {
                this.openTransaction();
                Iterator<List<String>> part_val_itr = part_vals.iterator();
                for (Partition tmpPart : newParts) {
                    List<String> tmpPartVals = part_val_itr.next();
                    this.alterPartitionNoTxn(dbname, name, tmpPartVals, tmpPart);
                }
                success = this.commitTransaction();
            }
            catch (Exception exception) {
                e = exception;
            }
            finally {
                if (success) break block7;
                this.rollbackTransaction();
                MetaException metaException = new MetaException("The transaction for alter partition did not commit successfully.");
                if (e != null) {
                    metaException.initCause(e);
                }
                throw metaException;
            }
        }
    }

    private void copyMSD(MStorageDescriptor newSd, MStorageDescriptor oldSd) {
        oldSd.setLocation(newSd.getLocation());
        MColumnDescriptor oldCD = oldSd.getCD();
        if (oldSd == null || oldSd.getCD() == null || oldSd.getCD().getCols() == null || newSd == null || newSd.getCD() == null || newSd.getCD().getCols() == null || !this.convertToFieldSchemas(newSd.getCD().getCols()).equals(this.convertToFieldSchemas(oldSd.getCD().getCols()))) {
            oldSd.setCD(newSd.getCD());
        }
        this.removeUnusedColumnDescriptor(oldCD);
        oldSd.setBucketCols(newSd.getBucketCols());
        oldSd.setCompressed(newSd.isCompressed());
        oldSd.setInputFormat(newSd.getInputFormat());
        oldSd.setOutputFormat(newSd.getOutputFormat());
        oldSd.setNumBuckets(newSd.getNumBuckets());
        oldSd.getSerDeInfo().setName(newSd.getSerDeInfo().getName());
        oldSd.getSerDeInfo().setSerializationLib(newSd.getSerDeInfo().getSerializationLib());
        oldSd.getSerDeInfo().setParameters(newSd.getSerDeInfo().getParameters());
        oldSd.setSkewedColNames(newSd.getSkewedColNames());
        oldSd.setSkewedColValues(newSd.getSkewedColValues());
        oldSd.setSkewedColValueLocationMaps(newSd.getSkewedColValueLocationMaps());
        oldSd.setSortCols(newSd.getSortCols());
        oldSd.setParameters(newSd.getParameters());
        oldSd.setStoredAsSubDirectories(newSd.isStoredAsSubDirectories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnusedColumnDescriptor(MColumnDescriptor oldCD) {
        if (oldCD == null) {
            return;
        }
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            LOG.debug("execute removeUnusedColumnDescriptor");
            List<MStorageDescriptor> referencedSDs = this.listStorageDescriptorsWithCD(oldCD, 1L, queryWrapper);
            if (referencedSDs != null && referencedSDs.isEmpty()) {
                this.pm.retrieve((Object)oldCD);
                this.pm.deletePersistent((Object)oldCD);
            }
            success = this.commitTransaction();
            LOG.debug("successfully deleted a CD in removeUnusedColumnDescriptor");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
    }

    private void preDropStorageDescriptor(MStorageDescriptor msd) {
        if (msd == null || msd.getCD() == null) {
            return;
        }
        MColumnDescriptor mcd = msd.getCD();
        msd.setCD(null);
        this.removeUnusedColumnDescriptor(mcd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MStorageDescriptor> listStorageDescriptorsWithCD(MColumnDescriptor oldCD, long maxSDs, QueryWrapper queryWrapper) {
        boolean success = false;
        List sds = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listStorageDescriptorsWithCD");
            Query query = queryWrapper.query = this.pm.newQuery(MStorageDescriptor.class, "this.cd == inCD");
            query.declareParameters("MColumnDescriptor inCD");
            if (maxSDs >= 0L) {
                query.setRange(0L, maxSDs);
            }
            sds = (List)query.execute((Object)oldCD);
            LOG.debug("Done executing query for listStorageDescriptorsWithCD");
            this.pm.retrieveAll((Collection)sds);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listStorageDescriptorsWithCD");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return sds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addIndex(Index index) throws InvalidObjectException, MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            MIndex idx = this.convertToMIndex(index);
            this.pm.makePersistent((Object)idx);
            commited = this.commitTransaction();
            boolean bl = true;
            return bl;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
                return false;
            }
        }
    }

    private MIndex convertToMIndex(Index index) throws InvalidObjectException, MetaException {
        StorageDescriptor sd = index.getSd();
        if (sd == null) {
            throw new InvalidObjectException("Storage descriptor is not defined for index.");
        }
        MStorageDescriptor msd = this.convertToMStorageDescriptor(sd);
        MTable origTable = this.getMTable(index.getDbName(), index.getOrigTableName());
        if (origTable == null) {
            throw new InvalidObjectException("Original table does not exist for the given index.");
        }
        String[] qualified = MetaStoreUtils.getQualifiedName(index.getDbName(), index.getIndexTableName());
        MTable indexTable = this.getMTable(qualified[0], qualified[1]);
        if (indexTable == null) {
            throw new InvalidObjectException("Underlying index table does not exist for the given index.");
        }
        return new MIndex(HiveStringUtils.normalizeIdentifier((String)index.getIndexName()), origTable, index.getCreateTime(), index.getLastAccessTime(), index.getParameters(), indexTable, msd, index.getIndexHandlerClass(), index.isDeferredRebuild());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropIndex(String dbName, String origTableName, String indexName) throws MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            MIndex index = this.getMIndex(dbName, origTableName, indexName);
            if (index != null) {
                this.pm.deletePersistent((Object)index);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MIndex getMIndex(String dbName, String originalTblName, String indexName) throws MetaException {
        MIndex midx = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            originalTblName = HiveStringUtils.normalizeIdentifier((String)originalTblName);
            MTable mtbl = this.getMTable(dbName, originalTblName);
            if (mtbl == null) {
                commited = this.commitTransaction();
                MIndex mIndex = null;
                return mIndex;
            }
            query = this.pm.newQuery(MIndex.class, "origTable.tableName == t1 && origTable.database.name == t2 && indexName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            midx = (MIndex)query.execute((Object)originalTblName, (Object)dbName, (Object)HiveStringUtils.normalizeIdentifier((String)indexName));
            this.pm.retrieve((Object)midx);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return midx;
    }

    @Override
    public Index getIndex(String dbName, String origTableName, String indexName) throws MetaException {
        this.openTransaction();
        MIndex mIndex = this.getMIndex(dbName, origTableName, indexName);
        Index ret = this.convertToIndex(mIndex);
        this.commitTransaction();
        return ret;
    }

    private Index convertToIndex(MIndex mIndex) throws MetaException {
        if (mIndex == null) {
            return null;
        }
        MTable origTable = mIndex.getOrigTable();
        MTable indexTable = mIndex.getIndexTable();
        return new Index(mIndex.getIndexName(), mIndex.getIndexHandlerClass(), origTable.getDatabase().getName(), origTable.getTableName(), mIndex.getCreateTime(), mIndex.getLastAccessTime(), indexTable.getTableName(), this.convertToStorageDescriptor(mIndex.getSd()), mIndex.getParameters(), mIndex.getDeferredRebuild());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(String dbName, String origTableName, int max) throws MetaException {
        boolean success = false;
        Query query = null;
        try {
            LOG.debug("Executing getIndexes");
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            origTableName = HiveStringUtils.normalizeIdentifier((String)origTableName);
            query = this.pm.newQuery(MIndex.class, "origTable.tableName == t1 && origTable.database.name == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mIndexes = (List)query.execute((Object)origTableName, (Object)dbName);
            this.pm.retrieveAll((Collection)mIndexes);
            ArrayList<Index> indexes = new ArrayList<Index>(mIndexes.size());
            for (MIndex mIdx : mIndexes) {
                indexes.add(this.convertToIndex(mIdx));
            }
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for getIndexes");
            ArrayList<Index> arrayList = indexes;
            return arrayList;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listIndexNames(String dbName, String origTableName, short max) throws MetaException {
        ArrayList<String> pns = new ArrayList<String>();
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listIndexNames");
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            origTableName = HiveStringUtils.normalizeIdentifier((String)origTableName);
            query = this.pm.newQuery("select indexName from org.apache.hadoop.hive.metastore.model.MIndex where origTable.database.name == t1 && origTable.tableName == t2 order by indexName asc");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            query.setResult("indexName");
            Collection names = (Collection)query.execute((Object)dbName, (Object)origTableName);
            Iterator i = names.iterator();
            while (i.hasNext()) {
                pns.add((String)i.next());
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return pns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRole(String roleName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            MRole nameCheck = this.getMRole(roleName);
            if (nameCheck != null) {
                throw new InvalidObjectException("Role " + roleName + " already exists.");
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            MRole mRole = new MRole(roleName, now, ownerName);
            this.pm.makePersistent((Object)mRole);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException, InvalidObjectException {
        boolean success = false;
        boolean commited = false;
        try {
            this.openTransaction();
            MRoleMap roleMap = null;
            try {
                roleMap = this.getMSecurityUserRoleMap(userName, principalType, role.getRoleName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (roleMap != null) {
                throw new InvalidObjectException("Principal " + userName + " already has the role " + role.getRoleName());
            }
            if (principalType == PrincipalType.ROLE) {
                this.validateRole(userName);
            }
            MRole mRole = this.getMRole(role.getRoleName());
            long now = System.currentTimeMillis() / 1000L;
            MRoleMap roleMember = new MRoleMap(userName, principalType.toString(), mRole, (int)now, grantor, grantorType.toString(), grantOption);
            this.pm.makePersistent((Object)roleMember);
            commited = this.commitTransaction();
            success = true;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return success;
    }

    private void validateRole(String roleName) throws NoSuchObjectException {
        MRole granteeRole = this.getMRole(roleName);
        if (granteeRole == null) {
            throw new NoSuchObjectException("Role " + roleName + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean revokeRole(Role role, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, NoSuchObjectException {
        boolean success = false;
        try {
            this.openTransaction();
            MRoleMap roleMember = this.getMSecurityUserRoleMap(userName, principalType, role.getRoleName());
            if (grantOption) {
                if (!roleMember.getGrantOption()) throw new MetaException("User " + userName + " does not have grant option with role " + role.getRoleName());
                roleMember.setGrantOption(false);
            } else {
                this.pm.deletePersistent((Object)roleMember);
            }
            success = this.commitTransaction();
            return success;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MRoleMap getMSecurityUserRoleMap(String userName, PrincipalType principalType, String roleName) {
        MRoleMap mRoleMember = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2 && role.roleName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            mRoleMember = (MRoleMap)query.executeWithArray(new Object[]{userName, principalType.toString(), roleName});
            this.pm.retrieve((Object)mRoleMember);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mRoleMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
        boolean success = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            this.openTransaction();
            MRole mRol = this.getMRole(roleName);
            this.pm.retrieve((Object)mRol);
            if (mRol != null) {
                List<MDBPrivilege> dbGrants;
                List<MRoleMap> roleMember;
                List<MRoleMap> roleMap = this.listMRoleMembers(mRol.getRoleName());
                if (roleMap.size() > 0) {
                    this.pm.deletePersistentAll(roleMap);
                }
                if ((roleMember = this.listMSecurityPrincipalMembershipRole(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper)).size() > 0) {
                    this.pm.deletePersistentAll(roleMember);
                }
                queryWrapper.close();
                List<MGlobalPrivilege> userGrants = this.listPrincipalMGlobalGrants(mRol.getRoleName(), PrincipalType.ROLE);
                if (userGrants.size() > 0) {
                    this.pm.deletePersistentAll(userGrants);
                }
                if ((dbGrants = this.listPrincipalAllDBGrant(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper)).size() > 0) {
                    this.pm.deletePersistentAll(dbGrants);
                }
                queryWrapper.close();
                List<MTablePrivilege> tabPartGrants = this.listPrincipalAllTableGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (tabPartGrants.size() > 0) {
                    this.pm.deletePersistentAll(tabPartGrants);
                }
                queryWrapper.close();
                List<MPartitionPrivilege> partGrants = this.listPrincipalAllPartitionGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (partGrants.size() > 0) {
                    this.pm.deletePersistentAll(partGrants);
                }
                queryWrapper.close();
                List<MTableColumnPrivilege> tblColumnGrants = this.listPrincipalAllTableColumnGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (tblColumnGrants.size() > 0) {
                    this.pm.deletePersistentAll(tblColumnGrants);
                }
                queryWrapper.close();
                List<MPartitionColumnPrivilege> partColumnGrants = this.listPrincipalAllPartitionColumnGrants(mRol.getRoleName(), PrincipalType.ROLE, queryWrapper);
                if (partColumnGrants.size() > 0) {
                    this.pm.deletePersistentAll(partColumnGrants);
                }
                queryWrapper.close();
                this.pm.deletePersistent((Object)mRol);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            queryWrapper.close();
        }
        return success;
    }

    private Set<String> listAllRolesInHierarchy(String userName, List<String> groupNames) {
        ArrayList<MRoleMap> ret = new ArrayList<MRoleMap>();
        if (userName != null) {
            ret.addAll(this.listMRoles(userName, PrincipalType.USER));
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ret.addAll(this.listMRoles(groupName, PrincipalType.GROUP));
            }
        }
        HashSet<String> roleNames = new HashSet<String>();
        this.getAllRoleAncestors(roleNames, ret);
        return roleNames;
    }

    private void getAllRoleAncestors(Set<String> processedRoleNames, List<MRoleMap> parentRoles) {
        for (MRoleMap parentRole : parentRoles) {
            String parentRoleName = parentRole.getRole().getRoleName();
            if (processedRoleNames.contains(parentRoleName)) continue;
            List<MRoleMap> nextParentRoles = this.listMRoles(parentRoleName, PrincipalType.ROLE);
            processedRoleNames.add(parentRoleName);
            this.getAllRoleAncestors(processedRoleNames, nextParentRoles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MRoleMap> listMRoles(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        ArrayList<MRoleMap> mRoleMember = new ArrayList<MRoleMap>();
        try {
            LOG.debug("Executing listRoles");
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            query.setUnique(false);
            List mRoles = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
            this.pm.retrieveAll((Collection)mRoles);
            success = this.commitTransaction();
            mRoleMember.addAll(mRoles);
            LOG.debug("Done retrieving all objects for listRoles");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        if (principalType == PrincipalType.USER) {
            MRole publicRole = new MRole("public", 0, "public");
            mRoleMember.add(new MRoleMap(principalName, principalType.toString(), publicRole, 0, null, null, false));
        }
        return mRoleMember;
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        ArrayList<Role> result = new ArrayList<Role>();
        List<MRoleMap> roleMaps = this.listMRoles(principalName, principalType);
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                MRole mrole = roleMap.getRole();
                Role role = new Role(mrole.getRoleName(), mrole.getCreateTime(), mrole.getOwnerName());
                result.add(role);
            }
        }
        return result;
    }

    @Override
    public List<RolePrincipalGrant> listRolesWithGrants(String principalName, PrincipalType principalType) {
        ArrayList<RolePrincipalGrant> result = new ArrayList<RolePrincipalGrant>();
        List<MRoleMap> roleMaps = this.listMRoles(principalName, principalType);
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                RolePrincipalGrant rolePrinGrant = new RolePrincipalGrant(roleMap.getRole().getRoleName(), roleMap.getPrincipalName(), PrincipalType.valueOf(roleMap.getPrincipalType()), roleMap.getGrantOption(), roleMap.getAddTime(), roleMap.getGrantor(), roleMap.getGrantorType() == null ? null : PrincipalType.valueOf(roleMap.getGrantorType()));
                result.add(rolePrinGrant);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MRoleMap> listMSecurityPrincipalMembershipRole(String roleName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mRoleMemebership = null;
        try {
            LOG.debug("Executing listMSecurityPrincipalMembershipRole");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MRoleMap.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mRoleMemebership = (List)query.execute((Object)roleName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mRoleMemebership);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listMSecurityPrincipalMembershipRole");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mRoleMemebership;
    }

    @Override
    public Role getRole(String roleName) throws NoSuchObjectException {
        MRole mRole = this.getMRole(roleName);
        if (mRole == null) {
            throw new NoSuchObjectException(roleName + " role can not be found.");
        }
        Role ret = new Role(mRole.getRoleName(), mRole.getCreateTime(), mRole.getOwnerName());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MRole getMRole(String roleName) {
        MRole mrole = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MRole.class, "roleName == t1");
            query.declareParameters("java.lang.String t1");
            query.setUnique(true);
            mrole = (MRole)query.execute((Object)roleName);
            this.pm.retrieve((Object)mrole);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mrole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listRoleNames() {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listAllRoleNames");
            query = this.pm.newQuery("select roleName from org.apache.hadoop.hive.metastore.model.MRole");
            query.setResult("roleName");
            Collection names = (Collection)query.execute();
            ArrayList<String> roleNames = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                roleNames.add((String)i.next());
            }
            success = this.commitTransaction();
            ArrayList<String> arrayList = roleNames;
            return arrayList;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            List<MGlobalPrivilege> user;
            this.openTransaction();
            if (userName != null && (user = this.listPrincipalMGlobalGrants(userName, PrincipalType.USER)).size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> userPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(user.size());
                for (int i = 0; i < user.size(); ++i) {
                    MGlobalPrivilege item = user.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                userPriv.put(userName, grantInfos);
                ret.setUserPrivileges(userPriv);
            }
            if (groupNames != null && groupNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> groupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    List<MGlobalPrivilege> group = this.listPrincipalMGlobalGrants(groupName, PrincipalType.GROUP);
                    if (group.size() <= 0) continue;
                    ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(group.size());
                    for (int i = 0; i < group.size(); ++i) {
                        MGlobalPrivilege item = group.get(i);
                        grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                    }
                    groupPriv.put(groupName, grantInfos);
                }
                ret.setGroupPrivileges(groupPriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    public List<PrivilegeGrantInfo> getDBPrivilege(String dbName, String principalName, PrincipalType principalType) throws InvalidObjectException, MetaException {
        List<MDBPrivilege> userNameDbPriv;
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        if (principalName != null && (userNameDbPriv = this.listPrincipalMDBGrants(principalName, principalType, dbName)) != null && userNameDbPriv.size() > 0) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameDbPriv.size());
            for (int i = 0; i < userNameDbPriv.size(); ++i) {
                MDBPrivilege item = userNameDbPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getDBPrivilegeSet(String dbName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> dbUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                dbUserPriv.put(userName, this.getDBPrivilege(dbName, userName, PrincipalType.USER));
                ret.setUserPrivileges(dbUserPriv);
            }
            if (groupNames != null && groupNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> dbGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    dbGroupPriv.put(groupName, this.getDBPrivilege(dbName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(dbGroupPriv);
            }
            if ((roleNames = this.listAllRolesInHierarchy(userName, groupNames)) != null && roleNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> dbRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    dbRolePriv.put(roleName, this.getDBPrivilege(dbName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(dbRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String dbName, String tableName, String partition, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> partUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                partUserPriv.put(userName, this.getPartitionPrivilege(dbName, tableName, partition, userName, PrincipalType.USER));
                ret.setUserPrivileges(partUserPriv);
            }
            if (groupNames != null && groupNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> partGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    partGroupPriv.put(groupName, this.getPartitionPrivilege(dbName, tableName, partition, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(partGroupPriv);
            }
            if ((roleNames = this.listAllRolesInHierarchy(userName, groupNames)) != null && roleNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> partRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    partRolePriv.put(roleName, this.getPartitionPrivilege(dbName, tableName, partition, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(partRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getTablePrivilegeSet(String dbName, String tableName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> tableUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                tableUserPriv.put(userName, this.getTablePrivilege(dbName, tableName, userName, PrincipalType.USER));
                ret.setUserPrivileges(tableUserPriv);
            }
            if (groupNames != null && groupNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> tableGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    tableGroupPriv.put(groupName, this.getTablePrivilege(dbName, tableName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(tableGroupPriv);
            }
            if ((roleNames = this.listAllRolesInHierarchy(userName, groupNames)) != null && roleNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> tableRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    tableRolePriv.put(roleName, this.getTablePrivilege(dbName, tableName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(tableRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalPrivilegeSet getColumnPrivilegeSet(String dbName, String tableName, String partitionName, String columnName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        columnName = HiveStringUtils.normalizeIdentifier((String)columnName);
        boolean commited = false;
        PrincipalPrivilegeSet ret = new PrincipalPrivilegeSet();
        try {
            Set<String> roleNames;
            this.openTransaction();
            if (userName != null) {
                HashMap<String, List<PrivilegeGrantInfo>> columnUserPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                columnUserPriv.put(userName, this.getColumnPrivilege(dbName, tableName, columnName, partitionName, userName, PrincipalType.USER));
                ret.setUserPrivileges(columnUserPriv);
            }
            if (groupNames != null && groupNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> columnGroupPriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String groupName : groupNames) {
                    columnGroupPriv.put(groupName, this.getColumnPrivilege(dbName, tableName, columnName, partitionName, groupName, PrincipalType.GROUP));
                }
                ret.setGroupPrivileges(columnGroupPriv);
            }
            if ((roleNames = this.listAllRolesInHierarchy(userName, groupNames)) != null && roleNames.size() > 0) {
                HashMap<String, List<PrivilegeGrantInfo>> columnRolePriv = new HashMap<String, List<PrivilegeGrantInfo>>();
                for (String roleName : roleNames) {
                    columnRolePriv.put(roleName, this.getColumnPrivilege(dbName, tableName, columnName, partitionName, roleName, PrincipalType.ROLE));
                }
                ret.setRolePrivileges(columnRolePriv);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return ret;
    }

    private List<PrivilegeGrantInfo> getPartitionPrivilege(String dbName, String tableName, String partName, String principalName, PrincipalType principalType) {
        List<MPartitionPrivilege> userNameTabPartPriv;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        if (principalName != null && (userNameTabPartPriv = this.listPrincipalMPartitionGrants(principalName, principalType, dbName, tableName, partName)) != null && userNameTabPartPriv.size() > 0) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameTabPartPriv.size());
            for (int i = 0; i < userNameTabPartPriv.size(); ++i) {
                MPartitionPrivilege item = userNameTabPartPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    private PrincipalType getPrincipalTypeFromStr(String str) {
        return str == null ? null : PrincipalType.valueOf(str);
    }

    private List<PrivilegeGrantInfo> getTablePrivilege(String dbName, String tableName, String principalName, PrincipalType principalType) {
        List<MTablePrivilege> userNameTabPartPriv;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        if (principalName != null && (userNameTabPartPriv = this.listAllMTableGrants(principalName, principalType, dbName, tableName)) != null && userNameTabPartPriv.size() > 0) {
            ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameTabPartPriv.size());
            for (int i = 0; i < userNameTabPartPriv.size(); ++i) {
                MTablePrivilege item = userNameTabPartPriv.get(i);
                grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
            }
            return grantInfos;
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    private List<PrivilegeGrantInfo> getColumnPrivilege(String dbName, String tableName, String columnName, String partitionName, String principalName, PrincipalType principalType) {
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        columnName = HiveStringUtils.normalizeIdentifier((String)columnName);
        if (partitionName == null) {
            List<MTableColumnPrivilege> userNameColumnPriv = this.listPrincipalMTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
            if (userNameColumnPriv != null && userNameColumnPriv.size() > 0) {
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameColumnPriv.size());
                for (int i = 0; i < userNameColumnPriv.size(); ++i) {
                    MTableColumnPrivilege item = userNameColumnPriv.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                return grantInfos;
            }
        } else {
            List<MPartitionColumnPrivilege> userNameColumnPriv = this.listPrincipalMPartitionColumnGrants(principalName, principalType, dbName, tableName, partitionName, columnName);
            if (userNameColumnPriv != null && userNameColumnPriv.size() > 0) {
                ArrayList<PrivilegeGrantInfo> grantInfos = new ArrayList<PrivilegeGrantInfo>(userNameColumnPriv.size());
                for (int i = 0; i < userNameColumnPriv.size(); ++i) {
                    MPartitionColumnPrivilege item = userNameColumnPriv.get(i);
                    grantInfos.add(new PrivilegeGrantInfo(item.getPrivilege(), item.getCreateTime(), item.getGrantor(), this.getPrincipalTypeFromStr(item.getGrantorType()), item.getGrantOption()));
                }
                return grantInfos;
            }
        }
        return new ArrayList<PrivilegeGrantInfo>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean committed = false;
        int now = (int)(System.currentTimeMillis() / 1000L);
        try {
            this.openTransaction();
            ArrayList<Object> persistentObjs = new ArrayList<Object>();
            List<HiveObjectPrivilege> privilegeList = privileges.getPrivileges();
            if (privilegeList != null && privilegeList.size() > 0) {
                Iterator<HiveObjectPrivilege> privIter = privilegeList.iterator();
                HashSet<String> privSet = new HashSet<String>();
                while (privIter.hasNext()) {
                    String privilege;
                    int i$;
                    MTable tblObj;
                    int i$2;
                    HiveObjectPrivilege privDef = privIter.next();
                    HiveObjectRef hiveObject = privDef.getHiveObject();
                    String privilegeStr = privDef.getGrantInfo().getPrivilege();
                    String[] privs = privilegeStr.split(",");
                    String userName = privDef.getPrincipalName();
                    PrincipalType principalType = privDef.getPrincipalType();
                    String grantor = privDef.getGrantInfo().getGrantor();
                    String grantorType = privDef.getGrantInfo().getGrantorType().toString();
                    boolean grantOption = privDef.getGrantInfo().isGrantOption();
                    privSet.clear();
                    if (principalType == PrincipalType.ROLE) {
                        this.validateRole(userName);
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                        List<MGlobalPrivilege> globalPrivs = this.listPrincipalMGlobalGrants(userName, principalType);
                        if (globalPrivs != null) {
                            for (MGlobalPrivilege priv : globalPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        for (String privilege2 : privs) {
                            if (privSet.contains(privilege2)) {
                                throw new InvalidObjectException(privilege2 + " is already granted by " + grantor);
                            }
                            MGlobalPrivilege mGlobalPrivs = new MGlobalPrivilege(userName, principalType.toString(), privilege2, now, grantor, grantorType, grantOption);
                            persistentObjs.add(mGlobalPrivs);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                        MDatabase dbObj = this.getMDatabase(hiveObject.getDbName());
                        if (dbObj == null) continue;
                        List<MDBPrivilege> dbPrivs = this.listPrincipalMDBGrants(userName, principalType, hiveObject.getDbName());
                        if (dbPrivs != null) {
                            for (MDBPrivilege priv : dbPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] arr$ = privs;
                        int len$ = arr$.length;
                        for (i$2 = 0; i$2 < len$; ++i$2) {
                            String privilege3 = arr$[i$2];
                            if (privSet.contains(privilege3)) {
                                throw new InvalidObjectException(privilege3 + " is already granted on database " + hiveObject.getDbName() + " by " + grantor);
                            }
                            MDBPrivilege mDb = new MDBPrivilege(userName, principalType.toString(), dbObj, privilege3, now, grantor, grantorType, grantOption);
                            persistentObjs.add(mDb);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                        tblObj = this.getMTable(hiveObject.getDbName(), hiveObject.getObjectName());
                        if (tblObj == null) continue;
                        List<MTablePrivilege> tablePrivs = this.listAllMTableGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
                        if (tablePrivs != null) {
                            for (MTablePrivilege priv : tablePrivs) {
                                if (priv.getGrantor() == null || !priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] arr$ = privs;
                        int len$ = arr$.length;
                        for (i$2 = 0; i$2 < len$; ++i$2) {
                            String privilege4 = arr$[i$2];
                            if (privSet.contains(privilege4)) {
                                throw new InvalidObjectException(privilege4 + " is already granted on table [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "] by " + grantor);
                            }
                            MTablePrivilege mTab = new MTablePrivilege(userName, principalType.toString(), tblObj, privilege4, now, grantor, grantorType, grantOption);
                            persistentObjs.add(mTab);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                        MPartition partObj = this.getMPartition(hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
                        String partName = null;
                        if (partObj == null) continue;
                        partName = partObj.getPartitionName();
                        List<MPartitionPrivilege> partPrivs = this.listPrincipalMPartitionGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), partObj.getPartitionName());
                        if (partPrivs != null) {
                            for (MPartitionPrivilege priv : partPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] arr$ = privs;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            privilege = arr$[i$];
                            if (privSet.contains(privilege)) {
                                throw new InvalidObjectException(privilege + " is already granted on partition [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "," + partName + "] by " + grantor);
                            }
                            MPartitionPrivilege mTab = new MPartitionPrivilege(userName, principalType.toString(), partObj, privilege, now, grantor, grantorType, grantOption);
                            persistentObjs.add(mTab);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() != HiveObjectType.COLUMN || (tblObj = this.getMTable(hiveObject.getDbName(), hiveObject.getObjectName())) == null) continue;
                    if (hiveObject.getPartValues() != null) {
                        MPartition partObj = null;
                        List<MPartitionColumnPrivilege> colPrivs = null;
                        partObj = this.getMPartition(hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
                        if (partObj == null) continue;
                        colPrivs = this.listPrincipalMPartitionColumnGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), partObj.getPartitionName(), hiveObject.getColumnName());
                        if (colPrivs != null) {
                            for (MPartitionColumnPrivilege priv : colPrivs) {
                                if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                                privSet.add(priv.getPrivilege());
                            }
                        }
                        String[] arr$ = privs;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            privilege = arr$[i$];
                            if (privSet.contains(privilege)) {
                                throw new InvalidObjectException(privilege + " is already granted on column " + hiveObject.getColumnName() + " [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "," + partObj.getPartitionName() + "] by " + grantor);
                            }
                            MPartitionColumnPrivilege mCol = new MPartitionColumnPrivilege(userName, principalType.toString(), partObj, hiveObject.getColumnName(), privilege, now, grantor, grantorType, grantOption);
                            persistentObjs.add(mCol);
                        }
                        continue;
                    }
                    List<MTableColumnPrivilege> colPrivs = null;
                    colPrivs = this.listPrincipalMTableColumnGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
                    if (colPrivs != null) {
                        for (MTableColumnPrivilege priv : colPrivs) {
                            if (!priv.getGrantor().equalsIgnoreCase(grantor)) continue;
                            privSet.add(priv.getPrivilege());
                        }
                    }
                    String[] arr$ = privs;
                    int len$ = arr$.length;
                    for (i$2 = 0; i$2 < len$; ++i$2) {
                        String privilege5 = arr$[i$2];
                        if (privSet.contains(privilege5)) {
                            throw new InvalidObjectException(privilege5 + " is already granted on column " + hiveObject.getColumnName() + " [" + hiveObject.getDbName() + "," + hiveObject.getObjectName() + "] by " + grantor);
                        }
                        MTableColumnPrivilege mCol = new MTableColumnPrivilege(userName, principalType.toString(), tblObj, hiveObject.getColumnName(), privilege5, now, grantor, grantorType, grantOption);
                        persistentObjs.add(mCol);
                    }
                }
            }
            if (persistentObjs.size() > 0) {
                this.pm.makePersistentAll(persistentObjs);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean committed = false;
        try {
            this.openTransaction();
            ArrayList<Object> persistentObjs = new ArrayList<Object>();
            List<HiveObjectPrivilege> privilegeList = privileges.getPrivileges();
            if (privilegeList != null && privilegeList.size() > 0) {
                for (HiveObjectPrivilege privDef : privilegeList) {
                    String colPriv;
                    List<Object> mSecCol;
                    HiveObjectRef hiveObject = privDef.getHiveObject();
                    String privilegeStr = privDef.getGrantInfo().getPrivilege();
                    if (privilegeStr == null || privilegeStr.trim().equals("")) continue;
                    String[] privs = privilegeStr.split(",");
                    String userName = privDef.getPrincipalName();
                    PrincipalType principalType = privDef.getPrincipalType();
                    if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                        List<MGlobalPrivilege> mSecUser = this.listPrincipalMGlobalGrants(userName, principalType);
                        boolean found = false;
                        if (mSecUser == null) continue;
                        for (String privilege : privs) {
                            for (MGlobalPrivilege userGrant : mSecUser) {
                                String userGrantPrivs = userGrant.getPrivilege();
                                if (!privilege.equals(userGrantPrivs)) continue;
                                found = true;
                                if (grantOption) {
                                    if (userGrant.getGrantOption()) {
                                        userGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(userGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No user grant found for privileges " + privilege);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                        MDatabase dbObj = this.getMDatabase(hiveObject.getDbName());
                        if (dbObj == null) continue;
                        String db = hiveObject.getDbName();
                        boolean found = false;
                        List<MDBPrivilege> dbGrants = this.listPrincipalMDBGrants(userName, principalType, db);
                        for (String privilege : privs) {
                            for (MDBPrivilege dbGrant : dbGrants) {
                                String dbGrantPriv = dbGrant.getPrivilege();
                                if (!privilege.equals(dbGrantPriv)) continue;
                                found = true;
                                if (grantOption) {
                                    if (dbGrant.getGrantOption()) {
                                        dbGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(dbGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No database grant found for privileges " + privilege + " on database " + db);
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                        boolean found = false;
                        List<MTablePrivilege> tableGrants = this.listAllMTableGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
                        for (String privilege : privs) {
                            for (MTablePrivilege tabGrant : tableGrants) {
                                String tableGrantPriv = tabGrant.getPrivilege();
                                if (!privilege.equalsIgnoreCase(tableGrantPriv)) continue;
                                found = true;
                                if (grantOption) {
                                    if (tabGrant.getGrantOption()) {
                                        tabGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(tabGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege + ") found " + " on table " + hiveObject.getObjectName() + ", database is " + hiveObject.getDbName());
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                        boolean found = false;
                        Table tabObj = this.getTable(hiveObject.getDbName(), hiveObject.getObjectName());
                        String partName = null;
                        if (hiveObject.getPartValues() != null) {
                            partName = Warehouse.makePartName(tabObj.getPartitionKeys(), hiveObject.getPartValues());
                        }
                        List<MPartitionPrivilege> partitionGrants = this.listPrincipalMPartitionGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), partName);
                        for (String privilege : privs) {
                            for (MPartitionPrivilege partGrant : partitionGrants) {
                                String partPriv = partGrant.getPrivilege();
                                if (!partPriv.equalsIgnoreCase(privilege)) continue;
                                found = true;
                                if (grantOption) {
                                    if (partGrant.getGrantOption()) {
                                        partGrant.setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(partGrant);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege + ") found " + " on table " + tabObj.getTableName() + ", partition is " + partName + ", database is " + tabObj.getDbName());
                        }
                        continue;
                    }
                    if (hiveObject.getObjectType() != HiveObjectType.COLUMN) continue;
                    Table tabObj = this.getTable(hiveObject.getDbName(), hiveObject.getObjectName());
                    String partName = null;
                    if (hiveObject.getPartValues() != null) {
                        partName = Warehouse.makePartName(tabObj.getPartitionKeys(), hiveObject.getPartValues());
                    }
                    if (partName != null) {
                        mSecCol = this.listPrincipalMPartitionColumnGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName());
                        boolean found = false;
                        if (mSecCol == null) continue;
                        for (String privilege : privs) {
                            for (Object col : mSecCol) {
                                colPriv = ((MPartitionColumnPrivilege)col).getPrivilege();
                                if (!colPriv.equalsIgnoreCase(privilege)) continue;
                                found = true;
                                if (grantOption) {
                                    if (((MPartitionColumnPrivilege)col).getGrantOption()) {
                                        ((MPartitionColumnPrivilege)col).setGrantOption(false);
                                    } else {
                                        throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                    }
                                }
                                persistentObjs.add(col);
                                break;
                            }
                            if (found) continue;
                            throw new InvalidObjectException("No grant (" + privilege + ") found " + " on table " + tabObj.getTableName() + ", partition is " + partName + ", column name = " + hiveObject.getColumnName() + ", database is " + tabObj.getDbName());
                        }
                        continue;
                    }
                    mSecCol = this.listPrincipalMTableColumnGrants(userName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
                    boolean found = false;
                    if (mSecCol == null) continue;
                    for (String privilege : privs) {
                        for (Object col : mSecCol) {
                            colPriv = ((MTableColumnPrivilege)col).getPrivilege();
                            if (!colPriv.equalsIgnoreCase(privilege)) continue;
                            found = true;
                            if (grantOption) {
                                if (((MTableColumnPrivilege)col).getGrantOption()) {
                                    ((MTableColumnPrivilege)col).setGrantOption(false);
                                } else {
                                    throw new MetaException("User " + userName + " does not have grant option with privilege " + privilege);
                                }
                            }
                            persistentObjs.add(col);
                            break;
                        }
                        if (found) continue;
                        throw new InvalidObjectException("No grant (" + privilege + ") found " + " on table " + tabObj.getTableName() + ", column name = " + hiveObject.getColumnName() + ", database is " + tabObj.getDbName());
                    }
                }
            }
            if (persistentObjs.size() > 0 && !grantOption) {
                this.pm.deletePersistentAll(persistentObjs);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MRoleMap> listMRoleMembers(String roleName) {
        boolean success = false;
        Query query = null;
        ArrayList<MRoleMap> mRoleMemeberList = new ArrayList<MRoleMap>();
        try {
            LOG.debug("Executing listRoleMembers");
            this.openTransaction();
            query = this.pm.newQuery(MRoleMap.class, "role.roleName == t1");
            query.declareParameters("java.lang.String t1");
            query.setUnique(false);
            List mRoles = (List)query.execute((Object)roleName);
            this.pm.retrieveAll((Collection)mRoles);
            success = this.commitTransaction();
            mRoleMemeberList.addAll(mRoles);
            LOG.debug("Done retrieving all objects for listRoleMembers");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mRoleMemeberList;
    }

    @Override
    public List<RolePrincipalGrant> listRoleMembers(String roleName) {
        List<MRoleMap> roleMaps = this.listMRoleMembers(roleName);
        ArrayList<RolePrincipalGrant> rolePrinGrantList = new ArrayList<RolePrincipalGrant>();
        if (roleMaps != null) {
            for (MRoleMap roleMap : roleMaps) {
                RolePrincipalGrant rolePrinGrant = new RolePrincipalGrant(roleMap.getRole().getRoleName(), roleMap.getPrincipalName(), PrincipalType.valueOf(roleMap.getPrincipalType()), roleMap.getGrantOption(), roleMap.getAddTime(), roleMap.getGrantor(), roleMap.getGrantorType() == null ? null : PrincipalType.valueOf(roleMap.getGrantorType()));
                rolePrinGrantList.add(rolePrinGrant);
            }
        }
        return rolePrinGrantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MGlobalPrivilege> listPrincipalMGlobalGrants(String principalName, PrincipalType principalType) {
        boolean commited = false;
        Query query = null;
        ArrayList<MGlobalPrivilege> userNameDbPriv = new ArrayList<MGlobalPrivilege>();
        try {
            List mPrivs = null;
            this.openTransaction();
            if (principalName != null) {
                query = this.pm.newQuery(MGlobalPrivilege.class, "principalName == t1 && principalType == t2 ");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
                this.pm.retrieveAll((Collection)mPrivs);
            }
            commited = this.commitTransaction();
            if (mPrivs != null) {
                userNameDbPriv.addAll(mPrivs);
            }
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return userNameDbPriv;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName, PrincipalType principalType) {
        List<MGlobalPrivilege> mUsers = this.listPrincipalMGlobalGrants(principalName, principalType);
        if (mUsers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mUsers.size(); ++i) {
            MGlobalPrivilege sUsr = mUsers.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
            HiveObjectPrivilege secUser = new HiveObjectPrivilege(objectRef, sUsr.getPrincipalName(), principalType, new PrivilegeGrantInfo(sUsr.getPrivilege(), sUsr.getCreateTime(), sUsr.getGrantor(), PrincipalType.valueOf(sUsr.getGrantorType()), sUsr.getGrantOption()));
            result.add(secUser);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MGlobalPrivilege.class);
            List userNameDbPriv = (List)query.execute();
            this.pm.retrieveAll((Collection)userNameDbPriv);
            commited = this.commitTransaction();
            List<HiveObjectPrivilege> list = this.convertGlobal(userNameDbPriv);
            return list;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<HiveObjectPrivilege> convertGlobal(List<MGlobalPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MGlobalPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MDBPrivilege> listPrincipalMDBGrants(String principalName, PrincipalType principalType, String dbName) {
        boolean success = false;
        Query query = null;
        ArrayList<MDBPrivilege> mSecurityDBList = new ArrayList<MDBPrivilege>();
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        try {
            LOG.debug("Executing listPrincipalDBGrants");
            this.openTransaction();
            query = this.pm.newQuery(MDBPrivilege.class, "principalName == t1 && principalType == t2 && database.name == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            List mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), dbName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityDBList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalDBGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityDBList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName, PrincipalType principalType, String dbName) {
        List<MDBPrivilege> mDbs = this.listPrincipalMDBGrants(principalName, principalType, dbName);
        if (mDbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mDbs.size(); ++i) {
            MDBPrivilege sDB = mDbs.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sDB.getPrincipalName(), principalType, new PrivilegeGrantInfo(sDB.getPrivilege(), sDB.getCreateTime(), sDB.getGrantor(), PrincipalType.valueOf(sDB.getGrantorType()), sDB.getGrantOption()));
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName, PrincipalType principalType) {
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<HiveObjectPrivilege> list = this.convertDB(this.listPrincipalAllDBGrant(principalName, principalType, queryWrapper));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listDBGrantsAll(String dbName) {
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<HiveObjectPrivilege> list = this.convertDB(this.listDatabaseGrants(dbName, queryWrapper));
            return list;
        }
    }

    private List<HiveObjectPrivilege> convertDB(List<MDBPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MDBPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            String database = priv.getDatabase().getName();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, database, null, null, null);
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MDBPrivilege> listPrincipalAllDBGrant(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        Query query = null;
        List mSecurityDBList = null;
        try {
            LOG.debug("Executing listPrincipalAllDBGrant");
            this.openTransaction();
            if (principalName != null && principalType != null) {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityDBList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class);
                mSecurityDBList = (List)query.execute();
            }
            this.pm.retrieveAll((Collection)mSecurityDBList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllDBGrant");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityDBList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTablePrivilege> listAllTableGrants(String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        ArrayList<MTablePrivilege> mSecurityTabList = new ArrayList<MTablePrivilege>();
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        try {
            LOG.debug("Executing listAllTableGrants");
            this.openTransaction();
            String queryStr = "table.tableName == t1 && table.database.name == t2";
            query = this.pm.newQuery(MTablePrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName});
            LOG.debug("Done executing query for listAllTableGrants");
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listAllTableGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityTabList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MPartitionPrivilege> listTableAllPartitionGrants(String dbName, String tableName) {
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        boolean success = false;
        Query query = null;
        ArrayList<MPartitionPrivilege> mSecurityTabPartList = new ArrayList<MPartitionPrivilege>();
        try {
            LOG.debug("Executing listTableAllPartitionGrants");
            this.openTransaction();
            String queryStr = "partition.table.tableName == t1 && partition.table.database.name == t2";
            query = this.pm.newQuery(MPartitionPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityTabPartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTableColumnPrivilege> listTableAllColumnGrants(String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        ArrayList<MTableColumnPrivilege> mTblColPrivilegeList = new ArrayList<MTableColumnPrivilege>();
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        try {
            LOG.debug("Executing listTableAllColumnGrants");
            this.openTransaction();
            String queryStr = "table.tableName == t1 && table.database.name == t2";
            query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mTblColPrivilegeList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mTblColPrivilegeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MPartitionColumnPrivilege> listTableAllPartitionColumnGrants(String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        ArrayList<MPartitionColumnPrivilege> mSecurityColList = new ArrayList<MPartitionColumnPrivilege>();
        try {
            LOG.debug("Executing listTableAllPartitionColumnGrants");
            this.openTransaction();
            String queryStr = "partition.table.tableName == t1 && partition.table.database.name == t2";
            query = this.pm.newQuery(MPartitionColumnPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mPrivs = (List)query.executeWithArray(new Object[]{tableName, dbName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listTableAllPartitionColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityColList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MPartitionColumnPrivilege> listPartitionAllColumnGrants(String dbName, String tableName, List<String> partNames) {
        boolean success = false;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        List<MPartitionColumnPrivilege> mSecurityColList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionAllColumnGrants");
            mSecurityColList = this.queryByPartitionNames(dbName, tableName, partNames, MPartitionColumnPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName");
            LOG.debug("Done executing query for listPartitionAllColumnGrants");
            this.pm.retrieveAll(mSecurityColList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionAllColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColList;
    }

    public void dropPartitionAllColumnGrantsNoTxn(String dbName, String tableName, List<String> partNames) {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(dbName, tableName, partNames, MPartitionColumnPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName");
        ((Query)queryWithParams.getFirst()).deletePersistentAll((Object[])queryWithParams.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MDBPrivilege> listDatabaseGrants(String dbName, QueryWrapper queryWrapper) {
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        boolean success = false;
        try {
            LOG.debug("Executing listDatabaseGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MDBPrivilege.class, "database.name == t1");
            query.declareParameters("java.lang.String t1");
            List mSecurityDBList = (List)query.executeWithArray(new Object[]{dbName});
            this.pm.retrieveAll((Collection)mSecurityDBList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listDatabaseGrants");
            List list = mSecurityDBList;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listPartitionGrants(String dbName, String tableName, List<String> partNames) {
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        boolean success = false;
        List<MPartitionPrivilege> mSecurityTabPartList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionGrants");
            mSecurityTabPartList = this.queryByPartitionNames(dbName, tableName, partNames, MPartitionPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName");
            LOG.debug("Done executing query for listPartitionGrants");
            this.pm.retrieveAll(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    private void dropPartitionGrantsNoTxn(String dbName, String tableName, List<String> partNames) {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(dbName, tableName, partNames, MPartitionPrivilege.class, "partition.table.tableName", "partition.table.database.name", "partition.partitionName");
        ((Query)queryWithParams.getFirst()).deletePersistentAll((Object[])queryWithParams.getSecond());
    }

    private <T> List<T> queryByPartitionNames(String dbName, String tableName, List<String> partNames, Class<T> clazz, String tbCol, String dbCol, String partCol) {
        ObjectPair<Query, Object[]> queryAndParams = this.makeQueryByPartitionNames(dbName, tableName, partNames, clazz, tbCol, dbCol, partCol);
        return (List)((Query)queryAndParams.getFirst()).executeWithArray((Object[])queryAndParams.getSecond());
    }

    private ObjectPair<Query, Object[]> makeQueryByPartitionNames(String dbName, String tableName, List<String> partNames, Class<?> clazz, String tbCol, String dbCol, String partCol) {
        String queryStr = tbCol + " == t1 && " + dbCol + " == t2";
        String paramStr = "java.lang.String t1, java.lang.String t2";
        Object[] params = new Object[2 + partNames.size()];
        params[0] = HiveStringUtils.normalizeIdentifier((String)tableName);
        params[1] = HiveStringUtils.normalizeIdentifier((String)dbName);
        int index = 0;
        for (String partName : partNames) {
            params[index + 2] = partName;
            queryStr = queryStr + (index == 0 ? " && (" : " || ") + partCol + " == p" + index;
            paramStr = paramStr + ", java.lang.String p" + index;
            ++index;
        }
        queryStr = queryStr + ")";
        Query query = this.pm.newQuery(clazz, queryStr);
        query.declareParameters(paramStr);
        return new ObjectPair((Object)query, (Object)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTablePrivilege> listAllMTableGrants(String principalName, PrincipalType principalType, String dbName, String tableName) {
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        boolean success = false;
        Query query = null;
        ArrayList<MTablePrivilege> mSecurityTabPartList = new ArrayList<MTablePrivilege>();
        try {
            this.openTransaction();
            LOG.debug("Executing listAllTableGrants");
            query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2 && table.tableName == t3 && table.database.name == t4");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4");
            List mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listAllTableGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityTabPartList;
    }

    @Override
    public List<HiveObjectPrivilege> listAllTableGrants(String principalName, PrincipalType principalType, String dbName, String tableName) {
        List<MTablePrivilege> mTbls = this.listAllMTableGrants(principalName, principalType, dbName, tableName);
        if (mTbls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mTbls.size(); ++i) {
            MTablePrivilege sTbl = mTbls.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sTbl.getPrincipalName(), principalType, new PrivilegeGrantInfo(sTbl.getPrivilege(), sTbl.getCreateTime(), sTbl.getGrantor(), PrincipalType.valueOf(sTbl.getGrantorType()), sTbl.getGrantOption()));
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MPartitionPrivilege> listPrincipalMPartitionGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String partName) {
        boolean success = false;
        Query query = null;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        ArrayList<MPartitionPrivilege> mSecurityTabPartList = new ArrayList<MPartitionPrivilege>();
        try {
            LOG.debug("Executing listPrincipalPartitionGrants");
            this.openTransaction();
            query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.partitionName == t5");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5");
            List mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, partName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityTabPartList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityTabPartList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String partName) {
        List<MPartitionPrivilege> mParts = this.listPrincipalMPartitionGrants(principalName, principalType, dbName, tableName, partName);
        if (mParts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mParts.size(); ++i) {
            MPartitionPrivilege sPart = mParts.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null);
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sPart.getPrincipalName(), principalType, new PrivilegeGrantInfo(sPart.getPrivilege(), sPart.getCreateTime(), sPart.getGrantor(), PrincipalType.valueOf(sPart.getGrantorType()), sPart.getGrantOption()));
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MTableColumnPrivilege> listPrincipalMTableColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String columnName) {
        boolean success = false;
        Query query = null;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        columnName = HiveStringUtils.normalizeIdentifier((String)columnName);
        ArrayList<MTableColumnPrivilege> mSecurityColList = new ArrayList<MTableColumnPrivilege>();
        try {
            LOG.debug("Executing listPrincipalTableColumnGrants");
            this.openTransaction();
            String queryStr = "principalName == t1 && principalType == t2 && table.tableName == t3 && table.database.name == t4 &&  columnName == t5 ";
            query = this.pm.newQuery(MTableColumnPrivilege.class, queryStr);
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5");
            List mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, columnName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityColList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String columnName) {
        List<MTableColumnPrivilege> mTableCols = this.listPrincipalMTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
        if (mTableCols.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mTableCols.size(); ++i) {
            MTableColumnPrivilege sCol = mTableCols.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, sCol.getColumnName());
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MPartitionColumnPrivilege> listPrincipalMPartitionColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String partitionName, String columnName) {
        boolean success = false;
        Query query = null;
        tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
        dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
        columnName = HiveStringUtils.normalizeIdentifier((String)columnName);
        ArrayList<MPartitionColumnPrivilege> mSecurityColList = new ArrayList<MPartitionColumnPrivilege>();
        try {
            LOG.debug("Executing listPrincipalPartitionColumnGrants");
            this.openTransaction();
            query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2 && partition.table.tableName == t3 && partition.table.database.name == t4 && partition.partitionName == t5 && columnName == t6");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
            List mPrivs = (List)query.executeWithArray(new Object[]{principalName, principalType.toString(), tableName, dbName, partitionName, columnName});
            this.pm.retrieveAll((Collection)mPrivs);
            success = this.commitTransaction();
            mSecurityColList.addAll(mPrivs);
            LOG.debug("Done retrieving all objects for listPrincipalPartitionColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mSecurityColList;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String partitionName, String columnName) {
        List<MPartitionColumnPrivilege> mPartitionCols = this.listPrincipalMPartitionColumnGrants(principalName, principalType, dbName, tableName, partitionName, columnName);
        if (mPartitionCols.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (int i = 0; i < mPartitionCols.size(); ++i) {
            MPartitionColumnPrivilege sCol = mPartitionCols.get(i);
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, partValues, sCol.getColumnName());
            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
            result.add(secObj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionColumnGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.executeWithArray(new Object[]{principalName, principalType.toString()});
            } else {
                query = this.pm.newQuery(MPartitionColumnPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalPartitionColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String dbName, String tableName, String partitionName, String columnName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPartitionColumnGrantsAll");
            query = this.pm.newQuery(MPartitionColumnPrivilege.class, "partition.table.tableName == t3 && partition.table.database.name == t4 && partition.partitionName == t5 && columnName == t6");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5, java.lang.String t6");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, partitionName, columnName});
            LOG.debug("Done executing query for listPartitionColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPartitionColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<HiveObjectPrivilege> convertPartCols(List<MPartitionColumnPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MPartitionColumnPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MPartition mpartition = priv.getPartition();
            MTable mtable = mpartition.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, mdatabase.getName(), mtable.getTableName(), mpartition.getValues(), priv.getColumnName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTablePrivilege> listPrincipalAllTableGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityTabPartList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalAllTableGrants");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MTablePrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MTablePrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalAllTableGrants");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTable(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listTableGrantsAll(String dbName, String tableName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listTableGrantsAll");
            query = this.pm.newQuery(MTablePrivilege.class, "table.tableName == t1 && table.database.name == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName});
            LOG.debug("Done executing query for listTableGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTable(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableGrants");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<HiveObjectPrivilege> convertTable(List<MTablePrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MTablePrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            String table = priv.getTable().getTableName();
            String database = priv.getTable().getDatabase().getName();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, database, table, null, null);
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionPrivilege> listPrincipalAllPartitionGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityTabPartList = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalAllPartitionGrants");
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllPartitionGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityTabPartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MPartitionPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MPartitionPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalPartitionGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartition(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPartitionGrantsAll(String dbName, String tableName, String partitionName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalPartitionGrantsAll");
            query = this.pm.newQuery(MPartitionPrivilege.class, "partition.table.tableName == t3 && partition.table.database.name == t4 && partition.partitionName == t5");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, partitionName});
            LOG.debug("Done executing query for listPrincipalPartitionGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertPartition(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalPartitionGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<HiveObjectPrivilege> convertPartition(List<MPartitionPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MPartitionPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MPartition mpartition = priv.getPartition();
            MTable mtable = mpartition.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, mdatabase.getName(), mtable.getTableName(), mpartition.getValues(), null);
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MTableColumnPrivilege> listPrincipalAllTableColumnGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityColumnList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableColumnGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MTableColumnPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityColumnList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityColumnList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName, PrincipalType principalType) {
        boolean success = false;
        Query query = null;
        try {
            List mSecurityTabPartList;
            this.openTransaction();
            LOG.debug("Executing listPrincipalTableColumnGrantsAll");
            if (principalName != null && principalType != null) {
                query = this.pm.newQuery(MTableColumnPrivilege.class, "principalName == t1 && principalType == t2");
                query.declareParameters("java.lang.String t1, java.lang.String t2");
                mSecurityTabPartList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            } else {
                query = this.pm.newQuery(MTableColumnPrivilege.class);
                mSecurityTabPartList = (List)query.execute();
            }
            LOG.debug("Done executing query for listPrincipalTableColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTableCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String dbName, String tableName, String columnName) {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            LOG.debug("Executing listPrincipalTableColumnGrantsAll");
            query = this.pm.newQuery(MTableColumnPrivilege.class, "table.tableName == t3 && table.database.name == t4 &&  columnName == t5");
            query.declareParameters("java.lang.String t3, java.lang.String t4, java.lang.String t5");
            List mSecurityTabPartList = (List)query.executeWithArray(new Object[]{tableName, dbName, columnName});
            LOG.debug("Done executing query for listPrincipalTableColumnGrantsAll");
            this.pm.retrieveAll((Collection)mSecurityTabPartList);
            List<HiveObjectPrivilege> result = this.convertTableCols(mSecurityTabPartList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalTableColumnGrantsAll");
            List<HiveObjectPrivilege> list = result;
            return list;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<HiveObjectPrivilege> convertTableCols(List<MTableColumnPrivilege> privs) {
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        for (MTableColumnPrivilege priv : privs) {
            String pname = priv.getPrincipalName();
            PrincipalType ptype = PrincipalType.valueOf(priv.getPrincipalType());
            MTable mtable = priv.getTable();
            MDatabase mdatabase = mtable.getDatabase();
            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, mdatabase.getName(), mtable.getTableName(), null, priv.getColumnName());
            PrivilegeGrantInfo grantor = new PrivilegeGrantInfo(priv.getPrivilege(), priv.getCreateTime(), priv.getGrantor(), PrincipalType.valueOf(priv.getGrantorType()), priv.getGrantOption());
            result.add(new HiveObjectPrivilege(objectRef, pname, ptype, grantor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MPartitionColumnPrivilege> listPrincipalAllPartitionColumnGrants(String principalName, PrincipalType principalType, QueryWrapper queryWrapper) {
        boolean success = false;
        List mSecurityColumnList = null;
        try {
            LOG.debug("Executing listPrincipalAllTableColumnGrants");
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == t1 && principalType == t2");
            query.declareParameters("java.lang.String t1, java.lang.String t2");
            mSecurityColumnList = (List)query.execute((Object)principalName, (Object)principalType.toString());
            this.pm.retrieveAll((Collection)mSecurityColumnList);
            success = this.commitTransaction();
            LOG.debug("Done retrieving all objects for listPrincipalAllTableColumnGrants");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return mSecurityColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws UnknownTableException, MetaException, InvalidPartitionException, UnknownPartitionException {
        boolean success = false;
        Query query = null;
        try {
            LOG.debug("Begin Executing isPartitionMarkedForEvent");
            this.openTransaction();
            query = this.pm.newQuery(MPartitionEvent.class, "dbName == t1 && tblName == t2 && partName == t3 && eventType == t4");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3, int t4");
            Table tbl = this.getTable(dbName, tblName);
            if (null == tbl) {
                throw new UnknownTableException("Table: " + tblName + " is not found.");
            }
            Collection partEvents = (Collection)query.executeWithArray(new Object[]{dbName, tblName, this.getPartitionStr(tbl, partName), evtType.getValue()});
            this.pm.retrieveAll(partEvents);
            success = this.commitTransaction();
            LOG.debug("Done executing isPartitionMarkedForEvent");
            boolean bl = partEvents != null && !partEvents.isEmpty();
            return bl;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table markPartitionForEvent(String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        LOG.debug("Begin executing markPartitionForEvent");
        boolean success = false;
        Table tbl = null;
        try {
            this.openTransaction();
            tbl = this.getTable(dbName, tblName);
            if (null == tbl) {
                throw new UnknownTableException("Table: " + tblName + " is not found.");
            }
            this.pm.makePersistent((Object)new MPartitionEvent(dbName, tblName, this.getPartitionStr(tbl, partName), evtType.getValue()));
            success = this.commitTransaction();
            LOG.debug("Done executing markPartitionForEvent");
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        return tbl;
    }

    private String getPartitionStr(Table tbl, Map<String, String> partName) throws InvalidPartitionException {
        if (tbl.getPartitionKeysSize() != partName.size()) {
            throw new InvalidPartitionException("Number of partition columns in table: " + tbl.getPartitionKeysSize() + " doesn't match with number of supplied partition values: " + partName.size());
        }
        ArrayList<String> storedVals = new ArrayList<String>(tbl.getPartitionKeysSize());
        for (FieldSchema partKey : tbl.getPartitionKeys()) {
            String partVal = partName.get(partKey.getName());
            if (null == partVal) {
                throw new InvalidPartitionException("No value found for partition column: " + partKey.getName());
            }
            storedVals.add(partVal);
        }
        return StringUtils.join(storedVals, (char)',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> executeJDOQLSelect(String queryStr, QueryWrapper queryWrapper) {
        boolean committed = false;
        Collection result = null;
        try {
            this.openTransaction();
            Query query = queryWrapper.query = this.pm.newQuery(queryStr);
            result = (Collection)query.execute();
            committed = this.commitTransaction();
            if (committed) {
                Collection collection = result;
                return collection;
            }
            Collection<?> collection = null;
            return collection;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeJDOQLUpdate(String queryStr) {
        boolean committed = false;
        long numUpdated = 0L;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(queryStr);
            numUpdated = (Long)query.execute();
            committed = this.commitTransaction();
            if (committed) {
                long l = numUpdated;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listFSRoots() {
        boolean committed = false;
        Query query = null;
        HashSet<String> fsRoots = new HashSet<String>();
        try {
            HashSet<String> hashSet;
            this.openTransaction();
            query = this.pm.newQuery(MDatabase.class);
            List mDBs = (List)query.execute();
            this.pm.retrieveAll((Collection)mDBs);
            for (MDatabase mDB : mDBs) {
                fsRoots.add(mDB.getLocationUri());
            }
            committed = this.commitTransaction();
            if (committed) {
                hashSet = fsRoots;
                return hashSet;
            }
            hashSet = null;
            return hashSet;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private boolean shouldUpdateURI(URI onDiskUri, URI inputUri) {
        String onDiskHost = onDiskUri.getHost();
        String inputHost = inputUri.getHost();
        int onDiskPort = onDiskUri.getPort();
        int inputPort = inputUri.getPort();
        String onDiskScheme = onDiskUri.getScheme();
        String inputScheme = inputUri.getScheme();
        if (inputPort != -1 && inputPort != onDiskPort) {
            return false;
        }
        if (inputScheme != null) {
            if (onDiskScheme == null) {
                return false;
            }
            if (!inputScheme.equalsIgnoreCase(onDiskScheme)) {
                return false;
            }
        }
        return !(onDiskHost != null ? inputHost == null || !inputHost.equalsIgnoreCase(onDiskHost) : inputHost != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMDatabaseURIRetVal updateMDatabaseURI(URI oldLoc, URI newLoc, boolean dryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateMDatabaseURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MDatabase.class);
            List mDBs = (List)query.execute();
            this.pm.retrieveAll((Collection)mDBs);
            for (MDatabase mDB : mDBs) {
                URI locationURI = null;
                String location = mDB.getLocationUri();
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                    continue;
                }
                if (!this.shouldUpdateURI(locationURI, oldLoc)) continue;
                String dbLoc = mDB.getLocationUri().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(locationURI.toString(), dbLoc);
                if (dryRun) continue;
                mDB.setLocationUri(dbLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMDatabaseURIRetVal(badRecords, updateLocations);
            }
            UpdateMDatabaseURIRetVal updateMDatabaseURIRetVal = retVal;
            return updateMDatabaseURIRetVal;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private void updatePropURIHelper(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun, List<String> badRecords, Map<String, String> updateLocations, Map<String, String> parameters) {
        URI tablePropLocationURI = null;
        if (parameters.containsKey(tblPropKey)) {
            String tablePropLocation = parameters.get(tblPropKey);
            try {
                tablePropLocationURI = new Path(tablePropLocation).toUri();
            }
            catch (IllegalArgumentException e) {
                badRecords.add(tablePropLocation);
            }
            if (tablePropLocationURI == null) {
                badRecords.add(tablePropLocation);
            } else if (this.shouldUpdateURI(tablePropLocationURI, oldLoc)) {
                String tblPropLoc = parameters.get(tblPropKey).replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(tablePropLocationURI.toString(), tblPropLoc);
                if (!isDryRun) {
                    parameters.put(tblPropKey, tblPropLoc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatePropURIRetVal updateTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MTable.class);
            List mTbls = (List)query.execute();
            this.pm.retrieveAll((Collection)mTbls);
            for (MTable mTbl : mTbls) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mTbl.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(badRecords, updateLocations);
            }
            UpdatePropURIRetVal updatePropURIRetVal = retVal;
            return updatePropURIRetVal;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public UpdatePropURIRetVal updateMStorageDescriptorTblPropURI(URI oldLoc, URI newLoc, String tblPropKey, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdatePropURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                this.updatePropURIHelper(oldLoc, newLoc, tblPropKey, isDryRun, badRecords, updateLocations, mSDS.getParameters());
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdatePropURIRetVal(badRecords, updateLocations);
            }
            UpdatePropURIRetVal updatePropURIRetVal = retVal;
            return updatePropURIRetVal;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMStorageDescriptorTblURIRetVal updateMStorageDescriptorTblURI(URI oldLoc, URI newLoc, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        int numNullRecords = 0;
        UpdateMStorageDescriptorTblURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MStorageDescriptor.class);
            List mSDSs = (List)query.execute();
            this.pm.retrieveAll((Collection)mSDSs);
            for (MStorageDescriptor mSDS : mSDSs) {
                URI locationURI = null;
                String location = mSDS.getLocation();
                if (location == null) {
                    ++numNullRecords;
                    continue;
                }
                try {
                    locationURI = new Path(location).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(location);
                }
                if (locationURI == null) {
                    badRecords.add(location);
                    continue;
                }
                if (!this.shouldUpdateURI(locationURI, oldLoc)) continue;
                String tblLoc = mSDS.getLocation().replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(locationURI.toString(), tblLoc);
                if (isDryRun) continue;
                mSDS.setLocation(tblLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateMStorageDescriptorTblURIRetVal(badRecords, updateLocations, numNullRecords);
            }
            UpdateMStorageDescriptorTblURIRetVal updateMStorageDescriptorTblURIRetVal = retVal;
            return updateMStorageDescriptorTblURIRetVal;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSerdeURIRetVal updateSerdeURI(URI oldLoc, URI newLoc, String serdeProp, boolean isDryRun) {
        boolean committed = false;
        Query query = null;
        HashMap<String, String> updateLocations = new HashMap<String, String>();
        ArrayList<String> badRecords = new ArrayList<String>();
        UpdateSerdeURIRetVal retVal = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MSerDeInfo.class);
            List mSerdes = (List)query.execute();
            this.pm.retrieveAll((Collection)mSerdes);
            for (MSerDeInfo mSerde : mSerdes) {
                if (!mSerde.getParameters().containsKey(serdeProp)) continue;
                String schemaLoc = mSerde.getParameters().get(serdeProp);
                URI schemaLocURI = null;
                try {
                    schemaLocURI = new Path(schemaLoc).toUri();
                }
                catch (IllegalArgumentException e) {
                    badRecords.add(schemaLoc);
                }
                if (schemaLocURI == null) {
                    badRecords.add(schemaLoc);
                    continue;
                }
                if (!this.shouldUpdateURI(schemaLocURI, oldLoc)) continue;
                String newSchemaLoc = schemaLoc.replaceAll(oldLoc.toString(), newLoc.toString());
                updateLocations.put(schemaLocURI.toString(), newSchemaLoc);
                if (isDryRun) continue;
                mSerde.getParameters().put(serdeProp, newSchemaLoc);
            }
            committed = this.commitTransaction();
            if (committed) {
                retVal = new UpdateSerdeURIRetVal(badRecords, updateLocations);
            }
            UpdateSerdeURIRetVal updateSerdeURIRetVal = retVal;
            return updateSerdeURIRetVal;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMTableColumnStatistics(Table table, MTableColumnStatistics mStatsObj) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        String dbName = mStatsObj.getDbName();
        String tableName = mStatsObj.getTableName();
        String colName = mStatsObj.getColName();
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            LOG.info("Updating table level column statistics for db=" + dbName + " tableName=" + tableName + " colName=" + colName);
            this.validateTableCols(table, Lists.newArrayList((Object[])new String[]{colName}));
            List<MTableColumnStatistics> oldStats = this.getMTableColumnStatistics(table, Lists.newArrayList((Object[])new String[]{colName}), queryWrapper);
            if (!oldStats.isEmpty()) {
                assert (oldStats.size() == 1);
                StatObjectConverter.setFieldsIntoOldStats(mStatsObj, oldStats.get(0));
            } else {
                this.pm.makePersistent((Object)mStatsObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMPartitionColumnStatistics(Table table, Partition partition, MPartitionColumnStatistics mStatsObj) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        String dbName = mStatsObj.getDbName();
        String tableName = mStatsObj.getTableName();
        String partName = mStatsObj.getPartitionName();
        String colName = mStatsObj.getColName();
        LOG.info("Updating partition level column statistics for db=" + dbName + " tableName=" + tableName + " partName=" + partName + " colName=" + colName);
        boolean foundCol = false;
        List<FieldSchema> colList = partition.getSd().getCols();
        for (FieldSchema col : colList) {
            if (!col.getName().equals(mStatsObj.getColName().trim())) continue;
            foundCol = true;
            break;
        }
        if (!foundCol) {
            throw new NoSuchObjectException("Column " + colName + " for which stats gathering is requested doesn't exist.");
        }
        try (QueryWrapper queryWrapper = new QueryWrapper();){
            List<MPartitionColumnStatistics> oldStats = this.getMPartitionColumnStatistics(table, Lists.newArrayList((Object[])new String[]{partName}), Lists.newArrayList((Object[])new String[]{colName}), queryWrapper);
            if (!oldStats.isEmpty()) {
                assert (oldStats.size() == 1);
                StatObjectConverter.setFieldsIntoOldStats(mStatsObj, oldStats.get(0));
            } else {
                this.pm.makePersistent((Object)mStatsObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean committed = false;
        this.openTransaction();
        try {
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            Table table = this.ensureGetTable(statsDesc.getDbName(), statsDesc.getTableName());
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                MTableColumnStatistics mStatsObj = StatObjectConverter.convertToMTableColumnStatistics(this.ensureGetMTable(statsDesc.getDbName(), statsDesc.getTableName()), statsDesc, statsObj);
                this.writeMTableColumnStatistics(table, mStatsObj);
                colNames.add(statsObj.getColName());
            }
            String dbname = table.getDbName();
            String name = table.getTableName();
            MTable oldt = this.getMTable(dbname, name);
            Map<String, String> parameters = table.getParameters();
            StatsSetupConst.setColumnStatsState(parameters, colNames);
            oldt.setParameters(parameters);
            boolean bl = committed = this.commitTransaction();
            return bl;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePartitionColumnStatistics(ColumnStatistics colStats, List<String> partVals) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean committed = false;
        try {
            this.openTransaction();
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            Table table = this.ensureGetTable(statsDesc.getDbName(), statsDesc.getTableName());
            Partition partition = this.convertToPart(this.getMPartition(statsDesc.getDbName(), statsDesc.getTableName(), partVals));
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                MPartition mPartition = this.getMPartition(statsDesc.getDbName(), statsDesc.getTableName(), partVals);
                if (partition == null) {
                    throw new NoSuchObjectException("Partition for which stats is gathered doesn't exist.");
                }
                MPartitionColumnStatistics mStatsObj = StatObjectConverter.convertToMPartitionColumnStatistics(mPartition, statsDesc, statsObj);
                this.writeMPartitionColumnStatistics(table, partition, mStatsObj);
                colNames.add(statsObj.getColName());
            }
            MPartition mPartition = this.getMPartition(statsDesc.getDbName(), statsDesc.getTableName(), partVals);
            Map<String, String> parameters = mPartition.getParameters();
            StatsSetupConst.setColumnStatsState(parameters, colNames);
            mPartition.setParameters(parameters);
            boolean bl = committed = this.commitTransaction();
            return bl;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    private List<MTableColumnStatistics> getMTableColumnStatistics(Table table, List<String> colNames, QueryWrapper queryWrapper) throws MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            List result = null;
            this.validateTableCols(table, colNames);
            Query query = queryWrapper.query = this.pm.newQuery(MTableColumnStatistics.class);
            String filter = "tableName == t1 && dbName == t2 && (";
            String paramStr = "java.lang.String t1, java.lang.String t2";
            Object[] params = new Object[colNames.size() + 2];
            params[0] = table.getTableName();
            params[1] = table.getDbName();
            for (int i = 0; i < colNames.size(); ++i) {
                filter = filter + (i == 0 ? "" : " || ") + "colName == c" + i;
                paramStr = paramStr + ", java.lang.String c" + i;
                params[i + 2] = colNames.get(i);
            }
            filter = filter + ")";
            query.setFilter(filter);
            query.declareParameters(paramStr);
            result = (List)query.executeWithArray(params);
            this.pm.retrieveAll((Collection)result);
            if (result.size() > colNames.size()) {
                throw new MetaException("Unexpected " + result.size() + " statistics for " + colNames.size() + " columns");
            }
            committed = this.commitTransaction();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            LOG.error("Error retrieving statistics via jdo", (Throwable)ex);
            if (ex instanceof MetaException) {
                throw (MetaException)((Object)ex);
            }
            throw new MetaException(ex.getMessage());
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
                return Lists.newArrayList();
            }
        }
    }

    @VisibleForTesting
    public void validateTableCols(Table table, List<String> colNames) throws MetaException {
        List<FieldSchema> colList = table.getSd().getCols();
        for (String colName : colNames) {
            boolean foundCol = false;
            for (FieldSchema mCol : colList) {
                if (!mCol.getName().equals(colName.trim())) continue;
                foundCol = true;
                break;
            }
            if (foundCol) continue;
            throw new MetaException("Column " + colName + " doesn't exist in table " + table.getTableName() + " in database " + table.getDbName());
        }
    }

    @Override
    public ColumnStatistics getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.getTableColumnStatisticsInternal(dbName, tableName, colNames, true, true);
    }

    protected ColumnStatistics getTableColumnStatisticsInternal(String dbName, String tableName, final List<String> colNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (ColumnStatistics)new GetStatHelper(HiveStringUtils.normalizeIdentifier((String)dbName), HiveStringUtils.normalizeIdentifier((String)tableName), allowSql, allowJdo){

            @Override
            protected ColumnStatistics getSqlResult(GetHelper<ColumnStatistics> ctx) throws MetaException {
                return ObjectStore.this.directSql.getTableStats(this.dbName, this.tblName, colNames);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ColumnStatistics getJdoResult(GetHelper<ColumnStatistics> ctx) throws MetaException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List mStats = ObjectStore.this.getMTableColumnStatistics(this.getTable(), colNames, queryWrapper);
                    if (mStats.isEmpty()) {
                        ColumnStatistics columnStatistics = null;
                        return columnStatistics;
                    }
                    ColumnStatisticsDesc desc = StatObjectConverter.getTableColumnStatisticsDesc((MTableColumnStatistics)mStats.get(0));
                    ArrayList<ColumnStatisticsObj> statObjs = new ArrayList<ColumnStatisticsObj>(mStats.size());
                    for (MTableColumnStatistics mStat : mStats) {
                        if (desc.getLastAnalyzed() > mStat.getLastAnalyzed()) {
                            desc.setLastAnalyzed(mStat.getLastAnalyzed());
                        }
                        statObjs.add(StatObjectConverter.getTableColumnStatisticsObj(mStat));
                        Deadline.checkTimeout();
                    }
                    ColumnStatistics columnStatistics = new ColumnStatistics(desc, statObjs);
                    return columnStatistics;
                }
            }
        }.run(true);
    }

    @Override
    public List<ColumnStatistics> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.getPartitionColumnStatisticsInternal(dbName, tableName, partNames, colNames, true, true);
    }

    protected List<ColumnStatistics> getPartitionColumnStatisticsInternal(String dbName, String tableName, final List<String> partNames, final List<String> colNames, boolean allowSql, boolean allowJdo) throws MetaException, NoSuchObjectException {
        return (List)new GetListHelper<ColumnStatistics>(dbName, tableName, allowSql, allowJdo){

            @Override
            protected List<ColumnStatistics> getSqlResult(GetHelper<List<ColumnStatistics>> ctx) throws MetaException {
                return ObjectStore.this.directSql.getPartitionStats(this.dbName, this.tblName, partNames, colNames);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<ColumnStatistics> getJdoResult(GetHelper<List<ColumnStatistics>> ctx) throws MetaException, NoSuchObjectException {
                try (QueryWrapper queryWrapper = new QueryWrapper();){
                    List mStats = ObjectStore.this.getMPartitionColumnStatistics(this.getTable(), partNames, colNames, queryWrapper);
                    ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(Math.min(mStats.size(), partNames.size()));
                    String lastPartName = null;
                    ArrayList<ColumnStatisticsObj> curList = null;
                    ColumnStatisticsDesc csd = null;
                    for (int i = 0; i <= mStats.size(); ++i) {
                        String partName;
                        boolean isLast = i == mStats.size();
                        MPartitionColumnStatistics mStatsObj = isLast ? null : (MPartitionColumnStatistics)mStats.get(i);
                        String string = partName = isLast ? null : mStatsObj.getPartitionName();
                        if (isLast || !partName.equals(lastPartName)) {
                            if (i != 0) {
                                result.add(new ColumnStatistics(csd, (List<ColumnStatisticsObj>)curList));
                            }
                            if (isLast) continue;
                            csd = StatObjectConverter.getPartitionColumnStatisticsDesc(mStatsObj);
                            curList = new ArrayList<ColumnStatisticsObj>(colNames.size());
                        }
                        curList.add(StatObjectConverter.getPartitionColumnStatisticsObj(mStatsObj));
                        lastPartName = partName;
                        Deadline.checkTimeout();
                    }
                    ArrayList<ColumnStatistics> arrayList = result;
                    return arrayList;
                }
            }
        }.run(true);
    }

    @Override
    public AggrStats get_aggr_stats_for(String dbName, String tblName, final List<String> partNames, final List<String> colNames) throws MetaException, NoSuchObjectException {
        final boolean useDensityFunctionForNDVEstimation = HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_STATS_NDV_DENSITY_FUNCTION);
        return (AggrStats)new GetHelper<AggrStats>(dbName, tblName, true, false){

            @Override
            protected AggrStats getSqlResult(GetHelper<AggrStats> ctx) throws MetaException {
                return ObjectStore.this.directSql.aggrColStatsForPartitions(this.dbName, this.tblName, partNames, colNames, useDensityFunctionForNDVEstimation);
            }

            @Override
            protected AggrStats getJdoResult(GetHelper<AggrStats> ctx) throws MetaException, NoSuchObjectException {
                throw new MetaException("Jdo path is not implemented for stats aggr.");
            }

            @Override
            protected String describeResult() {
                return null;
            }
        }.run(true);
    }

    @Override
    public void flushCache() {
    }

    private List<MPartitionColumnStatistics> getMPartitionColumnStatistics(Table table, List<String> partNames, List<String> colNames, QueryWrapper queryWrapper) throws NoSuchObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            this.validateTableCols(table, colNames);
            Query query = queryWrapper.query = this.pm.newQuery(MPartitionColumnStatistics.class);
            String paramStr = "java.lang.String t1, java.lang.String t2";
            String filter = "tableName == t1 && dbName == t2 && (";
            Object[] params = new Object[colNames.size() + partNames.size() + 2];
            int i = 0;
            params[i++] = table.getTableName();
            params[i++] = table.getDbName();
            int firstI = i;
            for (String s : partNames) {
                filter = filter + (i == firstI ? "" : " || ") + "partitionName == p" + i;
                paramStr = paramStr + ", java.lang.String p" + i;
                params[i++] = s;
            }
            filter = filter + ") && (";
            firstI = i;
            for (String s : colNames) {
                filter = filter + (i == firstI ? "" : " || ") + "colName == c" + i;
                paramStr = paramStr + ", java.lang.String c" + i;
                params[i++] = s;
            }
            filter = filter + ")";
            query.setFilter(filter);
            query.declareParameters(paramStr);
            query.setOrdering("partitionName ascending");
            List result = (List)query.executeWithArray(params);
            this.pm.retrieveAll((Collection)result);
            committed = this.commitTransaction();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            LOG.error("Error retrieving statistics via jdo", (Throwable)ex);
            if (ex instanceof MetaException) {
                throw (MetaException)((Object)ex);
            }
            throw new MetaException(ex.getMessage());
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
                return Lists.newArrayList();
            }
        }
    }

    private void dropPartitionColumnStatisticsNoTxn(String dbName, String tableName, List<String> partNames) throws MetaException {
        ObjectPair<Query, Object[]> queryWithParams = this.makeQueryByPartitionNames(dbName, tableName, partNames, MPartitionColumnStatistics.class, "tableName", "dbName", "partition.partitionName");
        ((Query)queryWithParams.getFirst()).deletePersistentAll((Object[])queryWithParams.getSecond());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, List<String> partVals, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean ret = false;
        Query query = null;
        if (dbName == null) {
            dbName = "default";
        }
        if (tableName == null) {
            throw new InvalidInputException("Table name is null.");
        }
        try {
            String parameters;
            String filter;
            this.openTransaction();
            MTable mTable = this.getMTable(dbName, tableName);
            if (mTable == null) {
                throw new NoSuchObjectException("Table " + tableName + "  for which stats deletion is requested doesn't exist");
            }
            MPartition mPartition = this.getMPartition(dbName, tableName, partVals);
            if (mPartition == null) {
                throw new NoSuchObjectException("Partition " + partName + " for which stats deletion is requested doesn't exist");
            }
            query = this.pm.newQuery(MPartitionColumnStatistics.class);
            if (colName != null) {
                filter = "partition.partitionName == t1 && dbName == t2 && tableName == t3 && colName == t4";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3, java.lang.String t4";
            } else {
                filter = "partition.partitionName == t1 && dbName == t2 && tableName == t3";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
            }
            query.setFilter(filter);
            query.declareParameters(parameters);
            if (colName != null) {
                query.setUnique(true);
                MPartitionColumnStatistics mStatsObj = (MPartitionColumnStatistics)query.executeWithArray(new Object[]{partName.trim(), HiveStringUtils.normalizeIdentifier((String)dbName), HiveStringUtils.normalizeIdentifier((String)tableName), HiveStringUtils.normalizeIdentifier((String)colName)});
                this.pm.retrieve((Object)mStatsObj);
                if (mStatsObj == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName + " partition=" + partName + " col=" + colName);
                this.pm.deletePersistent((Object)mStatsObj);
            } else {
                List mStatsObjColl = (List)query.execute((Object)partName.trim(), (Object)HiveStringUtils.normalizeIdentifier((String)dbName), (Object)HiveStringUtils.normalizeIdentifier((String)tableName));
                this.pm.retrieveAll((Collection)mStatsObjColl);
                if (mStatsObjColl == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName + " partition" + partName);
                this.pm.deletePersistentAll((Collection)mStatsObjColl);
            }
            ret = this.commitTransaction();
            return ret;
        }
        catch (NoSuchObjectException e) {
            this.rollbackTransaction();
            throw e;
        }
        finally {
            if (!ret) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean ret = false;
        Query query = null;
        if (dbName == null) {
            dbName = "default";
        }
        if (tableName == null) {
            throw new InvalidInputException("Table name is null.");
        }
        try {
            String parameters;
            String filter;
            this.openTransaction();
            MTable mTable = this.getMTable(dbName, tableName);
            if (mTable == null) {
                throw new NoSuchObjectException("Table " + tableName + "  for which stats deletion is requested doesn't exist");
            }
            query = this.pm.newQuery(MTableColumnStatistics.class);
            if (colName != null) {
                filter = "table.tableName == t1 && dbName == t2 && colName == t3";
                parameters = "java.lang.String t1, java.lang.String t2, java.lang.String t3";
            } else {
                filter = "table.tableName == t1 && dbName == t2";
                parameters = "java.lang.String t1, java.lang.String t2";
            }
            query.setFilter(filter);
            query.declareParameters(parameters);
            if (colName != null) {
                query.setUnique(true);
                MTableColumnStatistics mStatsObj = (MTableColumnStatistics)query.execute((Object)HiveStringUtils.normalizeIdentifier((String)tableName), (Object)HiveStringUtils.normalizeIdentifier((String)dbName), (Object)HiveStringUtils.normalizeIdentifier((String)colName));
                this.pm.retrieve((Object)mStatsObj);
                if (mStatsObj == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName + " col=" + colName);
                this.pm.deletePersistent((Object)mStatsObj);
            } else {
                List mStatsObjColl = (List)query.execute((Object)HiveStringUtils.normalizeIdentifier((String)tableName), (Object)HiveStringUtils.normalizeIdentifier((String)dbName));
                this.pm.retrieveAll((Collection)mStatsObjColl);
                if (mStatsObjColl == null) throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " table=" + tableName);
                this.pm.deletePersistentAll((Collection)mStatsObjColl);
            }
            ret = this.commitTransaction();
            return ret;
        }
        catch (NoSuchObjectException e) {
            this.rollbackTransaction();
            throw e;
        }
        finally {
            if (!ret) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long cleanupEvents() {
        long delCnt;
        boolean commited = false;
        Query query = null;
        LOG.debug("Begin executing cleanupEvents");
        Long expiryTime = HiveConf.getTimeVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_EVENT_EXPIRY_DURATION, (TimeUnit)TimeUnit.MILLISECONDS);
        Long curTime = System.currentTimeMillis();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MPartitionEvent.class, "curTime - eventTime > expiryTime");
            query.declareParameters("java.lang.Long curTime, java.lang.Long expiryTime");
            delCnt = query.deletePersistentAll(new Object[]{curTime, expiryTime});
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
            LOG.debug("Done executing cleanupEvents");
        }
        return delCnt;
    }

    private MDelegationToken getTokenFrom(String tokenId) {
        Query query = this.pm.newQuery(MDelegationToken.class, "tokenIdentifier == tokenId");
        query.declareParameters("java.lang.String tokenId");
        query.setUnique(true);
        MDelegationToken delegationToken = (MDelegationToken)query.execute((Object)tokenId);
        if (query != null) {
            query.closeAll();
        }
        return delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToken(String tokenId, String delegationToken) {
        MDelegationToken token;
        LOG.debug("Begin executing addToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (token == null) {
                this.pm.makePersistent((Object)new MDelegationToken(tokenId, delegationToken));
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing addToken with status : " + committed);
        return committed && token == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeToken(String tokenId) {
        MDelegationToken token;
        LOG.debug("Begin executing removeToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (null != token) {
                this.pm.deletePersistent((Object)token);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing removeToken with status : " + committed);
        return committed && token != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken(String tokenId) {
        MDelegationToken token;
        LOG.debug("Begin executing getToken");
        boolean committed = false;
        try {
            this.openTransaction();
            token = this.getTokenFrom(tokenId);
            if (null != token) {
                this.pm.retrieve((Object)token);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing getToken with status : " + committed);
        return null == token ? null : token.getTokenStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllTokenIdentifiers() {
        LOG.debug("Begin executing getAllTokenIdentifiers");
        boolean committed = false;
        Query query = null;
        ArrayList<String> tokenIdents = new ArrayList<String>();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MDelegationToken.class);
            List tokens = (List)query.execute();
            this.pm.retrieveAll((Collection)tokens);
            committed = this.commitTransaction();
            for (MDelegationToken token : tokens) {
                tokenIdents.add(token.getTokenIdentifier());
            }
            ArrayList<String> arrayList = tokenIdents;
            return arrayList;
        }
        finally {
            LOG.debug("Done executing getAllTokenIdentifers with status : " + committed);
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addMasterKey(String key) throws MetaException {
        LOG.debug("Begin executing addMasterKey");
        boolean committed = false;
        MMasterKey masterKey = new MMasterKey(key);
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)masterKey);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
        LOG.debug("Done executing addMasterKey with status : " + committed);
        if (committed) {
            return ((IntIdentity)this.pm.getObjectId((Object)masterKey)).getKey();
        }
        throw new MetaException("Failed to add master key.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMasterKey(Integer id, String key) throws NoSuchObjectException, MetaException {
        MMasterKey masterKey;
        LOG.debug("Begin executing updateMasterKey");
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class, "keyId == id");
            query.declareParameters("java.lang.Integer id");
            query.setUnique(true);
            masterKey = (MMasterKey)query.execute((Object)id);
            if (null != masterKey) {
                masterKey.setMasterKey(key);
            }
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        LOG.debug("Done executing updateMasterKey with status : " + committed);
        if (null == masterKey) {
            throw new NoSuchObjectException("No key found with keyId: " + id);
        }
        if (!committed) {
            throw new MetaException("Though key is found, failed to update it. " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMasterKey(Integer id) {
        MMasterKey masterKey;
        LOG.debug("Begin executing removeMasterKey");
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class, "keyId == id");
            query.declareParameters("java.lang.Integer id");
            query.setUnique(true);
            masterKey = (MMasterKey)query.execute((Object)id);
            if (null != masterKey) {
                this.pm.deletePersistent((Object)masterKey);
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        LOG.debug("Done executing removeMasterKey with status : " + success);
        return null != masterKey && success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMasterKeys() {
        LOG.debug("Begin executing getMasterKeys");
        boolean committed = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MMasterKey.class);
            List keys = (List)query.execute();
            this.pm.retrieveAll((Collection)keys);
            committed = this.commitTransaction();
            String[] masterKeys = new String[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                masterKeys[i] = ((MMasterKey)keys.get(i)).getMasterKey();
            }
            String[] stringArray = masterKeys;
            return stringArray;
        }
        finally {
            LOG.debug("Done executing getMasterKeys with status : " + committed);
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    @Override
    public void verifySchema() throws MetaException {
        if (isSchemaVerified.get()) {
            return;
        }
        this.checkSchema();
    }

    public static void setSchemaVerified(boolean val) {
        isSchemaVerified.set(val);
    }

    private synchronized void checkSchema() throws MetaException {
        if (isSchemaVerified.get()) {
            return;
        }
        boolean strictValidation = HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION);
        String schemaVer = this.getMetaStoreSchemaVersion();
        if (schemaVer == null) {
            if (strictValidation) {
                throw new MetaException("Version information not found in metastore. ");
            }
            LOG.warn("Version information not found in metastore. " + HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.toString() + " is not enabled so recording the schema version " + MetaStoreSchemaInfo.getHiveSchemaVersion());
            this.setMetaStoreSchemaVersion(MetaStoreSchemaInfo.getHiveSchemaVersion(), "Set by MetaStore " + USER + "@" + HOSTNAME);
        } else if (schemaVer.equalsIgnoreCase(MetaStoreSchemaInfo.getHiveSchemaVersion())) {
            LOG.debug("Found expected HMS version of " + schemaVer);
        } else {
            if (strictValidation) {
                throw new MetaException("Hive Schema version " + MetaStoreSchemaInfo.getHiveSchemaVersion() + " does not match metastore's schema version " + schemaVer + " Metastore is not upgraded or corrupt");
            }
            LOG.error("Version information found in metastore differs " + schemaVer + " from expected schema version " + MetaStoreSchemaInfo.getHiveSchemaVersion() + ". Schema verififcation is disabled " + HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION + " so setting version.");
            this.setMetaStoreSchemaVersion(MetaStoreSchemaInfo.getHiveSchemaVersion(), "Set by MetaStore " + USER + "@" + HOSTNAME);
        }
        isSchemaVerified.set(true);
    }

    @Override
    public String getMetaStoreSchemaVersion() throws MetaException {
        MVersionTable mSchemaVer;
        try {
            mSchemaVer = this.getMSchemaVersion();
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        return mSchemaVer.getSchemaVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MVersionTable getMSchemaVersion() throws NoSuchObjectException, MetaException {
        boolean committed = false;
        Query query = null;
        List mVerTables = new ArrayList();
        try {
            this.openTransaction();
            query = this.pm.newQuery(MVersionTable.class);
            try {
                mVerTables = (List)query.execute();
                this.pm.retrieveAll(mVerTables);
            }
            catch (JDODataStoreException e) {
                if (e.getCause() instanceof MissingTableException) {
                    throw new MetaException("Version table not found. The metastore is not upgraded to " + MetaStoreSchemaInfo.getHiveSchemaVersion());
                }
                throw e;
            }
            committed = this.commitTransaction();
            if (mVerTables.isEmpty()) {
                throw new NoSuchObjectException("No matching version found");
            }
            if (mVerTables.size() > 1) {
                String msg = "Metastore contains multiple versions (" + mVerTables.size() + ") ";
                for (MVersionTable version : mVerTables) {
                    msg = msg + "[ version = " + version.getSchemaVersion() + ", comment = " + version.getVersionComment() + " ] ";
                }
                throw new MetaException(msg.trim());
            }
            MVersionTable mVersionTable = (MVersionTable)mVerTables.get(0);
            return mVersionTable;
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaStoreSchemaVersion(String schemaVersion, String comment) throws MetaException {
        MVersionTable mSchemaVer;
        boolean commited = false;
        boolean recordVersion = HiveConf.getBoolVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION_RECORD_VERSION);
        if (!recordVersion) {
            LOG.warn("setMetaStoreSchemaVersion called but recording version is disabled: version = " + schemaVersion + ", comment = " + comment);
            return;
        }
        try {
            mSchemaVer = this.getMSchemaVersion();
        }
        catch (NoSuchObjectException e) {
            mSchemaVer = new MVersionTable();
        }
        mSchemaVer.setSchemaVersion(schemaVersion);
        mSchemaVer.setVersionComment(comment);
        try {
            this.openTransaction();
            this.pm.makePersistent((Object)mSchemaVer);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesPartitionExist(String dbName, String tableName, List<String> partVals) throws MetaException {
        boolean success = false;
        Query query = null;
        try {
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            tableName = HiveStringUtils.normalizeIdentifier((String)tableName);
            MTable mtbl = this.getMTable(dbName, tableName);
            if (mtbl == null) {
                success = this.commitTransaction();
                boolean bl = false;
                return bl;
            }
            query = this.pm.newQuery("select partitionName from org.apache.hadoop.hive.metastore.model.MPartition where table.tableName == t1 && table.database.name == t2 && partitionName == t3");
            query.declareParameters("java.lang.String t1, java.lang.String t2, java.lang.String t3");
            query.setUnique(true);
            query.setResult("partitionName");
            String name = Warehouse.makePartName(this.convertToFieldSchemas(mtbl.getPartitionKeys()), partVals);
            String result = (String)query.execute((Object)tableName, (Object)dbName, (Object)name);
            success = this.commitTransaction();
            boolean bl = result != null;
            return bl;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private void debugLog(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message + this.getCallStack());
        }
    }

    private String getCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int thislimit = Math.min(5, stackTrace.length);
        StringBuilder sb = new StringBuilder();
        sb.append(" at:");
        for (int i = 4; i < thislimit; ++i) {
            sb.append("\n\t");
            sb.append(stackTrace[i].toString());
        }
        return sb.toString();
    }

    private Function convertToFunction(MFunction mfunc) {
        if (mfunc == null) {
            return null;
        }
        Function func = new Function(mfunc.getFunctionName(), mfunc.getDatabase().getName(), mfunc.getClassName(), mfunc.getOwnerName(), PrincipalType.valueOf(mfunc.getOwnerType()), mfunc.getCreateTime(), FunctionType.findByValue(mfunc.getFunctionType()), this.convertToResourceUriList(mfunc.getResourceUris()));
        return func;
    }

    private List<Function> convertToFunctions(List<MFunction> mfuncs) {
        if (mfuncs == null) {
            return null;
        }
        ArrayList<Function> functions = new ArrayList<Function>();
        for (MFunction mfunc : mfuncs) {
            functions.add(this.convertToFunction(mfunc));
        }
        return functions;
    }

    private MFunction convertToMFunction(Function func) throws InvalidObjectException {
        if (func == null) {
            return null;
        }
        MDatabase mdb = null;
        try {
            mdb = this.getMDatabase(func.getDbName());
        }
        catch (NoSuchObjectException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)((Object)e)));
            throw new InvalidObjectException("Database " + func.getDbName() + " doesn't exist.");
        }
        MFunction mfunc = new MFunction(func.getFunctionName(), mdb, func.getClassName(), func.getOwnerName(), func.getOwnerType().name(), func.getCreateTime(), func.getFunctionType().getValue(), this.convertToMResourceUriList(func.getResourceUris()));
        return mfunc;
    }

    private List<ResourceUri> convertToResourceUriList(List<MResourceUri> mresourceUriList) {
        ArrayList<ResourceUri> resourceUriList = null;
        if (mresourceUriList != null) {
            resourceUriList = new ArrayList<ResourceUri>(mresourceUriList.size());
            for (MResourceUri mres : mresourceUriList) {
                resourceUriList.add(new ResourceUri(ResourceType.findByValue(mres.getResourceType()), mres.getUri()));
            }
        }
        return resourceUriList;
    }

    private List<MResourceUri> convertToMResourceUriList(List<ResourceUri> resourceUriList) {
        ArrayList<MResourceUri> mresourceUriList = null;
        if (resourceUriList != null) {
            mresourceUriList = new ArrayList<MResourceUri>(resourceUriList.size());
            for (ResourceUri res : resourceUriList) {
                mresourceUriList.add(new MResourceUri(res.getResourceType().getValue(), res.getUri()));
            }
        }
        return mresourceUriList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        boolean committed = false;
        try {
            this.openTransaction();
            MFunction mfunc = this.convertToMFunction(func);
            this.pm.makePersistent((Object)mfunc);
            committed = this.commitTransaction();
        }
        finally {
            if (!committed) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException {
        boolean success = false;
        try {
            this.openTransaction();
            funcName = HiveStringUtils.normalizeIdentifier((String)funcName);
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            MFunction newf = this.convertToMFunction(newFunction);
            if (newf == null) {
                throw new InvalidObjectException("new function is invalid");
            }
            MFunction oldf = this.getMFunction(dbName, funcName);
            if (oldf == null) {
                throw new MetaException("function " + funcName + " doesn't exist");
            }
            oldf.setFunctionName(HiveStringUtils.normalizeIdentifier((String)newf.getFunctionName()));
            oldf.setDatabase(newf.getDatabase());
            oldf.setOwnerName(newf.getOwnerName());
            oldf.setOwnerType(newf.getOwnerType());
            oldf.setClassName(newf.getClassName());
            oldf.setFunctionType(newf.getFunctionType());
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean success = false;
        try {
            this.openTransaction();
            MFunction mfunc = this.getMFunction(dbName, funcName);
            this.pm.retrieve((Object)mfunc);
            if (mfunc != null) {
                this.pm.deletePersistentAll(new Object[]{mfunc});
            }
            success = this.commitTransaction();
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFunction getMFunction(String db, String function) {
        MFunction mfunc = null;
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            db = HiveStringUtils.normalizeIdentifier((String)db);
            function = HiveStringUtils.normalizeIdentifier((String)function);
            query = this.pm.newQuery(MFunction.class, "functionName == function && database.name == db");
            query.declareParameters("java.lang.String function, java.lang.String db");
            query.setUnique(true);
            mfunc = (MFunction)query.execute((Object)function, (Object)db);
            this.pm.retrieve((Object)mfunc);
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return mfunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(String dbName, String funcName) throws MetaException {
        boolean commited = false;
        Function func = null;
        try {
            this.openTransaction();
            func = this.convertToFunction(this.getMFunction(dbName, funcName));
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getAllFunctions() throws MetaException {
        boolean commited = false;
        try {
            this.openTransaction();
            Query query = this.pm.newQuery(MFunction.class);
            List allFunctions = (List)query.execute();
            this.pm.retrieveAll((Collection)allFunctions);
            commited = this.commitTransaction();
            List<Function> list = this.convertToFunctions(allFunctions);
            return list;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFunctions(String dbName, String pattern) throws MetaException {
        boolean commited = false;
        Query query = null;
        ArrayList<String> funcs = null;
        try {
            this.openTransaction();
            dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            String[] subpatterns = pattern.trim().split("\\|");
            String queryStr = "select functionName from org.apache.hadoop.hive.metastore.model.MFunction where database.name == dbName && (";
            boolean first = true;
            for (String subpattern : subpatterns) {
                subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
                if (!first) {
                    queryStr = queryStr + " || ";
                }
                queryStr = queryStr + " functionName.matches(\"" + subpattern + "\")";
                first = false;
            }
            queryStr = queryStr + ")";
            query = this.pm.newQuery(queryStr);
            query.declareParameters("java.lang.String dbName");
            query.setResult("functionName");
            query.setOrdering("functionName ascending");
            Collection names = (Collection)query.execute((Object)dbName);
            funcs = new ArrayList<String>();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                funcs.add((String)i.next());
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
        return funcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            long lastEvent = rqst.getLastEvent();
            query = this.pm.newQuery(MNotificationLog.class, "eventId > lastEvent");
            query.declareParameters("java.lang.Long lastEvent");
            query.setOrdering("eventId ascending");
            Collection events = (Collection)query.execute((Object)lastEvent);
            commited = this.commitTransaction();
            if (events == null) {
                NotificationEventResponse notificationEventResponse = null;
                return notificationEventResponse;
            }
            Iterator i = events.iterator();
            NotificationEventResponse result = new NotificationEventResponse();
            result.setEvents(new ArrayList<NotificationEvent>());
            int maxEvents = rqst.getMaxEvents() > 0 ? rqst.getMaxEvents() : Integer.MAX_VALUE;
            int numEvents = 0;
            while (i.hasNext() && numEvents++ < maxEvents) {
                result.addToEvents(this.translateDbToThrift((MNotificationLog)i.next()));
            }
            NotificationEventResponse notificationEventResponse = result;
            return notificationEventResponse;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
            if (!commited) {
                this.rollbackTransaction();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationEvent(NotificationEvent entry) {
        boolean commited = false;
        Query query = null;
        try {
            boolean needToPersistId;
            this.openTransaction();
            query = this.pm.newQuery(MNotificationNextId.class);
            Collection ids = (Collection)query.execute();
            MNotificationNextId id = null;
            if (ids == null || ids.size() == 0) {
                id = new MNotificationNextId(1L);
                needToPersistId = true;
            } else {
                id = (MNotificationNextId)ids.iterator().next();
                needToPersistId = false;
            }
            entry.setEventId(id.getNextEventId());
            id.incrementEventId();
            if (needToPersistId) {
                this.pm.makePersistent((Object)id);
            }
            this.pm.makePersistent((Object)this.translateThriftToDb(entry));
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanNotificationEvents(int olderThan) {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            long tmp = System.currentTimeMillis() / 1000L - (long)olderThan;
            int tooOld = tmp > Integer.MAX_VALUE ? 0 : (int)tmp;
            query = this.pm.newQuery(MNotificationLog.class, "eventTime < tooOld");
            query.declareParameters("java.lang.Integer tooOld");
            Collection toBeRemoved = (Collection)query.execute((Object)tooOld);
            if (toBeRemoved != null && toBeRemoved.size() > 0) {
                this.pm.deletePersistent((Object)toBeRemoved);
            }
            commited = this.commitTransaction();
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CurrentNotificationEventId getCurrentNotificationEventId() {
        boolean commited = false;
        Query query = null;
        try {
            this.openTransaction();
            query = this.pm.newQuery(MNotificationNextId.class);
            Collection ids = (Collection)query.execute();
            long id = 0L;
            if (ids != null && ids.size() > 0) {
                id = ((MNotificationNextId)ids.iterator().next()).getNextEventId() - 1L;
            }
            commited = this.commitTransaction();
            CurrentNotificationEventId currentNotificationEventId = new CurrentNotificationEventId(id);
            return currentNotificationEventId;
        }
        finally {
            if (!commited) {
                this.rollbackTransaction();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private MNotificationLog translateThriftToDb(NotificationEvent entry) {
        MNotificationLog dbEntry = new MNotificationLog();
        dbEntry.setEventId(entry.getEventId());
        dbEntry.setEventTime(entry.getEventTime());
        dbEntry.setEventType(entry.getEventType());
        dbEntry.setDbName(entry.getDbName());
        dbEntry.setTableName(entry.getTableName());
        dbEntry.setMessage(entry.getMessage());
        return dbEntry;
    }

    private NotificationEvent translateDbToThrift(MNotificationLog dbEvent) {
        NotificationEvent event = new NotificationEvent();
        event.setEventId(dbEvent.getEventId());
        event.setEventTime(dbEvent.getEventTime());
        event.setEventType(dbEvent.getEventType());
        event.setDbName(dbEvent.getDbName());
        event.setTableName(dbEvent.getTableName());
        event.setMessage(dbEvent.getMessage());
        return event;
    }

    @Override
    public ByteBuffer[] getFileMetadata(List<Long> fileIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFileMetadataSupported() {
        return false;
    }

    @Override
    public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr, ByteBuffer[] metadatas, ByteBuffer[] stripeBitsets, boolean[] eliminated) {
        throw new UnsupportedOperationException();
    }

    public static void unCacheDataNucleusClassLoaders() {
        PersistenceManagerFactory pmf = ObjectStore.getPMF();
        if (pmf != null && pmf instanceof JDOPersistenceManagerFactory) {
            JDOPersistenceManagerFactory jdoPmf = (JDOPersistenceManagerFactory)pmf;
            PersistenceNucleusContext nc = jdoPmf.getNucleusContext();
            try {
                Field classLoaderResolverMap = AbstractNucleusContext.class.getDeclaredField("classLoaderResolverMap");
                classLoaderResolverMap.setAccessible(true);
                classLoaderResolverMap.set(nc, new HashMap());
                LOG.debug("Removed cached classloaders from DataNucleus NucleusContext");
            }
            catch (Exception e) {
                LOG.warn("Failed to remove cached classloaders from DataNucleus NucleusContext ", (Throwable)e);
            }
        }
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("table", MTable.class);
        map.put("storagedescriptor", MStorageDescriptor.class);
        map.put("serdeinfo", MSerDeInfo.class);
        map.put("partition", MPartition.class);
        map.put("database", MDatabase.class);
        map.put("type", MType.class);
        map.put("fieldschema", MFieldSchema.class);
        map.put("order", MOrder.class);
        PINCLASSMAP = Collections.unmodifiableMap(map);
        String hostname = "UNKNOWN";
        try {
            InetAddress clientAddr = InetAddress.getLocalHost();
            hostname = clientAddr.getHostAddress();
        }
        catch (IOException e) {
            // empty catch block
        }
        HOSTNAME = hostname;
        String user = System.getenv("USER");
        USER = user == null ? "UNKNOWN" : user;
    }

    public class UpdateSerdeURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateSerdeURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdateMStorageDescriptorTblURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;
        private int numNullRecords;

        UpdateMStorageDescriptorTblURIRetVal(List<String> badRecords, Map<String, String> updateLocations, int numNullRecords) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
            this.numNullRecords = numNullRecords;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }

        public int getNumNullRecords() {
            return this.numNullRecords;
        }

        public void setNumNullRecords(int numNullRecords) {
            this.numNullRecords = numNullRecords;
        }
    }

    public class UpdatePropURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdatePropURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    public class UpdateMDatabaseURIRetVal {
        private List<String> badRecords;
        private Map<String, String> updateLocations;

        UpdateMDatabaseURIRetVal(List<String> badRecords, Map<String, String> updateLocations) {
            this.badRecords = badRecords;
            this.updateLocations = updateLocations;
        }

        public List<String> getBadRecords() {
            return this.badRecords;
        }

        public void setBadRecords(List<String> badRecords) {
            this.badRecords = badRecords;
        }

        public Map<String, String> getUpdateLocations() {
            return this.updateLocations;
        }

        public void setUpdateLocations(Map<String, String> updateLocations) {
            this.updateLocations = updateLocations;
        }
    }

    private abstract class GetStatHelper
    extends GetHelper<ColumnStatistics> {
        public GetStatHelper(String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(dbName, tblName, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return "statistics for " + (this.results == null ? 0 : ((ColumnStatistics)this.results).getStatsObjSize()) + " columns";
        }
    }

    private abstract class GetDbHelper
    extends GetHelper<Database> {
        public GetDbHelper(String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(dbName, null, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return "db details for db " + this.dbName;
        }
    }

    private abstract class GetListHelper<T>
    extends GetHelper<List<T>> {
        public GetListHelper(String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            super(dbName, tblName, allowSql, allowJdo);
        }

        @Override
        protected String describeResult() {
            return ((List)this.results).size() + " entries";
        }
    }

    private abstract class GetHelper<T> {
        private final boolean isInTxn;
        private final boolean doTrace;
        private final boolean allowJdo;
        private boolean doUseDirectSql;
        private long start;
        private Table table;
        protected final String dbName;
        protected final String tblName;
        private boolean success = false;
        protected T results = null;

        public GetHelper(String dbName, String tblName, boolean allowSql, boolean allowJdo) throws MetaException {
            boolean isConfigEnabled;
            assert (allowSql || allowJdo);
            this.allowJdo = allowJdo;
            this.dbName = HiveStringUtils.normalizeIdentifier((String)dbName);
            if (tblName != null) {
                this.tblName = HiveStringUtils.normalizeIdentifier((String)tblName);
            } else {
                this.tblName = null;
                this.table = null;
            }
            this.doTrace = LOG.isDebugEnabled();
            this.isInTxn = ObjectStore.this.isActiveTransaction();
            boolean bl = isConfigEnabled = HiveConf.getBoolVar((Configuration)ObjectStore.this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL) && (HiveConf.getBoolVar((Configuration)ObjectStore.this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL_DDL) || !this.isInTxn);
            if (!allowJdo && isConfigEnabled && !ObjectStore.this.directSql.isCompatibleDatastore()) {
                throw new MetaException("SQL is not operational");
            }
            this.doUseDirectSql = allowSql && isConfigEnabled && ObjectStore.this.directSql.isCompatibleDatastore();
        }

        protected abstract String describeResult();

        protected abstract T getSqlResult(GetHelper<T> var1) throws MetaException;

        protected abstract T getJdoResult(GetHelper<T> var1) throws MetaException, NoSuchObjectException;

        public T run(boolean initTable) throws MetaException, NoSuchObjectException {
            try {
                this.start(initTable);
                if (this.doUseDirectSql) {
                    try {
                        ObjectStore.this.directSql.prepareTxn();
                        this.setResult(this.getSqlResult(this));
                    }
                    catch (Exception ex) {
                        this.handleDirectSqlError(ex);
                    }
                }
                if (!this.doUseDirectSql) {
                    this.setResult(this.getJdoResult(this));
                }
                T ex = this.commit();
                return ex;
            }
            catch (NoSuchObjectException ex) {
                throw ex;
            }
            catch (MetaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
                throw new MetaException(ex.getMessage());
            }
            finally {
                this.close();
            }
        }

        private void start(boolean initTable) throws MetaException, NoSuchObjectException {
            this.start = this.doTrace ? System.nanoTime() : 0L;
            ObjectStore.this.openTransaction();
            if (initTable && this.tblName != null) {
                this.table = ObjectStore.this.ensureGetTable(this.dbName, this.tblName);
            }
        }

        private boolean setResult(T results) {
            this.results = results;
            return this.results != null;
        }

        private void handleDirectSqlError(Exception ex) throws MetaException, NoSuchObjectException {
            LOG.warn("Direct SQL failed" + (this.allowJdo ? ", falling back to ORM" : ""), (Throwable)ex);
            if (!this.allowJdo) {
                if (ex instanceof MetaException) {
                    throw (MetaException)((Object)ex);
                }
                throw new MetaException(ex.getMessage());
            }
            if (!this.isInTxn) {
                JDOException rollbackEx = null;
                try {
                    ObjectStore.this.rollbackTransaction();
                }
                catch (JDOException jex) {
                    rollbackEx = jex;
                }
                if (rollbackEx != null) {
                    if (ObjectStore.this.currentTransaction != null && ObjectStore.this.currentTransaction.isActive()) {
                        throw rollbackEx;
                    }
                    LOG.info("Ignoring exception, rollback succeeded: " + rollbackEx.getMessage());
                }
                this.start = this.doTrace ? System.nanoTime() : 0L;
                ObjectStore.this.openTransaction();
                if (this.table != null) {
                    this.table = ObjectStore.this.ensureGetTable(this.dbName, this.tblName);
                }
            } else {
                this.start = this.doTrace ? System.nanoTime() : 0L;
            }
            this.doUseDirectSql = false;
        }

        public void disableDirectSql() {
            this.doUseDirectSql = false;
        }

        private T commit() {
            this.success = ObjectStore.this.commitTransaction();
            if (this.doTrace) {
                LOG.debug(this.describeResult() + " retrieved using " + (this.doUseDirectSql ? "SQL" : "ORM") + " in " + (double)(System.nanoTime() - this.start) / 1000000.0 + "ms");
            }
            return this.results;
        }

        private void close() {
            if (!this.success) {
                ObjectStore.this.rollbackTransaction();
            }
        }

        public Table getTable() {
            return this.table;
        }
    }

    public static class QueryWrapper {
        public Query query;

        public void close() {
            if (this.query != null) {
                this.query.closeAll();
                this.query = null;
            }
        }

        protected void finalize() {
            this.close();
        }
    }

    private static enum TXN_STATUS {
        NO_STATE,
        OPEN,
        COMMITED,
        ROLLBACK;

    }
}

