/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.listener;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotificationListener
extends MetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbNotificationListener.class.getName());
    private static CleanerThread cleaner = null;
    private HiveConf hiveConf;
    private MessageFactory msgFactory;
    private RawStore rs;

    private synchronized void init(HiveConf conf) {
        try {
            this.rs = RawStoreProxy.getProxy((HiveConf)conf, (Configuration)conf, (String)conf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL), (int)999999);
        }
        catch (MetaException e) {
            LOG.error("Unable to connect to raw store, notifications will not be tracked", (Throwable)e);
            this.rs = null;
        }
        if (cleaner == null && this.rs != null) {
            cleaner = new CleanerThread(conf, this.rs);
            cleaner.start();
        }
    }

    public DbNotificationListener(Configuration config) {
        super(config);
        this.hiveConf = (HiveConf)config;
        this.init(this.hiveConf);
        this.msgFactory = MessageFactory.getInstance();
    }

    public void onConfigChange(ConfigChangeEvent tableEvent) throws MetaException {
        String key = tableEvent.getKey();
        if (key.equals(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.toString())) {
            this.hiveConf.set(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.name(), tableEvent.getNewValue());
            cleaner.setTimeToLive(this.hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "CREATE_TABLE", this.msgFactory.buildCreateTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "DROP_TABLE", this.msgFactory.buildDropTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        Table before = tableEvent.getOldTable();
        Table after = tableEvent.getNewTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "ALTER_TABLE", this.msgFactory.buildAlterTableMessage(before, after).toString());
        event.setDbName(after.getDbName());
        event.setTableName(after.getTableName());
        this.enqueue(event);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "ADD_PARTITION", this.msgFactory.buildAddPartitionMessage(t, partitionEvent.getPartitionIterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "DROP_PARTITION", this.msgFactory.buildDropPartitionMessage(t, partitionEvent.getPartitionIterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event);
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        Partition before = partitionEvent.getOldPartition();
        Partition after = partitionEvent.getNewPartition();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "ALTER_PARTITION", this.msgFactory.buildAlterPartitionMessage(partitionEvent.getTable(), before, after).toString());
        event.setDbName(before.getDbName());
        event.setTableName(before.getTableName());
        this.enqueue(event);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "CREATE_DATABASE", this.msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.enqueue(event);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), "DROP_DATABASE", this.msgFactory.buildDropDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.enqueue(event);
    }

    public void onInsert(InsertEvent insertEvent) throws MetaException {
        NotificationEvent event = new NotificationEvent(0L, this.now(), "INSERT", this.msgFactory.buildInsertMessage(insertEvent.getDb(), insertEvent.getTable(), insertEvent.getPartitionKeyValues(), insertEvent.getFiles()).toString());
        event.setDbName(insertEvent.getDb());
        event.setTableName(insertEvent.getTable());
        this.enqueue(event);
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partSetDoneEvent) throws MetaException {
    }

    private int now() {
        long millis = System.currentTimeMillis();
        if ((millis /= 1000L) > Integer.MAX_VALUE) {
            LOG.warn("We've passed max int value in seconds since the epoch, all notification times will be the same!");
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    private void enqueue(NotificationEvent event) {
        if (this.rs != null) {
            this.rs.addNotificationEvent(event);
        } else {
            LOG.warn("Dropping event " + event + " since notification is not running.");
        }
    }

    private static class CleanerThread
    extends Thread {
        private RawStore rs;
        private int ttl;

        CleanerThread(HiveConf conf, RawStore rs) {
            super("CleanerThread");
            this.rs = rs;
            this.setTimeToLive(conf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.rs.cleanNotificationEvents(this.ttl);
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Cleaner thread sleep interupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public void setTimeToLive(long configTtl) {
            this.ttl = configTtl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)configTtl;
        }
    }
}

