/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.util.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.http.HttpServer;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.logging.log4j.util.Strings;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveServer2
extends CompositeService {
    private static CountDownLatch deleteSignal;
    private static final Logger LOG;
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;
    private PersistentEphemeralNode znode;
    private String znodePath;
    private CuratorFramework zooKeeperClient;
    private boolean registeredWithZooKeeper = false;
    private HttpServer webServer;
    private final ACLProvider zooKeeperAclProvider = new ACLProvider(){
        List<ACL> nodeAcls = new ArrayList<ACL>();

        public List<ACL> getDefaultAcl() {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.nodeAcls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
                this.nodeAcls.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            } else {
                this.nodeAcls.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
            }
            return this.nodeAcls;
        }

        public List<ACL> getAclForPath(String path) {
            return this.getDefaultAcl();
        }
    };

    public HiveServer2() {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService(this);
        this.addService(this.cliService);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            try {
                Path scratchDir = new Path(HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR));
                FileSystem fs = FileSystem.get((Configuration)hiveConf);
                if (!fs.exists(scratchDir)) {
                    fs.mkdirs(scratchDir);
                }
                fs.setPermission(scratchDir, new FsPermission(511));
            }
            catch (IOException e) {
                LOG.warn(String.format("Failed to create/change scratchdir permissions to 777: %s", e.getMessage()), (Throwable)e);
            }
        }
        final HiveServer2 hiveServer2 = this;
        Runnable oomHook = new Runnable(){

            @Override
            public void run() {
                hiveServer2.stop();
            }
        };
        this.thriftCLIService = HiveServer2.isHTTPTransportMode(hiveConf) ? new ThriftHttpCLIService(this.cliService, oomHook) : new ThriftBinaryCLIService(this.cliService, oomHook);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
        try {
            hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.getServerHost());
        }
        catch (Throwable t) {
            throw new Error("Unable to intitialize HiveServer2", t);
        }
        try {
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                LOG.info("Web UI is disabled since in test mode");
            } else {
                int webUIPort = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT);
                if (webUIPort <= 0) {
                    LOG.info("Web UI is disabled since port is set to " + webUIPort);
                } else {
                    HttpServer.Builder builder = new HttpServer.Builder();
                    builder.setName("hiveserver2").setPort(webUIPort).setConf(hiveConf);
                    builder.setHost(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_BIND_HOST));
                    builder.setMaxThreads(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_MAX_THREADS));
                    builder.setAdmins(hiveConf.getVar(HiveConf.ConfVars.USERS_IN_ADMIN_ROLE));
                    builder.setContextAttribute("hive.sm", (Object)this.cliService.getSessionManager());
                    hiveConf.set("startcode", String.valueOf(System.currentTimeMillis()));
                    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL)) {
                        String keyStorePath = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH);
                        if (Strings.isBlank((String)keyStorePath)) {
                            throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                        }
                        builder.setKeyStorePassword(ShimLoader.getHadoopShims().getPassword((Configuration)hiveConf, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PASSWORD.varname));
                        builder.setKeyStorePath(keyStorePath);
                        builder.setUseSSL(true);
                    }
                    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SPNEGO)) {
                        String spnegoPrincipal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_PRINCIPAL);
                        String spnegoKeytab = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_KEYTAB);
                        if (Strings.isBlank((String)spnegoPrincipal) || Strings.isBlank((String)spnegoKeytab)) {
                            throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_PRINCIPAL.varname + "/" + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_KEYTAB.varname + " Not configured for SPNEGO authentication");
                        }
                        builder.setSPNEGOPrincipal(spnegoPrincipal);
                        builder.setSPNEGOKeytab(spnegoKeytab);
                        builder.setUseSPNEGO(true);
                    }
                    this.webServer = builder.build();
                }
            }
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                hiveServer2.stop();
            }
        });
    }

    public static boolean isHTTPTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    public static boolean isKerberosAuthMode(HiveConf hiveConf) {
        String authMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        return authMode != null && authMode.equalsIgnoreCase("KERBEROS");
    }

    private void addServerInstanceToZooKeeper(HiveConf hiveConf) throws Exception {
        HashMap<String, String> confsToPublish;
        String instanceURI;
        String rootNamespace;
        block7: {
            String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
            rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
            instanceURI = this.getServerInstanceURI();
            this.setUpZooKeeperAuth(hiveConf);
            confsToPublish = new HashMap<String, String>();
            this.addConfsToPublish(hiveConf, confsToPublish);
            int sessionTimeout = (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
            int baseSleepTime = (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS);
            int maxRetries = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_MAX_RETRIES);
            this.zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).sessionTimeoutMs(sessionTimeout).aclProvider(this.zooKeeperAclProvider).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseSleepTime, maxRetries)).build();
            this.zooKeeperClient.start();
            try {
                ((ACLBackgroundPathAndBytesable)this.zooKeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/" + rootNamespace);
                LOG.info("Created the root name space: " + rootNamespace + " on ZooKeeper for HiveServer2");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block7;
                LOG.error("Unable to create HiveServer2 namespace: " + rootNamespace + " on ZooKeeper", (Throwable)e);
                throw e;
            }
        }
        try {
            String pathPrefix = "/" + rootNamespace + "/" + "serverUri=" + instanceURI + ";" + "version=" + HiveVersionInfo.getVersion() + ";" + "sequence=";
            String znodeData = "";
            znodeData = Joiner.on((char)';').withKeyValueSeparator("=").join(confsToPublish);
            byte[] znodeDataUTF8 = znodeData.getBytes(Charset.forName("UTF-8"));
            this.znode = new PersistentEphemeralNode(this.zooKeeperClient, PersistentEphemeralNode.Mode.EPHEMERAL_SEQUENTIAL, pathPrefix, znodeDataUTF8);
            this.znode.start();
            long znodeCreationTimeout = 120L;
            if (!this.znode.waitForInitialCreate(znodeCreationTimeout, TimeUnit.SECONDS)) {
                throw new Exception("Max znode creation wait time: " + znodeCreationTimeout + "s exhausted");
            }
            this.setRegisteredWithZooKeeper(true);
            this.znodePath = this.znode.getActualPath();
            if (((BackgroundPathable)this.zooKeeperClient.checkExists().usingWatcher((Watcher)new DeRegisterWatcher())).forPath(this.znodePath) == null) {
                throw new Exception("Unable to create znode for this HiveServer2 instance on ZooKeeper.");
            }
            LOG.info("Created a znode on ZooKeeper for HiveServer2 uri: " + instanceURI);
        }
        catch (Exception e) {
            LOG.error("Unable to create a znode for this server instance", (Throwable)e);
            if (this.znode != null) {
                this.znode.close();
            }
            throw e;
        }
    }

    private void addConfsToPublish(HiveConf hiveConf, Map<String, String> confsToPublish) {
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST));
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE));
        if (HiveServer2.isHTTPTransportMode(hiveConf)) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
        } else {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION));
        if (HiveServer2.isKerberosAuthMode(hiveConf)) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL));
    }

    private void setUpZooKeeperAuth(HiveConf hiveConf) throws Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
            if (principal.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos principal is empty");
            }
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
            if (keyTabFile.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos keytab is empty");
            }
            Utils.setZookeeperClientKerberosJaasConfig((String)principal, (String)keyTabFile);
        }
    }

    private void removeServerInstanceFromZooKeeper() throws Exception {
        this.setRegisteredWithZooKeeper(false);
        if (this.znode != null) {
            this.znode.close();
        }
        this.zooKeeperClient.close();
        LOG.info("Server instance removed from ZooKeeper.");
    }

    public boolean isRegisteredWithZooKeeper() {
        return this.registeredWithZooKeeper;
    }

    private void setRegisteredWithZooKeeper(boolean registeredWithZooKeeper) {
        this.registeredWithZooKeeper = registeredWithZooKeeper;
    }

    private String getServerInstanceURI() throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName() + ":" + this.thriftCLIService.getPortNumber();
    }

    private String getServerHost() throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName();
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.webServer != null) {
            try {
                this.webServer.start();
                LOG.info("Web UI has started on port " + this.webServer.getPort());
            }
            catch (Exception e) {
                LOG.error("Error starting Web UI: ", (Throwable)e);
                throw new ServiceException(e);
            }
        }
    }

    @Override
    public synchronized void stop() {
        LOG.info("Shutting down HiveServer2");
        HiveConf hiveConf = this.getHiveConf();
        super.stop();
        if (this.webServer != null) {
            try {
                this.webServer.stop();
                LOG.info("Web UI has stopped");
            }
            catch (Exception e) {
                LOG.error("Error stopping Web UI: ", (Throwable)e);
            }
        }
        if (MetricsFactory.getInstance() != null) {
            try {
                MetricsFactory.close();
            }
            catch (Exception e) {
                LOG.error("error in Metrics deinit: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            }
        }
        if (hiveConf != null && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY)) {
            try {
                this.removeServerInstanceFromZooKeeper();
            }
            catch (Exception e) {
                LOG.error("Error removing znode for this HiveServer2 instance from ZooKeeper.", (Throwable)e);
            }
        }
        if (hiveConf != null && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
            try {
                TezSessionPoolManager.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error("Tez session pool manager stop had an error during stop of HiveServer2. Shutting down HiveServer2 anyway.", (Throwable)e);
            }
        }
        if (hiveConf != null && hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
            try {
                SparkSessionManagerImpl.getInstance().shutdown();
            }
            catch (Exception ex) {
                LOG.error("Spark session pool manager failed to stop during HiveServer2 shutdown.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            LOG.info("Starting HiveServer2");
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                TezSessionPoolManager sessionPool = null;
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
                    sessionPool = TezSessionPoolManager.getInstance();
                    sessionPool.setupPool(hiveConf);
                }
                ServerUtils.cleanUpScratchDir((HiveConf)hiveConf);
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
                    MetricsFactory.init((HiveConf)hiveConf);
                }
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor((Configuration)hiveConf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
                }
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY)) {
                    server.addServerInstanceToZooKeeper(hiveConf);
                }
                if (sessionPool != null) {
                    sessionPool.startPool();
                }
                if (!hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) break;
                SparkSessionManagerImpl.getInstance().setup(hiveConf);
            }
            catch (Throwable throwable) {
                if (server != null) {
                    try {
                        server.stop();
                    }
                    catch (Throwable t) {
                        LOG.info("Exception caught when calling stop of HiveServer2 before retrying start", t);
                    }
                    finally {
                        server = null;
                    }
                }
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds", throwable);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    static void deleteServerInstancesFromZooKeeper(String versionNumber) throws Exception {
        HiveConf hiveConf = new HiveConf();
        String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
        String rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
        int baseSleepTime = (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS);
        int maxRetries = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_MAX_RETRIES);
        CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseSleepTime, maxRetries)).build();
        zooKeeperClient.start();
        List znodePaths = (List)zooKeeperClient.getChildren().forPath("/" + rootNamespace);
        for (int i = 0; i < znodePaths.size(); ++i) {
            String znodePath = (String)znodePaths.get(i);
            deleteSignal = new CountDownLatch(1);
            if (!znodePath.contains("version=" + versionNumber + ";")) continue;
            String fullZnodePath = "/" + rootNamespace + "/" + znodePath;
            LOG.warn("Will attempt to remove the znode: " + fullZnodePath + " from ZooKeeper");
            System.out.println("Will attempt to remove the znode: " + fullZnodePath + " from ZooKeeper");
            ((Pathable)zooKeeperClient.delete().guaranteed().inBackground((BackgroundCallback)new DeleteCallBack())).forPath(fullZnodePath);
            deleteSignal.await();
            List znodePathsUpdated = (List)zooKeeperClient.getChildren().forPath("/" + rootNamespace);
            znodePathsUpdated.removeAll(znodePaths);
            znodePaths.addAll(znodePathsUpdated);
        }
        zooKeeperClient.close();
    }

    public static void main(String[] args) {
        HiveConf.setLoadHiveServer2Config((boolean)true);
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            ServerOptionsProcessorResponse oprocResponse = oproc.parse(args);
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug(initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Logger)LOG);
            LOG.debug(oproc.getDebugMessage().toString());
            oprocResponse.getServerOptionsExecutor().execute();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error("Error initializing log: " + e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(HiveServer2.class);
    }

    static class DeregisterOptionExecutor
    implements ServerOptionsExecutor {
        private final String versionNumber;

        DeregisterOptionExecutor(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public void execute() {
            try {
                HiveServer2.deleteServerInstancesFromZooKeeper(this.versionNumber);
            }
            catch (Exception e) {
                LOG.error("Error deregistering HiveServer2 instances for version: " + this.versionNumber + " from ZooKeeper", (Throwable)e);
                System.out.println("Error deregistering HiveServer2 instances for version: " + this.versionNumber + " from ZooKeeper." + e);
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static class StartOptionExecutor
    implements ServerOptionsExecutor {
        StartOptionExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveServer2.startHiveServer2();
            }
            catch (Throwable t) {
                LOG.error("Error starting HiveServer2", t);
                System.exit(-1);
            }
        }
    }

    static class HelpOptionExecutor
    implements ServerOptionsExecutor {
        private final Options options;
        private final String serverName;

        HelpOptionExecutor(String serverName, Options options) {
            this.options = options;
            this.serverName = serverName;
        }

        @Override
        public void execute() {
            new HelpFormatter().printHelp(this.serverName, this.options);
            System.exit(0);
        }
    }

    static interface ServerOptionsExecutor {
        public void execute();
    }

    static class ServerOptionsProcessorResponse {
        private final ServerOptionsExecutor serverOptionsExecutor;

        ServerOptionsProcessorResponse(ServerOptionsExecutor serverOptionsExecutor) {
            this.serverOptionsExecutor = serverOptionsExecutor;
        }

        ServerOptionsExecutor getServerOptionsExecutor() {
            return this.serverOptionsExecutor;
        }
    }

    static class ServerOptionsProcessor {
        private final Options options = new Options();
        private CommandLine commandLine;
        private final String serverName;
        private final StringBuilder debugMessage = new StringBuilder();

        ServerOptionsProcessor(String serverName) {
            this.serverName = serverName;
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withLongOpt((String)"hiveconf");
            OptionBuilder.withDescription((String)"Use value for given property");
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.hasArgs((int)1);
            OptionBuilder.withArgName((String)"versionNumber");
            OptionBuilder.withLongOpt((String)"deregister");
            OptionBuilder.withDescription((String)"Deregister all instances of given version from dynamic service discovery");
            this.options.addOption(OptionBuilder.create());
            this.options.addOption(new Option("H", "help", false, "Print help information"));
        }

        ServerOptionsProcessorResponse parse(String[] argv) {
            try {
                this.commandLine = new GnuParser().parse(this.options, argv);
                Properties confProps = this.commandLine.getOptionProperties("hiveconf");
                for (String propKey : confProps.stringPropertyNames()) {
                    this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                    System.setProperty(propKey, confProps.getProperty(propKey));
                }
                if (this.commandLine.hasOption('H')) {
                    return new ServerOptionsProcessorResponse(new HelpOptionExecutor(this.serverName, this.options));
                }
                if (this.commandLine.hasOption("deregister")) {
                    return new ServerOptionsProcessorResponse(new DeregisterOptionExecutor(this.commandLine.getOptionValue("deregister")));
                }
            }
            catch (ParseException e) {
                System.err.println("Error starting HiveServer2 with given arguments: ");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return new ServerOptionsProcessorResponse(new StartOptionExecutor());
        }

        StringBuilder getDebugMessage() {
            return this.debugMessage;
        }
    }

    private static class DeleteCallBack
    implements BackgroundCallback {
        private DeleteCallBack() {
        }

        public void processResult(CuratorFramework zooKeeperClient, CuratorEvent event) throws Exception {
            if (event.getType() == CuratorEventType.DELETE) {
                deleteSignal.countDown();
            }
        }
    }

    private class DeRegisterWatcher
    implements Watcher {
        private DeRegisterWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted) && HiveServer2.this.znode != null) {
                try {
                    HiveServer2.this.znode.close();
                    LOG.warn("This HiveServer2 instance is now de-registered from ZooKeeper. The server will be shut down after the last client sesssion completes.");
                }
                catch (IOException e) {
                    LOG.error("Failed to close the persistent ephemeral znode", (Throwable)e);
                }
                finally {
                    HiveServer2.this.setRegisteredWithZooKeeper(false);
                    if (HiveServer2.this.cliService.getSessionManager().getOpenSessionCount() == 0) {
                        LOG.warn("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                        HiveServer2.this.stop();
                    }
                }
            }
        }
    }
}

