/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Range;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloRangeGenerator;
import org.apache.hadoop.hive.accumulo.predicate.NoSuchCompareOpException;
import org.apache.hadoop.hive.accumulo.predicate.NoSuchPrimitiveComparisonException;
import org.apache.hadoop.hive.accumulo.predicate.PrimitiveComparisonFilter;
import org.apache.hadoop.hive.accumulo.predicate.PushdownTuple;
import org.apache.hadoop.hive.accumulo.predicate.compare.CompareOp;
import org.apache.hadoop.hive.accumulo.predicate.compare.DoubleCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.IntCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.Like;
import org.apache.hadoop.hive.accumulo.predicate.compare.LongCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.apache.hadoop.hive.accumulo.predicate.compare.StringCompare;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloPredicateHandler {
    private static final List<Range> TOTAL_RANGE = Collections.singletonList(new Range());
    private static AccumuloPredicateHandler handler = new AccumuloPredicateHandler();
    private static Map<String, Class<? extends CompareOp>> compareOps = Maps.newHashMap();
    private static Map<String, Class<? extends PrimitiveComparison>> pComparisons = Maps.newHashMap();
    private static int iteratorCount = 50;
    private static final Logger log = LoggerFactory.getLogger(AccumuloPredicateHandler.class);

    public static AccumuloPredicateHandler getInstance() {
        return handler;
    }

    public Set<String> cOpKeyset() {
        return compareOps.keySet();
    }

    public Set<String> pComparisonKeyset() {
        return pComparisons.keySet();
    }

    public Class<? extends CompareOp> getCompareOpClass(String udfType) throws NoSuchCompareOpException {
        if (!compareOps.containsKey(udfType)) {
            throw new NoSuchCompareOpException("Null compare op for specified key: " + udfType);
        }
        return compareOps.get(udfType);
    }

    public CompareOp getCompareOp(String udfType, IndexSearchCondition sc) throws NoSuchCompareOpException, SerDeException {
        Class<? extends CompareOp> clz = this.getCompareOpClass(udfType);
        try {
            return clz.newInstance();
        }
        catch (ClassCastException e) {
            throw new SerDeException("Column type mismatch in WHERE clause " + sc.getComparisonExpr().getExprString() + " found type " + sc.getConstantDesc().getTypeString() + " instead of " + sc.getColumnDesc().getTypeString());
        }
        catch (IllegalAccessException e) {
            throw new SerDeException("Could not instantiate class for WHERE clause", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SerDeException("Could not instantiate class for WHERE clause", (Throwable)e);
        }
    }

    public Class<? extends PrimitiveComparison> getPrimitiveComparisonClass(String type) throws NoSuchPrimitiveComparisonException {
        if (!pComparisons.containsKey(type)) {
            throw new NoSuchPrimitiveComparisonException("Null primitive comparison for specified key: " + type);
        }
        return pComparisons.get(type);
    }

    public PrimitiveComparison getPrimitiveComparison(String type, IndexSearchCondition sc) throws NoSuchPrimitiveComparisonException, SerDeException {
        Class<? extends PrimitiveComparison> clz = this.getPrimitiveComparisonClass(type);
        try {
            return clz.newInstance();
        }
        catch (ClassCastException e) {
            throw new SerDeException("Column type mismatch in WHERE clause " + sc.getComparisonExpr().getExprString() + " found type " + sc.getConstantDesc().getTypeString() + " instead of " + sc.getColumnDesc().getTypeString());
        }
        catch (IllegalAccessException e) {
            throw new SerDeException("Could not instantiate class for WHERE clause", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SerDeException("Could not instantiate class for WHERE clause", (Throwable)e);
        }
    }

    private AccumuloPredicateHandler() {
    }

    public List<Range> getRanges(Configuration conf, ColumnMapper columnMapper) throws SerDeException {
        if (!columnMapper.hasRowIdMapping()) {
            return TOTAL_RANGE;
        }
        int rowIdOffset = columnMapper.getRowIdOffset();
        String[] hiveColumnNamesArr = conf.getStrings("columns");
        if (null == hiveColumnNamesArr) {
            throw new IllegalArgumentException("Could not find Hive columns in configuration");
        }
        String hiveRowIdColumnName = hiveColumnNamesArr[rowIdOffset];
        ExprNodeDesc root = this.getExpression(conf);
        if (null == root) {
            return TOTAL_RANGE;
        }
        Object result = this.generateRanges(columnMapper, hiveRowIdColumnName, root);
        if (null == result) {
            log.info("Calculated null set of ranges, scanning full table");
            return TOTAL_RANGE;
        }
        if (result instanceof Range) {
            log.info("Computed a single Range for the query: " + result);
            return Collections.singletonList((Range)result);
        }
        if (result instanceof List) {
            log.info("Computed a collection of Ranges for the query: " + result);
            List ranges = (List)result;
            return ranges;
        }
        throw new IllegalArgumentException("Unhandled return from Range generation: " + result);
    }

    protected Object generateRanges(ColumnMapper columnMapper, String hiveRowIdColumnName, ExprNodeDesc root) {
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(handler, columnMapper.getRowIdMapping(), hiveRowIdColumnName);
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeDesc> roots = new ArrayList<ExprNodeDesc>();
        roots.add(root);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(roots, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        return nodeOutput.get(root);
    }

    public List<IteratorSetting> getIterators(Configuration conf, ColumnMapper columnMapper) throws SerDeException {
        ArrayList itrs = Lists.newArrayList();
        boolean shouldPushdown = conf.getBoolean("accumulo.iterator.pushdown", true);
        if (!shouldPushdown) {
            log.info("Iterator pushdown is disabled for this table");
            return itrs;
        }
        int rowIdOffset = columnMapper.getRowIdOffset();
        String[] hiveColumnNamesArr = conf.getStrings("columns");
        if (null == hiveColumnNamesArr) {
            throw new IllegalArgumentException("Could not find Hive columns in configuration");
        }
        String hiveRowIdColumnName = null;
        if (rowIdOffset >= 0 && rowIdOffset < hiveColumnNamesArr.length) {
            hiveRowIdColumnName = hiveColumnNamesArr[rowIdOffset];
        }
        List<String> hiveColumnNames = Arrays.asList(hiveColumnNamesArr);
        for (IndexSearchCondition sc : this.getSearchConditions(conf)) {
            String col = sc.getColumnDesc().getColumn();
            if (hiveRowIdColumnName != null && hiveRowIdColumnName.equals(col)) continue;
            HiveAccumuloColumnMapping mapping = (HiveAccumuloColumnMapping)columnMapper.getColumnMappingForHiveColumn(hiveColumnNames, col);
            itrs.add(this.toSetting(mapping, sc));
        }
        if (log.isInfoEnabled()) {
            log.info("num iterators = " + itrs.size());
        }
        return itrs;
    }

    public IteratorSetting toSetting(HiveAccumuloColumnMapping accumuloColumnMapping, IndexSearchCondition sc) throws SerDeException {
        PushdownTuple tuple;
        IteratorSetting is = new IteratorSetting(++iteratorCount, "accumulo.filter.compare.iterator." + iteratorCount, PrimitiveComparisonFilter.class);
        String type = sc.getColumnDesc().getTypeString();
        String comparisonOpStr = sc.getComparisonOp();
        try {
            tuple = new PushdownTuple(sc, this.getPrimitiveComparison(type, sc), this.getCompareOp(comparisonOpStr, sc));
        }
        catch (NoSuchPrimitiveComparisonException e) {
            throw new SerDeException("No configured PrimitiveComparison class for " + type, (Throwable)e);
        }
        catch (NoSuchCompareOpException e) {
            throw new SerDeException("No configured CompareOp class for " + comparisonOpStr, (Throwable)e);
        }
        is.addOption("accumulo.filter.iterator.p.compare.class", tuple.getpCompare().getClass().getName());
        is.addOption("accumulo.filter.iterator.compare.opt.class", tuple.getcOpt().getClass().getName());
        is.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])tuple.getConstVal())));
        is.addOption("accumulo.filter.iterator.qual", accumuloColumnMapping.serialize());
        return is;
    }

    public ExprNodeDesc getExpression(Configuration conf) {
        String filteredExprSerialized = conf.get("hive.io.filter.expr.serialized");
        if (filteredExprSerialized == null) {
            return null;
        }
        return SerializationUtilities.deserializeExpression((String)filteredExprSerialized);
    }

    public List<IndexSearchCondition> getSearchConditions(Configuration conf) {
        ArrayList sConditions = Lists.newArrayList();
        ExprNodeDesc filterExpr = this.getExpression(conf);
        if (null == filterExpr) {
            return sConditions;
        }
        IndexPredicateAnalyzer analyzer = this.newAnalyzer(conf);
        ExprNodeDesc residual = analyzer.analyzePredicate(filterExpr, (List)sConditions);
        if (residual != null) {
            throw new RuntimeException("Unexpected residual predicate: " + residual.getExprString());
        }
        return sConditions;
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decompose(Configuration conf, ExprNodeDesc desc) {
        IndexPredicateAnalyzer analyzer = this.newAnalyzer(conf);
        ArrayList sConditions = new ArrayList();
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(desc, sConditions);
        if (sConditions.size() == 0) {
            if (log.isInfoEnabled()) {
                log.info("nothing to decompose. Returning");
            }
            return null;
        }
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(sConditions);
        decomposedPredicate.residualPredicate = (ExprNodeGenericFuncDesc)residualPredicate;
        return decomposedPredicate;
    }

    private IndexPredicateAnalyzer newAnalyzer(Configuration conf) {
        String[] hiveColumnNames;
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.clearAllowedColumnNames();
        for (String op : this.cOpKeyset()) {
            analyzer.addComparisonOp(op);
        }
        for (String col : hiveColumnNames = conf.getStrings("columns")) {
            analyzer.allowColumnName(col);
        }
        return analyzer;
    }

    static {
        compareOps.put(GenericUDFOPEqual.class.getName(), Equal.class);
        compareOps.put(GenericUDFOPNotEqual.class.getName(), NotEqual.class);
        compareOps.put(GenericUDFOPGreaterThan.class.getName(), GreaterThan.class);
        compareOps.put(GenericUDFOPEqualOrGreaterThan.class.getName(), GreaterThanOrEqual.class);
        compareOps.put(GenericUDFOPEqualOrLessThan.class.getName(), LessThanOrEqual.class);
        compareOps.put(GenericUDFOPLessThan.class.getName(), LessThan.class);
        compareOps.put(UDFLike.class.getName(), Like.class);
        pComparisons.put("bigint", LongCompare.class);
        pComparisons.put("int", IntCompare.class);
        pComparisons.put("double", DoubleCompare.class);
        pComparisons.put("string", StringCompare.class);
    }
}

