/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="sum", value="_FUNC_(x) - Returns the sum of a set of numbers")
public class GenericUDAFSum
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFSum.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new GenericUDAFSumLong();
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new GenericUDAFSumDouble();
            }
            case DECIMAL: {
                return new GenericUDAFSumHiveDecimal();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static PrimitiveObjectInspector.PrimitiveCategory getReturnType(TypeInfo type) {
        if (type.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return PrimitiveObjectInspector.PrimitiveCategory.LONG;
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return PrimitiveObjectInspector.PrimitiveCategory.DOUBLE;
            }
            case DECIMAL: {
                return PrimitiveObjectInspector.PrimitiveCategory.DECIMAL;
            }
        }
        return null;
    }

    public static class GenericUDAFSumLong
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        protected LongWritable result;
        private boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new LongWritable(0L);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumLongAgg result = new SumLongAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            myagg.empty = true;
            myagg.sum = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block3: {
                assert (parameters.length == 1);
                try {
                    this.merge(agg, parameters[0]);
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block3;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumLongAgg myagg = (SumLongAgg)agg;
                myagg.sum += PrimitiveObjectInspectorUtils.getLong(partial, this.inputOI);
                myagg.empty = false;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            if (myagg.empty) {
                return null;
            }
            this.result.set(myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<LongWritable, Long>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected LongWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    Long r = myagg.empty ? null : Long.valueOf(myagg.sum);
                    Long d = (Long)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : Long.valueOf(r - d);
                    }
                    return r == null ? null : new LongWritable(r.longValue());
                }

                @Override
                protected Long getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    return myagg.empty ? null : new Long(myagg.sum);
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumLongAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            boolean empty;
            long sum;

            SumLongAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    public static class GenericUDAFSumDouble
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private DoubleWritable result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new DoubleWritable(0.0);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumDoubleAgg result = new SumDoubleAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            myagg.empty = true;
            myagg.sum = 0.0;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block3: {
                assert (parameters.length == 1);
                try {
                    this.merge(agg, parameters[0]);
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block3;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumDoubleAgg myagg = (SumDoubleAgg)agg;
                myagg.empty = false;
                myagg.sum += PrimitiveObjectInspectorUtils.getDouble(partial, this.inputOI);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            if (myagg.empty) {
                return null;
            }
            this.result.set(myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<DoubleWritable, Double>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected DoubleWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    Double r = myagg.empty ? null : Double.valueOf(myagg.sum);
                    Double d = (Double)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : Double.valueOf(r - d);
                    }
                    return r == null ? null : new DoubleWritable(r);
                }

                @Override
                protected Double getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    return myagg.empty ? null : new Double(myagg.sum);
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumDoubleAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            boolean empty;
            double sum;

            SumDoubleAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    public static class GenericUDAFSumHiveDecimal
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private HiveDecimalWritable result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new HiveDecimalWritable(HiveDecimal.ZERO);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            DecimalTypeInfo outputTypeInfo = null;
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                int precision = Math.min(38, this.inputOI.precision() + 10);
                outputTypeInfo = TypeInfoFactory.getDecimalTypeInfo(precision, this.inputOI.scale());
            } else {
                outputTypeInfo = (DecimalTypeInfo)this.inputOI.getTypeInfo();
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(outputTypeInfo);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumHiveDecimalAgg agg = new SumHiveDecimalAgg();
            this.reset(agg);
            return agg;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumHiveDecimalAgg bdAgg = (SumHiveDecimalAgg)agg;
            bdAgg.empty = true;
            bdAgg.sum = HiveDecimal.ZERO;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block3: {
                assert (parameters.length == 1);
                try {
                    this.merge(agg, parameters[0]);
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block3;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumHiveDecimalAgg myagg = (SumHiveDecimalAgg)agg;
                if (myagg.sum == null) {
                    return;
                }
                myagg.empty = false;
                myagg.sum = myagg.sum.add(PrimitiveObjectInspectorUtils.getHiveDecimal(partial, this.inputOI));
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumHiveDecimalAgg myagg = (SumHiveDecimalAgg)agg;
            if (myagg.empty || myagg.sum == null) {
                return null;
            }
            this.result.set(myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<HiveDecimalWritable, HiveDecimal>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected HiveDecimalWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumHiveDecimalAgg myagg = (SumHiveDecimalAgg)ss.wrappedBuf;
                    HiveDecimal r = myagg.empty ? null : myagg.sum;
                    HiveDecimal d = (HiveDecimal)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : r.subtract(d);
                    }
                    return r == null ? null : new HiveDecimalWritable(r);
                }

                @Override
                protected HiveDecimal getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumHiveDecimalAgg myagg = (SumHiveDecimalAgg)ss.wrappedBuf;
                    return myagg.empty ? null : myagg.sum;
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=false)
        static class SumHiveDecimalAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            boolean empty;
            HiveDecimal sum;

            SumHiveDecimalAgg() {
            }
        }
    }
}

