/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.FileDump;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.orc.BinaryColumnStatistics;
import org.apache.orc.BloomFilterIO;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcProto;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.OrcIndex;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONStringer;
import org.codehaus.jettison.json.JSONWriter;

public class JsonFileDump {
    public static void printJsonMetaData(List<String> files, Configuration conf, List<Integer> rowIndexCols, boolean prettyPrint, boolean printTimeZone) throws JSONException, IOException {
        boolean multiFile;
        JSONStringer writer = new JSONStringer();
        boolean bl = multiFile = files.size() > 1;
        if (multiFile) {
            writer.array();
        } else {
            writer.object();
        }
        for (String filename : files) {
            try {
                int i;
                if (multiFile) {
                    writer.object();
                }
                writer.key("fileName").value((Object)filename);
                Path path = new Path(filename);
                Reader reader = FileDump.getReader(path, conf, null);
                if (reader == null) {
                    writer.key("status").value((Object)"FAILED");
                    continue;
                }
                writer.key("fileVersion").value((Object)reader.getFileVersion().getName());
                writer.key("writerVersion").value((Object)reader.getWriterVersion());
                RecordReaderImpl rows = (RecordReaderImpl)reader.rows();
                writer.key("numberOfRows").value(reader.getNumberOfRows());
                writer.key("compression").value((Object)reader.getCompression());
                if (reader.getCompression() != CompressionKind.NONE) {
                    writer.key("compressionBufferSize").value((long)reader.getCompressionSize());
                }
                writer.key("schemaString").value((Object)reader.getObjectInspector().getTypeName());
                writer.key("schema").array();
                JsonFileDump.writeSchema(writer, reader.getTypes());
                writer.endArray();
                writer.key("stripeStatistics").array();
                List<StripeStatistics> stripeStatistics = reader.getStripeStatistics();
                for (int n = 0; n < stripeStatistics.size(); ++n) {
                    writer.object();
                    writer.key("stripeNumber").value((long)(n + 1));
                    StripeStatistics ss = stripeStatistics.get(n);
                    writer.key("columnStatistics").array();
                    for (i = 0; i < ss.getColumnStatistics().length; ++i) {
                        writer.object();
                        writer.key("columnId").value((long)i);
                        JsonFileDump.writeColumnStatistics((JSONWriter)writer, ss.getColumnStatistics()[i]);
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.endObject();
                }
                writer.endArray();
                ColumnStatistics[] stats = reader.getStatistics();
                int colCount = stats.length;
                writer.key("fileStatistics").array();
                for (i = 0; i < stats.length; ++i) {
                    writer.object();
                    writer.key("columnId").value((long)i);
                    JsonFileDump.writeColumnStatistics((JSONWriter)writer, stats[i]);
                    writer.endObject();
                }
                writer.endArray();
                writer.key("stripes").array();
                int stripeIx = -1;
                for (StripeInformation stripe : reader.getStripes()) {
                    long stripeStart = stripe.getOffset();
                    OrcProto.StripeFooter footer = rows.readStripeFooter(stripe);
                    writer.object();
                    writer.key("stripeNumber").value((long)(++stripeIx + 1));
                    writer.key("stripeInformation");
                    JsonFileDump.writeStripeInformation((JSONWriter)writer, stripe);
                    if (printTimeZone) {
                        writer.key("writerTimezone").value((Object)(footer.hasWriterTimezone() ? footer.getWriterTimezone() : "UNKNOWN"));
                    }
                    long sectionStart = stripeStart;
                    writer.key("streams").array();
                    for (OrcProto.Stream section : footer.getStreamsList()) {
                        writer.object();
                        String kind = section.hasKind() ? section.getKind().name() : "UNKNOWN";
                        writer.key("columnId").value((long)section.getColumn());
                        writer.key("section").value((Object)kind);
                        writer.key("startOffset").value(sectionStart);
                        writer.key("length").value(section.getLength());
                        sectionStart += section.getLength();
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.key("encodings").array();
                    for (int i2 = 0; i2 < footer.getColumnsCount(); ++i2) {
                        writer.object();
                        OrcProto.ColumnEncoding encoding = footer.getColumns(i2);
                        writer.key("columnId").value((long)i2);
                        writer.key("kind").value((Object)encoding.getKind());
                        if (encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY || encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                            writer.key("dictionarySize").value((long)encoding.getDictionarySize());
                        }
                        writer.endObject();
                    }
                    writer.endArray();
                    if (rowIndexCols != null && !rowIndexCols.isEmpty()) {
                        boolean[] sargColumns = new boolean[colCount];
                        for (int colIdx : rowIndexCols) {
                            sargColumns[colIdx] = true;
                        }
                        OrcIndex indices = rows.readRowIndex(stripeIx, null, sargColumns);
                        writer.key("indexes").array();
                        for (int col : rowIndexCols) {
                            writer.object();
                            writer.key("columnId").value((long)col);
                            JsonFileDump.writeRowGroupIndexes((JSONWriter)writer, col, indices.getRowGroupIndex());
                            JsonFileDump.writeBloomFilterIndexes((JSONWriter)writer, col, indices.getBloomFilterIndex());
                            writer.endObject();
                        }
                        writer.endArray();
                    }
                    writer.endObject();
                }
                writer.endArray();
                FileSystem fs = path.getFileSystem(conf);
                long fileLen = fs.getContentSummary(path).getLength();
                long paddedBytes = FileDump.getTotalPaddingSize(reader);
                double percentPadding = (double)paddedBytes / (double)fileLen * 100.0;
                writer.key("fileLength").value(fileLen);
                writer.key("paddingLength").value(paddedBytes);
                writer.key("paddingRatio").value(percentPadding);
                OrcRecordUpdater.AcidStats acidStats = OrcRecordUpdater.parseAcidStats(reader);
                if (acidStats != null) {
                    writer.key("numInserts").value(acidStats.inserts);
                    writer.key("numDeletes").value(acidStats.deletes);
                    writer.key("numUpdates").value(acidStats.updates);
                }
                writer.key("status").value((Object)"OK");
                rows.close();
                writer.endObject();
            }
            catch (Exception e) {
                writer.key("status").value((Object)"FAILED");
                throw e;
            }
        }
        if (multiFile) {
            writer.endArray();
        }
        if (prettyPrint) {
            String prettyJson;
            if (multiFile) {
                JSONArray jsonArray = new JSONArray(writer.toString());
                prettyJson = jsonArray.toString(2);
            } else {
                JSONObject jsonObject = new JSONObject(writer.toString());
                prettyJson = jsonObject.toString(2);
            }
            System.out.println(prettyJson);
        } else {
            System.out.println(writer.toString());
        }
    }

    private static void writeSchema(JSONStringer writer, List<OrcProto.Type> types) throws JSONException {
        int i = 0;
        for (OrcProto.Type type : types) {
            writer.object();
            writer.key("columnId").value((long)i++);
            writer.key("columnType").value((Object)type.getKind());
            if (type.getFieldNamesCount() > 0) {
                writer.key("childColumnNames").array();
                for (String field : type.getFieldNamesList()) {
                    writer.value((Object)field);
                }
                writer.endArray();
                writer.key("childColumnIds").array();
                for (Integer colId : type.getSubtypesList()) {
                    writer.value((Object)colId);
                }
                writer.endArray();
            }
            if (type.hasPrecision()) {
                writer.key("precision").value((long)type.getPrecision());
            }
            if (type.hasScale()) {
                writer.key("scale").value((long)type.getScale());
            }
            if (type.hasMaximumLength()) {
                writer.key("maxLength").value((long)type.getMaximumLength());
            }
            writer.endObject();
        }
    }

    private static void writeStripeInformation(JSONWriter writer, StripeInformation stripe) throws JSONException {
        writer.object();
        writer.key("offset").value(stripe.getOffset());
        writer.key("indexLength").value(stripe.getIndexLength());
        writer.key("dataLength").value(stripe.getDataLength());
        writer.key("footerLength").value(stripe.getFooterLength());
        writer.key("rowCount").value(stripe.getNumberOfRows());
        writer.endObject();
    }

    private static void writeColumnStatistics(JSONWriter writer, ColumnStatistics cs) throws JSONException {
        if (cs != null) {
            writer.key("count").value(cs.getNumberOfValues());
            writer.key("hasNull").value(cs.hasNull());
            if (cs instanceof BinaryColumnStatistics) {
                writer.key("totalLength").value(((BinaryColumnStatistics)cs).getSum());
                writer.key("type").value((Object)OrcProto.Type.Kind.BINARY);
            } else if (cs instanceof BooleanColumnStatistics) {
                writer.key("trueCount").value(((BooleanColumnStatistics)cs).getTrueCount());
                writer.key("falseCount").value(((BooleanColumnStatistics)cs).getFalseCount());
                writer.key("type").value((Object)OrcProto.Type.Kind.BOOLEAN);
            } else if (cs instanceof IntegerColumnStatistics) {
                writer.key("min").value(((IntegerColumnStatistics)cs).getMinimum());
                writer.key("max").value(((IntegerColumnStatistics)cs).getMaximum());
                if (((IntegerColumnStatistics)cs).isSumDefined()) {
                    writer.key("sum").value(((IntegerColumnStatistics)cs).getSum());
                }
                writer.key("type").value((Object)OrcProto.Type.Kind.LONG);
            } else if (cs instanceof DoubleColumnStatistics) {
                writer.key("min").value(((DoubleColumnStatistics)cs).getMinimum());
                writer.key("max").value(((DoubleColumnStatistics)cs).getMaximum());
                writer.key("sum").value(((DoubleColumnStatistics)cs).getSum());
                writer.key("type").value((Object)OrcProto.Type.Kind.DOUBLE);
            } else if (cs instanceof StringColumnStatistics) {
                writer.key("min").value((Object)((StringColumnStatistics)cs).getMinimum());
                writer.key("max").value((Object)((StringColumnStatistics)cs).getMaximum());
                writer.key("totalLength").value(((StringColumnStatistics)cs).getSum());
                writer.key("type").value((Object)OrcProto.Type.Kind.STRING);
            } else if (cs instanceof DateColumnStatistics) {
                if (((DateColumnStatistics)cs).getMaximum() != null) {
                    writer.key("min").value((Object)((DateColumnStatistics)cs).getMinimum());
                    writer.key("max").value((Object)((DateColumnStatistics)cs).getMaximum());
                }
                writer.key("type").value((Object)OrcProto.Type.Kind.DATE);
            } else if (cs instanceof TimestampColumnStatistics) {
                if (((TimestampColumnStatistics)cs).getMaximum() != null) {
                    writer.key("min").value((Object)((TimestampColumnStatistics)cs).getMinimum());
                    writer.key("max").value((Object)((TimestampColumnStatistics)cs).getMaximum());
                }
                writer.key("type").value((Object)OrcProto.Type.Kind.TIMESTAMP);
            } else if (cs instanceof DecimalColumnStatistics) {
                if (((DecimalColumnStatistics)cs).getMaximum() != null) {
                    writer.key("min").value((Object)((DecimalColumnStatistics)cs).getMinimum());
                    writer.key("max").value((Object)((DecimalColumnStatistics)cs).getMaximum());
                    writer.key("sum").value((Object)((DecimalColumnStatistics)cs).getSum());
                }
                writer.key("type").value((Object)OrcProto.Type.Kind.DECIMAL);
            }
        }
    }

    private static void writeBloomFilterIndexes(JSONWriter writer, int col, OrcProto.BloomFilterIndex[] bloomFilterIndex) throws JSONException {
        BloomFilterIO stripeLevelBF = null;
        if (bloomFilterIndex != null && bloomFilterIndex[col] != null) {
            int entryIx = 0;
            writer.key("bloomFilterIndexes").array();
            for (OrcProto.BloomFilter bf : bloomFilterIndex[col].getBloomFilterList()) {
                writer.object();
                writer.key("entryId").value((long)entryIx++);
                BloomFilterIO toMerge = new BloomFilterIO(bf);
                JsonFileDump.writeBloomFilterStats(writer, toMerge);
                if (stripeLevelBF == null) {
                    stripeLevelBF = toMerge;
                } else {
                    stripeLevelBF.merge(toMerge);
                }
                writer.endObject();
            }
            writer.endArray();
        }
        if (stripeLevelBF != null) {
            writer.key("stripeLevelBloomFilter");
            writer.object();
            JsonFileDump.writeBloomFilterStats(writer, stripeLevelBF);
            writer.endObject();
        }
    }

    private static void writeBloomFilterStats(JSONWriter writer, BloomFilterIO bf) throws JSONException {
        int bitCount = bf.getBitSize();
        int popCount = 0;
        for (long l : bf.getBitSet()) {
            popCount += Long.bitCount(l);
        }
        int k = bf.getNumHashFunctions();
        float loadFactor = (float)popCount / (float)bitCount;
        float expectedFpp = (float)Math.pow(loadFactor, k);
        writer.key("numHashFunctions").value((long)k);
        writer.key("bitCount").value((long)bitCount);
        writer.key("popCount").value((long)popCount);
        writer.key("loadFactor").value((double)loadFactor);
        writer.key("expectedFpp").value((double)expectedFpp);
    }

    private static void writeRowGroupIndexes(JSONWriter writer, int col, OrcProto.RowIndex[] rowGroupIndex) throws JSONException {
        OrcProto.RowIndex index;
        if (rowGroupIndex == null || col >= rowGroupIndex.length || (index = rowGroupIndex[col]) == null) {
            return;
        }
        writer.key("rowGroupIndexes").array();
        for (int entryIx = 0; entryIx < index.getEntryCount(); ++entryIx) {
            writer.object();
            writer.key("entryId").value((long)entryIx);
            OrcProto.RowIndexEntry entry = index.getEntry(entryIx);
            if (entry == null) continue;
            OrcProto.ColumnStatistics colStats = entry.getStatistics();
            JsonFileDump.writeColumnStatistics(writer, ColumnStatisticsImpl.deserialize(colStats));
            writer.key("positions").array();
            for (int posIx = 0; posIx < entry.getPositionsCount(); ++posIx) {
                writer.value(entry.getPositions(posIx));
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endArray();
    }
}

