/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsSetupConst {
    protected static final Logger LOG = LoggerFactory.getLogger((String)StatsSetupConst.class.getName());
    public static final String NUM_FILES = "numFiles";
    public static final String NUM_PARTITIONS = "numPartitions";
    public static final String TOTAL_SIZE = "totalSize";
    public static final String ROW_COUNT = "numRows";
    public static final String RAW_DATA_SIZE = "rawDataSize";
    public static final String STATS_TMP_LOC = "hive.stats.tmp.loc";
    public static final String STATS_FILE_PREFIX = "tmpstats-";
    public static final String[] supportedStats = new String[]{"numFiles", "numRows", "totalSize", "rawDataSize"};
    public static final String[] statsRequireCompute = new String[]{"numRows", "rawDataSize"};
    public static final String[] fastStats = new String[]{"numFiles", "totalSize"};
    public static final String STATS_GENERATED_VIA_STATS_TASK = "STATS_GENERATED_VIA_STATS_TASK";
    public static final String DO_NOT_UPDATE_STATS = "DO_NOT_UPDATE_STATS";
    public static final String COLUMN_STATS_ACCURATE = "COLUMN_STATS_ACCURATE";
    public static final String COLUMN_STATS = "COLUMN_STATS";
    public static final String BASIC_STATS = "BASIC_STATS";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static boolean areBasicStatsUptoDate(Map<String, String> params) {
        String statsAcc = params.get(COLUMN_STATS_ACCURATE);
        if (statsAcc == null) {
            return false;
        }
        try {
            JSONObject jsonObj = new JSONObject(statsAcc);
            return jsonObj != null && jsonObj.has(BASIC_STATS);
        }
        catch (JSONException e) {
            LOG.debug("In StatsSetupConst, JsonParser can not parse BASIC_STATS.");
            if (statsAcc.equals(TRUE)) {
                StatsSetupConst.setBasicStatsState(params, TRUE);
                return true;
            }
            StatsSetupConst.setBasicStatsState(params, FALSE);
            return false;
        }
    }

    public static boolean areColumnStatsUptoDate(Map<String, String> params, String colName) {
        String statsAcc = params.get(COLUMN_STATS_ACCURATE);
        if (statsAcc == null) {
            return false;
        }
        try {
            JSONObject jsonObj = new JSONObject(statsAcc);
            if (jsonObj == null || !jsonObj.has(COLUMN_STATS)) {
                return false;
            }
            JSONObject columns = jsonObj.getJSONObject(COLUMN_STATS);
            return columns != null && columns.has(colName);
        }
        catch (JSONException e) {
            LOG.debug("In StatsSetupConst, JsonParser can not parse COLUMN_STATS.");
            return false;
        }
    }

    public static void setBasicStatsState(Map<String, String> params, String setting) {
        if (setting.equals(FALSE)) {
            if (params.containsKey(COLUMN_STATS_ACCURATE)) {
                params.remove(COLUMN_STATS_ACCURATE);
            }
        } else {
            String statsAcc = params.get(COLUMN_STATS_ACCURATE);
            if (statsAcc == null) {
                JSONObject stats = new JSONObject(new LinkedHashMap());
                try {
                    stats.put(BASIC_STATS, TRUE);
                }
                catch (JSONException e) {
                    LOG.trace(e.getMessage());
                }
                params.put(COLUMN_STATS_ACCURATE, stats.toString());
            } else {
                JSONObject stats;
                try {
                    stats = new JSONObject(statsAcc);
                }
                catch (JSONException e) {
                    LOG.debug("In StatsSetupConst, JsonParser can not parse statsAcc.");
                    stats = new JSONObject(new LinkedHashMap());
                    try {
                        if (statsAcc.equals(TRUE)) {
                            stats.put(BASIC_STATS, TRUE);
                        } else {
                            stats.put(BASIC_STATS, FALSE);
                        }
                    }
                    catch (JSONException e1) {
                        LOG.trace(e1.getMessage());
                    }
                }
                if (!stats.has(BASIC_STATS)) {
                    try {
                        stats.put(BASIC_STATS, TRUE);
                    }
                    catch (JSONException e) {
                        LOG.trace(e.getMessage());
                    }
                }
                params.put(COLUMN_STATS_ACCURATE, stats.toString());
            }
        }
    }

    public static void setColumnStatsState(Map<String, String> params, List<String> colNames) {
        block13: {
            try {
                JSONObject stats;
                String statsAcc = params.get(COLUMN_STATS_ACCURATE);
                JSONObject colStats = new JSONObject(new LinkedHashMap());
                for (String colName : colNames) {
                    colStats.put(colName.toLowerCase(), TRUE);
                }
                if (statsAcc == null) {
                    stats = new JSONObject(new LinkedHashMap());
                    stats.put(COLUMN_STATS, colStats);
                    params.put(COLUMN_STATS_ACCURATE, stats.toString());
                    break block13;
                }
                try {
                    stats = new JSONObject(statsAcc);
                }
                catch (JSONException e) {
                    LOG.debug("In StatsSetupConst, JsonParser can not parse statsAcc.");
                    stats = new JSONObject(new LinkedHashMap());
                    try {
                        if (statsAcc.equals(TRUE)) {
                            stats.put(BASIC_STATS, TRUE);
                        } else {
                            stats.put(BASIC_STATS, FALSE);
                        }
                    }
                    catch (JSONException e1) {
                        LOG.trace(e1.getMessage());
                    }
                }
                if (!stats.has(COLUMN_STATS)) {
                    stats.put(COLUMN_STATS, colStats);
                } else {
                    JSONObject allColumnStats = stats.getJSONObject(COLUMN_STATS);
                    for (String colName : colNames) {
                        if (allColumnStats.has(colName)) continue;
                        allColumnStats.put(colName, TRUE);
                    }
                    stats.remove(COLUMN_STATS);
                    stats.put(COLUMN_STATS, allColumnStats);
                }
                params.put(COLUMN_STATS_ACCURATE, stats.toString());
            }
            catch (JSONException e) {
                LOG.trace(e.getMessage());
            }
        }
    }

    public static void clearColumnStatsState(Map<String, String> params) {
        String statsAcc = params.get(COLUMN_STATS_ACCURATE);
        if (statsAcc != null) {
            JSONObject stats;
            try {
                stats = new JSONObject(statsAcc);
            }
            catch (JSONException e) {
                LOG.debug("In StatsSetupConst, JsonParser can not parse statsAcc.");
                stats = new JSONObject(new LinkedHashMap());
                try {
                    if (statsAcc.equals(TRUE)) {
                        stats.put(BASIC_STATS, TRUE);
                    } else {
                        stats.put(BASIC_STATS, FALSE);
                    }
                }
                catch (JSONException e1) {
                    LOG.trace(e1.getMessage());
                }
            }
            if (stats.has(COLUMN_STATS)) {
                stats.remove(COLUMN_STATS);
            }
            params.put(COLUMN_STATS_ACCURATE, stats.toString());
        }
    }

    public static enum StatDB {
        fs{

            @Override
            public String getPublisher(Configuration conf) {
                return "org.apache.hadoop.hive.ql.stats.fs.FSStatsPublisher";
            }

            @Override
            public String getAggregator(Configuration conf) {
                return "org.apache.hadoop.hive.ql.stats.fs.FSStatsAggregator";
            }
        }
        ,
        custom{

            @Override
            public String getPublisher(Configuration conf) {
                return HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_STATS_DEFAULT_PUBLISHER);
            }

            @Override
            public String getAggregator(Configuration conf) {
                return HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_STATS_DEFAULT_AGGREGATOR);
            }
        };


        public abstract String getPublisher(Configuration var1);

        public abstract String getAggregator(Configuration var1);
    }
}

