/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.jeromq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;
import org.zeromq.ZMQ;

@Plugin(name="JeroMQ", category="Core", elementType="appender", printObject=true)
public final class JeroMqAppender
extends AbstractAppender {
    static final String SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK = "log4j.jeromq.enableShutdownHook";
    static final String SYS_PROPERTY_IO_THREADS = "log4j.jeromq.ioThreads";
    private static volatile ZMQ.Context context;
    private static final int DEFAULT_BACKLOG = 100;
    private static final int DEFAULT_IVL = 100;
    private static final int DEFAULT_RCV_HWM = 1000;
    private static final int DEFAULT_SND_HWM = 1000;
    private static Logger logger;
    private static ZMQ.Socket publisher;
    private static final long serialVersionUID = 1L;
    private static final String SIMPLE_NAME;
    private final long affinity;
    private final long backlog;
    private final boolean delayAttachOnConnect;
    private final List<String> endpoints;
    private final byte[] identity;
    private final int ioThreads = 1;
    private final boolean ipv4Only;
    private final long linger;
    private final long maxMsgSize;
    private final long rcvHwm;
    private final long receiveBufferSize;
    private final int receiveTimeOut;
    private final long reconnectIVL;
    private final long reconnectIVLMax;
    private final long sendBufferSize;
    private int sendRcFalse;
    private int sendRcTrue;
    private final int sendTimeOut;
    private final long sndHwm;
    private final int tcpKeepAlive;
    private final long tcpKeepAliveCount;
    private final long tcpKeepAliveIdle;
    private final long tcpKeepAliveInterval;
    private final boolean xpubVerbose;

    private JeroMqAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, List<String> endpoints, long affinity, long backlog, boolean delayAttachOnConnect, byte[] identity, boolean ipv4Only, long linger, long maxMsgSize, long rcvHwm, long receiveBufferSize, int receiveTimeOut, long reconnectIVL, long reconnectIVLMax, long sendBufferSize, int sendTimeOut, long sndHWM, int tcpKeepAlive, long tcpKeepAliveCount, long tcpKeepAliveIdle, long tcpKeepAliveInterval, boolean xpubVerbose) {
        super(name, filter, layout, ignoreExceptions);
        this.endpoints = endpoints;
        this.affinity = affinity;
        this.backlog = backlog;
        this.delayAttachOnConnect = delayAttachOnConnect;
        this.identity = identity;
        this.ipv4Only = ipv4Only;
        this.linger = linger;
        this.maxMsgSize = maxMsgSize;
        this.rcvHwm = rcvHwm;
        this.receiveBufferSize = receiveBufferSize;
        this.receiveTimeOut = receiveTimeOut;
        this.reconnectIVL = reconnectIVL;
        this.reconnectIVLMax = reconnectIVLMax;
        this.sendBufferSize = sendBufferSize;
        this.sendTimeOut = sendTimeOut;
        this.sndHwm = sndHWM;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpKeepAliveCount = tcpKeepAliveCount;
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
        this.xpubVerbose = xpubVerbose;
    }

    @PluginFactory
    public static JeroMqAppender createAppender(@Required(message="No name provided for JeroMqAppender") @PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Properties") Property[] properties, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="affinity", defaultLong=0L) long affinity, @PluginAttribute(value="backlog", defaultLong=100L) long backlog, @PluginAttribute(value="delayAttachOnConnect", defaultBoolean=false) boolean delayAttachOnConnect, @PluginAttribute(value="identity") byte[] identity, @PluginAttribute(value="ipv4Only", defaultBoolean=true) boolean ipv4Only, @PluginAttribute(value="linger", defaultLong=-1L) long linger, @PluginAttribute(value="maxMsgSize", defaultLong=-1L) long maxMsgSize, @PluginAttribute(value="rcvHwm", defaultLong=1000L) long rcvHwm, @PluginAttribute(value="receiveBufferSize", defaultLong=0L) long receiveBufferSize, @PluginAttribute(value="receiveTimeOut", defaultLong=-1L) int receiveTimeOut, @PluginAttribute(value="reconnectIVL", defaultLong=100L) long reconnectIVL, @PluginAttribute(value="reconnectIVLMax", defaultLong=0L) long reconnectIVLMax, @PluginAttribute(value="sendBufferSize", defaultLong=0L) long sendBufferSize, @PluginAttribute(value="sendTimeOut", defaultLong=-1L) int sendTimeOut, @PluginAttribute(value="sndHwm", defaultLong=1000L) long sndHwm, @PluginAttribute(value="tcpKeepAlive", defaultInt=-1) int tcpKeepAlive, @PluginAttribute(value="tcpKeepAliveCount", defaultLong=-1L) long tcpKeepAliveCount, @PluginAttribute(value="tcpKeepAliveIdle", defaultLong=-1L) long tcpKeepAliveIdle, @PluginAttribute(value="tcpKeepAliveInterval", defaultLong=-1L) long tcpKeepAliveInterval, @PluginAttribute(value="xpubVerbose", defaultBoolean=false) boolean xpubVerbose) {
        ArrayList<String> endpoints;
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (properties == null) {
            endpoints = new ArrayList<String>(0);
        } else {
            endpoints = new ArrayList(properties.length);
            for (Property property : properties) {
                String value;
                if (!"endpoint".equalsIgnoreCase(property.getName()) || !Strings.isNotEmpty((CharSequence)(value = property.getValue()))) continue;
                endpoints.add(value);
            }
        }
        logger.debug("Creating JeroMqAppender with name={}, filter={}, layout={}, ignoreExceptions={}, endpoints={}", new Object[]{name, filter, layout, ignoreExceptions, endpoints});
        return new JeroMqAppender(name, filter, layout, ignoreExceptions, endpoints, affinity, backlog, delayAttachOnConnect, identity, ipv4Only, linger, maxMsgSize, rcvHwm, receiveBufferSize, receiveTimeOut, reconnectIVL, reconnectIVLMax, sendBufferSize, sendTimeOut, sndHwm, tcpKeepAlive, tcpKeepAliveCount, tcpKeepAliveIdle, tcpKeepAliveInterval, xpubVerbose);
    }

    static ZMQ.Context getContext() {
        return context;
    }

    private static ZMQ.Socket getPublisher() {
        return publisher;
    }

    private static ZMQ.Socket newPublisher() {
        logger.trace("{} creating a new ZMQ PUB socket with context {}", new Object[]{SIMPLE_NAME, context});
        ZMQ.Socket socketPub = context.socket(1);
        logger.trace("{} created new ZMQ PUB socket {}", new Object[]{SIMPLE_NAME, socketPub});
        return socketPub;
    }

    static void shutdown() {
        if (context != null) {
            logger.trace("{} terminating JeroMQ context {}", new Object[]{SIMPLE_NAME, context});
            context.term();
            context = null;
        }
    }

    @Override
    public synchronized void append(LogEvent event) {
        String formattedMessage = event.getMessage().getFormattedMessage();
        if (JeroMqAppender.getPublisher().send(formattedMessage, 0)) {
            ++this.sendRcTrue;
        } else {
            ++this.sendRcFalse;
            logger.error("Appender {} could not send message {} to JeroMQ {}", new Object[]{this.getName(), this.sendRcFalse, formattedMessage});
        }
    }

    int getSendRcFalse() {
        return this.sendRcFalse;
    }

    int getSendRcTrue() {
        return this.sendRcTrue;
    }

    void resetSendRcs() {
        this.sendRcFalse = 0;
        this.sendRcTrue = 0;
    }

    @Override
    public synchronized void start() {
        super.start();
        publisher = JeroMqAppender.newPublisher();
        String name = this.getName();
        String prefix = "JeroMQ Appender";
        logger.debug("Starting {} {} using ZMQ version {}", new Object[]{"JeroMQ Appender", name, ZMQ.getVersionString()});
        logger.debug("{} {} context {} with ioThreads={}", new Object[]{"JeroMQ Appender", name, context, 1});
        ZMQ.Socket socketPub = JeroMqAppender.getPublisher();
        logger.trace("{} {} setting {} publisher properties for instance {}", new Object[]{"JeroMQ Appender", name, socketPub.getClass().getName(), socketPub});
        logger.trace("{} {} publisher setAffinity({})", new Object[]{"JeroMQ Appender", name, this.affinity});
        socketPub.setAffinity(this.affinity);
        logger.trace("{} {} publisher setBacklog({})", new Object[]{"JeroMQ Appender", name, this.backlog});
        socketPub.setBacklog(this.backlog);
        logger.trace("{} {} publisher setDelayAttachOnConnect({})", new Object[]{"JeroMQ Appender", name, this.delayAttachOnConnect});
        socketPub.setDelayAttachOnConnect(this.delayAttachOnConnect);
        if (this.identity != null) {
            logger.trace("{} {} publisher setIdentity({})", new Object[]{"JeroMQ Appender", name, Arrays.toString(this.identity)});
            socketPub.setIdentity(this.identity);
        }
        logger.trace("{} {} publisher setIPv4Only({})", new Object[]{"JeroMQ Appender", name, this.ipv4Only});
        socketPub.setIPv4Only(this.ipv4Only);
        logger.trace("{} {} publisher setLinger({})", new Object[]{"JeroMQ Appender", name, this.linger});
        socketPub.setLinger(this.linger);
        logger.trace("{} {} publisher setMaxMsgSize({})", new Object[]{"JeroMQ Appender", name, this.maxMsgSize});
        socketPub.setMaxMsgSize(this.maxMsgSize);
        logger.trace("{} {} publisher setRcvHWM({})", new Object[]{"JeroMQ Appender", name, this.rcvHwm});
        socketPub.setRcvHWM(this.rcvHwm);
        logger.trace("{} {} publisher setReceiveBufferSize({})", new Object[]{"JeroMQ Appender", name, this.receiveBufferSize});
        socketPub.setReceiveBufferSize(this.receiveBufferSize);
        logger.trace("{} {} publisher setReceiveTimeOut({})", new Object[]{"JeroMQ Appender", name, this.receiveTimeOut});
        socketPub.setReceiveTimeOut(this.receiveTimeOut);
        logger.trace("{} {} publisher setReconnectIVL({})", new Object[]{"JeroMQ Appender", name, this.reconnectIVL});
        socketPub.setReconnectIVL(this.reconnectIVL);
        logger.trace("{} {} publisher setReconnectIVLMax({})", new Object[]{"JeroMQ Appender", name, this.reconnectIVLMax});
        socketPub.setReconnectIVLMax(this.reconnectIVLMax);
        logger.trace("{} {} publisher setSendBufferSize({})", new Object[]{"JeroMQ Appender", name, this.sendBufferSize});
        socketPub.setSendBufferSize(this.sendBufferSize);
        logger.trace("{} {} publisher setSendTimeOut({})", new Object[]{"JeroMQ Appender", name, this.sendTimeOut});
        socketPub.setSendTimeOut(this.sendTimeOut);
        logger.trace("{} {} publisher setSndHWM({})", new Object[]{"JeroMQ Appender", name, this.sndHwm});
        socketPub.setSndHWM(this.sndHwm);
        logger.trace("{} {} publisher setTCPKeepAlive({})", new Object[]{"JeroMQ Appender", name, this.tcpKeepAlive});
        socketPub.setTCPKeepAlive(this.tcpKeepAlive);
        logger.trace("{} {} publisher setTCPKeepAliveCount({})", new Object[]{"JeroMQ Appender", name, this.tcpKeepAliveCount});
        socketPub.setTCPKeepAliveCount(this.tcpKeepAliveCount);
        logger.trace("{} {} publisher setTCPKeepAliveIdle({})", new Object[]{"JeroMQ Appender", name, this.tcpKeepAliveIdle});
        socketPub.setTCPKeepAliveIdle(this.tcpKeepAliveIdle);
        logger.trace("{} {} publisher setTCPKeepAliveInterval({})", new Object[]{"JeroMQ Appender", name, this.tcpKeepAliveInterval});
        socketPub.setTCPKeepAliveInterval(this.tcpKeepAliveInterval);
        logger.trace("{} {} publisher setXpubVerbose({})", new Object[]{"JeroMQ Appender", name, this.xpubVerbose});
        socketPub.setXpubVerbose(this.xpubVerbose);
        if (logger.isDebugEnabled()) {
            logger.debug("Created JeroMQ {} publisher {} type {}, affinity={}, backlog={}, delayAttachOnConnect={}, events={}, IPv4Only={}, linger={}, maxMsgSize={}, multicastHops={}, rate={}, rcvHWM={}, receiveBufferSize={}, receiveTimeOut={}, reconnectIVL={}, reconnectIVLMax={}, recoveryInterval={}, sendBufferSize={}, sendTimeOut={}, sndHWM={}, TCPKeepAlive={}, TCPKeepAliveCount={}, TCPKeepAliveIdle={}, TCPKeepAliveInterval={}, TCPKeepAliveSetting={}", new Object[]{name, socketPub, socketPub.getType(), socketPub.getAffinity(), socketPub.getBacklog(), socketPub.getDelayAttachOnConnect(), socketPub.getEvents(), socketPub.getIPv4Only(), socketPub.getLinger(), socketPub.getMaxMsgSize(), socketPub.getMulticastHops(), socketPub.getRate(), socketPub.getRcvHWM(), socketPub.getReceiveBufferSize(), socketPub.getReceiveTimeOut(), socketPub.getReconnectIVL(), socketPub.getReconnectIVLMax(), socketPub.getRecoveryInterval(), socketPub.getSendBufferSize(), socketPub.getSendTimeOut(), socketPub.getSndHWM(), socketPub.getTCPKeepAlive(), socketPub.getTCPKeepAliveCount(), socketPub.getTCPKeepAliveIdle(), socketPub.getTCPKeepAliveInterval(), socketPub.getTCPKeepAliveSetting()});
        }
        for (String endpoint : this.endpoints) {
            logger.debug("Binding {} appender {} to endpoint {}", new Object[]{SIMPLE_NAME, name, endpoint});
            socketPub.bind(endpoint);
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        ZMQ.Socket socketPub = JeroMqAppender.getPublisher();
        if (socketPub != null) {
            logger.debug("Closing {} appender {} publisher {}", new Object[]{SIMPLE_NAME, this.getName(), socketPub});
            socketPub.close();
            publisher = null;
        }
    }

    @Override
    public String toString() {
        return "JeroMqAppender [context=" + context + ", publisher=" + publisher + ", endpoints=" + this.endpoints + "]";
    }

    static {
        SIMPLE_NAME = JeroMqAppender.class.getSimpleName();
        logger = StatusLogger.getLogger();
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        Integer ioThreads = managerProps.getIntegerProperty(SYS_PROPERTY_IO_THREADS, 1);
        Boolean enableShutdownHook = managerProps.getBooleanProperty(SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK, true);
        String simpleName = SIMPLE_NAME;
        logger.trace("{} using ZMQ version {}", new Object[]{simpleName, ZMQ.getVersionString()});
        logger.trace("{} creating ZMQ context with ioThreads={}", new Object[]{simpleName, ioThreads});
        context = ZMQ.context((int)ioThreads);
        logger.trace("{} created ZMQ context {}", new Object[]{simpleName, context});
        if (enableShutdownHook.booleanValue()) {
            Thread hook = new Thread(simpleName + "-shutdown"){

                @Override
                public void run() {
                    JeroMqAppender.shutdown();
                }
            };
            logger.trace("{} adding shutdown hook {}", new Object[]{simpleName, hook});
            Runtime.getRuntime().addShutdownHook(hook);
        }
    }
}

