/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.helpers;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hive.llap.LlapNodeId;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskCommunicator;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.serviceplugins.api.TaskCommunicatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceStateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SourceStateTracker.class);
    private final TaskCommunicatorContext taskCommunicatorContext;
    private final LlapTaskCommunicator taskCommunicator;
    private final LlapDaemonProtocolProtos.QueryIdentifierProto BASE_QUERY_IDENTIFIER;
    private final Set<String> notificationRegisteredVertices = new HashSet<String>();
    private final Map<String, SourceInfo> sourceInfoMap = new HashMap<String, SourceInfo>();
    private final Map<LlapNodeId, NodeInfo> nodeInfoMap = new HashMap<LlapNodeId, NodeInfo>();
    private volatile LlapDaemonProtocolProtos.QueryIdentifierProto currentQueryIdentifier;

    public SourceStateTracker(TaskCommunicatorContext taskCommunicatorContext, LlapTaskCommunicator taskCommunicator) {
        this.taskCommunicatorContext = taskCommunicatorContext;
        this.taskCommunicator = taskCommunicator;
        this.BASE_QUERY_IDENTIFIER = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setAppIdentifier(taskCommunicatorContext.getCurrentAppIdentifier()).build();
    }

    public synchronized void resetState(int newDagId) {
        this.sourceInfoMap.clear();
        this.nodeInfoMap.clear();
        this.notificationRegisteredVertices.clear();
        this.currentQueryIdentifier = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder((LlapDaemonProtocolProtos.QueryIdentifierProto)this.BASE_QUERY_IDENTIFIER).setDagIdentifier(newDagId).build();
    }

    public synchronized void registerTaskForStateUpdates(String host, int port, List<InputSpec> inputSpecList) {
        List<String> sourcesOfInterest = this.getSourceInterestList(inputSpecList);
        if (sourcesOfInterest != null && !sourcesOfInterest.isEmpty()) {
            LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
            NodeInfo nodeInfo = this.getNodeInfo(nodeId);
            for (String src : sourcesOfInterest) {
                VertexState oldStateForNode = nodeInfo.getLastKnownStateForSource(src);
                if (oldStateForNode == null) {
                    SourceInfo srcInfo = this.getSourceInfo(src);
                    srcInfo.addNode(nodeId);
                    nodeInfo.addSource(src, srcInfo.lastKnownState);
                    if (srcInfo.lastKnownState == VertexState.SUCCEEDED) {
                        this.sendStateUpdateToNode(nodeId, src, srcInfo.lastKnownState);
                    }
                }
                this.maybeRegisterForVertexUpdates(src);
            }
        }
    }

    public synchronized void sourceStateUpdated(String sourceName, VertexState sourceState) {
        SourceInfo sourceInfo = this.getSourceInfo(sourceName);
        if (sourceState == VertexState.SUCCEEDED) {
            sourceInfo.numCompletedTasks = this.taskCommunicatorContext.getVertexCompletedTaskCount(sourceName);
            sourceInfo.numTasks = this.taskCommunicatorContext.getVertexTotalTaskCount(sourceName);
        }
        sourceInfo.lastKnownState = sourceState;
        for (LlapNodeId nodeId : sourceInfo.getInterestedNodes()) {
            NodeInfo nodeInfo = this.nodeInfoMap.get(nodeId);
            VertexState lastStateForNode = nodeInfo.getLastKnownStateForSource(sourceName);
            if (lastStateForNode == sourceState) continue;
            nodeInfo.setLastKnownStateForSource(sourceName, sourceState);
            this.sendStateUpdateToNode(nodeId, sourceName, sourceState);
        }
    }

    public synchronized LlapDaemonProtocolProtos.FragmentRuntimeInfo getFragmentRuntimeInfo(String vertexName, int fragmentNumber, int priority) {
        LlapDaemonProtocolProtos.FragmentRuntimeInfo.Builder builder = LlapDaemonProtocolProtos.FragmentRuntimeInfo.newBuilder();
        this.maybeRegisterForVertexUpdates(vertexName);
        MutableInt totalTaskCount = new MutableInt(0);
        MutableInt completedTaskCount = new MutableInt(0);
        this.computeUpstreamTaskCounts(completedTaskCount, totalTaskCount, vertexName);
        builder.setNumSelfAndUpstreamCompletedTasks(completedTaskCount.intValue());
        builder.setNumSelfAndUpstreamTasks(totalTaskCount.intValue());
        builder.setDagStartTime(this.taskCommunicatorContext.getDagStartTime());
        builder.setWithinDagPriority(priority);
        builder.setFirstAttemptStartTime(this.taskCommunicatorContext.getFirstAttemptStartTime(vertexName, fragmentNumber));
        builder.setCurrentAttemptStartTime(System.currentTimeMillis());
        return builder.build();
    }

    private void computeUpstreamTaskCounts(MutableInt completedTaskCount, MutableInt totalTaskCount, String sourceName) {
        SourceInfo sourceInfo = this.getSourceInfo(sourceName);
        if (sourceInfo.lastKnownState == VertexState.SUCCEEDED) {
            completedTaskCount.add(sourceInfo.numCompletedTasks);
            totalTaskCount.add(sourceInfo.numTasks);
        } else {
            completedTaskCount.add(this.taskCommunicatorContext.getVertexCompletedTaskCount(sourceName));
            int totalCount = this.taskCommunicatorContext.getVertexTotalTaskCount(sourceName);
            totalCount = totalCount == -1 ? 0 : totalCount;
            totalTaskCount.add(totalCount);
        }
        for (String up : this.taskCommunicatorContext.getInputVertexNames(sourceName)) {
            this.computeUpstreamTaskCounts(completedTaskCount, totalTaskCount, up);
        }
    }

    private synchronized SourceInfo getSourceInfo(String srcName) {
        SourceInfo sourceInfo = this.sourceInfoMap.get(srcName);
        if (sourceInfo == null) {
            sourceInfo = new SourceInfo();
            this.sourceInfoMap.put(srcName, sourceInfo);
        }
        return sourceInfo;
    }

    private synchronized NodeInfo getNodeInfo(LlapNodeId llapNodeId) {
        NodeInfo nodeInfo = this.nodeInfoMap.get(llapNodeId);
        if (nodeInfo == null) {
            nodeInfo = new NodeInfo();
            this.nodeInfoMap.put(llapNodeId, nodeInfo);
        }
        return nodeInfo;
    }

    private List<String> getSourceInterestList(List<InputSpec> inputSpecList) {
        List<String> sourcesOfInterest = Collections.emptyList();
        if (inputSpecList != null) {
            boolean alreadyFound = false;
            for (InputSpec inputSpec : inputSpecList) {
                if (!LlapTezUtils.isSourceOfInterest(inputSpec.getInputDescriptor().getClassName())) continue;
                if (!alreadyFound) {
                    alreadyFound = true;
                    sourcesOfInterest = new LinkedList<String>();
                }
                sourcesOfInterest.add(inputSpec.getSourceVertexName());
            }
        }
        return sourcesOfInterest;
    }

    private void maybeRegisterForVertexUpdates(String sourceName) {
        if (!this.notificationRegisteredVertices.contains(sourceName)) {
            this.notificationRegisteredVertices.add(sourceName);
            this.taskCommunicatorContext.registerForVertexStateUpdates(sourceName, EnumSet.of(VertexState.RUNNING, VertexState.SUCCEEDED));
        }
    }

    void sendStateUpdateToNode(LlapNodeId nodeId, String sourceName, VertexState state) {
        this.taskCommunicator.sendStateUpdate(nodeId.getHostname(), nodeId.getPort(), LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto.newBuilder().setQueryIdentifier(this.currentQueryIdentifier).setSrcName(sourceName).setState(Converters.fromVertexState((VertexState)state)).build());
    }

    private static class NodeInfo {
        private final Map<String, VertexState> sourcesOfInterest = new HashMap<String, VertexState>();

        private NodeInfo() {
        }

        void addSource(String srcName, VertexState sourceState) {
            this.sourcesOfInterest.put(srcName, sourceState);
        }

        VertexState getLastKnownStateForSource(String src) {
            return this.sourcesOfInterest.get(src);
        }

        void setLastKnownStateForSource(String src, VertexState state) {
            this.sourcesOfInterest.put(src, state);
        }
    }

    private static class SourceInfo {
        private VertexState lastKnownState = VertexState.RUNNING;
        private final List<LlapNodeId> interestedNodes = new LinkedList<LlapNodeId>();
        private int numTasks;
        private int numCompletedTasks;

        private SourceInfo() {
        }

        void addNode(LlapNodeId nodeId) {
            this.interestedNodes.add(nodeId);
        }

        List<LlapNodeId> getInterestedNodes() {
            return this.interestedNodes;
        }
    }
}

