/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.trace.instrument.receivers.SendSpansViaThrift;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZooTraceClient
extends SendSpansViaThrift
implements Watcher {
    private static final Logger log = Logger.getLogger(ZooTraceClient.class);
    final ZooReader zoo;
    final String path;
    final Random random = new Random();
    final List<String> hosts = new ArrayList<String>();

    public ZooTraceClient(ZooReader zoo, String path, String host, String service, long millis) throws IOException, KeeperException, InterruptedException {
        super(host, service, millis);
        this.path = path;
        this.zoo = zoo;
        this.updateHosts(path, zoo.getChildren(path, (Watcher)this));
    }

    protected synchronized String getSpanKey(Map<String, String> data) {
        if (this.hosts.size() > 0) {
            return this.hosts.get(this.random.nextInt(this.hosts.size()));
        }
        return null;
    }

    public void process(WatchedEvent event) {
        try {
            this.updateHosts(this.path, this.zoo.getChildren(this.path, null));
        }
        catch (Exception ex) {
            log.error((Object)"unable to get destination hosts in zookeeper", (Throwable)ex);
        }
    }

    private synchronized void updateHosts(String path, List<String> children) {
        log.debug((Object)("Scanning trace hosts in zookeeper: " + path));
        try {
            ArrayList<String> hosts = new ArrayList<String>();
            for (String child : children) {
                byte[] data = this.zoo.getData(path + "/" + child, null);
                hosts.add(new String(data, Constants.UTF8));
            }
            this.hosts.clear();
            this.hosts.addAll(hosts);
            log.debug((Object)("Trace hosts: " + this.hosts));
        }
        catch (Exception ex) {
            log.error((Object)"unable to get destination hosts in zookeeper", (Throwable)ex);
        }
    }
}

