/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.Function;

public class Package {
    String name;
    ArrayList<Var> vars = new ArrayList();
    ArrayList<String> publicVars = new ArrayList();
    ArrayList<String> publicFuncs = new ArrayList();
    ArrayList<String> publicProcs = new ArrayList();
    HashMap<String, HplsqlParser.Create_function_stmtContext> func = new HashMap();
    HashMap<String, HplsqlParser.Create_procedure_stmtContext> proc = new HashMap();
    boolean allMembersPublic = false;
    Exec exec;
    Function function;
    boolean trace = false;

    Package(String name, Exec exec) {
        this.name = name;
        this.exec = exec;
        this.function = new Function(exec);
        this.trace = exec.getTrace();
    }

    void addVariable(Var var) {
        this.vars.add(var);
    }

    Var findVariable(String name) {
        for (Var var : this.vars) {
            if (!name.equalsIgnoreCase(var.getName())) continue;
            return var;
        }
        return null;
    }

    void createSpecification(HplsqlParser.Create_package_stmtContext ctx) {
        int cnt = ctx.package_spec().package_spec_item().size();
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Package_spec_itemContext c = ctx.package_spec().package_spec_item(i);
            if (c.declare_stmt_item() != null) {
                this.visit(c);
                continue;
            }
            if (c.T_FUNCTION() != null) {
                this.publicFuncs.add(c.ident().getText().toUpperCase());
                continue;
            }
            if (c.T_PROC() == null && c.T_PROCEDURE() == null) continue;
            this.publicProcs.add(c.ident().getText().toUpperCase());
        }
    }

    void createBody(HplsqlParser.Create_package_body_stmtContext ctx) {
        int cnt = ctx.package_body().package_body_item().size();
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Package_body_itemContext c = ctx.package_body().package_body_item(i);
            if (c.declare_stmt_item() != null) {
                this.visit(c);
                continue;
            }
            if (c.create_function_stmt() != null) {
                this.func.put(c.create_function_stmt().ident().getText().toUpperCase(), c.create_function_stmt());
                continue;
            }
            if (c.create_procedure_stmt() == null) continue;
            this.proc.put(c.create_procedure_stmt().ident(0).getText().toUpperCase(), c.create_procedure_stmt());
        }
    }

    public boolean execFunc(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        HplsqlParser.Create_function_stmtContext f = this.func.get(name.toUpperCase());
        if (f == null) {
            return this.execProc(name, ctx, false);
        }
        if (this.trace) {
            this.trace(ctx, "EXEC PACKAGE FUNCTION " + this.name + "." + name);
        }
        ArrayList<Var> actualParams = this.function.getActualCallParameters(ctx);
        this.exec.enterScope(Scope.Type.ROUTINE, this);
        this.function.setCallParameters(ctx, actualParams, f.create_routine_params(), null);
        this.visit(f.single_block_stmt());
        this.exec.leaveScope();
        return true;
    }

    public boolean execProc(String name, HplsqlParser.Expr_func_paramsContext ctx, boolean traceNotExists) {
        HplsqlParser.Create_procedure_stmtContext p = this.proc.get(name.toUpperCase());
        if (p == null) {
            if (this.trace && traceNotExists) {
                this.trace(ctx, "Package procedure not found: " + this.name + "." + name);
            }
            return false;
        }
        if (this.trace) {
            this.trace(ctx, "EXEC PACKAGE PROCEDURE " + this.name + "." + name);
        }
        ArrayList<Var> actualParams = this.function.getActualCallParameters(ctx);
        HashMap<String, Var> out = new HashMap<String, Var>();
        this.exec.enterScope(Scope.Type.ROUTINE, this);
        this.exec.callStackPush(name);
        if (p.create_routine_params() != null) {
            this.function.setCallParameters(ctx, actualParams, p.create_routine_params(), out);
        }
        this.visit(p.proc_block());
        this.exec.callStackPop();
        this.exec.leaveScope();
        for (Map.Entry<String, Var> i : out.entrySet()) {
            this.exec.setVariable(i.getKey(), i.getValue());
        }
        return true;
    }

    void setAllMembersPublic(boolean value) {
        this.allMembersPublic = value;
    }

    Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    Integer visitChildren(ParserRuleContext ctx) {
        return (Integer)this.exec.visitChildren((RuleNode)ctx);
    }

    public void trace(ParserRuleContext ctx, String message) {
        if (this.trace) {
            this.exec.trace(ctx, message);
        }
    }
}

