/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.ClientHook;

public class ClientCommandHookFactory {
    private static final ClientCommandHookFactory instance = new ClientCommandHookFactory();

    private ClientCommandHookFactory() {
    }

    public static ClientCommandHookFactory get() {
        return instance;
    }

    public ClientHook getHook(String cmdLine) {
        if (cmdLine.toLowerCase().startsWith("set")) {
            if (cmdLine.contains("=")) {
                return new SetCommandHook(cmdLine);
            }
            return null;
        }
        if (cmdLine.toLowerCase().startsWith("use")) {
            return new UseCommandHook(cmdLine);
        }
        return null;
    }

    public class UseCommandHook
    extends ClientHook {
        public UseCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            if (!beeLine.isBeeLine()) {
                String line = this.sql.replaceAll("\\s+", " ");
                String[] strs = line.split(" ");
                String dbName = strs == null || strs.length != 2 ? "" : strs[1];
                beeLine.setCurrentDatabase(dbName);
            }
        }
    }

    public class SetCommandHook
    extends ClientHook {
        public SetCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            if (!beeLine.isBeeLine()) {
                beeLine.getOpts().setHiveConf(beeLine.getCommands().getHiveConf(false));
            }
        }
    }
}

