/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.interpreter.NoneToBindableConverterRule;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.CalcMergeRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterCalcMergeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.JoinAssociateRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.MultiJoinOptimizeBushyRule;
import org.apache.calcite.rel.rules.ProjectCalcMergeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;

public class Programs {
    private static final Function<RuleSet, Program> RULE_SET_TO_PROGRAM = new Function<RuleSet, Program>(){

        public Program apply(RuleSet ruleSet) {
            return Programs.of(ruleSet);
        }
    };
    public static final ImmutableList<RelOptRule> CALC_RULES = ImmutableList.of((Object)NoneToBindableConverterRule.INSTANCE, (Object)EnumerableRules.ENUMERABLE_CALC_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE, (Object)CalcMergeRule.INSTANCE, (Object)FilterCalcMergeRule.INSTANCE, (Object)ProjectCalcMergeRule.INSTANCE, (Object)FilterToCalcRule.INSTANCE, (Object)ProjectToCalcRule.INSTANCE, (Object)CalcMergeRule.INSTANCE, (Object)FilterCalcMergeRule.INSTANCE, (Object)ProjectCalcMergeRule.INSTANCE, (Object[])new RelOptRule[0]);
    public static final Program CALC_PROGRAM = Programs.hep(CALC_RULES, true, new DefaultRelMetadataProvider());
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of((Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_SEMI_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_AGGREGATE_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, SemiJoinRule.INSTANCE, TableScanRule.INSTANCE, CalcitePrepareImpl.COMMUTE ? JoinAssociateRule.INSTANCE : ProjectMergeRule.INSTANCE, AggregateStarTableRule.INSTANCE, AggregateStarTableRule.INSTANCE2, FilterTableScanRule.INSTANCE, FilterProjectTransposeRule.INSTANCE, FilterJoinRule.FILTER_ON_JOIN, AggregateExpandDistinctAggregatesRule.INSTANCE, AggregateReduceFunctionsRule.INSTANCE, FilterAggregateTransposeRule.INSTANCE, JoinCommuteRule.INSTANCE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), RULE_SET_TO_PROGRAM);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Lists.transform(ruleSets, RULE_SET_TO_PROGRAM);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Iterable<? extends RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram((ImmutableList<Program>)ImmutableList.copyOf((Object[])programs));
    }

    public static Program hep(Iterable<? extends RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule relOptRule : rules) {
            builder.addRuleInstance(relOptRule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(final HepProgram hepProgram, final boolean noDag, final RelMetadataProvider metadataProvider) {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
                ArrayList list = Lists.newArrayList();
                if (metadataProvider != null) {
                    list.add(metadataProvider);
                }
                hepPlanner.registerMetadataProviders(list);
                RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
                rel.getCluster().setMetadataProvider(plannerChain);
                hepPlanner.setRoot(rel);
                return hepPlanner.findBestExp();
            }
        };
    }

    public static Program heuristicJoinOrder(final Iterable<? extends RelOptRule> rules, final boolean bushy, final int minJoinCount) {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                Program program;
                int joinCount = RelOptUtil.countJoins(rel);
                if (joinCount < minJoinCount) {
                    program = Programs.ofRules(rules);
                } else {
                    HepProgram hep = new HepProgramBuilder().addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(JoinToMultiJoinRule.INSTANCE).build();
                    Program program1 = Programs.of(hep, false, new DefaultRelMetadataProvider());
                    ArrayList list = Lists.newArrayList((Iterable)rules);
                    list.removeAll((Collection<?>)ImmutableList.of((Object)JoinCommuteRule.INSTANCE, (Object)JoinAssociateRule.INSTANCE, (Object)JoinPushThroughJoinRule.LEFT, (Object)JoinPushThroughJoinRule.RIGHT));
                    list.add(bushy ? MultiJoinOptimizeBushyRule.INSTANCE : LoptOptimizeJoinRule.INSTANCE);
                    Program program2 = Programs.ofRules(list);
                    program = Programs.sequence(program1, program2);
                }
                return program.run(planner, rel, requiredOutputTraits);
            }
        };
    }

    public static Program getProgram() {
        return new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                return null;
            }
        };
    }

    public static Program standard() {
        Program program1 = new Program(){

            @Override
            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                RelNode rootRel2;
                RelNode relNode = rootRel2 = rel.getTraitSet().equals(requiredOutputTraits) ? rel : planner.changeTraits(rel, requiredOutputTraits);
                assert (rootRel2 != null);
                planner.setRoot(rootRel2);
                RelOptPlanner planner2 = planner.chooseDelegate();
                RelNode rootRel3 = planner2.findBestExp();
                assert (rootRel3 != null) : "could not implement exp";
                return rootRel3;
            }
        };
        Program program2 = CALC_PROGRAM;
        return Programs.sequence(program1, program2);
    }

    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

