/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlFunction
extends SqlOperator {
    private static final Function1<Integer, String> ARG_FN = new Function1<Integer, String>(){

        public String apply(Integer a0) {
            return "arg" + a0;
        }
    };
    private final SqlFunctionCategory category;
    private final SqlIdentifier sqlIdentifier;
    private final List<RelDataType> paramTypes;

    public SqlFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, null, category);
        assert (category != SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR || returnTypeInference != null);
    }

    public SqlFunction(SqlIdentifier sqlIdentifier, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory funcType) {
        this(Util.last(sqlIdentifier.names), sqlIdentifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, funcType);
    }

    protected SqlFunction(String name, SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory category) {
        super(name, kind, 100, 100, returnTypeInference, operandTypeInference, operandTypeChecker);
        this.sqlIdentifier = sqlIdentifier;
        this.category = category;
        ImmutableList immutableList = this.paramTypes = paramTypes == null ? null : ImmutableList.copyOf(paramTypes);
        assert (category != null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public SqlIdentifier getNameAsId() {
        if (this.sqlIdentifier != null) {
            return this.sqlIdentifier;
        }
        return new SqlIdentifier(this.getName(), SqlParserPos.ZERO);
    }

    public List<RelDataType> getParamTypes() {
        return this.paramTypes;
    }

    public List<String> getParamNames() {
        return Functions.generate((int)this.paramTypes.size(), ARG_FN);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    public SqlFunctionCategory getFunctionType() {
        return this.category;
    }

    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        this.validateQuantifier(validator, call);
    }

    protected void validateQuantifier(SqlValidator validator, SqlCall call) {
        if (null != call.getFunctionQuantifier() && !this.isQuantifierAllowed()) {
            throw validator.newValidationError(call.getFunctionQuantifier(), Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.deriveType(validator, scope, call, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call, boolean convertRowArgToColumnList) {
        ImmutableList args;
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        validator.pushFunctionCall();
        ImmutableList.Builder nameBuilder = ImmutableList.builder();
        ImmutableList.Builder argBuilder = ImmutableList.builder();
        for (SqlNode operand : call.getOperandList()) {
            if (operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            List<SqlNode> operandList = ((SqlCall)operand).getOperandList();
            nameBuilder.add((Object)((SqlIdentifier)operandList.get(1)).getSimple());
            argBuilder.add((Object)operandList.get(0));
        }
        ImmutableList argNames = nameBuilder.build();
        if (argNames.isEmpty()) {
            args = call.getOperandList();
            argNames = null;
        } else {
            if (argNames.size() < call.getOperandList().size()) {
                throw validator.newValidationError(call, Static.RESOURCE.someButNotAllArgumentsAreNamed());
            }
            int duplicate = Util.firstDuplicate(argNames);
            if (duplicate >= 0) {
                throw validator.newValidationError(call, Static.RESOURCE.duplicateArgumentName((String)argNames.get(duplicate)));
            }
            args = argBuilder.build();
        }
        try {
            RelDataType relDataType;
            ImmutableList.Builder argTypeBuilder = ImmutableList.builder();
            boolean containsRowArg = false;
            for (SqlNode operand : args) {
                RelDataType nodeType;
                if (operand.getKind() == SqlKind.ROW && convertRowArgToColumnList) {
                    containsRowArg = true;
                    RelDataTypeFactory typeFactory = validator.getTypeFactory();
                    nodeType = typeFactory.createSqlType(SqlTypeName.COLUMN_LIST);
                } else {
                    nodeType = validator.deriveType(operandScope, operand);
                }
                validator.setValidatedNodeType(operand, nodeType);
                argTypeBuilder.add((Object)nodeType);
            }
            ImmutableList argTypes = argTypeBuilder.build();
            SqlFunction function = SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)argTypes, (List<String>)argNames, this.getFunctionType());
            if (containsRowArg) {
                if (function == null && SqlUtil.matchRoutinesByParameterCount(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)argTypes, this.getFunctionType())) {
                    for (SqlNode operand : args) {
                        if (operand.getKind() != SqlKind.ROW) continue;
                        validator.removeValidatedNodeType(operand);
                    }
                    relDataType = this.deriveType(validator, scope, call, false);
                    return relDataType;
                }
                if (function != null) {
                    validator.validateColumnListParams(function, (List<RelDataType>)argTypes, (List<SqlNode>)args);
                }
            }
            if (this.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
                relDataType = validator.deriveConstructorType(scope, call, this, function, (List<RelDataType>)argTypes);
                return relDataType;
            }
            if (function == null) {
                throw validator.handleUnresolvedFunction(call, this, (List<RelDataType>)argTypes, (List<String>)argNames);
            }
            ((SqlBasicCall)call).setOperator(function);
            relDataType = function.validateOperands(validator, operandScope, call);
            return relDataType;
        }
        finally {
            validator.popFunctionCall();
        }
    }
}

