/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.EquiJoin;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Stacks;
import org.apache.calcite.util.Util;

public abstract class ReduceExpressionsRule
extends RelOptRule {
    public static final Pattern EXCLUSION_PATTERN = Pattern.compile("Reduce(Expressions|Values)Rule.*");
    public static final ReduceExpressionsRule FILTER_INSTANCE = new FilterReduceExpressionsRule(LogicalFilter.class, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule PROJECT_INSTANCE = new ProjectReduceExpressionsRule(LogicalProject.class, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule JOIN_INSTANCE = new JoinReduceExpressionsRule(Join.class, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule CALC_INSTANCE = new CalcReduceExpressionsRule(LogicalCalc.class, RelFactories.LOGICAL_BUILDER);

    protected ReduceExpressionsRule(Class<? extends RelNode> clazz, RelBuilderFactory relBuilderFactory, String desc) {
        super(ReduceExpressionsRule.operand(clazz, ReduceExpressionsRule.any()), relBuilderFactory, desc);
    }

    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates) {
        RelOptPlanner.Executor executor;
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        new CaseShuttle().mutate(expList);
        ArrayList constExps = Lists.newArrayList();
        List<Object> addCasts = Lists.newArrayList();
        ArrayList removableCasts = Lists.newArrayList();
        ImmutableMap<RexNode, RexLiteral> constants = ReduceExpressionsRule.predicateConstants(predicates);
        ReduceExpressionsRule.findReducibleExps(rel.getCluster().getTypeFactory(), expList, constants, constExps, addCasts, removableCasts);
        if (constExps.isEmpty() && removableCasts.isEmpty()) {
            return false;
        }
        if (!removableCasts.isEmpty()) {
            ArrayList reducedExprs = Lists.newArrayList();
            for (RexNode exp : removableCasts) {
                RexCall call = (RexCall)exp;
                reducedExprs.add(call.getOperands().get(0));
            }
            RexReplacer replacer = new RexReplacer(rexBuilder, removableCasts, reducedExprs, Collections.nCopies(removableCasts.size(), false));
            replacer.mutate(expList);
        }
        if (constExps.isEmpty()) {
            return true;
        }
        ArrayList constExps2 = Lists.newArrayList((Iterable)constExps);
        if (!constants.isEmpty()) {
            ArrayList pairs = Lists.newArrayList((Iterable)constants.entrySet());
            RexReplacer replacer = new RexReplacer(rexBuilder, Pair.left(pairs), Pair.right(pairs), Collections.nCopies(pairs.size(), false));
            replacer.mutate(constExps2);
        }
        if ((executor = rel.getCluster().getPlanner().getExecutor()) == null) {
            return false;
        }
        ArrayList reducedValues = Lists.newArrayList();
        executor.reduce(rexBuilder, constExps2, reducedValues);
        if (rel instanceof Project) {
            addCasts = Collections.nCopies(reducedValues.size(), true);
        }
        RexReplacer replacer = new RexReplacer(rexBuilder, constExps, reducedValues, addCasts);
        replacer.mutate(expList);
        return true;
    }

    protected static void findReducibleExps(RelDataTypeFactory typeFactory, List<RexNode> exps, ImmutableMap<RexNode, RexLiteral> constants, List<RexNode> constExps, List<Boolean> addCasts, List<RexNode> removableCasts) {
        ReducibleExprLocator gardener = new ReducibleExprLocator(typeFactory, constants, constExps, addCasts, removableCasts);
        for (RexNode exp : exps) {
            gardener.analyze(exp);
        }
        assert (constExps.size() == addCasts.size());
    }

    protected static ImmutableMap<RexNode, RexLiteral> predicateConstants(RelOptPredicateList predicates) {
        HashMap<RexNode, RexLiteral> map = new HashMap<RexNode, RexLiteral>();
        HashSet<RexNode> excludeSet = new HashSet<RexNode>();
        for (RexNode predicate : predicates.pulledUpPredicates) {
            ReduceExpressionsRule.gatherConstraints(map, predicate, excludeSet);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            RexNode rexNode = (RexNode)entry.getKey();
            if (ReduceExpressionsRule.overlap(rexNode, excludeSet)) continue;
            builder.put((Object)rexNode, entry.getValue());
        }
        return builder.build();
    }

    private static boolean overlap(RexNode rexNode, Set<RexNode> set) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                if (!ReduceExpressionsRule.overlap(r, set)) continue;
                return true;
            }
            return false;
        }
        return set.contains(rexNode);
    }

    private static void decompose(Set<RexNode> set, RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                ReduceExpressionsRule.decompose(set, r);
            }
        } else if (!(rexNode instanceof RexLiteral)) {
            set.add(rexNode);
        }
    }

    private static void gatherConstraints(Map<RexNode, RexLiteral> map, RexNode predicate, Set<RexNode> excludeSet) {
        if (predicate.getKind() != SqlKind.EQUALS) {
            ReduceExpressionsRule.decompose(excludeSet, predicate);
            return;
        }
        List<RexNode> operands = ((RexCall)predicate).getOperands();
        if (operands.size() != 2) {
            ReduceExpressionsRule.decompose(excludeSet, predicate);
            return;
        }
        RexNode left = operands.get(0);
        RexNode right = operands.get(1);
        if (right instanceof RexLiteral && !excludeSet.contains(left)) {
            RexLiteral existedValue = map.get(left);
            if (existedValue == null) {
                map.put(left, (RexLiteral)right);
            } else if (!existedValue.getValue().equals(((RexLiteral)right).getValue())) {
                map.remove(left);
                excludeSet.add(left);
            }
        } else if (left instanceof RexLiteral && !excludeSet.contains(right)) {
            RexLiteral existedValue = map.get(right);
            if (existedValue == null) {
                map.put(right, (RexLiteral)left);
            } else if (!existedValue.getValue().equals(((RexLiteral)left).getValue())) {
                map.remove(right);
                excludeSet.add(right);
            }
        }
    }

    protected static RexCall pushPredicateIntoCase(RexCall call) {
        if (call.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return call;
        }
        switch (call.getKind()) {
            case CASE: 
            case AND: 
            case OR: {
                return call;
            }
        }
        int caseOrdinal = -1;
        List<RexNode> operands = call.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = operands.get(i);
            switch (operand.getKind()) {
                case CASE: {
                    caseOrdinal = i;
                }
            }
        }
        if (caseOrdinal < 0) {
            return call;
        }
        RexCall case_ = (RexCall)operands.get(caseOrdinal);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        for (int i = 0; i < case_.getOperands().size(); ++i) {
            RexNode node = case_.getOperands().get(i);
            if (!RexUtil.isCasePredicate(case_, i)) {
                node = ReduceExpressionsRule.substitute(call, caseOrdinal, node);
            }
            nodes.add(node);
        }
        return case_.clone(call.getType(), nodes);
    }

    protected static RexNode substitute(RexCall call, int ordinal, RexNode node) {
        ArrayList newOperands = Lists.newArrayList(call.getOperands());
        newOperands.set(ordinal, node);
        return call.clone(call.getType(), newOperands);
    }

    protected static class CaseShuttle
    extends RexShuttle {
        protected CaseShuttle() {
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexCall old;
            do {
                old = call = (RexCall)super.visitCall(call);
            } while ((call = ReduceExpressionsRule.pushPredicateIntoCase(call)) != old);
            return call;
        }
    }

    protected static class ReducibleExprLocator
    extends RexVisitorImpl<Void> {
        private final RelDataTypeFactory typeFactory;
        private final List<Constancy> stack;
        private final ImmutableMap<RexNode, RexLiteral> constants;
        private final List<RexNode> constExprs;
        private final List<Boolean> addCasts;
        private final List<RexNode> removableCasts;
        private final List<SqlOperator> parentCallTypeStack;

        ReducibleExprLocator(RelDataTypeFactory typeFactory, ImmutableMap<RexNode, RexLiteral> constants, List<RexNode> constExprs, List<Boolean> addCasts, List<RexNode> removableCasts) {
            super(true);
            this.typeFactory = typeFactory;
            this.constants = constants;
            this.constExprs = constExprs;
            this.addCasts = addCasts;
            this.removableCasts = removableCasts;
            this.stack = Lists.newArrayList();
            this.parentCallTypeStack = Lists.newArrayList();
        }

        public void analyze(RexNode exp) {
            assert (this.stack.isEmpty());
            exp.accept(this);
            assert (this.stack.size() == 1);
            assert (this.parentCallTypeStack.isEmpty());
            Constancy rootConstancy = this.stack.get(0);
            if (rootConstancy == Constancy.REDUCIBLE_CONSTANT) {
                this.addResult(exp);
            }
            this.stack.clear();
        }

        private Void pushVariable() {
            this.stack.add(Constancy.NON_CONSTANT);
            return null;
        }

        private void addResult(RexNode exp) {
            RexCall cast;
            RexNode operand;
            if (exp.getKind() == SqlKind.CAST && (operand = (cast = (RexCall)exp).getOperands().get(0)) instanceof RexLiteral) {
                return;
            }
            this.constExprs.add(exp);
            if (this.parentCallTypeStack.isEmpty()) {
                this.addCasts.add(false);
            } else {
                this.addCasts.add(this.isUdf(Stacks.peek(this.parentCallTypeStack)));
            }
        }

        private Boolean isUdf(SqlOperator operator) {
            return false;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            if (this.constants.containsKey((Object)inputRef)) {
                this.stack.add(Constancy.REDUCIBLE_CONSTANT);
                return null;
            }
            return this.pushVariable();
        }

        @Override
        public Void visitLiteral(RexLiteral literal) {
            this.stack.add(Constancy.IRREDUCIBLE_CONSTANT);
            return null;
        }

        @Override
        public Void visitOver(RexOver over) {
            this.analyzeCall(over, Constancy.NON_CONSTANT);
            return null;
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.pushVariable();
        }

        @Override
        public Void visitCall(RexCall call) {
            this.analyzeCall(call, Constancy.REDUCIBLE_CONSTANT);
            return null;
        }

        private void analyzeCall(RexCall call, Constancy callConstancy) {
            Stacks.push(this.parentCallTypeStack, call.getOperator());
            super.visitCall(call);
            int operandCount = call.getOperands().size();
            List<Constancy> operandStack = Util.last(this.stack, operandCount);
            for (Constancy operandConstancy : operandStack) {
                if (operandConstancy != Constancy.NON_CONSTANT) continue;
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (!call.getOperator().isDeterministic()) {
                callConstancy = Constancy.NON_CONSTANT;
            } else if (call.getOperator().isDynamicFunction()) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.REDUCIBLE_CONSTANT && call.getOperator() instanceof SqlRowOperator) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.NON_CONSTANT) {
                for (int iOperand = 0; iOperand < operandCount; ++iOperand) {
                    Constancy constancy = operandStack.get(iOperand);
                    if (constancy != Constancy.REDUCIBLE_CONSTANT) continue;
                    this.addResult(call.getOperands().get(iOperand));
                }
                if (call.getOperator() == SqlStdOperatorTable.CAST) {
                    this.reduceCasts(call);
                }
            }
            operandStack.clear();
            Stacks.pop(this.parentCallTypeStack, call.getOperator());
            this.stack.add(callConstancy);
        }

        private void reduceCasts(RexCall outerCast) {
            RelDataType innerTypeNullable;
            List<RexNode> operands = outerCast.getOperands();
            if (operands.size() != 1) {
                return;
            }
            RelDataType outerCastType = outerCast.getType();
            RelDataType operandType = operands.get(0).getType();
            if (operandType.equals(outerCastType)) {
                this.removableCasts.add(outerCast);
                return;
            }
            if (!(operands.get(0) instanceof RexCall)) {
                return;
            }
            RexCall innerCast = (RexCall)operands.get(0);
            if (innerCast.getOperator() != SqlStdOperatorTable.CAST) {
                return;
            }
            if (innerCast.getOperands().size() != 1) {
                return;
            }
            RelDataType outerTypeNullable = this.typeFactory.createTypeWithNullability(outerCastType, true);
            if (outerTypeNullable != (innerTypeNullable = this.typeFactory.createTypeWithNullability(operandType, true))) {
                return;
            }
            if (operandType.isNullable()) {
                this.removableCasts.add(innerCast);
            }
        }

        @Override
        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.pushVariable();
        }

        @Override
        public Void visitRangeRef(RexRangeRef rangeRef) {
            return this.pushVariable();
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.pushVariable();
        }

        static enum Constancy {
            NON_CONSTANT,
            REDUCIBLE_CONSTANT,
            IRREDUCIBLE_CONSTANT;

        }
    }

    protected static class RexReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final List<RexNode> reducibleExps;
        private final List<RexNode> reducedValues;
        private final List<Boolean> addCasts;

        RexReplacer(RexBuilder rexBuilder, List<RexNode> reducibleExps, List<RexNode> reducedValues, List<Boolean> addCasts) {
            this.rexBuilder = rexBuilder;
            this.reducibleExps = reducibleExps;
            this.reducedValues = reducedValues;
            this.addCasts = addCasts;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RexNode node = this.visit(inputRef);
            if (node == null) {
                return super.visitInputRef(inputRef);
            }
            return node;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode node = this.visit(call);
            if (node != null) {
                return node;
            }
            node = super.visitCall(call);
            if (node != call) {
                node = RexUtil.simplify(this.rexBuilder, node);
            }
            return node;
        }

        private RexNode visit(RexNode call) {
            int i = this.reducibleExps.indexOf(call);
            if (i == -1) {
                return null;
            }
            RexNode replacement = this.reducedValues.get(i);
            if (this.addCasts.get(i).booleanValue() && replacement.getType() != call.getType()) {
                replacement = this.rexBuilder.makeCast(call.getType(), replacement, true);
            }
            return replacement;
        }
    }

    public static class CalcReduceExpressionsRule
    extends ReduceExpressionsRule {
        public CalcReduceExpressionsRule(Class<? extends Calc> calcClass, RelBuilderFactory relBuilderFactory) {
            super(calcClass, relBuilderFactory, "ReduceExpressionsRule(Calc)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            RexProgram program = calc.getProgram();
            List<RexNode> exprList = program.getExprList();
            final ArrayList expandedExprList = Lists.newArrayList();
            RexShuttle shuttle = new RexShuttle(){

                @Override
                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return (RexNode)expandedExprList.get(localRef.getIndex());
                }
            };
            for (RexNode expr : exprList) {
                expandedExprList.add(expr.accept(shuttle));
            }
            RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
            if (CalcReduceExpressionsRule.reduceExpressions(calc, expandedExprList, predicates)) {
                int conditionIndex;
                RexNode newConditionExp;
                RexProgramBuilder builder = new RexProgramBuilder(calc.getInput().getRowType(), calc.getCluster().getRexBuilder());
                ArrayList list = Lists.newArrayList();
                for (RexNode expr : expandedExprList) {
                    list.add(builder.registerInput(expr));
                }
                if (program.getCondition() != null && !(newConditionExp = (RexNode)expandedExprList.get(conditionIndex = program.getCondition().getIndex())).isAlwaysTrue()) {
                    if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                        call.transformTo(call.builder().values(calc.getRowType()).build());
                        return;
                    }
                    builder.addCondition((RexNode)list.get(conditionIndex));
                }
                int k = 0;
                for (RexLocalRef projectExpr : program.getProjectList()) {
                    int index = projectExpr.getIndex();
                    builder.addProject(((RexLocalRef)list.get(index)).getIndex(), program.getOutputRowType().getFieldNames().get(k++));
                }
                call.transformTo(calc.copy(calc.getTraitSet(), calc.getInput(), builder.getProgram()));
                call.getPlanner().setImportance(calc, 0.0);
            }
        }
    }

    public static class JoinReduceExpressionsRule
    extends ReduceExpressionsRule {
        public JoinReduceExpressionsRule(Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
            super(joinClass, relBuilderFactory, "ReduceExpressionsRule(Join)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            JoinInfo joinInfo;
            RelOptPredicateList rightPredicates;
            Join join = (Join)call.rel(0);
            ArrayList expList = Lists.newArrayList((Object[])new RexNode[]{join.getCondition()});
            int fieldCount = join.getLeft().getRowType().getFieldCount();
            RelOptPredicateList leftPredicates = RelMetadataQuery.getPulledUpPredicates(join.getLeft());
            RelOptPredicateList predicates = leftPredicates.union((rightPredicates = RelMetadataQuery.getPulledUpPredicates(join.getRight())).shift(fieldCount));
            if (!JoinReduceExpressionsRule.reduceExpressions(join, expList, predicates)) {
                return;
            }
            if (join instanceof EquiJoin && !(joinInfo = JoinInfo.of(join.getLeft(), join.getRight(), (RexNode)expList.get(0))).isEqui()) {
                return;
            }
            call.transformTo(join.copy(join.getTraitSet(), (RexNode)expList.get(0), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
            call.getPlanner().setImportance(join, 0.0);
        }
    }

    public static class ProjectReduceExpressionsRule
    extends ReduceExpressionsRule {
        public ProjectReduceExpressionsRule(Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
            super(projectClass, relBuilderFactory, "ReduceExpressionsRule(Project)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelOptPredicateList predicates = RelMetadataQuery.getPulledUpPredicates(project.getInput());
            ArrayList expList = Lists.newArrayList(project.getProjects());
            if (ProjectReduceExpressionsRule.reduceExpressions(project, expList, predicates)) {
                call.transformTo(call.builder().push(project.getInput()).project(expList, project.getRowType().getFieldNames()).build());
                call.getPlanner().setImportance(project, 0.0);
            }
        }
    }

    public static class FilterReduceExpressionsRule
    extends ReduceExpressionsRule {
        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
            super(filterClass, relBuilderFactory, "ReduceExpressionsRule(Filter)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelOptPredicateList predicates;
            ArrayList expList;
            Filter filter = (Filter)call.rel(0);
            if (FilterReduceExpressionsRule.reduceExpressions(filter, expList = Lists.newArrayList((Object[])new RexNode[]{filter.getCondition()}), predicates = RelMetadataQuery.getPulledUpPredicates(filter.getInput()))) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                call.transformTo(call.builder().values(filter.getRowType()).build());
            } else if (reduced) {
                call.transformTo(call.builder().push(filter.getInput()).filter((RexNode)expList.get(0)).build());
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    RexCall rexCall = (RexCall)newConditionExp;
                    boolean bl = reverse = rexCall.getOperator() == SqlStdOperatorTable.NOT;
                    if (reverse) {
                        rexCall = (RexCall)rexCall.getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, rexCall, reverse);
                }
                return;
            }
            call.getPlanner().setImportance(filter, 0.0);
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, Filter filter, RexCall rexCall, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            switch (rexCall.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = rexCall.getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getInput());
                } else {
                    call.transformTo(call.builder().values(filter.getRowType()).build());
                }
            }
        }
    }
}

