/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public class RelMdPredicates {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.PREDICATES.method, new RelMdPredicates());
    private static final List<RexNode> EMPTY_LIST = ImmutableList.of();

    public RelOptPredicateList getPredicates(RelNode rel) {
        return RelOptPredicateList.EMPTY;
    }

    public RelOptPredicateList getPredicates(TableScan table) {
        return RelOptPredicateList.EMPTY;
    }

    public RelOptPredicateList getPredicates(Project project) {
        RelNode child = project.getInput();
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelOptPredicateList childInfo = RelMetadataQuery.getPulledUpPredicates(child);
        ArrayList<RexNode> projectPullUpPredicates = new ArrayList<RexNode>();
        ImmutableBitSet.Builder columnsMappedBuilder = ImmutableBitSet.builder();
        Mapping m = Mappings.create(MappingType.PARTIAL_FUNCTION, child.getRowType().getFieldCount(), project.getRowType().getFieldCount());
        for (Ord o : Ord.zip(project.getProjects())) {
            if (!(o.e instanceof RexInputRef)) continue;
            int sIdx = ((RexInputRef)o.e).getIndex();
            m.set(sIdx, o.i);
            columnsMappedBuilder.set(sIdx);
        }
        ImmutableBitSet columnsMapped = columnsMappedBuilder.build();
        for (RexNode r : childInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(r);
            if (!columnsMapped.contains(rCols)) continue;
            r = r.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, child));
            projectPullUpPredicates.add(r);
        }
        for (Ord expr : Ord.zip(project.getProjects())) {
            if (RexLiteral.isNullLiteral((RexNode)expr.e)) {
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, rexBuilder.makeInputRef(project, expr.i)));
                continue;
            }
            if (!(expr.e instanceof RexLiteral)) continue;
            RexLiteral literal = (RexLiteral)expr.e;
            projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(project, expr.i), literal));
        }
        return RelOptPredicateList.of(projectPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Filter filter) {
        RelNode child = filter.getInput();
        RelOptPredicateList childInfo = RelMetadataQuery.getPulledUpPredicates(child);
        return RelOptPredicateList.of(Iterables.concat(childInfo.pulledUpPredicates, RelOptUtil.conjunctions(filter.getCondition())));
    }

    public RelOptPredicateList getPredicates(SemiJoin semiJoin) {
        RexBuilder rB = semiJoin.getCluster().getRexBuilder();
        RelNode left = semiJoin.getInput(0);
        RelNode right = semiJoin.getInput(1);
        RelOptPredicateList leftInfo = RelMetadataQuery.getPulledUpPredicates(left);
        RelOptPredicateList rightInfo = RelMetadataQuery.getPulledUpPredicates(right);
        JoinConditionBasedPredicateInference jI = new JoinConditionBasedPredicateInference(semiJoin, RexUtil.composeConjunction(rB, leftInfo.pulledUpPredicates, false), RexUtil.composeConjunction(rB, rightInfo.pulledUpPredicates, false));
        return jI.inferPredicates(false);
    }

    public RelOptPredicateList getPredicates(Join join) {
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelOptPredicateList leftInfo = RelMetadataQuery.getPulledUpPredicates(left);
        RelOptPredicateList rightInfo = RelMetadataQuery.getPulledUpPredicates(right);
        JoinConditionBasedPredicateInference jI = new JoinConditionBasedPredicateInference(join, RexUtil.composeConjunction(rB, leftInfo.pulledUpPredicates, false), RexUtil.composeConjunction(rB, rightInfo.pulledUpPredicates, false));
        return jI.inferPredicates(false);
    }

    public RelOptPredicateList getPredicates(Aggregate agg) {
        RelNode child = agg.getInput();
        RelOptPredicateList childInfo = RelMetadataQuery.getPulledUpPredicates(child);
        ArrayList<RexNode> aggPullUpPredicates = new ArrayList<RexNode>();
        ImmutableBitSet groupKeys = agg.getGroupSet();
        Mapping m = Mappings.create(MappingType.PARTIAL_FUNCTION, child.getRowType().getFieldCount(), agg.getRowType().getFieldCount());
        int i = 0;
        Iterator i$ = groupKeys.iterator();
        while (i$.hasNext()) {
            int j = i$.next();
            m.set(j, i++);
        }
        for (RexNode r : childInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(r);
            if (!groupKeys.contains(rCols)) continue;
            r = r.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, child));
            aggPullUpPredicates.add(r);
        }
        return RelOptPredicateList.of(aggPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Union union) {
        RexBuilder rB = union.getCluster().getRexBuilder();
        ArrayList orList = Lists.newArrayList();
        for (RelNode input : union.getInputs()) {
            RelOptPredicateList info = RelMetadataQuery.getPulledUpPredicates(input);
            if (info.pulledUpPredicates.isEmpty()) {
                return RelOptPredicateList.EMPTY;
            }
            RelOptUtil.decomposeDisjunction(RexUtil.composeConjunction(rB, info.pulledUpPredicates, false), orList);
        }
        if (orList.isEmpty()) {
            return RelOptPredicateList.EMPTY;
        }
        return RelOptPredicateList.of(RelOptUtil.conjunctions(RexUtil.composeDisjunction(rB, orList, false)));
    }

    public RelOptPredicateList getPredicates(Sort sort) {
        RelNode child = sort.getInput();
        return RelMetadataQuery.getPulledUpPredicates(child);
    }

    public RelOptPredicateList getPredicates(Exchange exchange) {
        RelNode child = exchange.getInput();
        return RelMetadataQuery.getPulledUpPredicates(child);
    }

    static class JoinConditionBasedPredicateInference {
        final Join joinRel;
        final boolean isSemiJoin;
        final int nSysFields;
        final int nFieldsLeft;
        final int nFieldsRight;
        final ImmutableBitSet leftFieldsBitSet;
        final ImmutableBitSet rightFieldsBitSet;
        final ImmutableBitSet allFieldsBitSet;
        SortedMap<Integer, BitSet> equivalence;
        final Map<String, ImmutableBitSet> exprFields;
        final Set<String> allExprsDigests;
        final Set<String> equalityPredicates;
        final RexNode leftChildPredicates;
        final RexNode rightChildPredicates;

        public JoinConditionBasedPredicateInference(Join joinRel, RexNode lPreds, RexNode rPreds) {
            this(joinRel, joinRel instanceof SemiJoin, lPreds, rPreds);
        }

        private JoinConditionBasedPredicateInference(Join joinRel, boolean isSemiJoin, RexNode lPreds, RexNode rPreds) {
            this.joinRel = joinRel;
            this.isSemiJoin = isSemiJoin;
            this.nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
            this.nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
            this.nSysFields = joinRel.getSystemFieldList().size();
            this.leftFieldsBitSet = ImmutableBitSet.range(this.nSysFields, this.nSysFields + this.nFieldsLeft);
            this.rightFieldsBitSet = ImmutableBitSet.range(this.nSysFields + this.nFieldsLeft, this.nSysFields + this.nFieldsLeft + this.nFieldsRight);
            this.allFieldsBitSet = ImmutableBitSet.range(0, this.nSysFields + this.nFieldsLeft + this.nFieldsRight);
            this.exprFields = Maps.newHashMap();
            this.allExprsDigests = new HashSet<String>();
            if (lPreds == null) {
                this.leftChildPredicates = null;
            } else {
                Mappings.TargetMapping leftMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft, this.nSysFields, 0, this.nFieldsLeft);
                this.leftChildPredicates = lPreds.accept(new RexPermuteInputsShuttle(leftMapping, joinRel.getInput(0)));
                for (RexNode r : RelOptUtil.conjunctions(this.leftChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits(r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            if (rPreds == null) {
                this.rightChildPredicates = null;
            } else {
                Mappings.TargetMapping rightMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft + this.nFieldsRight, this.nSysFields + this.nFieldsLeft, 0, this.nFieldsRight);
                this.rightChildPredicates = rPreds.accept(new RexPermuteInputsShuttle(rightMapping, joinRel.getInput(1)));
                for (RexNode r : RelOptUtil.conjunctions(this.rightChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits(r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            this.equivalence = Maps.newTreeMap();
            this.equalityPredicates = new HashSet<String>();
            for (int i = 0; i < this.nSysFields + this.nFieldsLeft + this.nFieldsRight; ++i) {
                this.equivalence.put(i, BitSets.of(i));
            }
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            List<RexNode> exprs = RelOptUtil.conjunctions(this.compose(rexBuilder, (Iterable<RexNode>)ImmutableList.of((Object)joinRel.getCondition())));
            final EquivalenceFinder eF = new EquivalenceFinder();
            new ArrayList(Lists.transform(exprs, (Function)new Function<RexNode, Void>(){

                public Void apply(RexNode input) {
                    return input.accept(eF);
                }
            }));
            this.equivalence = BitSets.closure(this.equivalence);
        }

        public RelOptPredicateList inferPredicates(boolean includeEqualityInference) {
            ArrayList<RexNode> inferredPredicates = new ArrayList<RexNode>();
            HashSet<String> allExprsDigests = new HashSet<String>(this.allExprsDigests);
            JoinRelType joinType = this.joinRel.getJoinType();
            switch (joinType) {
                case INNER: 
                case LEFT: {
                    this.infer(this.leftChildPredicates, allExprsDigests, inferredPredicates, includeEqualityInference, joinType == JoinRelType.LEFT ? this.rightFieldsBitSet : this.allFieldsBitSet);
                }
            }
            switch (joinType) {
                case INNER: 
                case RIGHT: {
                    this.infer(this.rightChildPredicates, allExprsDigests, inferredPredicates, includeEqualityInference, joinType == JoinRelType.RIGHT ? this.leftFieldsBitSet : this.allFieldsBitSet);
                }
            }
            Mappings.TargetMapping rightMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft + this.nFieldsRight, 0, this.nSysFields + this.nFieldsLeft, this.nFieldsRight);
            RexPermuteInputsShuttle rightPermute = new RexPermuteInputsShuttle(rightMapping, this.joinRel);
            Mappings.TargetMapping leftMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft, 0, this.nSysFields, this.nFieldsLeft);
            RexPermuteInputsShuttle leftPermute = new RexPermuteInputsShuttle(leftMapping, this.joinRel);
            ArrayList<RexNode> leftInferredPredicates = new ArrayList<RexNode>();
            ArrayList<RexNode> rightInferredPredicates = new ArrayList<RexNode>();
            for (RexNode iP : inferredPredicates) {
                ImmutableBitSet iPBitSet = RelOptUtil.InputFinder.bits(iP);
                if (this.leftFieldsBitSet.contains(iPBitSet)) {
                    leftInferredPredicates.add(iP.accept(leftPermute));
                    continue;
                }
                if (!this.rightFieldsBitSet.contains(iPBitSet)) continue;
                rightInferredPredicates.add(iP.accept(rightPermute));
            }
            switch (joinType) {
                case INNER: {
                    Iterable pulledUpPredicates = this.isSemiJoin ? Iterables.concat(RelOptUtil.conjunctions(this.leftChildPredicates), leftInferredPredicates) : Iterables.concat(RelOptUtil.conjunctions(this.leftChildPredicates), RelOptUtil.conjunctions(this.rightChildPredicates), RelOptUtil.conjunctions(this.joinRel.getCondition()), inferredPredicates);
                    return RelOptPredicateList.of(pulledUpPredicates, leftInferredPredicates, rightInferredPredicates);
                }
                case LEFT: {
                    return RelOptPredicateList.of(RelOptUtil.conjunctions(this.leftChildPredicates), leftInferredPredicates, rightInferredPredicates);
                }
                case RIGHT: {
                    return RelOptPredicateList.of(RelOptUtil.conjunctions(this.rightChildPredicates), inferredPredicates, EMPTY_LIST);
                }
            }
            assert (inferredPredicates.size() == 0);
            return RelOptPredicateList.EMPTY;
        }

        public RexNode left() {
            return this.leftChildPredicates;
        }

        public RexNode right() {
            return this.rightChildPredicates;
        }

        private void infer(RexNode predicates, Set<String> allExprsDigests, List<RexNode> inferedPredicates, boolean includeEqualityInference, ImmutableBitSet inferringFields) {
            for (RexNode r : RelOptUtil.conjunctions(predicates)) {
                if (!includeEqualityInference && this.equalityPredicates.contains(r.toString())) continue;
                for (Mapping m : this.mappings(r)) {
                    RexNode tr = r.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, this.joinRel.getInput(0), this.joinRel.getInput(1)));
                    if (!inferringFields.contains(RelOptUtil.InputFinder.bits(tr)) || allExprsDigests.contains(tr.toString()) || this.isAlwaysTrue(tr)) continue;
                    inferedPredicates.add(tr);
                    allExprsDigests.add(tr.toString());
                }
            }
        }

        Iterable<Mapping> mappings(final RexNode predicate) {
            return new Iterable<Mapping>(){

                @Override
                public Iterator<Mapping> iterator() {
                    ImmutableBitSet fields = JoinConditionBasedPredicateInference.this.exprFields.get(predicate.toString());
                    if (fields.cardinality() == 0) {
                        return Iterators.emptyIterator();
                    }
                    return new ExprsItr(fields);
                }
            };
        }

        private void equivalent(int p1, int p2) {
            BitSet b = (BitSet)this.equivalence.get(p1);
            b.set(p2);
            b = (BitSet)this.equivalence.get(p2);
            b.set(p1);
        }

        RexNode compose(RexBuilder rexBuilder, Iterable<RexNode> exprs) {
            exprs = Linq4j.asEnumerable(exprs).where((Predicate1)new Predicate1<RexNode>(){

                public boolean apply(RexNode expr) {
                    return expr != null;
                }
            });
            return RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)exprs, false);
        }

        private int pos(RexNode expr) {
            if (expr instanceof RexInputRef) {
                return ((RexInputRef)expr).getIndex();
            }
            return -1;
        }

        private boolean isAlwaysTrue(RexNode predicate) {
            RexCall c;
            if (predicate instanceof RexCall && (c = (RexCall)predicate).getOperator().getKind() == SqlKind.EQUALS) {
                int lPos = this.pos(c.getOperands().get(0));
                int rPos = this.pos(c.getOperands().get(1));
                return lPos != -1 && lPos == rPos;
            }
            return predicate.isAlwaysTrue();
        }

        class ExprsItr
        implements Iterator<Mapping> {
            final int[] columns;
            final BitSet[] columnSets;
            final int[] iterationIdx;
            Mapping nextMapping = null;
            boolean firstCall;

            ExprsItr(ImmutableBitSet fields) {
                this.columns = new int[fields.cardinality()];
                this.columnSets = new BitSet[fields.cardinality()];
                this.iterationIdx = new int[fields.cardinality()];
                int j = 0;
                int i = fields.nextSetBit(0);
                while (i >= 0) {
                    this.columns[j] = i;
                    this.columnSets[j] = (BitSet)JoinConditionBasedPredicateInference.this.equivalence.get(i);
                    this.iterationIdx[j] = 0;
                    i = fields.nextSetBit(i + 1);
                    ++j;
                }
                this.firstCall = true;
            }

            @Override
            public boolean hasNext() {
                if (this.firstCall) {
                    this.initializeMapping();
                    this.firstCall = false;
                } else {
                    this.computeNextMapping(this.iterationIdx.length - 1);
                }
                return this.nextMapping != null;
            }

            @Override
            public Mapping next() {
                return this.nextMapping;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void computeNextMapping(int level) {
                int t = this.columnSets[level].nextSetBit(this.iterationIdx[level]);
                if (t < 0) {
                    if (level == 0) {
                        this.nextMapping = null;
                    } else {
                        this.iterationIdx[level] = 0;
                        this.computeNextMapping(level - 1);
                    }
                } else {
                    this.nextMapping.set(this.columns[level], t);
                    this.iterationIdx[level] = t + 1;
                }
            }

            private void initializeMapping() {
                this.nextMapping = Mappings.create(MappingType.PARTIAL_FUNCTION, JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight, JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight);
                for (int i = 0; i < this.columnSets.length; ++i) {
                    BitSet c = this.columnSets[i];
                    int t = c.nextSetBit(this.iterationIdx[i]);
                    if (t < 0) {
                        this.nextMapping = null;
                        return;
                    }
                    this.nextMapping.set(this.columns[i], t);
                    this.iterationIdx[i] = t + 1;
                }
            }
        }

        class EquivalenceFinder
        extends RexVisitorImpl<Void> {
            protected EquivalenceFinder() {
                super(true);
            }

            @Override
            public Void visitCall(RexCall call) {
                if (call.getOperator().getKind() == SqlKind.EQUALS) {
                    int lPos = JoinConditionBasedPredicateInference.this.pos(call.getOperands().get(0));
                    int rPos = JoinConditionBasedPredicateInference.this.pos(call.getOperands().get(1));
                    if (lPos != -1 && rPos != -1) {
                        JoinConditionBasedPredicateInference.this.equivalent(lPos, rPos);
                        JoinConditionBasedPredicateInference.this.equalityPredicates.add(call.toString());
                    }
                }
                return null;
            }
        }
    }
}

