/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.VisitorDataContext;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteLogger;

public class RexImplicationChecker {
    private static final CalciteLogger LOGGER = new CalciteLogger(Logger.getLogger(RexImplicationChecker.class.getName()));
    final RexBuilder builder;
    final RexExecutorImpl executor;
    final RelDataType rowType;

    public RexImplicationChecker(RexBuilder builder, RexExecutorImpl executor, RelDataType rowType) {
        this.builder = builder;
        this.executor = executor;
        this.rowType = rowType;
    }

    public boolean implies(RexNode first, RexNode second) {
        if (!this.validate(first, second)) {
            return false;
        }
        LOGGER.fine("Checking if " + first.toString() + " => " + second.toString());
        RexCall firstCond = (RexCall)first;
        RexCall secondCond = (RexCall)second;
        RexNode firstDnf = RexUtil.toDnf(this.builder, first);
        RexNode secondDnf = RexUtil.toDnf(this.builder, second);
        if (firstDnf.isAlwaysFalse() || secondDnf.isAlwaysTrue()) {
            return true;
        }
        List<RexNode> firstDnfs = RelOptUtil.disjunctions(firstDnf);
        List<RexNode> secondDnfs = RelOptUtil.disjunctions(secondDnf);
        for (RexNode f : firstDnfs) {
            if (f.isAlwaysFalse()) continue;
            boolean implyOneConjunction = false;
            for (RexNode s : secondDnfs) {
                if (s.isAlwaysFalse() || !this.impliesConjunction(f, s)) continue;
                implyOneConjunction = true;
                break;
            }
            if (implyOneConjunction) continue;
            LOGGER.fine(first + " doesnot imply " + second);
            return false;
        }
        LOGGER.fine(first + " implies " + second);
        return true;
    }

    private boolean impliesConjunction(RexNode first, RexNode second) {
        InputUsageFinder firstUsageFinder = new InputUsageFinder();
        InputUsageFinder secondUsageFinder = new InputUsageFinder();
        RexUtil.apply((RexVisitor<Void>)firstUsageFinder, new ArrayList(), first);
        RexUtil.apply((RexVisitor<Void>)secondUsageFinder, new ArrayList(), second);
        if (!this.checkSupport(firstUsageFinder, secondUsageFinder)) {
            LOGGER.warning("Support for checking " + first + " => " + second + " is not there");
            return false;
        }
        ImmutableList.Builder usagesBuilder = ImmutableList.builder();
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry : firstUsageFinder.usageMap.entrySet()) {
            ImmutableSet.Builder usageBuilder = ImmutableSet.builder();
            if (((InputRefUsage)entry.getValue()).usageList.size() <= 0) continue;
            for (Pair pair : ((InputRefUsage)entry.getValue()).usageList) {
                usageBuilder.add(Pair.of(entry.getKey(), pair.getValue()));
            }
            usagesBuilder.add((Object)usageBuilder.build());
        }
        Set usages = Sets.cartesianProduct((List)usagesBuilder.build());
        for (List usageList : usages) {
            DataContext dataValues = VisitorDataContext.of(this.rowType, usageList);
            if (this.isSatisfiable(second, dataValues)) continue;
            return false;
        }
        return true;
    }

    private boolean isSatisfiable(RexNode second, DataContext dataValues) {
        Object[] result;
        if (dataValues == null) {
            return false;
        }
        ImmutableList constExps = ImmutableList.of((Object)second);
        RexExecutable exec = this.executor.getExecutable(this.builder, (List<RexNode>)constExps, this.rowType);
        exec.setDataContext(dataValues);
        try {
            result = exec.execute();
        }
        catch (Exception e) {
            LOGGER.warning("Exception thrown while checking if => " + second + ": " + e.getMessage());
            return false;
        }
        return result != null && result.length == 1 && result[0] instanceof Boolean && (Boolean)result[0] != false;
    }

    private boolean checkSupport(InputUsageFinder firstUsageFinder, InputUsageFinder secondUsageFinder) {
        Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> firstUsageMap = firstUsageFinder.usageMap;
        Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> secondUsageMap = secondUsageFinder.usageMap;
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry : secondUsageMap.entrySet()) {
            SqlKind sKind2;
            InputRefUsage<SqlOperator, RexNode> secondUsage = entry.getValue();
            List secondUsageList = ((InputRefUsage)secondUsage).usageList;
            int secondLen = secondUsageList.size();
            if (((InputRefUsage)secondUsage).usageCount != secondLen || secondLen > 2) {
                return false;
            }
            InputRefUsage<SqlOperator, RexNode> firstUsage = firstUsageMap.get(entry.getKey());
            if (firstUsage == null || ((InputRefUsage)firstUsage).usageList.size() != ((InputRefUsage)firstUsage).usageCount || ((InputRefUsage)firstUsage).usageCount > 2) {
                return false;
            }
            List firstUsageList = ((InputRefUsage)firstUsage).usageList;
            int firstLen = firstUsageList.size();
            SqlKind fKind = ((SqlOperator)((Pair)firstUsageList.get(0)).getKey()).getKind();
            SqlKind sKind = ((SqlOperator)((Pair)secondUsageList.get(0)).getKey()).getKind();
            SqlKind fKind2 = firstUsageList.size() == 2 ? ((SqlOperator)((Pair)firstUsageList.get(1)).getKey()).getKind() : null;
            SqlKind sqlKind = sKind2 = secondUsageList.size() == 2 ? ((SqlOperator)((Pair)secondUsageList.get(1)).getKey()).getKind() : null;
            if (!(firstLen != 2 || secondLen != 2 || this.isEquivalentOp(fKind, sKind) && this.isEquivalentOp(fKind2, sKind2) || this.isEquivalentOp(fKind, sKind2) && this.isEquivalentOp(fKind2, sKind))) {
                return false;
            }
            if (firstLen == 1 && secondLen == 1 && fKind != SqlKind.EQUALS && !this.isEquivalentOp(fKind, sKind)) {
                return false;
            }
            if (firstLen == 1 && secondLen == 2 && fKind != SqlKind.EQUALS) {
                return false;
            }
            if (firstLen != 2 || secondLen != 1 || this.isOppositeOp(fKind, fKind2) || this.isEquivalentOp(fKind, fKind2) && this.isEquivalentOp(fKind, sKind)) continue;
            return false;
        }
        return true;
    }

    private boolean isEquivalentOp(SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean isOppositeOp(SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean validate(RexNode first, RexNode second) {
        return first instanceof RexCall && second instanceof RexCall;
    }

    private static class InputRefUsage<T1, T2> {
        private final List<Pair<T1, T2>> usageList = new ArrayList<Pair<T1, T2>>();
        private int usageCount = 0;

        private InputRefUsage() {
        }
    }

    private static class InputUsageFinder
    extends RexVisitorImpl<Void> {
        public final Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> usageMap = new HashMap<RexInputRef, InputRefUsage<SqlOperator, RexNode>>();

        public InputUsageFinder() {
            super(true);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.getUsageMap(inputRef);
            ((InputRefUsage)inputRefUse).usageCount++;
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            switch (call.getOperator().getKind()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case EQUALS: 
                case NOT_EQUALS: {
                    this.updateUsage(call);
                    break;
                }
            }
            return (Void)super.visitCall(call);
        }

        private void updateUsage(RexCall call) {
            List<RexNode> operands = call.getOperands();
            RexNode first = InputUsageFinder.removeCast(operands.get(0));
            RexNode second = InputUsageFinder.removeCast(operands.get(1));
            if (first.isA(SqlKind.INPUT_REF) && second.isA(SqlKind.LITERAL)) {
                this.updateUsage(call.getOperator(), (RexInputRef)first, second);
            }
            if (first.isA(SqlKind.LITERAL) && second.isA(SqlKind.INPUT_REF)) {
                this.updateUsage(this.reverse(call.getOperator()), (RexInputRef)second, first);
            }
        }

        private SqlOperator reverse(SqlOperator op) {
            return RelOptUtil.op(op.getKind().reverse(), op);
        }

        private static RexNode removeCast(RexNode inputRef) {
            RexCall castedRef;
            SqlOperator operator;
            if (inputRef instanceof RexCall && (operator = (castedRef = (RexCall)inputRef).getOperator()) instanceof SqlCastFunction) {
                inputRef = castedRef.getOperands().get(0);
            }
            return inputRef;
        }

        private void updateUsage(SqlOperator op, RexInputRef inputRef, RexNode literal) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.getUsageMap(inputRef);
            Pair<SqlOperator, RexNode> use = Pair.of(op, literal);
            ((InputRefUsage)inputRefUse).usageList.add(use);
        }

        private InputRefUsage<SqlOperator, RexNode> getUsageMap(RexInputRef rex) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.usageMap.get(rex);
            if (inputRefUse == null) {
                inputRefUse = new InputRefUsage();
                this.usageMap.put(rex, inputRefUse);
            }
            return inputRefUse;
        }
    }
}

