/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.materialize.Lattices;
import org.apache.calcite.materialize.TileSuggester;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.calcite.util.mapping.IntPair;

public class Lattice {
    private static final Function<Column, String> GET_ALIAS = new Function<Column, String>(){

        public String apply(Column input) {
            return input.alias;
        }
    };
    private static final Function<Column, Integer> GET_ORDINAL = new Function<Column, Integer>(){

        public Integer apply(Column input) {
            return input.ordinal;
        }
    };
    public final CalciteSchema rootSchema;
    public final ImmutableList<Node> nodes;
    public final ImmutableList<Column> columns;
    public final boolean auto;
    public final boolean algorithm;
    public final long algorithmMaxMillis;
    public final double rowCountEstimate;
    public final ImmutableList<Measure> defaultMeasures;
    public final ImmutableList<Tile> tiles;
    public final ImmutableList<String> uniqueColumnNames;
    public final LatticeStatisticProvider statisticProvider;
    private final Function<Integer, Column> toColumnFunction = new Function<Integer, Column>(){

        public Column apply(Integer input) {
            return (Column)Lattice.this.columns.get(input.intValue());
        }
    };
    private final Function<AggregateCall, Measure> toMeasureFunction = new Function<AggregateCall, Measure>(){

        public Measure apply(AggregateCall input) {
            return new Measure(input.getAggregation(), Lists.transform(input.getArgList(), (Function)Lattice.this.toColumnFunction));
        }
    };

    private Lattice(CalciteSchema rootSchema, ImmutableList<Node> nodes, boolean auto, boolean algorithm, long algorithmMaxMillis, LatticeStatisticProvider statisticProvider, Double rowCountEstimate, ImmutableList<Column> columns, ImmutableList<Measure> defaultMeasures, ImmutableList<Tile> tiles) {
        this.rootSchema = rootSchema;
        this.nodes = (ImmutableList)Preconditions.checkNotNull(nodes);
        this.columns = (ImmutableList)Preconditions.checkNotNull(columns);
        this.auto = auto;
        this.algorithm = algorithm;
        this.algorithmMaxMillis = algorithmMaxMillis;
        this.statisticProvider = (LatticeStatisticProvider)Preconditions.checkNotNull((Object)statisticProvider);
        this.defaultMeasures = (ImmutableList)Preconditions.checkNotNull(defaultMeasures);
        this.tiles = (ImmutableList)Preconditions.checkNotNull(tiles);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (i == 0 ? !$assertionsDisabled && node.parent != null : !$assertionsDisabled && !nodes.subList(0, i).contains((Object)node.parent)) {
                throw new AssertionError();
            }
        }
        ArrayList nameList = Lists.newArrayList();
        for (Column column : columns) {
            nameList.add(column.alias);
        }
        this.uniqueColumnNames = ImmutableList.copyOf(SqlValidatorUtil.uniquify(Lists.transform(columns, GET_ALIAS)));
        if (rowCountEstimate == null) {
            rowCountEstimate = 1000.0;
        }
        Preconditions.checkArgument((rowCountEstimate > 0.0 ? 1 : 0) != 0);
        this.rowCountEstimate = rowCountEstimate;
    }

    public static Lattice create(CalciteSchema schema, String sql, boolean auto) {
        return Lattice.builder(schema, sql).auto(auto).build();
    }

    private static void populateAliases(SqlNode from, List<String> aliases, String current) {
        if (from instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)from;
            Lattice.populateAliases(join.getLeft(), aliases, null);
            Lattice.populateAliases(join.getRight(), aliases, null);
        } else if (from.getKind() == SqlKind.AS) {
            Lattice.populateAliases(SqlUtil.stripAs(from), aliases, SqlValidatorUtil.getAlias(from, -1));
        } else {
            if (current == null) {
                current = SqlValidatorUtil.getAlias(from, -1);
            }
            aliases.add(current);
        }
    }

    private static boolean populate(List<RelNode> nodes, List<int[][]> tempLinks, RelNode rel) {
        if (nodes.isEmpty() && rel instanceof LogicalProject) {
            return Lattice.populate(nodes, tempLinks, ((LogicalProject)rel).getInput());
        }
        if (rel instanceof TableScan) {
            nodes.add(rel);
            return true;
        }
        if (rel instanceof LogicalJoin) {
            LogicalJoin join = (LogicalJoin)rel;
            if (join.getJoinType() != JoinRelType.INNER) {
                throw new RuntimeException("only inner join allowed, but got " + (Object)((Object)join.getJoinType()));
            }
            Lattice.populate(nodes, tempLinks, join.getLeft());
            Lattice.populate(nodes, tempLinks, join.getRight());
            for (RexNode rex : RelOptUtil.conjunctions(join.getCondition())) {
                tempLinks.add(Lattice.grab(nodes, rex));
            }
            return true;
        }
        throw new RuntimeException("Invalid node type " + rel.getClass().getSimpleName() + " in lattice query");
    }

    private static int[][] grab(List<RelNode> leaves, RexNode rex) {
        switch (rex.getKind()) {
            case EQUALS: {
                break;
            }
            default: {
                throw new AssertionError((Object)"only equi-join allowed");
            }
        }
        List<RexNode> operands = ((RexCall)rex).getOperands();
        return new int[][]{Lattice.inputField(leaves, operands.get(0)), Lattice.inputField(leaves, operands.get(1))};
    }

    private static int[] inputField(List<RelNode> leaves, RexNode rex) {
        if (!(rex instanceof RexInputRef)) {
            throw new RuntimeException("only equi-join of columns allowed: " + rex);
        }
        RexInputRef ref = (RexInputRef)rex;
        int start = 0;
        for (int i = 0; i < leaves.size(); ++i) {
            RelNode leaf = leaves.get(i);
            int end = start + leaf.getRowType().getFieldCount();
            if (ref.getIndex() < end) {
                return new int[]{i, ref.getIndex() - start};
            }
            start = end;
        }
        throw new AssertionError((Object)"input not found");
    }

    public String sql(ImmutableBitSet groupSet, List<Measure> aggCallList) {
        ImmutableBitSet.Builder columnSetBuilder = ImmutableBitSet.builder(groupSet);
        for (Measure call : aggCallList) {
            for (Column arg : call.args) {
                columnSetBuilder.set(arg.ordinal);
            }
        }
        ImmutableBitSet columnSet = columnSetBuilder.build();
        ArrayList usedNodes = Lists.newArrayList();
        for (Node node : this.nodes) {
            if (!ImmutableBitSet.range(node.startCol, node.endCol).intersects(columnSet)) continue;
            Lattice.use(usedNodes, node);
        }
        if (usedNodes.isEmpty()) {
            usedNodes.add(this.nodes.get(0));
        }
        SqlDialect dialect = SqlDialect.DatabaseProduct.CALCITE.getDialect();
        StringBuilder buf = new StringBuilder("SELECT ");
        StringBuilder groupBuf = new StringBuilder("\nGROUP BY ");
        int k = 0;
        HashSet columnNames = Sets.newHashSet();
        for (int i : BitSets.toIter(groupSet)) {
            if (k++ > 0) {
                buf.append(", ");
                groupBuf.append(", ");
            }
            Column column = (Column)this.columns.get(i);
            dialect.quoteIdentifier(buf, column.identifiers());
            dialect.quoteIdentifier(groupBuf, column.identifiers());
            String fieldName = (String)this.uniqueColumnNames.get(i);
            columnNames.add(fieldName);
            if (column.alias.equals(fieldName)) continue;
            buf.append(" AS ");
            dialect.quoteIdentifier(buf, fieldName);
        }
        if (groupSet.isEmpty()) {
            groupBuf.append("()");
        }
        int m = 0;
        for (Measure measure : aggCallList) {
            String measureName;
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(measure.agg.getName()).append("(");
            if (measure.args.isEmpty()) {
                buf.append("*");
            } else {
                int z = 0;
                for (Column arg : measure.args) {
                    if (z++ > 0) {
                        buf.append(", ");
                    }
                    dialect.quoteIdentifier(buf, arg.identifiers());
                }
            }
            buf.append(") AS ");
            while (!columnNames.add(measureName = "m" + m)) {
                ++m;
            }
            dialect.quoteIdentifier(buf, measureName);
        }
        buf.append("\nFROM ");
        for (Node node : usedNodes) {
            if (node.parent != null) {
                buf.append("\nJOIN ");
            }
            dialect.quoteIdentifier(buf, node.scan.getTable().getQualifiedName());
            buf.append(" AS ");
            dialect.quoteIdentifier(buf, node.alias);
            if (node.parent == null) continue;
            buf.append(" ON ");
            k = 0;
            for (IntPair pair : node.link) {
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                Column left = (Column)this.columns.get(node.parent.startCol + pair.source);
                dialect.quoteIdentifier(buf, left.identifiers());
                buf.append(" = ");
                Column right = (Column)this.columns.get(node.startCol + pair.target);
                dialect.quoteIdentifier(buf, right.identifiers());
            }
        }
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Lattice SQL:\n" + buf);
        }
        buf.append((CharSequence)groupBuf);
        return buf.toString();
    }

    public String countSql(ImmutableBitSet groupSet) {
        return "select count(*) as c from (" + this.sql(groupSet, (List<Measure>)ImmutableList.of()) + ")";
    }

    private static void use(List<Node> usedNodes, Node node) {
        if (!usedNodes.contains(node)) {
            if (node.parent != null) {
                Lattice.use(usedNodes, node.parent);
            }
            usedNodes.add(node);
        }
    }

    public StarTable createStarTable() {
        ArrayList tables = Lists.newArrayList();
        for (Node node : this.nodes) {
            tables.add(node.scan.getTable().unwrap(Table.class));
        }
        return StarTable.of(this, tables);
    }

    public static Builder builder(CalciteSchema calciteSchema, String sql) {
        return new Builder(calciteSchema, sql);
    }

    public List<Measure> toMeasures(List<AggregateCall> aggCallList) {
        return Lists.transform(aggCallList, this.toMeasureFunction);
    }

    public Iterable<? extends Tile> computeTiles() {
        if (!this.algorithm) {
            return this.tiles;
        }
        return new TileSuggester(this).tiles();
    }

    public double getFactRowCount() {
        return this.rowCountEstimate;
    }

    public double getRowCount(List<Column> columns) {
        BigInteger n = BigInteger.ONE;
        for (Column column : columns) {
            int cardinality = this.statisticProvider.cardinality(this, column);
            if (cardinality <= 1) continue;
            n = n.multiply(BigInteger.valueOf(cardinality));
        }
        double nn = n.doubleValue();
        double f = this.getFactRowCount();
        double a = (nn - 1.0) / nn;
        if (a == 1.0) {
            return f;
        }
        double v = nn * (1.0 - Math.pow(a, f));
        return Math.min(v, f);
    }

    public static class TileBuilder {
        private final List<Measure> measureBuilder = Lists.newArrayList();
        private final List<Column> dimensionListBuilder = Lists.newArrayList();

        public Tile build() {
            return new Tile((ImmutableList<Measure>)Ordering.natural().immutableSortedCopy(this.measureBuilder), (ImmutableList<Column>)Ordering.natural().immutableSortedCopy(this.dimensionListBuilder));
        }

        public void addMeasure(Measure measure) {
            this.measureBuilder.add(measure);
        }

        public void addDimension(Column column) {
            this.dimensionListBuilder.add(column);
        }
    }

    public static class Tile {
        public final ImmutableList<Measure> measures;
        public final ImmutableList<Column> dimensions;
        public final ImmutableBitSet bitSet;

        public Tile(ImmutableList<Measure> measures, ImmutableList<Column> dimensions) {
            this.measures = measures;
            this.dimensions = dimensions;
            assert (Ordering.natural().isStrictlyOrdered(dimensions));
            assert (Ordering.natural().isStrictlyOrdered(measures));
            ImmutableBitSet.Builder bitSetBuilder = ImmutableBitSet.builder();
            for (Column dimension : dimensions) {
                bitSetBuilder.set(dimension.ordinal);
            }
            this.bitSet = bitSetBuilder.build();
        }

        public static TileBuilder builder() {
            return new TileBuilder();
        }

        public ImmutableBitSet bitSet() {
            return this.bitSet;
        }
    }

    public static class Builder {
        private final List<Node> nodes = Lists.newArrayList();
        private final ImmutableList<Column> columns;
        private final ImmutableListMultimap<String, Column> columnsByAlias;
        private final ImmutableList.Builder<Measure> defaultMeasureListBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<Tile> tileListBuilder = ImmutableList.builder();
        private final CalciteSchema rootSchema;
        private boolean algorithm = false;
        private long algorithmMaxMillis = -1L;
        private boolean auto = true;
        private Double rowCountEstimate;
        private String statisticProvider;

        public Builder(CalciteSchema schema, String sql) {
            this.rootSchema = (CalciteSchema)Preconditions.checkNotNull((Object)schema.root());
            Preconditions.checkArgument((boolean)this.rootSchema.isRoot(), (Object)"must be root schema");
            CalcitePrepare.ConvertResult parsed = Schemas.convert(MaterializedViewTable.MATERIALIZATION_CONNECTION, schema, schema.path(null), sql);
            ArrayList relNodes = Lists.newArrayList();
            ArrayList tempLinks = Lists.newArrayList();
            Lattice.populate(relNodes, tempLinks, parsed.root.rel);
            ArrayList aliases = Lists.newArrayList();
            Lattice.populateAliases(((SqlSelect)parsed.sqlNode).getFrom(), aliases, null);
            DefaultDirectedGraph<RelNode, Edge> graph = DefaultDirectedGraph.create(Edge.FACTORY);
            for (RelNode node : relNodes) {
                graph.addVertex(node);
            }
            for (int[][] tempLink : tempLinks) {
                RelNode target;
                RelNode source = (RelNode)relNodes.get(tempLink[0][0]);
                Edge edge = (Edge)graph.getEdge(source, target = (RelNode)relNodes.get(tempLink[1][0]));
                if (edge == null) {
                    edge = (Edge)graph.addEdge(source, target);
                }
                edge.pairs.add(IntPair.of(tempLink[0][1], tempLink[1][1]));
            }
            Node previous = null;
            IdentityHashMap map = Maps.newIdentityHashMap();
            int previousColumn = 0;
            for (RelNode relNode : TopologicalOrderIterator.of(graph)) {
                Node node;
                List edges = graph.getInwardEdges(relNode);
                int column = previousColumn + relNode.getRowType().getFieldCount();
                if (previous == null) {
                    if (!edges.isEmpty()) {
                        throw new RuntimeException("root node must not have relationships: " + relNode);
                    }
                    node = new Node((TableScan)relNode, null, null, previousColumn, column, (String)aliases.get(this.nodes.size()));
                } else {
                    if (edges.size() != 1) {
                        throw new RuntimeException("child node must have precisely one parent: " + relNode);
                    }
                    Edge edge = (Edge)edges.get(0);
                    node = new Node((TableScan)relNode, (Node)map.get(edge.getSource()), edge.pairs, previousColumn, column, (String)aliases.get(this.nodes.size()));
                }
                this.nodes.add(node);
                map.put(relNode, node);
                previous = node;
                previousColumn = column;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableListMultimap.Builder aliasBuilder = ImmutableListMultimap.builder();
            int c = 0;
            for (Node node : this.nodes) {
                if (node.scan == null) continue;
                for (String name : node.scan.getRowType().getFieldNames()) {
                    Column column = new Column(c++, node.alias, name, name);
                    builder.add((Object)column);
                    aliasBuilder.put((Object)column.alias, (Object)column);
                }
            }
            this.columns = builder.build();
            this.columnsByAlias = aliasBuilder.build();
        }

        public Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public Builder algorithm(boolean algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder algorithmMaxMillis(long algorithmMaxMillis) {
            this.algorithmMaxMillis = algorithmMaxMillis;
            return this;
        }

        public Builder rowCountEstimate(double rowCountEstimate) {
            this.rowCountEstimate = rowCountEstimate;
            return this;
        }

        public Builder statisticProvider(String statisticProvider) {
            this.statisticProvider = statisticProvider;
            return this;
        }

        public Lattice build() {
            LatticeStatisticProvider statisticProvider = this.statisticProvider != null ? (LatticeStatisticProvider)AvaticaUtils.instantiatePlugin(LatticeStatisticProvider.class, (String)this.statisticProvider) : Lattices.CACHED_SQL;
            Preconditions.checkArgument((boolean)this.rootSchema.isRoot(), (Object)"must be root schema");
            return new Lattice(this.rootSchema, ImmutableList.copyOf(this.nodes), this.auto, this.algorithm, this.algorithmMaxMillis, statisticProvider, this.rowCountEstimate, this.columns, this.defaultMeasureListBuilder.build(), this.tileListBuilder.build());
        }

        public ImmutableList<Column> resolveArgs(Object args) {
            if (args == null) {
                return ImmutableList.of();
            }
            if (args instanceof String) {
                return ImmutableList.of((Object)this.resolveColumnByAlias((String)args));
            }
            if (args instanceof List) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : (List)args) {
                    if (o instanceof String) {
                        builder.add((Object)this.resolveColumnByAlias((String)o));
                        continue;
                    }
                    throw new RuntimeException("Measure arguments must be a string or a list of strings; argument: " + o);
                }
                return builder.build();
            }
            throw new RuntimeException("Measure arguments must be a string or a list of strings");
        }

        private Column resolveColumnByAlias(String name) {
            ImmutableList list = this.columnsByAlias.get((Object)name);
            if (list == null || list.size() == 0) {
                throw new RuntimeException("Unknown lattice column '" + name + "'");
            }
            if (list.size() == 1) {
                return (Column)list.get(0);
            }
            throw new RuntimeException("Lattice column alias '" + name + "' is not unique");
        }

        public Column resolveColumn(Object name) {
            if (name instanceof String) {
                return this.resolveColumnByAlias((String)name);
            }
            if (name instanceof List) {
                List list = (List)name;
                switch (list.size()) {
                    case 1: {
                        Object alias = list.get(0);
                        if (!(alias instanceof String)) break;
                        return this.resolveColumnByAlias((String)alias);
                    }
                    case 2: {
                        Object table = list.get(0);
                        Object column = list.get(1);
                        if (!(table instanceof String) || !(column instanceof String)) break;
                        return this.resolveQualifiedColumn((String)table, (String)column);
                    }
                }
            }
            throw new RuntimeException("Lattice column reference must be a string or a list of 1 or 2 strings; column: " + name);
        }

        private Column resolveQualifiedColumn(String table, String column) {
            for (Column column1 : this.columns) {
                if (!column1.table.equals(table) || !column1.column.equals(column)) continue;
                return column1;
            }
            throw new RuntimeException("Unknown lattice column [" + table + ", " + column + "]");
        }

        public Measure resolveMeasure(String aggName, Object args) {
            SqlAggFunction agg = this.resolveAgg(aggName);
            ImmutableList<Column> list = this.resolveArgs(args);
            return new Measure(agg, (Iterable<Column>)list);
        }

        private SqlAggFunction resolveAgg(String aggName) {
            if (aggName.equalsIgnoreCase("count")) {
                return SqlStdOperatorTable.COUNT;
            }
            if (aggName.equalsIgnoreCase("sum")) {
                return SqlStdOperatorTable.SUM;
            }
            throw new RuntimeException("Unknown lattice aggregate function " + aggName);
        }

        public void addMeasure(Measure measure) {
            this.defaultMeasureListBuilder.add((Object)measure);
        }

        public void addTile(Tile tile) {
            this.tileListBuilder.add((Object)tile);
        }
    }

    public static class Column
    implements Comparable<Column> {
        public final int ordinal;
        public final String table;
        public final String column;
        public final String alias;

        private Column(int ordinal, String table, String column, String alias) {
            this.ordinal = ordinal;
            this.table = (String)Preconditions.checkNotNull((Object)table);
            this.column = (String)Preconditions.checkNotNull((Object)column);
            this.alias = (String)Preconditions.checkNotNull((Object)alias);
        }

        @Override
        public int compareTo(Column column) {
            return Utilities.compare(this.ordinal, column.ordinal);
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Column && this.ordinal == ((Column)obj).ordinal;
        }

        public String toString() {
            return this.identifiers().toString();
        }

        public List<String> identifiers() {
            return ImmutableList.of((Object)this.table, (Object)this.column);
        }
    }

    public static class Measure
    implements Comparable<Measure> {
        public final SqlAggFunction agg;
        public final ImmutableList<Column> args;

        public Measure(SqlAggFunction agg, Iterable<Column> args) {
            this.agg = (SqlAggFunction)Preconditions.checkNotNull((Object)agg);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public int compareTo(Measure measure) {
            int c = this.agg.getName().compareTo(measure.agg.getName());
            if (c != 0) {
                return c;
            }
            return Measure.compare(this.args, measure.args);
        }

        public String toString() {
            return "Measure: [agg: " + this.agg + ", args: " + this.args + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.agg, this.args});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Measure && this.agg.equals(((Measure)obj).agg) && this.args.equals(((Measure)obj).args);
        }

        public ImmutableBitSet argBitSet() {
            ImmutableBitSet.Builder bitSet = ImmutableBitSet.builder();
            for (Column arg : this.args) {
                bitSet.set(arg.ordinal);
            }
            return bitSet.build();
        }

        public List<Integer> argOrdinals() {
            return Lists.transform(this.args, (Function)GET_ORDINAL);
        }

        private static int compare(List<Column> list0, List<Column> list1) {
            int size = Math.min(list0.size(), list1.size());
            for (int i = 0; i < size; ++i) {
                int o0 = list0.get((int)i).ordinal;
                int o1 = list1.get((int)i).ordinal;
                int c = Utilities.compare(o0, o1);
                if (c == 0) continue;
                return c;
            }
            return Utilities.compare(list0.size(), list1.size());
        }
    }

    private static class Edge
    extends DefaultEdge {
        public static final DirectedGraph.EdgeFactory<RelNode, Edge> FACTORY = new DirectedGraph.EdgeFactory<RelNode, Edge>(){

            @Override
            public Edge createEdge(RelNode source, RelNode target) {
                return new Edge(source, target);
            }
        };
        final List<IntPair> pairs = Lists.newArrayList();

        public Edge(RelNode source, RelNode target) {
            super(source, target);
        }

        public RelNode getTarget() {
            return (RelNode)this.target;
        }

        public RelNode getSource() {
            return (RelNode)this.source;
        }
    }

    public static class Node {
        public final TableScan scan;
        public final Node parent;
        public final ImmutableList<IntPair> link;
        public final int startCol;
        public final int endCol;
        public final String alias;

        public Node(TableScan scan, Node parent, List<IntPair> link, int startCol, int endCol, String alias) {
            this.scan = (TableScan)Preconditions.checkNotNull((Object)scan);
            this.parent = parent;
            ImmutableList immutableList = this.link = link == null ? null : ImmutableList.copyOf(link);
            assert (parent == null == (link == null));
            assert (startCol >= 0);
            assert (endCol > startCol);
            this.startCol = startCol;
            this.endCol = endCol;
            this.alias = alias;
        }
    }
}

