/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.sql.SQLException;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.server.CalciteServerStatement;

public abstract class CalciteStatement
extends AvaticaStatement {
    CalciteStatement(CalciteConnectionImpl connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super((AvaticaConnection)connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == CalciteServerStatement.class) {
            return iface.cast(this.getConnection().server.getStatement(this.handle));
        }
        return (T)super.unwrap(iface);
    }

    public CalciteConnectionImpl getConnection() {
        return (CalciteConnectionImpl)this.connection;
    }

    public CalciteConnectionImpl.ContextImpl createPrepareContext() {
        return new CalciteConnectionImpl.ContextImpl(this.getConnection());
    }

    protected <T> CalcitePrepare.CalciteSignature<T> prepare(Queryable<T> queryable) {
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalcitePrepare prepare = (CalcitePrepare)calciteConnection.prepareFactory.apply();
        CalciteServerStatement serverStatement = calciteConnection.server.getStatement(this.handle);
        CalcitePrepare.Context prepareContext = serverStatement.createPrepareContext();
        return prepare.prepareQueryable(prepareContext, queryable);
    }

    protected void close_() {
        if (!this.closed) {
            this.closed = true;
            CalciteConnectionImpl connection1 = (CalciteConnectionImpl)this.connection;
            connection1.server.removeStatement(this.handle);
            if (this.openResultSet != null) {
                AvaticaResultSet c = this.openResultSet;
                this.openResultSet = null;
                c.close();
            }
            connection1.getDriver().handler.onStatementClose((AvaticaStatement)this);
        }
    }
}

