/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class JdbcImplementor {
    public static final SqlParserPos POS = SqlParserPos.ZERO;
    public static final SqlFunction ORACLE_SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    final SqlDialect dialect;
    private final Set<String> aliasSet = new LinkedHashSet<String>();

    public JdbcImplementor(SqlDialect dialect, JavaTypeFactory typeFactory) {
        this.dialect = dialect;
        Util.discard(typeFactory);
    }

    public Result result(SqlNode node, Collection<Clause> clauses, RelNode rel) {
        String alias2 = SqlValidatorUtil.getAlias(node, -1);
        String alias3 = alias2 != null ? alias2 : "t";
        String alias4 = SqlValidatorUtil.uniquify(alias3, this.aliasSet, SqlValidatorUtil.EXPR_SUGGESTER);
        String alias5 = alias2 == null || !alias2.equals(alias4) ? alias4 : null;
        return new Result(node, clauses, alias5, Collections.singletonList(Pair.of(alias4, rel.getRowType())));
    }

    public Result result(SqlNode join, Result leftResult, Result rightResult) {
        ArrayList list = new ArrayList();
        list.addAll(leftResult.aliases);
        list.addAll(rightResult.aliases);
        return new Result(join, (Collection)Expressions.list((Object[])new Clause[]{Clause.FROM}), null, list);
    }

    SqlSelect wrapSelect(SqlNode node) {
        assert (node instanceof SqlJoin || node instanceof SqlIdentifier || node instanceof SqlCall && (((SqlCall)node).getOperator() instanceof SqlSetOperator || ((SqlCall)node).getOperator() == SqlStdOperatorTable.AS)) : node;
        return new SqlSelect(POS, SqlNodeList.EMPTY, null, node, null, null, null, SqlNodeList.EMPTY, null, null, null);
    }

    public Result visitChild(int i, RelNode e) {
        return ((JdbcRel)e).implement(this);
    }

    private static int computeFieldCount(List<Pair<String, RelDataType>> aliases) {
        int x = 0;
        for (Pair<String, RelDataType> alias : aliases) {
            x += ((RelDataType)alias.right).getFieldCount();
        }
        return x;
    }

    Context aliasContext(List<Pair<String, RelDataType>> aliases, boolean qualified) {
        return new AliasContext(aliases, qualified);
    }

    Context joinContext(Context leftContext, Context rightContext) {
        return new JoinContext(leftContext, rightContext);
    }

    static enum Clause {
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        SELECT,
        SET_OP,
        ORDER_BY;

    }

    public class Builder {
        private final JdbcRel rel;
        private final List<Clause> clauses;
        private final SqlSelect select;
        public final Context context;

        public Builder(JdbcRel rel, List<Clause> clauses, SqlSelect select, Context context) {
            this.rel = rel;
            this.clauses = clauses;
            this.select = select;
            this.context = context;
        }

        public void setSelect(SqlNodeList nodeList) {
            this.select.setSelectList(nodeList);
        }

        public void setWhere(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.WHERE));
            this.select.setWhere(node);
        }

        public void setGroupBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.GROUP_BY));
            this.select.setGroupBy(nodeList);
        }

        public void setOrderBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.ORDER_BY));
            this.select.setOrderBy(nodeList);
        }

        public Result result() {
            return JdbcImplementor.this.result((SqlNode)this.select, this.clauses, this.rel);
        }
    }

    public class Result {
        final SqlNode node;
        private final String neededAlias;
        private final List<Pair<String, RelDataType>> aliases;
        final Expressions.FluentList<Clause> clauses;

        private Result(SqlNode node, Collection<Clause> clauses, String neededAlias, List<Pair<String, RelDataType>> aliases) {
            this.node = node;
            this.neededAlias = neededAlias;
            this.aliases = aliases;
            this.clauses = Expressions.list(clauses);
        }

        public Builder builder(JdbcRel rel, Clause ... clauses) {
            SqlSelect select;
            Clause maxClause = this.maxClause();
            boolean needNew = false;
            for (Clause clause : clauses) {
                if (maxClause.ordinal() < clause.ordinal()) continue;
                needNew = true;
            }
            Expressions.FluentList clauseList = Expressions.list();
            if (needNew) {
                select = this.subSelect();
            } else {
                select = this.asSelect();
                clauseList.addAll(this.clauses);
            }
            clauseList.appendAll((Object[])clauses);
            final SqlNodeList selectList = select.getSelectList();
            Context newContext = selectList != null ? new Context(selectList.size()){

                @Override
                public SqlNode field(int ordinal) {
                    SqlNode selectItem = selectList.get(ordinal);
                    switch (selectItem.getKind()) {
                        case AS: {
                            return ((SqlCall)selectItem).operand(0);
                        }
                    }
                    return selectItem;
                }
            } : JdbcImplementor.this.aliasContext(this.aliases, this.aliases.size() > 1);
            return new Builder(rel, (List<Clause>)clauseList, select, newContext);
        }

        public Clause maxClause() {
            Clause maxClause = null;
            for (Clause clause : this.clauses) {
                if (maxClause != null && clause.ordinal() <= maxClause.ordinal()) continue;
                maxClause = clause;
            }
            assert (maxClause != null);
            return maxClause;
        }

        public SqlNode asFrom() {
            if (this.neededAlias != null) {
                return SqlStdOperatorTable.AS.createCall(POS, this.node, new SqlIdentifier(this.neededAlias, POS));
            }
            return this.node;
        }

        public SqlSelect subSelect() {
            return JdbcImplementor.this.wrapSelect(this.asFrom());
        }

        SqlSelect asSelect() {
            if (this.node instanceof SqlSelect) {
                return (SqlSelect)this.node;
            }
            return JdbcImplementor.this.wrapSelect(this.node);
        }

        public SqlNode asQuery() {
            if (this.node instanceof SqlCall && ((SqlCall)this.node).getOperator() instanceof SqlSetOperator) {
                return this.node;
            }
            return this.asSelect();
        }

        public Context qualifiedContext() {
            return JdbcImplementor.this.aliasContext(this.aliases, true);
        }
    }

    class JoinContext
    extends Context {
        private final Context leftContext;
        private final Context rightContext;

        private JoinContext(Context leftContext, Context rightContext) {
            super(leftContext.fieldCount + rightContext.fieldCount);
            this.leftContext = leftContext;
            this.rightContext = rightContext;
        }

        @Override
        public SqlNode field(int ordinal) {
            if (ordinal < this.leftContext.fieldCount) {
                return this.leftContext.field(ordinal);
            }
            return this.rightContext.field(ordinal - this.leftContext.fieldCount);
        }
    }

    public class AliasContext
    extends Context {
        private final boolean qualified;
        private final List<Pair<String, RelDataType>> aliases;

        private AliasContext(List<Pair<String, RelDataType>> aliases, boolean qualified) {
            super(JdbcImplementor.computeFieldCount(aliases));
            this.aliases = aliases;
            this.qualified = qualified;
        }

        @Override
        public SqlNode field(int ordinal) {
            for (Pair<String, RelDataType> alias : this.aliases) {
                List<RelDataTypeField> fields = ((RelDataType)alias.right).getFieldList();
                if (ordinal < fields.size()) {
                    RelDataTypeField field = fields.get(ordinal);
                    return new SqlIdentifier((List<String>)(!this.qualified ? ImmutableList.of((Object)field.getName()) : ImmutableList.of(alias.left, (Object)field.getName())), POS);
                }
                ordinal -= fields.size();
            }
            throw new AssertionError((Object)("field ordinal " + ordinal + " out of range " + this.aliases));
        }
    }

    public abstract class Context {
        final int fieldCount;

        protected Context(int fieldCount) {
            this.fieldCount = fieldCount;
        }

        public abstract SqlNode field(int var1);

        SqlNode toSql(RexProgram program, RexNode rex) {
            switch (rex.getKind()) {
                case LOCAL_REF: {
                    int index = ((RexLocalRef)rex).getIndex();
                    return this.toSql(program, program.getExprList().get(index));
                }
                case INPUT_REF: {
                    return this.field(((RexInputRef)rex).getIndex());
                }
                case LITERAL: {
                    RexLiteral literal = (RexLiteral)rex;
                    if (literal.getTypeName() == SqlTypeName.SYMBOL) {
                        SqlLiteral.SqlSymbol symbol = (SqlLiteral.SqlSymbol)((Object)literal.getValue());
                        return SqlLiteral.createSymbol(symbol, POS);
                    }
                    switch (literal.getTypeName().getFamily()) {
                        case CHARACTER: {
                            return SqlLiteral.createCharString((String)literal.getValue2(), POS);
                        }
                        case NUMERIC: 
                        case EXACT_NUMERIC: {
                            return SqlLiteral.createExactNumeric(literal.getValue().toString(), POS);
                        }
                        case APPROXIMATE_NUMERIC: {
                            return SqlLiteral.createApproxNumeric(literal.getValue().toString(), POS);
                        }
                        case BOOLEAN: {
                            return SqlLiteral.createBoolean((Boolean)literal.getValue(), POS);
                        }
                        case DATE: {
                            return SqlLiteral.createDate((Calendar)literal.getValue(), POS);
                        }
                        case TIME: {
                            return SqlLiteral.createTime((Calendar)literal.getValue(), literal.getType().getPrecision(), POS);
                        }
                        case TIMESTAMP: {
                            return SqlLiteral.createTimestamp((Calendar)literal.getValue(), literal.getType().getPrecision(), POS);
                        }
                        case ANY: 
                        case NULL: {
                            switch (literal.getTypeName()) {
                                case NULL: {
                                    return SqlLiteral.createNull(POS);
                                }
                            }
                        }
                    }
                    throw new AssertionError((Object)(literal + ": " + (Object)((Object)literal.getTypeName())));
                }
                case CASE: {
                    SqlNode valueNode;
                    RexCall caseCall = (RexCall)rex;
                    List<SqlNode> caseNodeList = this.toSql(program, caseCall.getOperands());
                    Expressions.FluentList whenList = Expressions.list();
                    Expressions.FluentList thenList = Expressions.list();
                    if (caseNodeList.size() % 2 == 0) {
                        valueNode = caseNodeList.get(0);
                        for (int i = 1; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    } else {
                        valueNode = null;
                        for (int i = 0; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    }
                    SqlNode elseNode = caseNodeList.get(caseNodeList.size() - 1);
                    return new SqlCase(POS, valueNode, new SqlNodeList((Collection<? extends SqlNode>)whenList, POS), new SqlNodeList((Collection<? extends SqlNode>)thenList, POS), elseNode);
                }
            }
            RexCall call = (RexCall)rex;
            SqlOperator op = call.getOperator();
            List<SqlNode> nodeList = this.toSql(program, call.getOperands());
            switch (rex.getKind()) {
                case CAST: {
                    nodeList.add(this.toSql(call.getType()));
                }
            }
            if (op instanceof SqlBinaryOperator && nodeList.size() > 2) {
                return this.createLeftCall(op, nodeList);
            }
            if (op == SqlStdOperatorTable.SUBSTRING) {
                switch (JdbcImplementor.this.dialect.getDatabaseProduct()) {
                    case ORACLE: {
                        return ORACLE_SUBSTR.createCall(new SqlNodeList(nodeList, POS));
                    }
                }
            }
            return op.createCall(new SqlNodeList(nodeList, POS));
        }

        private SqlNode createLeftCall(SqlOperator op, List<SqlNode> nodeList) {
            if (nodeList.size() == 2) {
                return op.createCall(new SqlNodeList(nodeList, POS));
            }
            List<SqlNode> butLast = Util.skipLast(nodeList);
            SqlNode last = nodeList.get(nodeList.size() - 1);
            SqlNode call = this.createLeftCall(op, butLast);
            return op.createCall(new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)call, (Object)last), POS));
        }

        private SqlNode toSql(RelDataType type) {
            switch (JdbcImplementor.this.dialect.getDatabaseProduct()) {
                case MYSQL: {
                    switch (type.getSqlTypeName()) {
                        case VARCHAR: {
                            return new SqlDataTypeSpec(new SqlIdentifier("CHAR", POS), type.getPrecision(), -1, null, null, POS);
                        }
                        case INTEGER: {
                            return new SqlDataTypeSpec(new SqlIdentifier("_UNSIGNED", POS), type.getPrecision(), -1, null, null, POS);
                        }
                    }
                }
            }
            if (type instanceof BasicSqlType) {
                return new SqlDataTypeSpec(new SqlIdentifier(type.getSqlTypeName().name(), POS), type.getPrecision(), type.getScale(), type.getCharset() != null && JdbcImplementor.this.dialect.supportsCharSet() ? type.getCharset().name() : null, null, POS);
            }
            throw new AssertionError(type);
        }

        private List<SqlNode> toSql(RexProgram program, List<RexNode> operandList) {
            ArrayList<SqlNode> list = new ArrayList<SqlNode>();
            for (RexNode rex : operandList) {
                list.add(this.toSql(program, rex));
            }
            return list;
        }

        public List<SqlNode> fieldList() {
            return new AbstractList<SqlNode>(){

                @Override
                public SqlNode get(int index) {
                    return Context.this.field(index);
                }

                @Override
                public int size() {
                    return Context.this.fieldCount;
                }
            };
        }

        public SqlNode toSql(AggregateCall aggCall) {
            SqlAggFunction op = aggCall.getAggregation();
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                op = SqlStdOperatorTable.SUM;
            }
            Expressions.FluentList operands = Expressions.list();
            for (int arg : aggCall.getArgList()) {
                operands.add(this.field(arg));
            }
            return op.createCall(aggCall.isDistinct() ? SqlSelectKeyword.DISTINCT.symbol(POS) : null, POS, operands.toArray(new SqlNode[operands.size()]));
        }

        public SqlNode toSql(RelFieldCollation collation) {
            SqlNode node = this.field(collation.getFieldIndex());
            switch (collation.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                }
            }
            switch (collation.nullDirection) {
                case FIRST: {
                    node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                    break;
                }
                case LAST: {
                    node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                }
            }
            return node;
        }

        public JdbcImplementor implementor() {
            return JdbcImplementor.this;
        }
    }
}

