/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.JavaRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.ConditionalStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewArrayExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.BuiltInMethod;

public class EnumerableRelImplementor
extends JavaRelImplementor {
    public final Map<String, Object> map;
    private final Map<String, RexToLixTranslator.InputGetter> corrVars = Maps.newHashMap();
    private final Map<Object, ParameterExpression> stashedParameters = Maps.newIdentityHashMap();
    protected final Function1<String, RexToLixTranslator.InputGetter> allCorrelateVariables = new Function1<String, RexToLixTranslator.InputGetter>(){

        public RexToLixTranslator.InputGetter apply(String name) {
            return EnumerableRelImplementor.this.getCorrelVariableGetter(name);
        }
    };

    public EnumerableRelImplementor(RexBuilder rexBuilder, Map<String, Object> internalParameters) {
        super(rexBuilder);
        this.map = internalParameters;
    }

    public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
        if (parent != null) assert (child == parent.getInputs().get(ordinal));
        return child.implement(this, prefer);
    }

    public ClassDeclaration implementRoot(EnumerableRel rootRel, EnumerableRel.Prefer prefer) {
        EnumerableRel.Result result = rootRel.implement(this, prefer);
        ArrayList<MemberDeclaration> memberDeclarations = new ArrayList<MemberDeclaration>();
        new TypeRegistrar(memberDeclarations).go(result);
        ParameterExpression root0_ = Expressions.parameter((int)16, DataContext.class, (String)"root0");
        Collection stashed = Collections2.transform(this.stashedParameters.values(), (Function)new Function<ParameterExpression, Statement>(){

            public Statement apply(ParameterExpression input) {
                return Expressions.declare((int)16, (ParameterExpression)input, (Expression)Expressions.convert_((Expression)Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)input.name)}), (Type)input.type));
            }
        });
        BlockStatement block = Expressions.block((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)Expressions.statement((Expression)Expressions.assign((Expression)DataContext.ROOT, (Expression)root0_))), (Iterable)stashed, (Iterable)result.block.statements));
        memberDeclarations.add((MemberDeclaration)Expressions.fieldDecl((int)0, (ParameterExpression)DataContext.ROOT, null));
        memberDeclarations.add((MemberDeclaration)Expressions.methodDecl((int)1, Enumerable.class, (String)BuiltInMethod.BINDABLE_BIND.method.getName(), (Iterable)Expressions.list((Object[])new ParameterExpression[]{root0_}), (BlockStatement)block));
        memberDeclarations.add((MemberDeclaration)Expressions.methodDecl((int)1, Class.class, (String)BuiltInMethod.TYPED_GET_ELEMENT_TYPE.method.getName(), Collections.emptyList(), (BlockStatement)Blocks.toFunctionBlock((Node)Expressions.return_(null, (Expression)Expressions.constant((Object)result.physType.getJavaRowType())))));
        return Expressions.classDecl((int)1, (String)"Baz", null, Collections.singletonList(Bindable.class), memberDeclarations);
    }

    private ClassDeclaration classDecl(JavaTypeFactoryImpl.SyntheticRecordType type) {
        ClassDeclaration classDeclaration = Expressions.classDecl((int)9, (String)type.getName(), null, (List)ImmutableList.of(Serializable.class), new ArrayList());
        for (Types.RecordField field : type.getRecordFields()) {
            classDeclaration.memberDeclarations.add(Expressions.fieldDecl((int)field.getModifiers(), (ParameterExpression)Expressions.parameter((Type)field.getType(), (String)field.getName()), null));
        }
        BlockBuilder blockBuilder = new BlockBuilder();
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ParameterExpression thisParameter = Expressions.parameter((Type)((Object)type), (String)"this");
        for (Types.RecordField field : type.getRecordFields()) {
            ParameterExpression parameter = Expressions.parameter((Type)field.getType(), (String)field.getName());
            parameters.add(parameter);
            blockBuilder.add(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.field((Expression)thisParameter, (PseudoField)field), (Expression)parameter)));
        }
        classDeclaration.memberDeclarations.add(Expressions.constructorDecl((int)1, (Type)((Object)type), parameters, (BlockStatement)blockBuilder.toBlock()));
        BlockBuilder blockBuilder2 = new BlockBuilder();
        ParameterExpression thatParameter = Expressions.parameter((Type)((Object)type), (String)"that");
        ParameterExpression oParameter = Expressions.parameter(Object.class, (String)"o");
        blockBuilder2.add((Statement)Expressions.ifThen((Expression)Expressions.equal((Expression)thisParameter, (Expression)oParameter), (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)true))));
        blockBuilder2.add((Statement)Expressions.ifThen((Expression)Expressions.not((Expression)Expressions.typeIs((Expression)oParameter, (Type)((Object)type))), (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)false))));
        blockBuilder2.add((Statement)Expressions.declare((int)16, (ParameterExpression)thatParameter, (Expression)Expressions.convert_((Expression)oParameter, (Type)((Object)type))));
        ArrayList<BinaryExpression> conditions = new ArrayList<BinaryExpression>();
        for (Types.RecordField field : type.getRecordFields()) {
            conditions.add((BinaryExpression)(Primitive.is((Type)field.getType()) ? Expressions.equal((Expression)Expressions.field((Expression)thisParameter, (String)field.getName()), (Expression)Expressions.field((Expression)thatParameter, (String)field.getName())) : Expressions.call(Utilities.class, (String)"equal", (Expression[])new Expression[]{Expressions.field((Expression)thisParameter, (String)field.getName()), Expressions.field((Expression)thatParameter, (String)field.getName())})));
        }
        blockBuilder2.add((Statement)Expressions.return_(null, (Expression)Expressions.foldAnd(conditions)));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl((int)1, Boolean.TYPE, (String)"equals", Collections.singletonList(oParameter), (BlockStatement)blockBuilder2.toBlock()));
        BlockBuilder blockBuilder3 = new BlockBuilder();
        ParameterExpression hParameter = Expressions.parameter(Integer.TYPE, (String)"h");
        ConstantExpression constantZero = Expressions.constant((Object)0);
        blockBuilder3.add((Statement)Expressions.declare((int)0, (ParameterExpression)hParameter, (Expression)constantZero));
        for (Types.RecordField field : type.getRecordFields()) {
            blockBuilder3.add(Expressions.statement((Expression)Expressions.assign((Expression)hParameter, (Expression)Expressions.call(Utilities.class, (String)"hash", (Iterable)ImmutableList.of((Object)hParameter, (Object)Expressions.field((Expression)thisParameter, (PseudoField)field))))));
        }
        blockBuilder3.add((Statement)Expressions.return_(null, (Expression)hParameter));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl((int)1, Integer.TYPE, (String)"hashCode", Collections.emptyList(), (BlockStatement)blockBuilder3.toBlock()));
        BlockBuilder blockBuilder4 = new BlockBuilder();
        ParameterExpression cParameter = Expressions.parameter(Integer.TYPE, (String)"c");
        int mod = type.getRecordFields().size() == 1 ? 16 : 0;
        blockBuilder4.add((Statement)Expressions.declare((int)mod, (ParameterExpression)cParameter, null));
        ConditionalStatement conditionalStatement = Expressions.ifThen((Expression)Expressions.notEqual((Expression)cParameter, (Expression)constantZero), (Node)Expressions.return_(null, (Expression)cParameter));
        for (Types.RecordField field : type.getRecordFields()) {
            MethodCallExpression compareCall;
            try {
                compareCall = Expressions.call(Utilities.class, (String)(field.nullable() ? "compareNullsLast" : "compare"), (Expression[])new Expression[]{Expressions.field((Expression)thisParameter, (PseudoField)field), Expressions.field((Expression)thatParameter, (PseudoField)field)});
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) continue;
                throw e;
            }
            blockBuilder4.add(Expressions.statement((Expression)Expressions.assign((Expression)cParameter, (Expression)compareCall)));
            blockBuilder4.add((Statement)conditionalStatement);
        }
        blockBuilder4.add((Statement)Expressions.return_(null, (Expression)constantZero));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl((int)1, Integer.TYPE, (String)"compareTo", Collections.singletonList(thatParameter), (BlockStatement)blockBuilder4.toBlock()));
        BlockBuilder blockBuilder5 = new BlockBuilder();
        Object expression5 = null;
        for (Types.RecordField field : type.getRecordFields()) {
            expression5 = expression5 == null ? Expressions.constant((Object)("{" + field.getName() + "=")) : Expressions.add((Expression)expression5, (Expression)Expressions.constant((Object)(", " + field.getName() + "=")));
            expression5 = Expressions.add((Expression)expression5, (Expression)Expressions.field((Expression)thisParameter, (String)field.getName()));
        }
        expression5 = expression5 == null ? Expressions.constant((Object)"{}") : Expressions.add((Expression)expression5, (Expression)Expressions.constant((Object)"}"));
        blockBuilder5.add((Statement)Expressions.return_(null, (Expression)expression5));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl((int)1, String.class, (String)"toString", Collections.emptyList(), (BlockStatement)blockBuilder5.toBlock()));
        return classDeclaration;
    }

    public <T> Expression stash(T input, Class<? super T> clazz) {
        if (input == null || input instanceof String || input instanceof Boolean || input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Float || input instanceof Double) {
            return Expressions.constant(input, clazz);
        }
        ParameterExpression cached = this.stashedParameters.get(input);
        if (cached != null) {
            return cached;
        }
        String name = "v" + this.map.size() + "stashed";
        ParameterExpression x = Expressions.variable(clazz, (String)name);
        this.map.put(name, input);
        this.stashedParameters.put(input, x);
        return x;
    }

    public void registerCorrelVariable(final String name, final ParameterExpression pe, final BlockBuilder corrBlock, final PhysType physType) {
        this.corrVars.put(name, new RexToLixTranslator.InputGetter(){

            @Override
            public Expression field(BlockBuilder list, int index, Type storageType) {
                Expression fieldReference = physType.fieldReference((Expression)pe, index, storageType);
                return corrBlock.append(name + "_" + index, fieldReference);
            }
        });
    }

    public void clearCorrelVariable(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        this.corrVars.remove(name);
    }

    public RexToLixTranslator.InputGetter getCorrelVariableGetter(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        return this.corrVars.get(name);
    }

    public EnumerableRel.Result result(PhysType physType, BlockStatement block) {
        return new EnumerableRel.Result(block, physType, ((PhysTypeImpl)physType).format);
    }

    private class TypeRegistrar {
        private final List<MemberDeclaration> memberDeclarations;
        private final Set<Type> seen = new HashSet<Type>();

        TypeRegistrar(List<MemberDeclaration> memberDeclarations) {
            this.memberDeclarations = memberDeclarations;
        }

        private void register(Type type) {
            if (!this.seen.add(type)) {
                return;
            }
            if (type instanceof JavaTypeFactoryImpl.SyntheticRecordType) {
                this.memberDeclarations.add((MemberDeclaration)EnumerableRelImplementor.this.classDecl((JavaTypeFactoryImpl.SyntheticRecordType)((Object)type)));
            }
            if (type instanceof ParameterizedType) {
                for (Type type1 : ((ParameterizedType)type).getActualTypeArguments()) {
                    this.register(type1);
                }
            }
        }

        public void go(EnumerableRel.Result result) {
            LinkedHashSet<Type> types = new LinkedHashSet<Type>();
            result.block.accept((Visitor)new TypeFinder(types));
            types.add(result.physType.getJavaRowType());
            for (Type type : types) {
                this.register(type);
            }
        }
    }

    private static class TypeFinder
    extends Visitor {
        private final Collection<Type> types;

        TypeFinder(Collection<Type> types) {
            this.types = types;
        }

        public Expression visit(NewExpression newExpression, List<Expression> arguments, List<MemberDeclaration> memberDeclarations) {
            this.types.add(newExpression.type);
            return super.visit(newExpression, arguments, memberDeclarations);
        }

        public Expression visit(NewArrayExpression newArrayExpression, int dimension, Expression bound, List<Expression> expressions) {
            Type componentType;
            Type type = newArrayExpression.type;
            while ((componentType = Types.getComponentType((Type)type)) != null) {
                type = componentType;
            }
            this.types.add(type);
            return super.visit(newArrayExpression, dimension, bound, expressions);
        }
    }
}

