/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspector;
import org.apache.hive.hcatalog.data.JsonSerDe;
import org.apache.hive.hcatalog.streaming.AbstractRecordWriter;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;

public class StrictJsonWriter
extends AbstractRecordWriter {
    private JsonSerDe serde;
    private final HCatRecordObjectInspector recordObjInspector;
    private final ObjectInspector[] bucketObjInspectors;
    private final StructField[] bucketStructFields;

    public StrictJsonWriter(HiveEndPoint endPoint) throws ConnectionError, SerializationError, StreamingException {
        this(endPoint, null);
    }

    public StrictJsonWriter(HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, conf);
        this.serde = StrictJsonWriter.createSerde(this.tbl, conf);
        try {
            this.recordObjInspector = (HCatRecordObjectInspector)this.serde.getObjectInspector();
            this.bucketObjInspectors = StrictJsonWriter.getObjectInspectorsForBucketedCols(this.bucketIds, (StructObjectInspector)this.recordObjInspector);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to get ObjectInspector for bucket columns", (Exception)((Object)e));
        }
        this.bucketStructFields = new StructField[this.bucketIds.size()];
        List allFields = this.recordObjInspector.getAllStructFieldRefs();
        for (int i = 0; i < this.bucketIds.size(); ++i) {
            this.bucketStructFields[i] = (StructField)allFields.get((Integer)this.bucketIds.get(i));
        }
    }

    @Override
    public SerDe getSerde() {
        return this.serde;
    }

    protected HCatRecordObjectInspector getRecordObjectInspector() {
        return this.recordObjInspector;
    }

    @Override
    protected StructField[] getBucketStructFields() {
        return this.bucketStructFields;
    }

    @Override
    protected ObjectInspector[] getBucketObjectInspectors() {
        return this.bucketObjInspectors;
    }

    @Override
    public void write(long transactionId, byte[] record) throws StreamingIOFailure, SerializationError {
        try {
            Object encodedRow = this.encode(record);
            int bucket = this.getBucket(encodedRow);
            ((RecordUpdater)this.updaters.get(bucket)).insert(transactionId, encodedRow);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction(" + transactionId + ")", e);
        }
    }

    private static JsonSerDe createSerde(Table tbl, HiveConf conf) throws SerializationError {
        try {
            Properties tableProps = MetaStoreUtils.getTableMetadata((Table)tbl);
            JsonSerDe serde = new JsonSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)conf, (Properties)tableProps, null);
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + JsonSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    @Override
    public Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }
}

