/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.security.LlapSecurityHelper;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;

public class SecretManager
extends ZKDelegationTokenSecretManager<LlapTokenIdentifier> {
    public SecretManager(Configuration conf) {
        super(conf);
    }

    public LlapTokenIdentifier createIdentifier() {
        return new LlapTokenIdentifier();
    }

    public LlapTokenIdentifier decodeTokenIdentifier(Token<LlapTokenIdentifier> token) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
        LlapTokenIdentifier id = new LlapTokenIdentifier();
        id.readFields((DataInput)dis);
        dis.close();
        return id;
    }

    public static SecretManager createSecretManager(Configuration conf, String llapPrincipal, String llapKeytab) {
        UserGroupInformation zkUgi = null;
        String principal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_PRINCIPAL, (String)llapPrincipal);
        String keyTab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_KEYTAB_FILE, (String)llapKeytab);
        try {
            zkUgi = LlapSecurityHelper.loginWithKerberos(principal, keyTab);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Configuration zkConf = new Configuration(conf);
        zkConf.setLong("delegation-token.max-lifetime.sec", HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DELEGATION_TOKEN_LIFETIME, (TimeUnit)TimeUnit.SECONDS));
        zkConf.set("zk-dt-secret-manager.kerberos.principal", principal);
        zkConf.set("zk-dt-secret-manager.kerberos.keytab", keyTab);
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.znodeWorkingPath", "llapzkdtsm");
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkAuthType", "sasl");
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkConnectionString", HiveConf.getVar((Configuration)zkConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_ZK_CONNECTION_STRING));
        return (SecretManager)((Object)zkUgi.doAs((PrivilegedAction)new PrivilegedAction<SecretManager>(){

            @Override
            public SecretManager run() {
                SecretManager zkSecretManager = new SecretManager(zkConf);
                try {
                    zkSecretManager.startThreads();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return zkSecretManager;
            }
        }));
    }

    private static void setZkConfIfNotSet(Configuration zkConf, String name, String value) {
        if (zkConf.get(name) != null) {
            return;
        }
        zkConf.set(name, value);
    }
}

