/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.llap.IncrementalObjectSizeEstimator;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.MetadataReader;
import org.apache.orc.impl.OrcIndex;

public class OrcStripeMetadata
extends LlapCacheableBuffer {
    private final OrcBatchKey stripeKey;
    private final List<OrcProto.ColumnEncoding> encodings;
    private final List<OrcProto.Stream> streams;
    private final long rowCount;
    private OrcIndex rowIndex;
    private final int estimatedMemUsage;
    private static final HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> SIZE_ESTIMATORS;
    private static final IncrementalObjectSizeEstimator.ObjectEstimator SIZE_ESTIMATOR;

    public OrcStripeMetadata(OrcBatchKey stripeKey, MetadataReader mr, StripeInformation stripe, boolean[] includes, boolean[] sargColumns) throws IOException {
        this.stripeKey = stripeKey;
        OrcProto.StripeFooter footer = mr.readStripeFooter(stripe);
        this.streams = footer.getStreamsList();
        this.encodings = footer.getColumnsList();
        this.rowCount = stripe.getNumberOfRows();
        this.rowIndex = mr.readRowIndex(stripe, footer, includes, null, sargColumns, null);
        this.estimatedMemUsage = SIZE_ESTIMATOR.estimate(this, SIZE_ESTIMATORS);
    }

    private OrcStripeMetadata(long id) {
        this.stripeKey = new OrcBatchKey(id, 0, 0);
        this.encodings = new ArrayList<OrcProto.ColumnEncoding>();
        this.streams = new ArrayList<OrcProto.Stream>();
        this.estimatedMemUsage = 0;
        this.rowCount = 0;
    }

    @VisibleForTesting
    public static OrcStripeMetadata createDummy(long id) {
        OrcStripeMetadata dummy = new OrcStripeMetadata(id);
        dummy.encodings.add(OrcProto.ColumnEncoding.getDefaultInstance());
        dummy.streams.add(OrcProto.Stream.getDefaultInstance());
        OrcProto.RowIndex ri = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(1L).setStatistics(OrcFileMetadata.createStatsDummy())).build();
        OrcProto.BloomFilterIndex bfi = OrcProto.BloomFilterIndex.newBuilder().addBloomFilter(OrcProto.BloomFilter.newBuilder().addBitset(0L)).build();
        dummy.rowIndex = new OrcIndex(new OrcProto.RowIndex[]{ri}, new OrcProto.BloomFilterIndex[]{bfi});
        return dummy;
    }

    public boolean hasAllIndexes(boolean[] includes) {
        for (int i = 0; i < includes.length; ++i) {
            if (!includes[i] || this.rowIndex.getRowGroupIndex()[i] != null) continue;
            return false;
        }
        return true;
    }

    public void loadMissingIndexes(MetadataReader mr, StripeInformation stripe, boolean[] includes, boolean[] sargColumns) throws IOException {
        this.rowIndex = mr.readRowIndex(stripe, null, includes, this.rowIndex.getRowGroupIndex(), sargColumns, this.rowIndex.getBloomFilterIndex());
    }

    public int getStripeIx() {
        return this.stripeKey.stripeIx;
    }

    public OrcProto.RowIndex[] getRowIndexes() {
        return this.rowIndex.getRowGroupIndex();
    }

    public OrcProto.BloomFilterIndex[] getBloomFilterIndexes() {
        return this.rowIndex.getBloomFilterIndex();
    }

    public List<OrcProto.ColumnEncoding> getEncodings() {
        return this.encodings;
    }

    public List<OrcProto.Stream> getStreams() {
        return this.streams;
    }

    @Override
    public long getMemoryUsage() {
        return this.estimatedMemUsage;
    }

    @Override
    public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
        evictionDispatcher.notifyEvicted(this);
    }

    @Override
    protected boolean invalidate() {
        return true;
    }

    @Override
    protected boolean isLocked() {
        return false;
    }

    public OrcBatchKey getKey() {
        return this.stripeKey;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @VisibleForTesting
    public void resetRowIndex() {
        this.rowIndex = null;
    }

    static {
        OrcStripeMetadata osm = OrcStripeMetadata.createDummy(0L);
        SIZE_ESTIMATORS = IncrementalObjectSizeEstimator.createEstimators(osm);
        IncrementalObjectSizeEstimator.addEstimator("com.google.protobuf.LiteralByteString", SIZE_ESTIMATORS);
        SIZE_ESTIMATOR = SIZE_ESTIMATORS.get(OrcStripeMetadata.class);
    }
}

