/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.Cache;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderUtils;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcCacheKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.CompressionKind;
import org.apache.orc.DataReader;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.MetadataReader;
import org.apache.tez.common.CallableWithNdc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcEncodedDataReader
extends CallableWithNdc<Void>
implements ConsumerFeedback<Reader.OrcEncodedColumnBatch>,
Consumer<Reader.OrcEncodedColumnBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcEncodedDataReader.class);
    public static final FixedSizedObjectPool<EncodedColumnBatch.ColumnStreamData> CSD_POOL = new FixedSizedObjectPool(8192, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

        public EncodedColumnBatch.ColumnStreamData create() {
            return new EncodedColumnBatch.ColumnStreamData();
        }

        public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
            t.reset();
        }
    });
    public static final FixedSizedObjectPool<Reader.OrcEncodedColumnBatch> ECB_POOL = new FixedSizedObjectPool(1024, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

        public Reader.OrcEncodedColumnBatch create() {
            return new Reader.OrcEncodedColumnBatch();
        }

        public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
            t.reset();
        }
    });
    private static final Reader.PoolFactory POOL_FACTORY = new Reader.PoolFactory(){

        public <T> Pool<T> createPool(int size, Pool.PoolObjectHelper<T> helper) {
            return new FixedSizedObjectPool(size, helper);
        }

        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return CSD_POOL;
        }

        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return ECB_POOL;
        }
    };
    private final OrcMetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private final Cache<OrcCacheKey> cache;
    private final FileSplit split;
    private List<Integer> columnIds;
    private final SearchArgument sarg;
    private final String[] columnNames;
    private final OrcEncodedDataConsumer consumer;
    private final QueryFragmentCounters counters;
    private final UserGroupInformation ugi;
    private int stripeIxFrom;
    private OrcFileMetadata fileMetadata;
    private Reader orcReader;
    private MetadataReader metadataReader;
    private EncodedReader stripeReader;
    private Long fileId;
    private FileSystem fs;
    private boolean[][][] readState;
    private volatile boolean isStopped = false;
    private volatile boolean isPaused = false;

    public OrcEncodedDataReader(LowLevelCache lowLevelCache, BufferUsageManager bufferManager, Cache<OrcCacheKey> cache, OrcMetadataCache metadataCache, Configuration conf, FileSplit split, List<Integer> columnIds, SearchArgument sarg, String[] columnNames, OrcEncodedDataConsumer consumer, QueryFragmentCounters counters) {
        this.lowLevelCache = lowLevelCache;
        this.metadataCache = metadataCache;
        this.bufferManager = bufferManager;
        this.cache = cache;
        this.conf = conf;
        this.split = split;
        this.columnIds = columnIds;
        if (this.columnIds != null) {
            Collections.sort(this.columnIds);
        }
        this.sarg = sarg;
        this.columnNames = columnNames;
        this.consumer = consumer;
        this.counters = counters;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encoded reader is being stopped");
        }
        this.isStopped = true;
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    @Override
    public void unpause() {
        this.isPaused = false;
    }

    protected Void callInternal() throws IOException, InterruptedException {
        return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                return OrcEncodedDataReader.this.performDataRead();
            }
        });
    }

    protected Void performDataRead() throws IOException {
        long startTime = this.counters.startTimeCounter();
        if (LlapIoImpl.LOGL.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Processing data for " + this.split.getPath());
        }
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.TABLE, OrcEncodedDataReader.getDbAndTableName(this.split.getPath()));
        this.orcReader = null;
        this.fs = this.split.getPath().getFileSystem(this.conf);
        this.fileId = OrcEncodedDataReader.determineFileId(this.fs, this.split, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ALLOW_SYNTHETIC_FILEID));
        this.counters.setDesc(QueryFragmentCounters.Desc.FILE, this.split.getPath() + (this.fileId == null ? "" : " (" + this.fileId + ")"));
        try {
            this.fileMetadata = this.getOrReadFileMetadata();
            this.consumer.setFileMetadata(this.fileMetadata);
            this.validateFileMetadata();
            if (this.columnIds == null) {
                this.columnIds = OrcEncodedDataReader.createColumnIds(this.fileMetadata);
            }
            this.determineStripesToRead();
        }
        catch (Throwable t) {
            this.recordReaderTime(startTime);
            this.consumer.setError(t);
            return null;
        }
        if (this.readState.length == 0) {
            this.consumer.setDone();
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.STRIPES, this.stripeIxFrom + "," + this.readState.length);
        int stride = this.fileMetadata.getRowIndexStride();
        ArrayList<OrcStripeMetadata> stripeMetadatas = null;
        boolean[] globalIncludes = null;
        boolean[] sargColumns = null;
        try {
            boolean hasData;
            globalIncludes = OrcInputFormat.genIncludedColumns(this.fileMetadata.getTypes(), this.columnIds, (boolean)true);
            if (this.sarg != null && stride != 0) {
                int[] filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx((List)this.sarg.getLeaves(), (String[])this.columnNames, (int)0);
                sargColumns = new boolean[globalIncludes.length];
                for (int i : filterColumns) {
                    if (i <= 0) continue;
                    sargColumns[i] = true;
                }
                stripeMetadatas = this.readStripesMetadata(globalIncludes, sargColumns);
            }
            if (!(hasData = this.determineRgsToRead(globalIncludes, stride, stripeMetadatas))) {
                this.consumer.setDone();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        catch (Throwable t) {
            this.cleanupReaders();
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            return null;
        }
        if (this.processStop()) {
            this.cleanupReaders();
            this.recordReaderTime(startTime);
            return null;
        }
        List<Integer>[] stripeColsToRead = null;
        if (this.cache != null) {
            try {
                stripeColsToRead = this.produceDataFromCache(stride);
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        Consumer dataConsumer = (Consumer)(this.cache == null ? this.consumer : this);
        try {
            this.ensureOrcReader();
            DataWrapperForOrc dw = new DataWrapperForOrc();
            this.stripeReader = this.orcReader.encodedReader(this.fileId, (DataCache)dw, (DataReader)dw, POOL_FACTORY);
            this.stripeReader.setDebugTracing(DebugUtils.isTraceOrcEnabled());
        }
        catch (Throwable t) {
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            this.cleanupReaders();
            return null;
        }
        boolean hasFileId = this.fileId != null;
        long fileId = hasFileId ? this.fileId : 0L;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(fileId, -1, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            StripeInformation stripe;
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            int stripeIx = this.stripeIxFrom + stripeIxMod;
            boolean[][] colRgs = null;
            boolean[] stripeIncludes = null;
            OrcStripeMetadata stripeMetadata = null;
            try {
                List<Integer> cols;
                List<Integer> list = cols = stripeColsToRead == null ? null : stripeColsToRead[stripeIxMod];
                if (cols != null && cols.isEmpty()) continue;
                stripe = this.fileMetadata.getStripes().get(stripeIx);
                if (DebugUtils.isTraceOrcEnabled()) {
                    LlapIoImpl.LOG.info("Reading stripe " + stripeIx + ": " + stripe.getOffset() + ", " + stripe.getLength());
                }
                if ((colRgs = this.readState[stripeIxMod]).length > 0 && colRgs[0] == RecordReaderImpl.SargApplier.READ_NO_RGS) continue;
                if (this.cache == null || cols == null || cols.size() == colRgs.length) {
                    cols = this.columnIds;
                    stripeIncludes = globalIncludes;
                } else {
                    stripeIncludes = OrcInputFormat.genIncludedColumns(this.fileMetadata.getTypes(), cols, (boolean)true);
                    colRgs = this.genStripeColRgs(cols, colRgs);
                }
                boolean isFoundInCache = false;
                if (stripeMetadatas != null) {
                    stripeMetadata = stripeMetadatas.get(stripeIxMod);
                } else {
                    if (hasFileId && this.metadataCache != null) {
                        stripeKey.stripeIx = stripeIx;
                        stripeMetadata = this.metadataCache.getStripeMetadata(stripeKey);
                    }
                    boolean bl = isFoundInCache = stripeMetadata != null;
                    if (!isFoundInCache) {
                        this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_MISS);
                        this.ensureMetadataReader();
                        long startTimeHdfs = this.counters.startTimeCounter();
                        stripeMetadata = new OrcStripeMetadata(stripeKey, this.metadataReader, stripe, stripeIncludes, sargColumns);
                        this.counters.incrTimeCounter(QueryFragmentCounters.Counter.HDFS_TIME_US, startTimeHdfs);
                        if (hasFileId && this.metadataCache != null) {
                            stripeMetadata = this.metadataCache.putStripeMetadata(stripeMetadata);
                            if (DebugUtils.isTraceOrcEnabled()) {
                                LlapIoImpl.LOG.info("Caching stripe " + stripeKey.stripeIx + " metadata with includes: " + DebugUtils.toString((boolean[])stripeIncludes));
                            }
                            stripeKey = new OrcBatchKey(fileId, -1, 0);
                        }
                    }
                    this.consumer.setStripeMetadata(stripeMetadata);
                }
                if (!stripeMetadata.hasAllIndexes(stripeIncludes)) {
                    if (DebugUtils.isTraceOrcEnabled()) {
                        LlapIoImpl.LOG.info("Updating indexes in stripe " + stripeKey.stripeIx + " metadata for includes: " + DebugUtils.toString((boolean[])stripeIncludes));
                    }
                    assert (isFoundInCache);
                    this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_MISS);
                    this.ensureMetadataReader();
                    this.updateLoadedIndexes(stripeMetadata, stripe, stripeIncludes, sargColumns);
                } else if (isFoundInCache) {
                    this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_HIT);
                }
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            try {
                this.stripeReader.readEncodedColumns(stripeIx, stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getEncodings(), stripeMetadata.getStreams(), stripeIncludes, colRgs, dataConsumer);
                continue;
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        this.recordReaderTime(startTime);
        dataConsumer.setDone();
        if (DebugUtils.isTraceMttEnabled()) {
            LlapIoImpl.LOG.info("done processing " + this.split);
        }
        this.cleanupReaders();
        return null;
    }

    private void recordReaderTime(long startTime) {
        this.counters.incrTimeCounter(QueryFragmentCounters.Counter.TOTAL_IO_TIME_US, startTime);
    }

    private static String getDbAndTableName(Path path) {
        String[] parts = path.toUri().getPath().toString().split("/");
        int dbIx = -1;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!parts[i].endsWith(".db")) continue;
            if (dbIx >= 0) {
                dbIx = -1;
                break;
            }
            dbIx = i;
        }
        if (dbIx >= 0) {
            return parts[dbIx].substring(0, parts[dbIx].length() - 3) + "." + parts[dbIx + 1];
        }
        boolean isInPartFields = false;
        for (int i = parts.length - 2; i >= 0; --i) {
            String p = parts[i];
            boolean isPartField = p.contains("=");
            if (isInPartFields && !isPartField || !isPartField && !p.startsWith("base_") && !p.startsWith("delta_") && !p.startsWith("bucket_")) {
                dbIx = i - 1;
                break;
            }
            isInPartFields = isPartField;
        }
        if (dbIx >= 0) {
            String dbName = parts[dbIx];
            if (dbName.endsWith(".db")) {
                dbName = dbName.substring(0, dbName.length() - 3);
            }
            return dbName + "." + parts[dbIx + 1];
        }
        return "unknown";
    }

    private void validateFileMetadata() throws IOException {
        long minAllocSize;
        if (this.fileMetadata.getCompressionKind() == CompressionKind.NONE) {
            return;
        }
        int bufferSize = this.fileMetadata.getCompressionBufferSize();
        if ((long)bufferSize < (minAllocSize = HiveConf.getSizeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC))) {
            LOG.warn("ORC compression buffer size (" + bufferSize + ") is smaller than LLAP low-level " + "cache minimum allocation size (" + minAllocSize + "). Decrease the value for " + HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC.toString() + " to avoid wasting memory");
        }
    }

    private boolean processStop() {
        if (!this.isStopped) {
            return false;
        }
        LOG.info("Encoded data reader is stopping");
        this.cleanupReaders();
        return true;
    }

    private static Long determineFileId(FileSystem fs, FileSplit split, boolean allowSynthetic) throws IOException {
        Long fileId;
        if (split instanceof OrcSplit && (fileId = ((OrcSplit)split).getFileId()) != null) {
            return fileId;
        }
        LOG.warn("Split for " + split.getPath() + " (" + split.getClass() + ") does not have file ID");
        return HdfsUtils.getFileId((FileSystem)fs, (Path)split.getPath(), (boolean)allowSynthetic);
    }

    private boolean[][] genStripeColRgs(List<Integer> stripeCols, boolean[][] globalColRgs) {
        boolean[][] stripeColRgs = new boolean[stripeCols.size()][];
        int i2 = -1;
        for (int i = 0; i < globalColRgs.length; ++i) {
            if (globalColRgs[i] == null) continue;
            stripeColRgs[i2] = globalColRgs[i];
            ++i2;
        }
        return stripeColRgs;
    }

    private static List<Integer> createColumnIds(OrcFileMetadata metadata) {
        ArrayList<Integer> columnIds = new ArrayList<Integer>(metadata.getTypes().size());
        for (int i = 1; i < metadata.getTypes().size(); ++i) {
            columnIds.add(i);
        }
        return columnIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadedIndexes(OrcStripeMetadata stripeMetadata, StripeInformation stripe, boolean[] stripeIncludes, boolean[] sargColumns) throws IOException {
        OrcStripeMetadata orcStripeMetadata = stripeMetadata;
        synchronized (orcStripeMetadata) {
            if (stripeMetadata.hasAllIndexes(stripeIncludes)) {
                return;
            }
            long startTime = this.counters.startTimeCounter();
            stripeMetadata.loadMissingIndexes(this.metadataReader, stripe, stripeIncludes, sargColumns);
            this.counters.incrTimeCounter(QueryFragmentCounters.Counter.HDFS_TIME_US, startTime);
        }
    }

    private void cleanupReaders() {
        if (this.metadataReader != null) {
            try {
                this.metadataReader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.stripeReader != null) {
            try {
                this.stripeReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureOrcReader() throws IOException {
        if (this.orcReader != null) {
            return;
        }
        Path path = this.split.getPath();
        if (this.fileId != null && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH)) {
            path = HdfsUtils.getFileIdPath((FileSystem)this.fs, (Path)path, (long)this.fileId);
        }
        if (DebugUtils.isTraceOrcEnabled()) {
            LOG.info("Creating reader for " + path + " (" + this.split.getPath() + ")");
        }
        long startTime = this.counters.startTimeCounter();
        OrcFile.ReaderOptions opts = OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs).fileMetadata((FileMetadata)this.fileMetadata);
        this.orcReader = EncodedOrcFile.createReader((Path)path, (OrcFile.ReaderOptions)opts);
        this.counters.incrTimeCounter(QueryFragmentCounters.Counter.HDFS_TIME_US, startTime);
    }

    private OrcFileMetadata getOrReadFileMetadata() throws IOException {
        OrcFileMetadata metadata = null;
        if (this.fileId != null && this.metadataCache != null) {
            metadata = this.metadataCache.getFileMetadata(this.fileId);
            if (metadata != null) {
                this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_HIT);
                return metadata;
            }
            this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_MISS);
        }
        this.ensureOrcReader();
        metadata = new OrcFileMetadata(this.fileId != null ? this.fileId : 0L, (org.apache.hadoop.hive.ql.io.orc.Reader)this.orcReader);
        if (this.fileId == null || this.metadataCache == null) {
            return metadata;
        }
        return this.metadataCache.putFileMetadata(metadata);
    }

    private ArrayList<OrcStripeMetadata> readStripesMetadata(boolean[] globalInc, boolean[] sargColumns) throws IOException {
        ArrayList<OrcStripeMetadata> result = new ArrayList<OrcStripeMetadata>(this.readState.length);
        boolean hasFileId = this.fileId != null;
        long fileId = hasFileId ? this.fileId : 0L;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(fileId, 0, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            OrcStripeMetadata value = null;
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            if (hasFileId && this.metadataCache != null) {
                stripeKey.stripeIx = stripeIx;
                value = this.metadataCache.getStripeMetadata(stripeKey);
            }
            if (value == null || !value.hasAllIndexes(globalInc)) {
                this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_MISS);
                this.ensureMetadataReader();
                StripeInformation si = this.fileMetadata.getStripes().get(stripeIx);
                if (value == null) {
                    long startTime = this.counters.startTimeCounter();
                    value = new OrcStripeMetadata(stripeKey, this.metadataReader, si, globalInc, sargColumns);
                    this.counters.incrTimeCounter(QueryFragmentCounters.Counter.HDFS_TIME_US, startTime);
                    if (hasFileId && this.metadataCache != null) {
                        value = this.metadataCache.putStripeMetadata(value);
                        if (DebugUtils.isTraceOrcEnabled()) {
                            LlapIoImpl.LOG.info("Caching stripe " + stripeKey.stripeIx + " metadata with includes: " + DebugUtils.toString((boolean[])globalInc));
                        }
                        stripeKey = new OrcBatchKey(fileId, 0, 0);
                    }
                }
                if (!value.hasAllIndexes(globalInc)) {
                    if (DebugUtils.isTraceOrcEnabled()) {
                        LlapIoImpl.LOG.info("Updating indexes in stripe " + stripeKey.stripeIx + " metadata for includes: " + DebugUtils.toString((boolean[])globalInc));
                    }
                    this.updateLoadedIndexes(value, si, globalInc, sargColumns);
                }
            } else {
                this.counters.incrCounter(QueryFragmentCounters.Counter.METADATA_CACHE_HIT);
            }
            result.add(value);
            this.consumer.setStripeMetadata(value);
        }
        return result;
    }

    private void ensureMetadataReader() throws IOException {
        this.ensureOrcReader();
        if (this.metadataReader != null) {
            return;
        }
        long startTime = this.counters.startTimeCounter();
        this.metadataReader = this.orcReader.metadata();
        this.counters.incrTimeCounter(QueryFragmentCounters.Counter.HDFS_TIME_US, startTime);
    }

    @Override
    public void returnData(Reader.OrcEncodedColumnBatch ecb) {
        for (EncodedColumnBatch.ColumnStreamData[] datas : ecb.getColumnData()) {
            if (datas == null) continue;
            for (EncodedColumnBatch.ColumnStreamData data : datas) {
                if (data == null || data.decRef() != 0) continue;
                if (DebugUtils.isTraceLockingEnabled()) {
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        LlapIoImpl.LOG.info("Unlocking " + buf + " at the end of processing");
                    }
                }
                this.bufferManager.decRefBuffers(data.getCacheBuffers());
                CSD_POOL.offer((Object)data);
            }
        }
        ECB_POOL.offer((Object)ecb);
    }

    private boolean determineRgsToRead(boolean[] globalIncludes, int rowIndexStride, ArrayList<OrcStripeMetadata> metadata) throws IOException {
        RecordReaderImpl.SargApplier sargApp = null;
        if (this.sarg != null && rowIndexStride != 0) {
            List<OrcProto.Type> types = this.fileMetadata.getTypes();
            String[] colNamesForSarg = OrcInputFormat.getSargColumnNames((String[])this.columnNames, types, (boolean[])globalIncludes, (boolean)this.fileMetadata.isOriginalFormat());
            sargApp = new RecordReaderImpl.SargApplier(this.sarg, colNamesForSarg, (long)rowIndexStride, types, globalIncludes.length);
        }
        boolean hasAnyData = false;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            StripeInformation stripe = this.fileMetadata.getStripes().get(stripeIx);
            int rgCount = this.getRgCount(stripe, rowIndexStride);
            boolean[] rgsToRead = null;
            if (sargApp != null) {
                OrcStripeMetadata stripeMetadata = metadata.get(stripeIxMod);
                rgsToRead = sargApp.pickRowGroups(stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getBloomFilterIndexes(), true);
            }
            boolean isNone = rgsToRead == RecordReaderImpl.SargApplier.READ_NO_RGS;
            boolean isAll = rgsToRead == RecordReaderImpl.SargApplier.READ_ALL_RGS;
            boolean bl = hasAnyData = hasAnyData || !isNone;
            if (DebugUtils.isTraceOrcEnabled()) {
                if (isNone) {
                    LlapIoImpl.LOG.info("SARG eliminated all RGs for stripe " + stripeIx);
                } else if (!isAll) {
                    LlapIoImpl.LOG.info("SARG picked RGs for stripe " + stripeIx + ": " + DebugUtils.toString((boolean[])rgsToRead));
                } else {
                    LlapIoImpl.LOG.info("Will read all " + rgCount + " RGs for stripe " + stripeIx);
                }
            }
            assert (isAll || isNone || rgsToRead.length == rgCount);
            this.readState[stripeIxMod] = new boolean[this.columnIds.size()][];
            for (int j = 0; j < this.columnIds.size(); ++j) {
                this.readState[stripeIxMod][j] = isAll || isNone ? rgsToRead : Arrays.copyOf(rgsToRead, rgsToRead.length);
            }
            this.adjustRgMetric(rgCount, rgsToRead, isNone, isAll);
        }
        return hasAnyData;
    }

    private void adjustRgMetric(int rgCount, boolean[] rgsToRead, boolean isNone, boolean isAll) {
        int count = 0;
        if (!isAll) {
            for (boolean b : rgsToRead) {
                if (!b) continue;
                ++count;
            }
        } else if (!isNone) {
            count = rgCount;
        }
        this.counters.setCounter(QueryFragmentCounters.Counter.SELECTED_ROWGROUPS, count);
    }

    private int getRgCount(StripeInformation stripe, int rowIndexStride) {
        return (int)Math.ceil((double)stripe.getNumberOfRows() / (double)rowIndexStride);
    }

    public void determineStripesToRead() {
        List<StripeInformation> stripes = this.fileMetadata.getStripes();
        long offset = this.split.getStart();
        long maxOffset = offset + this.split.getLength();
        this.stripeIxFrom = -1;
        int stripeIxTo = -1;
        if (LlapIoImpl.LOGL.isDebugEnabled()) {
            String tmp = "FileSplit {" + this.split.getStart() + ", " + this.split.getLength() + "}; stripes ";
            for (StripeInformation stripe : stripes) {
                tmp = tmp + "{" + stripe.getOffset() + ", " + stripe.getLength() + "}, ";
            }
            LlapIoImpl.LOG.debug(tmp);
        }
        int stripeIx = 0;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                ++stripeIx;
                continue;
            }
            if (this.stripeIxFrom == -1) {
                if (DebugUtils.isTraceOrcEnabled()) {
                    LlapIoImpl.LOG.info("Including stripes from " + stripeIx + " (" + stripeStart + " >= " + offset + ")");
                }
                this.stripeIxFrom = stripeIx;
            }
            if (stripeStart >= maxOffset) {
                stripeIxTo = stripeIx;
                if (!DebugUtils.isTraceOrcEnabled()) break;
                LlapIoImpl.LOG.info("Including stripes until " + stripeIxTo + " (" + stripeStart + " >= " + maxOffset + "); " + (stripeIxTo - this.stripeIxFrom) + " stripes");
                break;
            }
            ++stripeIx;
        }
        if (this.stripeIxFrom == -1 && LlapIoImpl.LOG.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Not including any stripes - empty split");
        }
        if (stripeIxTo == -1 && this.stripeIxFrom != -1) {
            stripeIxTo = stripeIx;
            if (DebugUtils.isTraceOrcEnabled()) {
                LlapIoImpl.LOG.info("Including stripes until " + stripeIx + " (end of file); " + (stripeIxTo - this.stripeIxFrom) + " stripes");
            }
        }
        this.readState = new boolean[stripeIxTo - this.stripeIxFrom][][];
    }

    private List<Integer>[] produceDataFromCache(int rowIndexStride) throws IOException {
        OrcCacheKey key = new OrcCacheKey(this.fileId.longValue(), -1, -1, -1);
        List[] stripeColsNotInCache = new List[this.readState.length];
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            key.stripeIx = this.stripeIxFrom + stripeIxMod;
            boolean[][] cols = this.readState[stripeIxMod];
            boolean[] isMissingAnyRgs = new boolean[cols.length];
            int totalRgCount = this.getRgCount(this.fileMetadata.getStripes().get(key.stripeIx), rowIndexStride);
            for (int rgIx = 0; rgIx < totalRgCount; ++rgIx) {
                Reader.OrcEncodedColumnBatch col = (Reader.OrcEncodedColumnBatch)ECB_POOL.take();
                col.init(this.fileId.longValue(), key.stripeIx, rgIx, cols.length);
                boolean hasAnyCached = false;
                try {
                    key.rgIx = rgIx;
                    for (int colIxMod = 0; colIxMod < cols.length; ++colIxMod) {
                        boolean[] readMask = cols[colIxMod];
                        if (readMask == RecordReaderImpl.SargApplier.READ_NO_RGS || readMask != RecordReaderImpl.SargApplier.READ_ALL_RGS && (readMask.length <= rgIx || !readMask[rgIx])) continue;
                        key.colIx = this.columnIds.get(colIxMod);
                        EncodedColumnBatch.ColumnStreamData[] cached = this.cache.get(key);
                        if (cached == null) {
                            isMissingAnyRgs[colIxMod] = true;
                            continue;
                        }
                        assert (cached.length == Reader.OrcEncodedColumnBatch.MAX_DATA_STREAMS);
                        col.setAllStreamsData(colIxMod, key.colIx, cached);
                        hasAnyCached = true;
                        if (readMask == RecordReaderImpl.SargApplier.READ_ALL_RGS) {
                            readMask = new boolean[totalRgCount];
                            cols[colIxMod] = readMask;
                            Arrays.fill(readMask, true);
                        }
                        readMask[rgIx] = false;
                    }
                }
                catch (Throwable t) {
                    throw t instanceof IOException ? (IOException)t : new IOException(t);
                }
                if (!hasAnyCached) continue;
                this.consumer.consumeData(col);
            }
            boolean makeStripeColList = false;
            for (int colIxMod = 0; colIxMod < cols.length; ++colIxMod) {
                if (isMissingAnyRgs[colIxMod]) {
                    if (!makeStripeColList) continue;
                    stripeColsNotInCache[stripeIxMod].add(this.columnIds.get(colIxMod));
                    continue;
                }
                if (makeStripeColList) continue;
                makeStripeColList = true;
                stripeColsNotInCache[stripeIxMod] = new ArrayList(cols.length - 1);
                for (int i = 0; i < colIxMod; ++i) {
                    stripeColsNotInCache[stripeIxMod].add(this.columnIds.get(i));
                }
            }
        }
        return stripeColsNotInCache;
    }

    public void setDone() {
        this.consumer.setDone();
    }

    public void consumeData(Reader.OrcEncodedColumnBatch data) {
        assert (this.cache != null);
        throw new UnsupportedOperationException("not implemented");
    }

    public void setError(Throwable t) {
        this.consumer.setError(t);
    }

    private class DataWrapperForOrc
    implements DataReader,
    DataCache {
        private final DataReader orcDataReader;

        public DataWrapperForOrc() {
            boolean useZeroCopy;
            boolean bl = useZeroCopy = OrcEncodedDataReader.this.conf != null && OrcConf.USE_ZEROCOPY.getBoolean(OrcEncodedDataReader.this.conf);
            if (useZeroCopy && !this.getAllocator().isDirectAlloc()) {
                throw new UnsupportedOperationException("Cannot use zero-copy reader with non-direct cache buffers; either disable zero-copy or enable direct cache allocation");
            }
            this.orcDataReader = OrcEncodedDataReader.this.orcReader.createDefaultDataReader(useZeroCopy);
        }

        public DiskRangeList getFileData(long fileId, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            return OrcEncodedDataReader.this.lowLevelCache == null ? range : OrcEncodedDataReader.this.lowLevelCache.getFileData(fileId, range, baseOffset, factory, OrcEncodedDataReader.this.counters, gotAllData);
        }

        public long[] putFileData(long fileId, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            return OrcEncodedDataReader.this.lowLevelCache == null ? null : OrcEncodedDataReader.this.lowLevelCache.putFileData(fileId, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, OrcEncodedDataReader.this.counters);
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            OrcEncodedDataReader.this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = OrcEncodedDataReader.this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return OrcEncodedDataReader.this.bufferManager.getAllocator();
        }

        public void close() throws IOException {
            this.orcDataReader.close();
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            DiskRangeList result = this.orcDataReader.readFileData(range, baseOffset, doForceDirect);
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
            if (DebugUtils.isTraceOrcEnabled() && LOG.isInfoEnabled()) {
                LOG.info("Disk ranges after disk read (file " + OrcEncodedDataReader.this.fileId + ", base offset " + baseOffset + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result));
            }
            return result;
        }

        public boolean isTrackingDiskRanges() {
            return this.orcDataReader.isTrackingDiskRanges();
        }

        public void releaseBuffer(ByteBuffer buffer) {
            this.orcDataReader.releaseBuffer(buffer);
        }

        public void open() throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            this.orcDataReader.open();
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
        }
    }
}

