/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.decode.EncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonQueueMetrics;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.PositionProvider;

public class OrcEncodedDataConsumer
extends EncodedDataConsumer<OrcBatchKey, Reader.OrcEncodedColumnBatch> {
    private TreeReaderFactory.TreeReader[] columnReaders;
    private int previousStripeIndex = -1;
    private OrcFileMetadata fileMetadata;
    private CompressionCodec codec;
    private OrcStripeMetadata[] stripes;
    private final boolean skipCorrupt;
    private final QueryFragmentCounters counters;

    public OrcEncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, int colCount, boolean skipCorrupt, QueryFragmentCounters counters, LlapDaemonQueueMetrics queueMetrics) {
        super(consumer, colCount, queueMetrics);
        this.skipCorrupt = skipCorrupt;
        this.counters = counters;
    }

    public void setFileMetadata(OrcFileMetadata f) {
        assert (this.fileMetadata == null);
        this.fileMetadata = f;
        this.stripes = new OrcStripeMetadata[f.getStripes().size()];
        this.codec = WriterImpl.createCodec((CompressionKind)this.fileMetadata.getCompressionKind());
    }

    public void setStripeMetadata(OrcStripeMetadata m) {
        assert (this.stripes != null);
        this.stripes[m.getStripeIx()] = m;
    }

    @Override
    protected void decodeBatch(Reader.OrcEncodedColumnBatch batch, Consumer<ColumnVectorBatch> downstreamConsumer) {
        long startTime = this.counters.startTimeCounter();
        int currentStripeIndex = ((OrcBatchKey)batch.getBatchKey()).stripeIx;
        boolean sameStripe = currentStripeIndex == this.previousStripeIndex;
        try {
            OrcStripeMetadata stripeMetadata = this.stripes[currentStripeIndex];
            int rgIdx = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            long nonNullRowCount = -1L;
            if (rgIdx == -1) {
                nonNullRowCount = stripeMetadata.getRowCount();
            } else {
                OrcProto.RowIndexEntry rowIndex = stripeMetadata.getRowIndexes()[0].getEntry(rgIdx);
                nonNullRowCount = this.getRowCount(rowIndex);
            }
            int maxBatchesRG = (int)(nonNullRowCount / 1024L + 1L);
            int batchSize = 1024;
            int numCols = batch.getColumnIxs().length;
            if (this.columnReaders == null || !sameStripe) {
                this.columnReaders = EncodedTreeReaderFactory.createEncodedTreeReader((int)numCols, this.fileMetadata.getTypes(), stripeMetadata.getEncodings(), (EncodedColumnBatch)batch, (CompressionCodec)this.codec, (boolean)this.skipCorrupt);
                this.positionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, numCols, stripeMetadata);
            } else {
                this.repositionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, sameStripe, numCols, stripeMetadata);
            }
            this.previousStripeIndex = currentStripeIndex;
            for (int i = 0; i < maxBatchesRG && (i != maxBatchesRG - 1 || (batchSize = (int)(nonNullRowCount % 1024L)) != 0); ++i) {
                ColumnVectorBatch cvb = (ColumnVectorBatch)this.cvbPool.take();
                assert (cvb.cols.length == batch.getColumnIxs().length);
                cvb.size = batchSize;
                for (int idx = 0; idx < batch.getColumnIxs().length; ++idx) {
                    cvb.cols[idx] = (ColumnVector)this.columnReaders[idx].nextVector((Object)cvb.cols[idx], (long)batchSize);
                }
                downstreamConsumer.consumeData((Object)cvb);
                this.counters.incrCounter(QueryFragmentCounters.Counter.ROWS_EMITTED, batchSize);
            }
            this.counters.incrTimeCounter(QueryFragmentCounters.Counter.DECODE_TIME_US, startTime);
            this.counters.incrCounter(QueryFragmentCounters.Counter.NUM_VECTOR_BATCHES, maxBatchesRG);
            this.counters.incrCounter(QueryFragmentCounters.Counter.NUM_DECODED_BATCHES);
        }
        catch (IOException e) {
            downstreamConsumer.setError((Throwable)e);
        }
    }

    private void positionInStreams(TreeReaderFactory.TreeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, int numCols, OrcStripeMetadata stripeMetadata) throws IOException {
        for (int i = 0; i < numCols; ++i) {
            int columnIndex = batch.getColumnIxs()[i];
            int rowGroupIndex = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            OrcProto.RowIndex rowIndex = stripeMetadata.getRowIndexes()[columnIndex];
            OrcProto.RowIndexEntry rowIndexEntry = rowIndex.getEntry(rowGroupIndex);
            columnReaders[i].seek((PositionProvider)new RecordReaderImpl.PositionProviderImpl(rowIndexEntry));
        }
    }

    private void repositionInStreams(TreeReaderFactory.TreeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe, int numCols, OrcStripeMetadata stripeMetadata) throws IOException {
        for (int i = 0; i < numCols; ++i) {
            int columnIndex = batch.getColumnIxs()[i];
            int rowGroupIndex = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            EncodedColumnBatch.ColumnStreamData[] streamBuffers = batch.getColumnData()[i];
            OrcProto.RowIndex rowIndex = stripeMetadata.getRowIndexes()[columnIndex];
            OrcProto.RowIndexEntry rowIndexEntry = rowIndex.getEntry(rowGroupIndex);
            ((EncodedTreeReaderFactory.SettableTreeReader)columnReaders[i]).setBuffers(streamBuffers, sameStripe);
            columnReaders[i].seek((PositionProvider)new RecordReaderImpl.PositionProviderImpl(rowIndexEntry));
        }
    }

    private long getRowCount(OrcProto.RowIndexEntry rowIndexEntry) {
        return rowIndexEntry.getStatistics().getNumberOfValues();
    }
}

