/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.services.impl.LlapWebApp;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class LlapWebServices
extends AbstractService {
    private int port;
    private Configuration conf;
    private WebApp webApp;
    private LlapWebApp webAppInstance;

    public LlapWebServices() {
        super("LlapWebServices");
    }

    public void serviceInit(Configuration conf) {
        this.conf = new Configuration(conf);
        this.conf.addResource("yarn-site.xml");
        this.port = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT);
        this.webAppInstance = new LlapWebApp();
    }

    public void serviceStart() throws Exception {
        String bindAddress = "0.0.0.0";
        if (UserGroupInformation.isSecurityEnabled() && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_WEB_AUTO_AUTH)) {
            this.conf.set("hadoop.http.authentication.type", "kerberos");
            this.conf.set("hadoop.http.authentication.kerberos.principal", HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL));
            this.conf.set("hadoop.http.authentication.kerberos.keytab", HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE));
            String authFilterName = AuthenticationFilterInitializer.class.getName();
            String initializers = this.conf.getTrimmed("hadoop.http.filter.initializers");
            if (initializers == null || initializers.isEmpty()) {
                initializers = authFilterName;
            } else if (!initializers.contains(authFilterName)) {
                initializers = authFilterName + "," + initializers;
            }
            this.conf.set("hadoop.http.filter.initializers", initializers);
        }
        WebApps.Builder webAppBuilder = WebApps.$for((String)"llap").at(bindAddress).at(this.port).with(this.conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            webAppBuilder.withHttpPolicy(this.conf, HttpConfig.Policy.HTTPS_ONLY);
        }
        this.webApp = webAppBuilder.start();
    }

    public void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
    }
}

