/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.task.ErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTaskReporter
implements TaskReporterInterface {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTaskReporter.class);
    private final LlapTaskUmbilicalProtocol umbilical;
    private final long pollInterval;
    private final long sendCounterInterval;
    private final int maxEventsToGet;
    private final AtomicLong requestCounter;
    private final String containerIdStr;
    private final ListeningExecutorService heartbeatExecutor;
    @VisibleForTesting
    HeartbeatCallable currentCallable;

    public LlapTaskReporter(LlapTaskUmbilicalProtocol umbilical, long amPollInterval, long sendCounterInterval, int maxEventsToGet, AtomicLong requestCounter, String containerIdStr) {
        this.umbilical = umbilical;
        this.pollInterval = amPollInterval;
        this.sendCounterInterval = sendCounterInterval;
        this.maxEventsToGet = maxEventsToGet;
        this.requestCounter = requestCounter;
        this.containerIdStr = containerIdStr;
        ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TaskHeartbeatThread").build());
        this.heartbeatExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
    }

    public synchronized void registerTask(RuntimeTask task, ErrorReporter errorReporter) {
        this.currentCallable = new HeartbeatCallable(task, this.umbilical, this.pollInterval, this.sendCounterInterval, this.maxEventsToGet, this.requestCounter, this.containerIdStr);
        ListenableFuture future = this.heartbeatExecutor.submit((Callable)this.currentCallable);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new HeartbeatCallback(errorReporter));
    }

    public synchronized void unregisterTask(TezTaskAttemptID taskAttemptID) {
        this.currentCallable.markComplete();
        this.currentCallable = null;
    }

    public void shutdown() {
        this.heartbeatExecutor.shutdownNow();
    }

    public synchronized boolean taskSucceeded(TezTaskAttemptID taskAttemptID) throws IOException, TezException {
        return this.currentCallable.taskSucceeded(taskAttemptID);
    }

    public synchronized boolean taskFailed(TezTaskAttemptID taskAttemptID, Throwable t, String diagnostics, EventMetaData srcMeta) throws IOException, TezException {
        return this.currentCallable.taskFailed(taskAttemptID, t, diagnostics, srcMeta);
    }

    public synchronized void addEvents(TezTaskAttemptID taskAttemptID, Collection<TezEvent> events) {
        this.currentCallable.addEvents(taskAttemptID, events);
    }

    public boolean canCommit(TezTaskAttemptID taskAttemptID) throws IOException {
        return this.umbilical.canCommit(taskAttemptID);
    }

    private static final class ResponseWrapper {
        boolean shouldDie;
        int numEvents;

        private ResponseWrapper(boolean shouldDie, int numEvents) {
            this.shouldDie = shouldDie;
            this.numEvents = numEvents;
        }
    }

    private static class HeartbeatCallback
    implements FutureCallback<Boolean> {
        private final ErrorReporter errorReporter;

        HeartbeatCallback(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        public void onSuccess(Boolean result) {
            if (!result.booleanValue()) {
                this.errorReporter.shutdownRequested();
            }
        }

        public void onFailure(Throwable t) {
            this.errorReporter.reportError(t);
        }
    }

    @VisibleForTesting
    static class HeartbeatCallable
    implements Callable<Boolean> {
        private static final int LOG_COUNTER_START_INTERVAL = 5000;
        private static final float LOG_COUNTER_BACKOFF = 1.3f;
        private final RuntimeTask task;
        private final EventMetaData updateEventMetadata;
        private final LlapTaskUmbilicalProtocol umbilical;
        private final long pollInterval;
        private final long sendCounterInterval;
        private final int maxEventsToGet;
        private final String containerIdStr;
        private final AtomicLong requestCounter;
        private final AtomicBoolean finalEventQueued = new AtomicBoolean(false);
        private final AtomicBoolean askedToDie = new AtomicBoolean(false);
        private LinkedBlockingQueue<TezEvent> eventsToSend = new LinkedBlockingQueue();
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private AtomicInteger nonOobHeartbeatCounter = new AtomicInteger(0);
        private int nextHeartbeatNumToLog = 0;
        private int prevCounterSendHeartbeatNum = 0;

        public HeartbeatCallable(RuntimeTask task, LlapTaskUmbilicalProtocol umbilical, long amPollInterval, long sendCounterInterval, int maxEventsToGet, AtomicLong requestCounter, String containerIdStr) {
            this.pollInterval = amPollInterval;
            this.sendCounterInterval = sendCounterInterval;
            this.maxEventsToGet = maxEventsToGet;
            this.requestCounter = requestCounter;
            this.containerIdStr = containerIdStr;
            this.task = task;
            this.umbilical = umbilical;
            this.updateEventMetadata = new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, task.getVertexName(), "", task.getTaskAttemptID());
            this.nextHeartbeatNumToLog = Math.max(1, (int)(5000.0f / (amPollInterval == 0L ? 1.0E-6f : (float)amPollInterval)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            while (!this.task.isTaskDone() && !this.task.hadFatalError()) {
                ResponseWrapper response = this.heartbeat(null);
                if (response.shouldDie) {
                    LOG.info("Asked to die via task heartbeat");
                    return false;
                }
                if (response.numEvents >= this.maxEventsToGet) continue;
                this.lock.lock();
                try {
                    boolean interrupted = this.condition.await(this.pollInterval, TimeUnit.MILLISECONDS);
                    if (interrupted) continue;
                    this.nonOobHeartbeatCounter.incrementAndGet();
                }
                finally {
                    this.lock.unlock();
                }
            }
            int pendingEventCount = this.eventsToSend.size();
            if (pendingEventCount > 0) {
                LOG.warn("Exiting TaskReporter thread with pending queue size=" + pendingEventCount);
            }
            return true;
        }

        private synchronized ResponseWrapper heartbeat(Collection<TezEvent> eventsArg) throws IOException, TezException {
            if (eventsArg != null) {
                this.eventsToSend.addAll(eventsArg);
            }
            TezEvent updateEvent = null;
            ArrayList<TezEvent> events = new ArrayList<TezEvent>();
            this.eventsToSend.drainTo(events);
            if (!this.task.isTaskDone() && !this.task.hadFatalError()) {
                boolean sendCounters = false;
                if ((long)(this.nonOobHeartbeatCounter.get() - this.prevCounterSendHeartbeatNum) * this.pollInterval >= this.sendCounterInterval) {
                    sendCounters = true;
                    this.prevCounterSendHeartbeatNum = this.nonOobHeartbeatCounter.get();
                }
                updateEvent = new TezEvent((Event)this.getStatusUpdateEvent(sendCounters), this.updateEventMetadata);
                events.add(updateEvent);
            }
            long requestId = this.requestCounter.incrementAndGet();
            int fromEventId = this.task.getNextFromEventId();
            int fromPreRoutedEventId = this.task.getNextPreRoutedEventId();
            TezHeartbeatRequest request = new TezHeartbeatRequest(requestId, events, fromPreRoutedEventId, this.containerIdStr, this.task.getTaskAttemptID(), fromEventId, this.maxEventsToGet);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending heartbeat to AM, request=" + request);
            }
            this.maybeLogCounters();
            TezHeartbeatResponse response = this.umbilical.heartbeat(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received heartbeat response from AM, response=" + response);
            }
            if (response.shouldDie()) {
                LOG.info("Received should die response from AM");
                this.askedToDie.set(true);
                return new ResponseWrapper(true, 1);
            }
            if (response.getLastRequestId() != requestId) {
                throw new TezException("AM and Task out of sync, responseReqId=" + response.getLastRequestId() + ", expectedReqId=" + requestId);
            }
            int numEventsReceived = 0;
            if (this.task.isTaskDone() || this.task.hadFatalError()) {
                if (response.getEvents() != null && !response.getEvents().isEmpty()) {
                    LOG.warn("Current task already complete, Ignoring all event in heartbeat response, eventCount=" + response.getEvents().size());
                }
            } else {
                this.task.setNextFromEventId(response.getNextFromEventId());
                this.task.setNextPreRoutedEventId(response.getNextPreRoutedEventId());
                if (response.getEvents() != null && !response.getEvents().isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Routing events from heartbeat response to task, currentTaskAttemptId=" + this.task.getTaskAttemptID() + ", eventCount=" + response.getEvents().size() + " fromEventId=" + fromEventId + " nextFromEventId=" + response.getNextFromEventId());
                    }
                    numEventsReceived = response.getEvents().size();
                    this.task.handleEvents((Collection)response.getEvents());
                }
            }
            return new ResponseWrapper(false, numEventsReceived);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markComplete() {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void maybeLogCounters() {
            if (LOG.isDebugEnabled() && this.nonOobHeartbeatCounter.get() == this.nextHeartbeatNumToLog) {
                LOG.debug("Counters: " + this.task.getCounters().toShortString());
                this.nextHeartbeatNumToLog = (int)((float)this.nextHeartbeatNumToLog * 1.3f);
            }
        }

        private boolean taskSucceeded(TezTaskAttemptID taskAttemptID) throws IOException, TezException {
            if (!this.finalEventQueued.getAndSet(true)) {
                TezEvent statusUpdateEvent = new TezEvent((Event)this.getStatusUpdateEvent(true), this.updateEventMetadata);
                TezEvent taskCompletedEvent = new TezEvent((Event)new TaskAttemptCompletedEvent(), this.updateEventMetadata);
                return !this.heartbeat((Collection<TezEvent>)Lists.newArrayList((Object[])new TezEvent[]{statusUpdateEvent, taskCompletedEvent})).shouldDie;
            }
            LOG.warn("A final task state event has already been sent. Not sending again");
            return this.askedToDie.get();
        }

        private TaskStatusUpdateEvent getStatusUpdateEvent(boolean sendCounters) {
            TezCounters counters = null;
            TaskStatistics stats = null;
            float progress = 0.0f;
            if (this.task.hasInitialized()) {
                progress = this.task.getProgress();
                if (sendCounters) {
                    counters = this.task.getCounters();
                    stats = this.task.getTaskStatistics();
                }
            }
            return new TaskStatusUpdateEvent(counters, progress, stats, true);
        }

        private boolean taskFailed(TezTaskAttemptID taskAttemptID, Throwable t, String diagnostics, EventMetaData srcMeta) throws IOException, TezException {
            if (!this.finalEventQueued.getAndSet(true)) {
                TezEvent statusUpdateEvent = new TezEvent((Event)this.getStatusUpdateEvent(true), this.updateEventMetadata);
                diagnostics = diagnostics == null ? ExceptionUtils.getStackTrace((Throwable)t) : diagnostics + ":" + ExceptionUtils.getStackTrace((Throwable)t);
                TezEvent taskAttemptFailedEvent = new TezEvent((Event)new TaskAttemptFailedEvent(diagnostics), srcMeta == null ? this.updateEventMetadata : srcMeta);
                return !this.heartbeat((Collection<TezEvent>)Lists.newArrayList((Object[])new TezEvent[]{statusUpdateEvent, taskAttemptFailedEvent})).shouldDie;
            }
            LOG.warn("A final task state event has already been sent. Not sending again");
            return this.askedToDie.get();
        }

        private void addEvents(TezTaskAttemptID taskAttemptID, Collection<TezEvent> events) {
            if (events != null && !events.isEmpty()) {
                this.eventsToSend.addAll(events);
            }
        }
    }
}

