/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class RuleRegExp
implements Rule {
    private final String ruleName;
    private final Pattern pattern;

    public RuleRegExp(String ruleName, String regExp) {
        this.ruleName = ruleName;
        this.pattern = Pattern.compile(regExp);
    }

    @Override
    public int cost(Stack<Node> stack) throws SemanticException {
        int numElems = stack != null ? stack.size() : 0;
        String name = "";
        for (int pos = numElems - 1; pos >= 0; --pos) {
            name = ((Node)stack.get(pos)).getName() + "%" + name;
            Matcher m = this.pattern.matcher(name);
            if (!m.matches()) continue;
            return m.group().length();
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.ruleName;
    }
}

