/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class InsertCommand
extends Shell.Command {
    private Option insertOptAuths;
    private Option timestampOpt;
    private Option timeoutOption;

    protected long getTimeout(CommandLine cl) {
        if (cl.hasOption(this.timeoutOption.getLongOpt())) {
            return AccumuloConfiguration.getTimeInMillis(cl.getOptionValue(this.timeoutOption.getLongOpt()));
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ConstraintViolationException {
        shellState.checkTableState();
        Mutation m = new Mutation(new Text(cl.getArgs()[0].getBytes("ISO-8859-1")));
        Text colf = new Text(cl.getArgs()[1].getBytes("ISO-8859-1"));
        Text colq = new Text(cl.getArgs()[2].getBytes("ISO-8859-1"));
        Value val = new Value(cl.getArgs()[3].getBytes("ISO-8859-1"));
        if (cl.hasOption(this.insertOptAuths.getOpt())) {
            ColumnVisibility le = new ColumnVisibility(cl.getOptionValue(this.insertOptAuths.getOpt()));
            Shell.log.debug((Object)("Authorization label will be set to: " + le.toString()));
            if (cl.hasOption(this.timestampOpt.getOpt())) {
                m.put(colf, colq, le, Long.parseLong(cl.getOptionValue(this.timestampOpt.getOpt())), val);
            } else {
                m.put(colf, colq, le, val);
            }
        } else if (cl.hasOption(this.timestampOpt.getOpt())) {
            m.put(colf, colq, Long.parseLong(cl.getOptionValue(this.timestampOpt.getOpt())), val);
        } else {
            m.put(colf, colq, val);
        }
        BatchWriter bw = shellState.getConnector().createBatchWriter(shellState.getTableName(), new BatchWriterConfig().setMaxMemory(Math.max(m.estimatedMemoryUsed(), 1024L)).setMaxWriteThreads(1).setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS));
        bw.addMutation(m);
        try {
            bw.close();
        }
        catch (MutationsRejectedException e) {
            ArrayList<String> lines = new ArrayList<String>();
            if (!e.getAuthorizationFailuresMap().isEmpty()) {
                lines.add("\tAuthorization Failures:");
            }
            for (Map.Entry<KeyExtent, Set<SecurityErrorCode>> entry : e.getAuthorizationFailuresMap().entrySet()) {
                lines.add("\t\t" + entry);
            }
            if (!e.getConstraintViolationSummaries().isEmpty()) {
                lines.add("\tConstraint Failures:");
            }
            for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                lines.add("\t\t" + cvs.toString());
            }
            if (lines.size() == 0 || e.getUnknownExceptions() > 0) {
                lines.add(" " + e.getClass().getName() + " : " + e.getMessage());
                if (e.getCause() != null) {
                    lines.add("   Caused by : " + e.getCause().getClass().getName() + " : " + e.getCause().getMessage());
                }
            }
            shellState.printLines(lines.iterator(), false);
            return 1;
        }
        return 0;
    }

    @Override
    public String description() {
        return "inserts a record";
    }

    @Override
    public String usage() {
        return this.getName() + " <row> <colfamily> <colqualifier> <value>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.insertOptAuths = new Option("l", "visibility-label", true, "formatted visibility");
        this.insertOptAuths.setArgName("expression");
        o.addOption(this.insertOptAuths);
        this.timestampOpt = new Option("ts", "timestamp", true, "timestamp to use for insert");
        this.timestampOpt.setArgName("timestamp");
        o.addOption(this.timestampOpt);
        this.timeoutOption = new Option(null, "timeout", true, "time before insert should fail if no data is written. If no unit is given assumes seconds.  Units d,h,m,s,and ms are supported.  e.g. 30s or 100ms");
        this.timeoutOption.setArgName("timeout");
        o.addOption(this.timeoutOption);
        return o;
    }

    @Override
    public int numArgs() {
        return 4;
    }
}

