/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class TimestampFilter
extends Filter {
    private static final String LONG_PREFIX = "LONG";
    private final SimpleDateFormat dateParser = TimestampFilter.initDateParser();
    public static final String START = "start";
    public static final String START_INCL = "startInclusive";
    public static final String END = "end";
    public static final String END_INCL = "endInclusive";
    private long start;
    private long end;
    private boolean startInclusive;
    private boolean endInclusive;
    private boolean hasStart;
    private boolean hasEnd;

    private static SimpleDateFormat initDateParser() {
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMddHHmmssz");
        dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateParser;
    }

    @Override
    public boolean accept(Key k, Value v) {
        long ts = k.getTimestamp();
        if (this.hasStart && ts < this.start || this.hasEnd && ts > this.end) {
            return false;
        }
        if (this.hasStart && !this.startInclusive && ts == this.start) {
            return false;
        }
        return !this.hasEnd || this.endInclusive || ts != this.end;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        if (options == null) {
            throw new IllegalArgumentException("start and/or end must be set for " + TimestampFilter.class.getName());
        }
        super.init(source, options, env);
        this.hasStart = false;
        this.hasEnd = false;
        this.startInclusive = true;
        this.endInclusive = true;
        if (options.containsKey(START)) {
            this.hasStart = true;
        }
        if (options.containsKey(END)) {
            this.hasEnd = true;
        }
        if (!this.hasStart && !this.hasEnd) {
            throw new IllegalArgumentException("must have either start or end for " + TimestampFilter.class.getName());
        }
        try {
            String s;
            if (this.hasStart) {
                s = options.get(START);
                this.start = s.startsWith(LONG_PREFIX) ? Long.valueOf(s.substring(LONG_PREFIX.length())).longValue() : this.dateParser.parse(s).getTime();
            }
            if (this.hasEnd) {
                s = options.get(END);
                this.end = s.startsWith(LONG_PREFIX) ? Long.valueOf(s.substring(LONG_PREFIX.length())).longValue() : this.dateParser.parse(s).getTime();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (options.get(START_INCL) != null) {
            this.startInclusive = Boolean.parseBoolean(options.get(START_INCL));
        }
        if (options.get(END_INCL) != null) {
            this.endInclusive = Boolean.parseBoolean(options.get(END_INCL));
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        TimestampFilter copy = (TimestampFilter)super.deepCopy(env);
        copy.hasStart = this.hasStart;
        copy.start = this.start;
        copy.startInclusive = this.startInclusive;
        copy.hasEnd = this.hasEnd;
        copy.end = this.end;
        copy.endInclusive = this.endInclusive;
        return copy;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("tsfilter");
        io.setDescription("TimestampFilter displays entries with timestamps between specified values");
        io.addNamedOption(START, "start timestamp (yyyyMMddHHmmssz or LONG<longstring>)");
        io.addNamedOption(END, "end timestamp (yyyyMMddHHmmssz or LONG<longstring>)");
        io.addNamedOption(START_INCL, "true or false");
        io.addNamedOption(END_INCL, "true or false");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        boolean hasStart = false;
        boolean hasEnd = false;
        try {
            String s;
            if (options.containsKey(START)) {
                hasStart = true;
                s = options.get(START);
                if (s.startsWith(LONG_PREFIX)) {
                    Long.valueOf(s.substring(LONG_PREFIX.length()));
                } else {
                    this.dateParser.parse(s);
                }
            }
            if (options.containsKey(END)) {
                hasEnd = true;
                s = options.get(END);
                if (s.startsWith(LONG_PREFIX)) {
                    Long.valueOf(s.substring(LONG_PREFIX.length()));
                } else {
                    this.dateParser.parse(s);
                }
            }
            if (!hasStart && !hasEnd) {
                throw new IllegalArgumentException("start or end must be specified");
            }
            if (options.get(START_INCL) != null) {
                Boolean.parseBoolean(options.get(START_INCL));
            }
            if (options.get(END_INCL) != null) {
                Boolean.parseBoolean(options.get(END_INCL));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid options", e);
        }
        return true;
    }

    public static void setRange(IteratorSetting is, String start, String end) {
        TimestampFilter.setRange(is, start, true, end, true);
    }

    public static void setRange(IteratorSetting is, String start, boolean startInclusive, String end, boolean endInclusive) {
        TimestampFilter.setStart(is, start, startInclusive);
        TimestampFilter.setEnd(is, end, endInclusive);
    }

    public static void setStart(IteratorSetting is, String start, boolean startInclusive) {
        SimpleDateFormat dateParser = TimestampFilter.initDateParser();
        try {
            long startTS = dateParser.parse(start).getTime();
            TimestampFilter.setStart(is, startTS, startInclusive);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("couldn't parse " + start);
        }
    }

    public static void setEnd(IteratorSetting is, String end, boolean endInclusive) {
        SimpleDateFormat dateParser = TimestampFilter.initDateParser();
        try {
            long endTS = dateParser.parse(end).getTime();
            TimestampFilter.setEnd(is, endTS, endInclusive);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("couldn't parse " + end);
        }
    }

    public static void setRange(IteratorSetting is, long start, long end) {
        TimestampFilter.setRange(is, start, true, end, true);
    }

    public static void setRange(IteratorSetting is, long start, boolean startInclusive, long end, boolean endInclusive) {
        TimestampFilter.setStart(is, start, startInclusive);
        TimestampFilter.setEnd(is, end, endInclusive);
    }

    public static void setStart(IteratorSetting is, long start, boolean startInclusive) {
        is.addOption(START, LONG_PREFIX + Long.toString(start));
        is.addOption(START_INCL, Boolean.toString(startInclusive));
    }

    public static void setEnd(IteratorSetting is, long end, boolean endInclusive) {
        is.addOption(END, LONG_PREFIX + Long.toString(end));
        is.addOption(END_INCL, Boolean.toString(endInclusive));
    }
}

