/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.base.Joiner;
import java.io.CharArrayWriter;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LogDivertAppender
extends WriterAppender {
    private static final Logger LOG = Logger.getLogger((String)LogDivertAppender.class.getName());
    private final OperationManager operationManager;
    private boolean isVerbose;
    private Layout verboseLayout;
    private final CharArrayWriter writer = new CharArrayWriter();

    private void setLayout(boolean isVerbose, Layout lo) {
        if (isVerbose) {
            if (lo == null) {
                lo = CLIServiceUtils.verboseLayout;
                LOG.info((Object)"Cannot find a Layout from a ConsoleAppender. Using default Layout pattern.");
            }
        } else {
            lo = CLIServiceUtils.nonVerboseLayout;
        }
        this.setLayout(lo);
    }

    private void initLayout(boolean isVerbose) {
        Logger root = Logger.getRootLogger();
        Layout layout = null;
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender ap = (Appender)appenders.nextElement();
            if (!ap.getClass().equals(ConsoleAppender.class)) continue;
            layout = ap.getLayout();
            break;
        }
        this.setLayout(isVerbose, layout);
    }

    public LogDivertAppender(OperationManager operationManager, OperationLog.LoggingLevel loggingMode) {
        this.isVerbose = loggingMode == OperationLog.LoggingLevel.VERBOSE;
        this.initLayout(this.isVerbose);
        this.setWriter(this.writer);
        this.setName("LogDivertAppender");
        this.operationManager = operationManager;
        this.verboseLayout = this.isVerbose ? this.layout : CLIServiceUtils.verboseLayout;
        this.addFilter(new NameFilter(loggingMode, operationManager));
    }

    public void doAppend(LoggingEvent event) {
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log != null) {
            boolean isCurrModeVerbose;
            boolean bl = isCurrModeVerbose = log.getOpLoggingLevel() == OperationLog.LoggingLevel.VERBOSE;
            if (isCurrModeVerbose != this.isVerbose) {
                this.isVerbose = isCurrModeVerbose;
                this.setLayout(this.isVerbose, this.verboseLayout);
            }
        }
        super.doAppend(event);
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        String logOutput = this.writer.toString();
        this.writer.reset();
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log == null) {
            LOG.debug((Object)(" ---+++=== Dropped log event from thread " + event.getThreadName()));
            return;
        }
        log.writeOperationLog(logOutput);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static class NameFilter
    extends Filter {
        private Pattern namePattern;
        private OperationLog.LoggingLevel loggingMode;
        private OperationManager operationManager;
        private static final Pattern verboseExcludeNamePattern = Pattern.compile(Joiner.on("|").join(new String[]{LogDivertAppender.access$000().getName(), OperationLog.class.getName(), OperationManager.class.getName()}));
        private static final Pattern executionIncludeNamePattern = Pattern.compile(Joiner.on("|").join(new String[]{"org.apache.hadoop.mapreduce.JobSubmitter", "org.apache.hadoop.mapreduce.Job", "SessionState", Task.class.getName(), "org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor"}));
        private static final Pattern performanceIncludeNamePattern = Pattern.compile(executionIncludeNamePattern.pattern() + "|" + PerfLogger.class.getName());

        private void setCurrentNamePattern(OperationLog.LoggingLevel mode) {
            if (mode == OperationLog.LoggingLevel.VERBOSE) {
                this.namePattern = verboseExcludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.EXECUTION) {
                this.namePattern = executionIncludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.PERFORMANCE) {
                this.namePattern = performanceIncludeNamePattern;
            }
        }

        public NameFilter(OperationLog.LoggingLevel loggingMode, OperationManager op) {
            this.operationManager = op;
            this.loggingMode = loggingMode;
            this.setCurrentNamePattern(loggingMode);
        }

        public int decide(LoggingEvent ev) {
            boolean isMatch;
            boolean excludeMatches;
            OperationLog log = this.operationManager.getOperationLogByThread();
            boolean bl = excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
            if (log == null) {
                return -1;
            }
            OperationLog.LoggingLevel currentLoggingMode = log.getOpLoggingLevel();
            if (currentLoggingMode == OperationLog.LoggingLevel.NONE) {
                return -1;
            }
            if (currentLoggingMode != this.loggingMode) {
                this.loggingMode = currentLoggingMode;
                this.setCurrentNamePattern(this.loggingMode);
            }
            if (excludeMatches == (isMatch = this.namePattern.matcher(ev.getLoggerName()).matches())) {
                return -1;
            }
            return 0;
        }
    }
}

