/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonControllerJob;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class LauncherDelegator
extends TempletonDelegator {
    private static final Log LOG = LogFactory.getLog(LauncherDelegator.class);
    protected String runAs = null;
    private boolean secureMeatastoreAccess = false;
    private final String HIVE_SHIMS_FILENAME_PATTERN = ".*hive-shims.*";

    public LauncherDelegator(AppConfig appConf) {
        super(appConf);
    }

    public static void registerJob(UserGroupInformation ugi, final String id, final String user, final String callback, final Map<String, Object> userArgs) throws IOException, InterruptedException {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                try (JobState state = null;){
                    state = new JobState(id, Main.getAppConfigInstance());
                    state.setUser(user);
                    state.setCallback(callback);
                    state.setUserArgs(userArgs);
                }
                return null;
            }
        });
    }

    public EnqueueBean enqueueController(String user, Map<String, Object> userArgs, String callback, List<String> args) throws NotAuthorizedException, BusyException, IOException, QueueException {
        try {
            UserGroupInformation ugi = UgiFactory.getUgi(user);
            long startTime = System.nanoTime();
            String id = this.queueAsUser(ugi, args);
            long elapsed = (System.nanoTime() - startTime) / 1000000L;
            LOG.debug((Object)("queued job " + id + " in " + elapsed + " ms"));
            if (id == null) {
                throw new QueueException("Unable to get job id");
            }
            LauncherDelegator.registerJob(ugi, id, user, callback, userArgs);
            return new EnqueueBean(id);
        }
        catch (InterruptedException e) {
            throw new QueueException("Unable to launch job " + e);
        }
    }

    private String queueAsUser(UserGroupInformation ugi, final List<String> args) throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Launching job: " + args));
        }
        return (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                String[] array = new String[args.size()];
                TempletonControllerJob ctrl = new TempletonControllerJob(LauncherDelegator.this.secureMeatastoreAccess, LauncherDelegator.this.appConf);
                ToolRunner.run((Tool)ctrl, (String[])args.toArray(array));
                return ctrl.getSubmittedId();
            }
        });
    }

    public List<String> makeLauncherArgs(AppConfig appConf, String statusdir, String completedUrl, List<String> copyFiles, boolean enablelog, Boolean enableJobReconnect, JobType jobType) {
        ArrayList<String> args = new ArrayList<String>();
        if (TempletonUtils.isset(appConf.libJars())) {
            args.add("-libjars");
            String libJars = String.format("%s,%s", this.getShimLibjars(), appConf.libJars());
            args.add(libJars);
        } else {
            args.add("-libjars");
            String libJars = String.format("%s", this.getShimLibjars());
            args.add(libJars);
        }
        LauncherDelegator.addCacheFiles(args, appConf);
        LauncherDelegator.addDef(args, "user.name", this.runAs);
        LauncherDelegator.addDef(args, "mapred.map.tasks.speculative.execution", "false");
        LauncherDelegator.addDef(args, "mapred.child.java.opts", appConf.controllerMRChildOpts());
        LauncherDelegator.addDef(args, "templeton.statusdir", statusdir);
        LauncherDelegator.addDef(args, "templeton.copy", TempletonUtils.encodeArray(copyFiles));
        LauncherDelegator.addDef(args, "templeton.override-classpath", LauncherDelegator.makeOverrideClasspath(appConf));
        LauncherDelegator.addDef(args, "templeton.enablelog", Boolean.toString(enablelog));
        LauncherDelegator.addDef(args, "templeton.jobtype", jobType.toString());
        LauncherDelegator.addDef(args, "templeton.job.launch.time", Long.toString(System.currentTimeMillis()));
        if (enableJobReconnect == null) {
            enableJobReconnect = appConf.enableJobReconnectDefault() != null ? Boolean.valueOf(Boolean.parseBoolean(appConf.enableJobReconnectDefault())) : Boolean.valueOf(false);
        }
        LauncherDelegator.addDef(args, "templeton.enablejobreconnect", Boolean.toString(enableJobReconnect));
        LauncherDelegator.addDef(args, "mapred.job.queue.name", appConf.hadoopQueueName());
        this.addStorageVars(args);
        this.addCompletionVars(args, completedUrl);
        return args;
    }

    private String getShimLibjars() {
        HadoopShims.WebHCatJTShim shim = null;
        try {
            shim = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get WebHCatShim", e);
        }
        Path shimCommonJar = new Path(TempletonUtils.findContainingJar(ShimLoader.class, ".*hive-shims.*"));
        Path shimCommonSecureJar = new Path(TempletonUtils.findContainingJar(HadoopShimsSecure.class, ".*hive-shims.*"));
        Path shimJar = new Path(TempletonUtils.findContainingJar(shim.getClass(), ".*hive-shims.*"));
        return String.format("%s,%s,%s", shimCommonJar.toString(), shimCommonSecureJar.toString(), shimJar.toString());
    }

    private void addStorageVars(List<String> args) {
        LauncherDelegator.addDef(args, "templeton.storage.class", this.appConf.get("templeton.storage.class"));
        LauncherDelegator.addDef(args, "templeton.storage.root", this.appConf.get("templeton.storage.root"));
        LauncherDelegator.addDef(args, "templeton.zookeeper.hosts", this.appConf.get("templeton.zookeeper.hosts"));
        LauncherDelegator.addDef(args, "templeton.zookeeper.session-timeout", this.appConf.get("templeton.zookeeper.session-timeout"));
    }

    private void addCompletionVars(List<String> args, String completedUrl) {
        LauncherDelegator.addDef(args, "job.end.retry.attempts", this.appConf.get("templeton.callback.retry.attempts"));
        LauncherDelegator.addDef(args, "job.end.retry.interval", this.appConf.get("templeton.callback.retry.interval"));
        LauncherDelegator.addDef(args, "job.end.notification.url", completedUrl);
    }

    public static void addCacheFiles(List<String> args, AppConfig appConf) {
        String overrides = appConf.overrideJarsString();
        if (overrides != null) {
            args.add("-files");
            args.add(overrides);
        }
    }

    public static String makeOverrideClasspath(AppConfig appConf) {
        String[] overrides = appConf.overrideJars();
        if (overrides == null) {
            return null;
        }
        ArrayList<String> cp = new ArrayList<String>();
        for (String fname : overrides) {
            Path p = new Path(fname);
            cp.add(p.getName());
        }
        return StringUtils.join((CharSequence)":", cp);
    }

    public static void addDef(List<String> args, String name, String val) {
        if (val != null) {
            args.add("-D");
            args.add(name + "=" + val);
        }
    }

    void addHiveMetaStoreTokenArg() {
        HiveConf hiveConf = new HiveConf();
        if (!hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)) {
            return;
        }
        this.secureMeatastoreAccess = true;
    }

    public static enum JobType {
        JAR,
        STREAMING,
        PIG,
        HIVE,
        SQOOP;

    }
}

