/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;

public class DateStringFormatter
implements Formatter {
    private boolean printTimestamps = false;
    private DefaultFormatter defaultFormatter = new DefaultFormatter();
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateStringFormatter.DATE_FORMAT);
        }
    };

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        this.printTimestamps = printTimestamps;
        this.defaultFormatter.initialize(scanner, printTimestamps);
    }

    @Override
    public boolean hasNext() {
        return this.defaultFormatter.hasNext();
    }

    @Override
    public String next() {
        DateFormat timestampformat = null;
        if (this.printTimestamps) {
            timestampformat = formatter.get();
        }
        return this.defaultFormatter.next(timestampformat);
    }

    @Override
    public void remove() {
        this.defaultFormatter.remove();
    }

    public void setTimeZone(TimeZone zone) {
        formatter.get().setTimeZone(zone);
    }
}

