/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModuleUtils;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CachingHDFSSecretKeyEncryptionStrategy
implements SecretKeyEncryptionStrategy {
    private static final Logger log = Logger.getLogger(CachingHDFSSecretKeyEncryptionStrategy.class);
    private SecretKeyCache secretKeyCache = new SecretKeyCache();

    @Override
    public CryptoModuleParameters encryptSecretKey(CryptoModuleParameters context) {
        try {
            this.secretKeyCache.ensureSecretKeyCacheInitialized(context);
            this.doKeyEncryptionOperation(3, context);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return context;
    }

    @Override
    public CryptoModuleParameters decryptSecretKey(CryptoModuleParameters context) {
        try {
            this.secretKeyCache.ensureSecretKeyCacheInitialized(context);
            this.doKeyEncryptionOperation(4, context);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return context;
    }

    private void doKeyEncryptionOperation(int encryptionMode, CryptoModuleParameters params) throws IOException {
        Cipher cipher = DefaultCryptoModuleUtils.getCipher(params.getAllOptions().get(Property.CRYPTO_DEFAULT_KEY_STRATEGY_CIPHER_SUITE.getKey()));
        try {
            cipher.init(encryptionMode, new SecretKeySpec(this.secretKeyCache.getKeyEncryptionKey(), params.getAlgorithmName()));
        }
        catch (InvalidKeyException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        if (4 == encryptionMode) {
            try {
                Key plaintextKey = cipher.unwrap(params.getEncryptedKey(), params.getAlgorithmName(), 3);
                params.setPlaintextKey(plaintextKey.getEncoded());
            }
            catch (InvalidKeyException e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        SecretKeySpec plaintextKey = new SecretKeySpec(params.getPlaintextKey(), params.getAlgorithmName());
        try {
            byte[] encryptedSecretKey = cipher.wrap(plaintextKey);
            params.setEncryptedKey(encryptedSecretKey);
            params.setOpaqueKeyEncryptionKeyID(this.secretKeyCache.getPathToKeyName());
        }
        catch (InvalidKeyException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private static class SecretKeyCache {
        private boolean initialized = false;
        private byte[] keyEncryptionKey;
        private String pathToKeyName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void ensureSecretKeyCacheInitialized(CryptoModuleParameters context) throws IOException {
            if (this.initialized) {
                return;
            }
            this.pathToKeyName = this.getFullPathToKey(context);
            if (this.pathToKeyName == null || this.pathToKeyName.equals("")) {
                this.pathToKeyName = Property.CRYPTO_DEFAULT_KEY_STRATEGY_KEY_LOCATION.getDefaultValue();
            }
            Path pathToKey = new Path(this.pathToKeyName);
            FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
            FSDataInputStream in = null;
            try {
                if (!fs.exists(pathToKey)) {
                    this.initializeKeyEncryptionKey(fs, pathToKey, context);
                }
                in = fs.open(pathToKey);
                int keyEncryptionKeyLength = in.readInt();
                this.keyEncryptionKey = new byte[keyEncryptionKeyLength];
                in.read(this.keyEncryptionKey);
                this.initialized = true;
            }
            catch (IOException e) {
                try {
                    log.error((Object)"Could not initialize key encryption cache", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeKeyEncryptionKey(FileSystem fs, Path pathToKey, CryptoModuleParameters params) throws IOException {
            FSDataOutputStream out = null;
            try {
                out = fs.create(pathToKey);
                fs.setReplication(pathToKey, (short)5);
                SecureRandom random = DefaultCryptoModuleUtils.getSecureRandom(params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider());
                int keyLength = params.getKeyLength();
                byte[] newRandomKeyEncryptionKey = new byte[keyLength / 8];
                random.nextBytes(newRandomKeyEncryptionKey);
                out.writeInt(newRandomKeyEncryptionKey.length);
                out.write(newRandomKeyEncryptionKey);
                out.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        private String getFullPathToKey(CryptoModuleParameters params) {
            String pathToKeyName = params.getAllOptions().get(Property.CRYPTO_DEFAULT_KEY_STRATEGY_KEY_LOCATION.getKey());
            String instanceDirectory = params.getAllOptions().get(Property.INSTANCE_DFS_DIR.getKey());
            if (pathToKeyName == null) {
                pathToKeyName = Property.CRYPTO_DEFAULT_KEY_STRATEGY_KEY_LOCATION.getDefaultValue();
            }
            if (instanceDirectory == null) {
                instanceDirectory = Property.INSTANCE_DFS_DIR.getDefaultValue();
            }
            if (!pathToKeyName.startsWith("/")) {
                pathToKeyName = "/" + pathToKeyName;
            }
            String fullPath = instanceDirectory + pathToKeyName;
            return fullPath;
        }

        public byte[] getKeyEncryptionKey() {
            return this.keyEncryptionKey;
        }

        public String getPathToKeyName() {
            return this.pathToKeyName;
        }
    }
}

